/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.nsd.WifiP2pServiceResponse;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WifiP2pDnsSdServiceResponse
extends WifiP2pServiceResponse {
    private static final Map<Integer, String> sVmpack = new HashMap<Integer, String>();
    private String mDnsQueryName;
    private int mDnsType;
    private String mInstanceName;
    private final HashMap<String, String> mTxtRecord = new HashMap();
    private int mVersion;

    static {
        sVmpack.put(12, "_tcp.local.");
        sVmpack.put(17, "local.");
        sVmpack.put(28, "_udp.local.");
    }

    protected WifiP2pDnsSdServiceResponse(int n, int n2, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        super(1, n, n2, wifiP2pDevice, byArray);
        if (!this.parse()) {
            throw new IllegalArgumentException("Malformed bonjour service response");
        }
    }

    static WifiP2pDnsSdServiceResponse newInstance(int n, int n2, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        if (n != 0) {
            return new WifiP2pDnsSdServiceResponse(n, n2, wifiP2pDevice, null);
        }
        try {
            WifiP2pDnsSdServiceResponse wifiP2pDnsSdServiceResponse = new WifiP2pDnsSdServiceResponse(n, n2, wifiP2pDevice, byArray);
            return wifiP2pDnsSdServiceResponse;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
    }

    private boolean parse() {
        DataInputStream dataInputStream;
        block7: {
            String string2;
            if (this.mData == null) {
                return true;
            }
            dataInputStream = new DataInputStream(new ByteArrayInputStream(this.mData));
            this.mDnsQueryName = this.readDnsName(dataInputStream);
            if (this.mDnsQueryName == null) {
                return false;
            }
            try {
                this.mDnsType = dataInputStream.readUnsignedShort();
                this.mVersion = dataInputStream.readUnsignedByte();
                if (this.mDnsType != 12) break block7;
                string2 = this.readDnsName(dataInputStream);
                if (string2 == null) {
                    return false;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
            if (string2.length() <= this.mDnsQueryName.length()) {
                return false;
            }
            this.mInstanceName = string2.substring(0, -1 + (string2.length() - this.mDnsQueryName.length()));
            return true;
        }
        if (this.mDnsType == 16) {
            return this.readTxtData(dataInputStream);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readDnsName(DataInputStream dataInputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(sVmpack);
        if (this.mDnsQueryName != null) {
            hashMap.put(39, this.mDnsQueryName);
        }
        try {
            while (true) {
                int n;
                if ((n = dataInputStream.readUnsignedByte()) == 0) {
                    return stringBuffer.toString();
                }
                if (n == 192) {
                    String string2 = hashMap.get(dataInputStream.readUnsignedByte());
                    if (string2 == null) return null;
                    stringBuffer.append(string2);
                    return stringBuffer.toString();
                }
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray);
                stringBuffer.append(new String(byArray));
                stringBuffer.append(".");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readTxtData(DataInputStream dataInputStream) {
        try {
            while (dataInputStream.available() > 0) {
                int n = dataInputStream.readUnsignedByte();
                if (n == 0) return true;
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray);
                String[] stringArray = new String(byArray).split("=");
                int n2 = stringArray.length;
                boolean bl = false;
                if (n2 != 2) return bl;
                this.mTxtRecord.put(stringArray[0], stringArray[1]);
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public String getDnsQueryName() {
        return this.mDnsQueryName;
    }

    public int getDnsType() {
        return this.mDnsType;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public Map<String, String> getTxtRecord() {
        return this.mTxtRecord;
    }

    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("serviceType:DnsSd(").append(this.mServiceType).append(")");
        stringBuffer.append(" status:").append(WifiP2pServiceResponse.Status.toString(this.mStatus));
        stringBuffer.append(" srcAddr:").append(this.mDevice.deviceAddress);
        StringBuffer stringBuffer2 = stringBuffer.append(" version:");
        Object[] objectArray = new Object[]{this.mVersion};
        stringBuffer2.append(String.format("%02x", objectArray));
        stringBuffer.append(" dnsName:").append(this.mDnsQueryName);
        stringBuffer.append(" TxtRecord:");
        for (String string2 : this.mTxtRecord.keySet()) {
            stringBuffer.append(" key:").append(string2).append(" value:").append(this.mTxtRecord.get(string2));
        }
        if (this.mInstanceName != null) {
            stringBuffer.append(" InsName:").append(this.mInstanceName);
        }
        return stringBuffer.toString();
    }
}

