/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.Application;
import android.net.Uri;
import android.nfc.BeamShareData;
import android.nfc.IAppCallback;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.nfc.Tag;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class NfcActivityManager
extends IAppCallback.Stub
implements Application.ActivityLifecycleCallbacks {
    static final Boolean DBG = false;
    static final String TAG = "NFC";
    final List<NfcActivityState> mActivities;
    final NfcAdapter mAdapter;
    final List<NfcApplicationState> mApps;
    final NfcEvent mDefaultEvent;

    public NfcActivityManager(NfcAdapter nfcAdapter) {
        this.mAdapter = nfcAdapter;
        this.mActivities = new LinkedList<NfcActivityState>();
        this.mApps = new ArrayList<NfcApplicationState>(1);
        this.mDefaultEvent = new NfcEvent(this.mAdapter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public BeamShareData createBeamShareData() {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.findResumedActivityState();
        if (nfcActivityState == null) {
            // MONITOREXIT : this
            return null;
        }
        NfcAdapter.CreateNdefMessageCallback createNdefMessageCallback = nfcActivityState.ndefMessageCallback;
        NfcAdapter.CreateBeamUrisCallback createBeamUrisCallback = nfcActivityState.uriCallback;
        NdefMessage ndefMessage = nfcActivityState.ndefMessage;
        Uri[] uriArray = nfcActivityState.uris;
        int n = nfcActivityState.flags;
        Activity activity = nfcActivityState.activity;
        // MONITOREXIT : this
        if (createNdefMessageCallback != null) {
            ndefMessage = createNdefMessageCallback.createNdefMessage(this.mDefaultEvent);
        }
        if (createBeamUrisCallback != null && (uriArray = createBeamUrisCallback.createBeamUris(this.mDefaultEvent)) != null) {
            for (Uri uri : uriArray) {
                if (uri == null) {
                    Log.e(TAG, "Uri not allowed to be null.");
                    return null;
                }
                String string2 = uri.getScheme();
                if (string2 != null && (string2.equalsIgnoreCase("file") || string2.equalsIgnoreCase("content"))) continue;
                Log.e(TAG, "Uri needs to have either scheme file or scheme content");
                return null;
            }
        }
        if (uriArray == null) return new BeamShareData(ndefMessage, uriArray, n);
        if (uriArray.length <= 0) return new BeamShareData(ndefMessage, uriArray, n);
        Uri[] uriArray2 = uriArray;
        int n2 = uriArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            activity.grantUriPermission("com.android.nfc", uriArray2[n3], 1);
            ++n3;
        }
        return new BeamShareData(ndefMessage, uriArray, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void destroyActivityState(Activity activity) {
        synchronized (this) {
            NfcActivityState nfcActivityState = this.findActivityState(activity);
            if (nfcActivityState != null) {
                nfcActivityState.destroy();
                this.mActivities.remove(nfcActivityState);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void disableReaderMode(Activity activity) {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.getActivityState(activity);
        nfcActivityState.readerCallback = null;
        nfcActivityState.readerModeFlags = 0;
        nfcActivityState.readerModeExtras = null;
        Binder binder = nfcActivityState.token;
        boolean bl = nfcActivityState.resumed;
        // MONITOREXIT : this
        if (!bl) return;
        this.setReaderMode(binder, 0, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void enableReaderMode(Activity activity, NfcAdapter.ReaderCallback readerCallback, int n, Bundle bundle) {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.getActivityState(activity);
        nfcActivityState.readerCallback = readerCallback;
        nfcActivityState.readerModeFlags = n;
        nfcActivityState.readerModeExtras = bundle;
        Binder binder = nfcActivityState.token;
        boolean bl = nfcActivityState.resumed;
        // MONITOREXIT : this
        if (!bl) return;
        this.setReaderMode(binder, n, bundle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    NfcActivityState findActivityState(Activity activity) {
        synchronized (this) {
            NfcActivityState nfcActivityState;
            Activity activity2;
            Iterator<NfcActivityState> iterator = this.mActivities.iterator();
            do {
                if (!iterator.hasNext()) return null;
                nfcActivityState = iterator.next();
            } while ((activity2 = nfcActivityState.activity) != activity);
            return nfcActivityState;
        }
    }

    NfcApplicationState findAppState(Application application) {
        for (NfcApplicationState nfcApplicationState : this.mApps) {
            if (nfcApplicationState.app != application) continue;
            return nfcApplicationState;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    NfcActivityState findResumedActivityState() {
        synchronized (this) {
            NfcActivityState nfcActivityState;
            boolean bl;
            Iterator<NfcActivityState> iterator = this.mActivities.iterator();
            do {
                if (!iterator.hasNext()) return null;
                nfcActivityState = iterator.next();
            } while (!(bl = nfcActivityState.resumed));
            return nfcActivityState;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    NfcActivityState getActivityState(Activity activity) {
        synchronized (this) {
            NfcActivityState nfcActivityState = this.findActivityState(activity);
            if (nfcActivityState == null) {
                nfcActivityState = new NfcActivityState(activity);
                this.mActivities.add(nfcActivityState);
            }
            return nfcActivityState;
        }
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onActivityDestroyed(Activity activity) {
        synchronized (this) {
            NfcActivityState nfcActivityState = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onDestroy() for " + activity + " " + nfcActivityState);
            }
            if (nfcActivityState != null) {
                this.destroyActivityState(activity);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onActivityPaused(Activity activity) {
        boolean bl;
        Binder binder;
        synchronized (this) {
            NfcActivityState nfcActivityState = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onPause() for " + activity + " " + nfcActivityState);
            }
            if (nfcActivityState == null) {
                return;
            }
            nfcActivityState.resumed = false;
            binder = nfcActivityState.token;
            if (nfcActivityState.readerModeFlags == 0) return;
            bl = true;
        }
        if (!bl) return;
        this.setReaderMode(binder, 0, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onActivityResumed(Activity activity) {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.findActivityState(activity);
        if (DBG.booleanValue()) {
            Log.d(TAG, "onResume() for " + activity + " " + nfcActivityState);
        }
        if (nfcActivityState == null) {
            // MONITOREXIT : this
            return;
        }
        nfcActivityState.resumed = true;
        Binder binder = nfcActivityState.token;
        int n = nfcActivityState.readerModeFlags;
        Bundle bundle = nfcActivityState.readerModeExtras;
        // MONITOREXIT : this
        if (n != 0) {
            this.setReaderMode(binder, n, bundle);
        }
        this.requestNfcServiceCallback();
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    @Override
    public void onActivityStarted(Activity activity) {
    }

    @Override
    public void onActivityStopped(Activity activity) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onNdefPushComplete() {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.findResumedActivityState();
        if (nfcActivityState == null) {
            // MONITOREXIT : this
            return;
        }
        NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback = nfcActivityState.onNdefPushCompleteCallback;
        // MONITOREXIT : this
        if (onNdefPushCompleteCallback == null) return;
        onNdefPushCompleteCallback.onNdefPushComplete(this.mDefaultEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onTagDiscovered(Tag tag) throws RemoteException {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.findResumedActivityState();
        if (nfcActivityState == null) {
            // MONITOREXIT : this
            return;
        }
        NfcAdapter.ReaderCallback readerCallback = nfcActivityState.readerCallback;
        // MONITOREXIT : this
        if (readerCallback == null) return;
        readerCallback.onTagDiscovered(tag);
    }

    void registerApplication(Application application) {
        NfcApplicationState nfcApplicationState = this.findAppState(application);
        if (nfcApplicationState == null) {
            nfcApplicationState = new NfcApplicationState(application);
            this.mApps.add(nfcApplicationState);
        }
        nfcApplicationState.register();
    }

    void requestNfcServiceCallback() {
        try {
            NfcAdapter.sService.setAppCallback(this);
            return;
        }
        catch (RemoteException remoteException) {
            this.mAdapter.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setNdefPushContentUri(Activity activity, Uri[] uriArray) {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.getActivityState(activity);
        nfcActivityState.uris = uriArray;
        boolean bl = nfcActivityState.resumed;
        // MONITOREXIT : this
        if (!bl) return;
        this.requestNfcServiceCallback();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setNdefPushContentUriCallback(Activity activity, NfcAdapter.CreateBeamUrisCallback createBeamUrisCallback) {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.getActivityState(activity);
        nfcActivityState.uriCallback = createBeamUrisCallback;
        boolean bl = nfcActivityState.resumed;
        // MONITOREXIT : this
        if (!bl) return;
        this.requestNfcServiceCallback();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setNdefPushMessage(Activity activity, NdefMessage ndefMessage, int n) {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.getActivityState(activity);
        nfcActivityState.ndefMessage = ndefMessage;
        nfcActivityState.flags = n;
        boolean bl = nfcActivityState.resumed;
        // MONITOREXIT : this
        if (!bl) return;
        this.requestNfcServiceCallback();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setNdefPushMessageCallback(Activity activity, NfcAdapter.CreateNdefMessageCallback createNdefMessageCallback, int n) {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.getActivityState(activity);
        nfcActivityState.ndefMessageCallback = createNdefMessageCallback;
        nfcActivityState.flags = n;
        boolean bl = nfcActivityState.resumed;
        // MONITOREXIT : this
        if (!bl) return;
        this.requestNfcServiceCallback();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setOnNdefPushCompleteCallback(Activity activity, NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback) {
        // MONITORENTER : this
        NfcActivityState nfcActivityState = this.getActivityState(activity);
        nfcActivityState.onNdefPushCompleteCallback = onNdefPushCompleteCallback;
        boolean bl = nfcActivityState.resumed;
        // MONITOREXIT : this
        if (!bl) return;
        this.requestNfcServiceCallback();
    }

    public void setReaderMode(Binder binder, int n, Bundle bundle) {
        if (DBG.booleanValue()) {
            Log.d(TAG, "Setting reader mode");
        }
        try {
            NfcAdapter.sService.setReaderMode(binder, this, n, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.mAdapter.attemptDeadServiceRecovery(remoteException);
            return;
        }
    }

    void unregisterApplication(Application application) {
        NfcApplicationState nfcApplicationState = this.findAppState(application);
        if (nfcApplicationState == null) {
            Log.e(TAG, "app was not registered " + application);
            return;
        }
        nfcApplicationState.unregister();
    }

    class NfcActivityState {
        Activity activity;
        int flags = 0;
        NdefMessage ndefMessage = null;
        NfcAdapter.CreateNdefMessageCallback ndefMessageCallback = null;
        NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback = null;
        NfcAdapter.ReaderCallback readerCallback = null;
        Bundle readerModeExtras = null;
        int readerModeFlags = 0;
        boolean resumed = false;
        Binder token;
        NfcAdapter.CreateBeamUrisCallback uriCallback = null;
        Uri[] uris = null;

        public NfcActivityState(Activity activity) {
            if (activity.getWindow().isDestroyed()) {
                throw new IllegalStateException("activity is already destroyed");
            }
            this.resumed = activity.isResumed();
            this.activity = activity;
            this.token = new Binder();
            NfcActivityManager.this.registerApplication(activity.getApplication());
        }

        public void destroy() {
            NfcActivityManager.this.unregisterApplication(this.activity.getApplication());
            this.resumed = false;
            this.activity = null;
            this.ndefMessage = null;
            this.ndefMessageCallback = null;
            this.onNdefPushCompleteCallback = null;
            this.uriCallback = null;
            this.uris = null;
            this.readerModeFlags = 0;
            this.token = null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[").append(" ");
            stringBuilder.append(this.ndefMessage).append(" ").append(this.ndefMessageCallback).append(" ");
            stringBuilder.append(this.uriCallback).append(" ");
            if (this.uris != null) {
                for (Uri uri : this.uris) {
                    stringBuilder.append(this.onNdefPushCompleteCallback).append(" ").append(uri).append("]");
                }
            }
            return stringBuilder.toString();
        }
    }

    class NfcApplicationState {
        final Application app;
        int refCount = 0;

        public NfcApplicationState(Application application) {
            this.app = application;
        }

        public void register() {
            this.refCount = 1 + this.refCount;
            if (this.refCount == 1) {
                this.app.registerActivityLifecycleCallbacks(NfcActivityManager.this);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void unregister() {
            this.refCount = -1 + this.refCount;
            if (this.refCount == 0) {
                this.app.unregisterActivityLifecycleCallbacks(NfcActivityManager.this);
                return;
            } else {
                if (this.refCount >= 0) return;
                Log.e(NfcActivityManager.TAG, "-ve refcount for " + this.app);
                return;
            }
        }
    }
}

