/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.TagLostException;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;

public final class TransceiveResult
implements Parcelable {
    public static final Parcelable.Creator<TransceiveResult> CREATOR = new Parcelable.Creator<TransceiveResult>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public TransceiveResult createFromParcel(Parcel parcel) {
            byte[] byArray;
            int n = parcel.readInt();
            if (n == 0) {
                byArray = new byte[parcel.readInt()];
                parcel.readByteArray(byArray);
                return new TransceiveResult(n, byArray);
            }
            byArray = null;
            return new TransceiveResult(n, byArray);
        }

        public TransceiveResult[] newArray(int n) {
            return new TransceiveResult[n];
        }
    };
    public static final int RESULT_EXCEEDED_LENGTH = 3;
    public static final int RESULT_FAILURE = 1;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_TAGLOST = 2;
    final byte[] mResponseData;
    final int mResult;

    public TransceiveResult(int n, byte[] byArray) {
        this.mResult = n;
        this.mResponseData = byArray;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public byte[] getResponseOrThrow() throws IOException {
        switch (this.mResult) {
            default: {
                throw new IOException("Transceive failed");
            }
            case 0: {
                return this.mResponseData;
            }
            case 2: {
                throw new TagLostException("Tag was lost.");
            }
            case 3: 
        }
        throw new IOException("Transceive length exceeds supported maximum");
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mResult);
        if (this.mResult == 0) {
            parcel.writeInt(this.mResponseData.length);
            parcel.writeByteArray(this.mResponseData);
        }
    }
}

