/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.app.Activity;
import android.app.ActivityThread;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.IPackageManager;
import android.nfc.INfcCardEmulation;
import android.nfc.NfcAdapter;
import android.nfc.cardemulation.AidGroup;
import android.nfc.cardemulation.ApduServiceInfo;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import java.util.HashMap;
import java.util.List;

public final class CardEmulation {
    public static final String ACTION_CHANGE_DEFAULT = "android.nfc.cardemulation.action.ACTION_CHANGE_DEFAULT";
    public static final String CATEGORY_OTHER = "other";
    public static final String CATEGORY_PAYMENT = "payment";
    public static final String EXTRA_CATEGORY = "category";
    public static final String EXTRA_SERVICE_COMPONENT = "component";
    public static final int SELECTION_MODE_ALWAYS_ASK = 1;
    public static final int SELECTION_MODE_ASK_IF_CONFLICT = 2;
    public static final int SELECTION_MODE_PREFER_DEFAULT = 0;
    static final String TAG = "CardEmulation";
    static HashMap<Context, CardEmulation> sCardEmus;
    static boolean sIsInitialized;
    static INfcCardEmulation sService;
    final Context mContext;

    static {
        sIsInitialized = false;
        sCardEmus = new HashMap();
    }

    private CardEmulation(Context context, INfcCardEmulation iNfcCardEmulation) {
        this.mContext = context.getApplicationContext();
        sService = iNfcCardEmulation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CardEmulation getInstance(NfcAdapter nfcAdapter) {
        synchronized (CardEmulation.class) {
            CardEmulation cardEmulation;
            if (nfcAdapter == null) {
                throw new NullPointerException("NfcAdapter is null");
            }
            Context context = nfcAdapter.getContext();
            if (context == null) {
                Log.e(TAG, "NfcAdapter context is null.");
                throw new UnsupportedOperationException();
            }
            if (!sIsInitialized) {
                IPackageManager iPackageManager = ActivityThread.getPackageManager();
                if (iPackageManager == null) {
                    Log.e(TAG, "Cannot get PackageManager");
                    throw new UnsupportedOperationException();
                }
                try {
                    if (!iPackageManager.hasSystemFeature("android.hardware.nfc.hce")) {
                        Log.e(TAG, "This device does not support card emulation");
                        throw new UnsupportedOperationException();
                    }
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "PackageManager query failed.");
                    throw new UnsupportedOperationException();
                }
                sIsInitialized = true;
            }
            if ((cardEmulation = sCardEmus.get(context)) == null) {
                INfcCardEmulation iNfcCardEmulation = nfcAdapter.getCardEmulationService();
                if (iNfcCardEmulation == null) {
                    Log.e(TAG, "This device does not implement the INfcCardEmulation interface.");
                    throw new UnsupportedOperationException();
                }
                cardEmulation = new CardEmulation(context, iNfcCardEmulation);
                sCardEmus.put(context, cardEmulation);
            }
            return cardEmulation;
        }
    }

    public static boolean isValidAid(String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.endsWith("*") && string2.length() % 2 == 0) {
            Log.e(TAG, "AID " + string2 + " is not a valid AID.");
            return false;
        }
        if (!string2.endsWith("*") && string2.length() % 2 != 0) {
            Log.e(TAG, "AID " + string2 + " is not a valid AID.");
            return false;
        }
        if (!string2.matches("[0-9A-Fa-f]{10,32}\\*?")) {
            Log.e(TAG, "AID " + string2 + " is not a valid AID.");
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean categoryAllowsForegroundPreference(String string2) {
        if (!CATEGORY_PAYMENT.equals(string2)) return true;
        try {
            int n = Settings.Secure.getInt(this.mContext.getContentResolver(), "nfc_payment_foreground");
            return n != 0;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getAidsForService(ComponentName componentName, String string2) {
        List<String> list;
        AidGroup aidGroup;
        try {
            aidGroup = sService.getAidGroupForService(UserHandle.myUserId(), componentName, string2);
            list = null;
            if (aidGroup == null) return list;
        }
        catch (RemoteException remoteException) {
            AidGroup aidGroup2;
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return null;
            }
            try {
                aidGroup2 = sService.getAidGroupForService(UserHandle.myUserId(), componentName, string2);
                list = null;
                if (aidGroup2 == null) return list;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return null;
            }
            return aidGroup2.getAids();
        }
        List<String> list2 = aidGroup.getAids();
        return list2;
    }

    public int getSelectionModeForCategory(String string2) {
        if (CATEGORY_PAYMENT.equals(string2)) {
            if (Settings.Secure.getString(this.mContext.getContentResolver(), "nfc_payment_default_component") != null) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public List<ApduServiceInfo> getServices(String string2) {
        try {
            List<ApduServiceInfo> list = sService.getServices(UserHandle.myUserId(), string2);
            return list;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return null;
            }
            try {
                List<ApduServiceInfo> list = sService.getServices(UserHandle.myUserId(), string2);
                return list;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to reach CardEmulationService.");
                return null;
            }
        }
    }

    public boolean isDefaultServiceForAid(ComponentName componentName, String string2) {
        try {
            boolean bl = sService.isDefaultServiceForAid(UserHandle.myUserId(), componentName, string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                boolean bl = sService.isDefaultServiceForAid(UserHandle.myUserId(), componentName, string2);
                return bl;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    public boolean isDefaultServiceForCategory(ComponentName componentName, String string2) {
        try {
            boolean bl = sService.isDefaultServiceForCategory(UserHandle.myUserId(), componentName, string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                boolean bl = sService.isDefaultServiceForCategory(UserHandle.myUserId(), componentName, string2);
                return bl;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
        }
    }

    void recoverService() {
        sService = NfcAdapter.getDefaultAdapter(this.mContext).getCardEmulationService();
    }

    public boolean registerAidsForService(ComponentName componentName, String string2, List<String> list) {
        AidGroup aidGroup = new AidGroup(list, string2);
        try {
            boolean bl = sService.registerAidGroupForService(UserHandle.myUserId(), componentName, aidGroup);
            return bl;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                boolean bl = sService.registerAidGroupForService(UserHandle.myUserId(), componentName, aidGroup);
                return bl;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    public boolean removeAidsForService(ComponentName componentName, String string2) {
        try {
            boolean bl = sService.removeAidGroupForService(UserHandle.myUserId(), componentName, string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                boolean bl = sService.removeAidGroupForService(UserHandle.myUserId(), componentName, string2);
                return bl;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    public boolean setDefaultForNextTap(ComponentName componentName) {
        try {
            boolean bl = sService.setDefaultForNextTap(UserHandle.myUserId(), componentName);
            return bl;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                boolean bl = sService.setDefaultForNextTap(UserHandle.myUserId(), componentName);
                return bl;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    public boolean setDefaultServiceForCategory(ComponentName componentName, String string2) {
        try {
            boolean bl = sService.setDefaultServiceForCategory(UserHandle.myUserId(), componentName, string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                boolean bl = sService.setDefaultServiceForCategory(UserHandle.myUserId(), componentName, string2);
                return bl;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    public boolean setPreferredService(Activity activity, ComponentName componentName) {
        if (activity == null || componentName == null) {
            throw new NullPointerException("activity or service or category is null");
        }
        if (!activity.isResumed()) {
            throw new IllegalArgumentException("Activity must be resumed.");
        }
        try {
            boolean bl = sService.setPreferredService(componentName);
            return bl;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                boolean bl = sService.setPreferredService(componentName);
                return bl;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    public boolean supportsAidPrefixRegistration() {
        try {
            boolean bl = sService.supportsAidPrefixRegistration();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                boolean bl = sService.supportsAidPrefixRegistration();
                return bl;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    public boolean unsetPreferredService(Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity is null");
        }
        if (!activity.isResumed()) {
            throw new IllegalArgumentException("Activity must be resumed.");
        }
        try {
            boolean bl = sService.unsetPreferredService();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.recoverService();
            if (sService == null) {
                Log.e(TAG, "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                boolean bl = sService.unsetPreferredService();
                return bl;
            }
            catch (RemoteException remoteException2) {
                Log.e(TAG, "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }
}

