/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class IsoDep
extends BasicTagTechnology {
    public static final String EXTRA_HIST_BYTES = "histbytes";
    public static final String EXTRA_HI_LAYER_RESP = "hiresp";
    private static final String TAG = "NFC";
    private byte[] mHiLayerResponse = null;
    private byte[] mHistBytes = null;

    public IsoDep(Tag tag) throws RemoteException {
        super(tag, 3);
        Bundle bundle = tag.getTechExtras(3);
        if (bundle != null) {
            this.mHiLayerResponse = bundle.getByteArray(EXTRA_HI_LAYER_RESP);
            this.mHistBytes = bundle.getByteArray(EXTRA_HIST_BYTES);
        }
    }

    public static IsoDep get(Tag tag) {
        if (!tag.hasTech(3)) {
            return null;
        }
        try {
            IsoDep isoDep = new IsoDep(tag);
            return isoDep;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public byte[] getHiLayerResponse() {
        return this.mHiLayerResponse;
    }

    public byte[] getHistoricalBytes() {
        return this.mHistBytes;
    }

    public int getMaxTransceiveLength() {
        return this.getMaxTransceiveLengthInternal();
    }

    public int getTimeout() {
        try {
            int n = this.mTag.getTagService().getTimeout(3);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return 0;
        }
    }

    public boolean isExtendedLengthApduSupported() {
        try {
            boolean bl = this.mTag.getTagService().getExtendedLengthApdusSupported();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return false;
        }
    }

    public void setTimeout(int n) {
        try {
            if (this.mTag.getTagService().setTimeout(3, n) != 0) {
                throw new IllegalArgumentException("The supplied timeout is not valid");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
        }
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return this.transceive(byArray, true);
    }
}

