/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.content.Context;
import android.opengl.EGLLogWrapper;
import android.opengl.GLDebugHelper;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final boolean LOG_ATTACH_DETACH = false;
    private static final boolean LOG_EGL = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_SURFACE = false;
    private static final boolean LOG_THREADS = false;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    private static final String TAG = "GLSurfaceView";
    private static final GLThreadManager sGLThreadManager = new GLThreadManager();
    private int mDebugFlags;
    private boolean mDetached;
    private EGLConfigChooser mEGLConfigChooser;
    private int mEGLContextClientVersion;
    private EGLContextFactory mEGLContextFactory;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLThread mGLThread;
    private GLWrapper mGLWrapper;
    private boolean mPreserveEGLContextOnPause;
    private Renderer mRenderer;
    private final WeakReference<GLSurfaceView> mThisWeakRef = new WeakReference<GLSurfaceView>(this);

    public GLSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GLSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    static /* synthetic */ Renderer access$1000(GLSurfaceView gLSurfaceView) {
        return gLSurfaceView.mRenderer;
    }

    static /* synthetic */ boolean access$900(GLSurfaceView gLSurfaceView) {
        return gLSurfaceView.mPreserveEGLContextOnPause;
    }

    private void checkRenderThreadState() {
        if (this.mGLThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    private void init() {
        this.getHolder().addCallback(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.mPreserveEGLContextOnPause;
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDetached && this.mRenderer != null) {
            int n = 1;
            if (this.mGLThread != null) {
                n = this.mGLThread.getRenderMode();
            }
            this.mGLThread = new GLThread(this.mThisWeakRef);
            if (n != 1) {
                this.mGLThread.setRenderMode(n);
            }
            this.mGLThread.start();
        }
        this.mDetached = false;
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        this.mDetached = true;
        super.onDetachedFromWindow();
    }

    public void onPause() {
        this.mGLThread.onPause();
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable runnable) {
        this.mGLThread.queueEvent(runnable);
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void setDebugFlags(int n) {
        this.mDebugFlags = n;
    }

    public void setEGLConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setEGLConfigChooser(new ComponentSizeChooser(n, n2, n3, n4, n5, n6));
    }

    public void setEGLConfigChooser(EGLConfigChooser eGLConfigChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = eGLConfigChooser;
    }

    public void setEGLConfigChooser(boolean bl) {
        this.setEGLConfigChooser(new SimpleEGLConfigChooser(bl));
    }

    public void setEGLContextClientVersion(int n) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = n;
    }

    public void setEGLContextFactory(EGLContextFactory eGLContextFactory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = eGLContextFactory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = eGLWindowSurfaceFactory;
    }

    public void setGLWrapper(GLWrapper gLWrapper) {
        this.mGLWrapper = gLWrapper;
    }

    public void setPreserveEGLContextOnPause(boolean bl) {
        this.mPreserveEGLContextOnPause = bl;
    }

    public void setRenderMode(int n) {
        this.mGLThread.setRenderMode(n);
    }

    public void setRenderer(Renderer renderer) {
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            this.mEGLConfigChooser = new SimpleEGLConfigChooser(true);
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory();
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        this.mRenderer = renderer;
        this.mGLThread = new GLThread(this.mThisWeakRef);
        this.mGLThread.start();
    }

    @Override
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        this.mGLThread.onWindowResize(n2, n3);
    }

    @Override
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mGLThread.surfaceCreated();
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mGLThread.surfaceDestroyed();
    }

    private abstract class BaseConfigChooser
    implements EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] nArray) {
            this.mConfigSpec = this.filterConfigSpec(nArray);
        }

        /*
         * Enabled aggressive block sorting
         */
        private int[] filterConfigSpec(int[] nArray) {
            if (GLSurfaceView.this.mEGLContextClientVersion != 2 && GLSurfaceView.this.mEGLContextClientVersion != 3) {
                return nArray;
            }
            int n = nArray.length;
            int[] nArray2 = new int[n + 2];
            System.arraycopy((int[])nArray, (int)0, (int[])nArray2, (int)0, (int)(n - 1));
            nArray2[n - 1] = 12352;
            nArray2[n] = GLSurfaceView.this.mEGLContextClientVersion == 2 ? 4 : 64;
            nArray2[n + 1] = 12344;
            return nArray2;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            if (!eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, null, 0, nArray)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int n = nArray[0];
            if (n <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            if (!eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, eGLConfigArray, n, nArray)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig eGLConfig = this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray);
            if (eGLConfig == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return eGLConfig;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        protected int mAlphaSize;
        protected int mBlueSize;
        protected int mDepthSize;
        protected int mGreenSize;
        protected int mRedSize;
        protected int mStencilSize;
        private int[] mValue;

        public ComponentSizeChooser(int n, int n2, int n3, int n4, int n5, int n6) {
            super(new int[]{12324, n, 12323, n2, 12322, n3, 12321, n4, 12325, n5, 12326, n6, 12344});
            this.mValue = new int[1];
            this.mRedSize = n;
            this.mGreenSize = n2;
            this.mBlueSize = n3;
            this.mAlphaSize = n4;
            this.mDepthSize = n5;
            this.mStencilSize = n6;
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.mValue)) {
                n2 = this.mValue[0];
            }
            return n2;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (n < this.mDepthSize || n2 < this.mStencilSize) continue;
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (n3 != this.mRedSize || n4 != this.mGreenSize || n5 != this.mBlueSize || n6 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }
    }

    private class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, GLSurfaceView.this.mEGLContextClientVersion, 12344};
            EGLContext eGLContext = EGL10.EGL_NO_CONTEXT;
            if (GLSurfaceView.this.mEGLContextClientVersion != 0) {
                return eGL10.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray);
            }
            nArray = null;
            return eGL10.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray);
        }

        @Override
        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            if (!eGL10.eglDestroyContext(eGLDisplay, eGLContext)) {
                Log.e("DefaultContextFactory", "display:" + eGLDisplay + " context: " + eGLContext);
                EglHelper.throwEglException("eglDestroyContex", eGL10.eglGetError());
            }
        }
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
            try {
                EGLSurface eGLSurface = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, null);
                return eGLSurface;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e(GLSurfaceView.TAG, "eglCreateWindowSurface", illegalArgumentException);
                return null;
            }
        }

        @Override
        public void destroySurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
            eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
        }
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private static class EglHelper {
        EGL10 mEgl;
        EGLConfig mEglConfig;
        EGLContext mEglContext;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        private WeakReference<GLSurfaceView> mGLSurfaceViewWeakRef;

        public EglHelper(WeakReference<GLSurfaceView> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        private void destroySurfaceImp() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLSurfaceView gLSurfaceView = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                if (gLSurfaceView != null) {
                    gLSurfaceView.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        public static String formatEglError(String string2, int n) {
            return string2 + " failed: " + EGLLogWrapper.getErrorString(n);
        }

        public static void logEglErrorAsWarning(String string2, String string3, int n) {
            Log.w(string2, EglHelper.formatEglError(string3, n));
        }

        private void throwEglException(String string2) {
            EglHelper.throwEglException(string2, this.mEgl.eglGetError());
        }

        public static void throwEglException(String string2, int n) {
            throw new RuntimeException(EglHelper.formatEglError(string2, n));
        }

        GL createGL() {
            GL gL = this.mEglContext.getGL();
            GLSurfaceView gLSurfaceView = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
            if (gLSurfaceView != null) {
                if (gLSurfaceView.mGLWrapper != null) {
                    gL = gLSurfaceView.mGLWrapper.wrap(gL);
                }
                if ((3 & gLSurfaceView.mDebugFlags) != 0) {
                    int n = 1 & gLSurfaceView.mDebugFlags;
                    int n2 = 0;
                    if (n != 0) {
                        n2 = 0 | 1;
                    }
                    int n3 = 2 & gLSurfaceView.mDebugFlags;
                    LogWriter logWriter = null;
                    if (n3 != 0) {
                        logWriter = new LogWriter();
                    }
                    gL = GLDebugHelper.wrap(gL, n2, (Writer)logWriter);
                }
            }
            return gL;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean createSurface() {
            if (this.mEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (this.mEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (this.mEglConfig == null) {
                throw new RuntimeException("mEglConfig not initialized");
            }
            this.destroySurfaceImp();
            GLSurfaceView gLSurfaceView = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
            this.mEglSurface = gLSurfaceView != null ? gLSurfaceView.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, gLSurfaceView.getHolder()) : null;
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                if (this.mEgl.eglGetError() == 12299) {
                    Log.e("EglHelper", "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
                return false;
            }
            return true;
        }

        public void destroySurface() {
            this.destroySurfaceImp();
        }

        public void finish() {
            if (this.mEglContext != null) {
                GLSurfaceView gLSurfaceView = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                if (gLSurfaceView != null) {
                    gLSurfaceView.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void start() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] nArray = new int[2];
            if (!this.mEgl.eglInitialize(this.mEglDisplay, nArray)) {
                throw new RuntimeException("eglInitialize failed");
            }
            GLSurfaceView gLSurfaceView = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
            if (gLSurfaceView == null) {
                this.mEglConfig = null;
                this.mEglContext = null;
            } else {
                this.mEglConfig = gLSurfaceView.mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                this.mEglContext = gLSurfaceView.mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
            }
            if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                this.mEglContext = null;
                this.throwEglException("createContext");
            }
            this.mEglSurface = null;
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }
    }

    static class GLThread
    extends Thread {
        private EglHelper mEglHelper;
        private ArrayList<Runnable> mEventQueue = new ArrayList();
        private boolean mExited;
        private boolean mFinishedCreatingEglSurface;
        private WeakReference<GLSurfaceView> mGLSurfaceViewWeakRef;
        private boolean mHasSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private int mHeight = 0;
        private boolean mPaused;
        private boolean mRenderComplete;
        private int mRenderMode = 1;
        private boolean mRequestPaused;
        private boolean mRequestRender = true;
        private boolean mShouldExit;
        private boolean mShouldReleaseEglContext;
        private boolean mSizeChanged = true;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private int mWidth = 0;

        GLThread(WeakReference<GLSurfaceView> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        static /* synthetic */ boolean access$1102(GLThread gLThread, boolean bl) {
            gLThread.mExited = bl;
            return bl;
        }

        /*
         * Exception decompiling
         */
        private void guardedRun() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 98->101)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean readyToDraw() {
            return !this.mPaused && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1);
        }

        private void stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                sGLThreadManager.releaseEglContextLocked(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        public boolean ableToDraw() {
            return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.mRequestPaused = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !(bl = this.mPaused)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && this.mPaused && !(bl = this.mRenderComplete)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onWindowResize(int n, int n2) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.mWidth = n;
                this.mHeight = n2;
                this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused && !this.mRenderComplete && (bl = this.ableToDraw())) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void queueEvent(Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mEventQueue.add(runnable);
                sGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                boolean bl;
                while (!(bl = this.mExited)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                return;
            }
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
                return;
            }
        }

        @Override
        public void run() {
            this.setName("GLThread " + this.getId());
            try {
                this.guardedRun();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                sGLThreadManager.threadExiting(this);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setRenderMode(int n) {
            if (n >= 0 && n <= 1) {
                GLThreadManager gLThreadManager = sGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mRenderMode = n;
                    sGLThreadManager.notifyAll();
                    return;
                }
            }
            throw new IllegalArgumentException("renderMode");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.mHasSurface = true;
                this.mFinishedCreatingEglSurface = false;
                sGLThreadManager.notifyAll();
                while (this.mWaitingForSurface && !this.mFinishedCreatingEglSurface && !(bl = this.mExited)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && !(bl = this.mExited)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }
    }

    private static class GLThreadManager {
        private static String TAG = "GLThreadManager";
        private static final int kGLES_20 = 131072;
        private static final String kMSM7K_RENDERER_PREFIX = "Q3Dimension MSM7500 ";
        private GLThread mEglOwner;
        private boolean mGLESDriverCheckComplete;
        private int mGLESVersion;
        private boolean mGLESVersionCheckComplete;
        private boolean mLimitedGLESContexts;
        private boolean mMultipleGLESContextsAllowed;

        private GLThreadManager() {
        }

        private void checkGLESVersion() {
            if (!this.mGLESVersionCheckComplete) {
                this.mGLESVersion = SystemProperties.getInt("ro.opengles.version", 0);
                if (this.mGLESVersion >= 131072) {
                    this.mMultipleGLESContextsAllowed = true;
                }
                this.mGLESVersionCheckComplete = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void checkGLDriver(GL10 gL10) {
            boolean bl = true;
            synchronized (this) {
                if (!this.mGLESDriverCheckComplete) {
                    this.checkGLESVersion();
                    String string2 = gL10.glGetString(7937);
                    if (this.mGLESVersion < 131072) {
                        boolean bl2 = !string2.startsWith(kMSM7K_RENDERER_PREFIX) ? bl : false;
                        this.mMultipleGLESContextsAllowed = bl2;
                        this.notifyAll();
                    }
                    if (this.mMultipleGLESContextsAllowed) {
                        bl = false;
                    }
                    this.mLimitedGLESContexts = bl;
                    this.mGLESDriverCheckComplete = true;
                }
                return;
            }
        }

        public void releaseEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public boolean shouldReleaseEGLContextWhenPausing() {
            synchronized (this) {
                boolean bl = this.mLimitedGLESContexts;
                return bl;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean shouldTerminateEGLWhenPausing() {
            synchronized (this) {
                this.checkGLESVersion();
                boolean bl = this.mMultipleGLESContextsAllowed;
                if (bl) return false;
                return true;
            }
        }

        public void threadExiting(GLThread gLThread) {
            synchronized (this) {
                GLThread.access$1102(gLThread, true);
                if (this.mEglOwner == gLThread) {
                    this.mEglOwner = null;
                }
                this.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean tryAcquireEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread || this.mEglOwner == null) {
                this.mEglOwner = gLThread;
                this.notifyAll();
                return true;
            } else {
                this.checkGLESVersion();
                if (this.mMultipleGLESContextsAllowed) return true;
                if (this.mEglOwner == null) return false;
                this.mEglOwner.requestReleaseEglContextLocked();
                return false;
            }
        }
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder = new StringBuilder();

        LogWriter() {
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Log.v(GLSurfaceView.TAG, this.mBuilder.toString());
                this.mBuilder.delete(0, this.mBuilder.length());
            }
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void write(char[] cArray, int n, int n2) {
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n + n3];
                if (c == '\n') {
                    this.flushBuilder();
                } else {
                    this.mBuilder.append(c);
                }
                ++n3;
            }
            return;
        }
    }

    public static interface Renderer {
        public void onDrawFrame(GL10 var1);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onSurfaceCreated(GL10 var1, EGLConfig var2);
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        /*
         * Enabled aggressive block sorting
         */
        public SimpleEGLConfigChooser(boolean bl) {
            int n = bl ? 16 : 0;
            super(8, 8, 8, 0, n, 0);
        }
    }
}

