/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.graphics.Bitmap;

public final class GLUtils {
    static {
        GLUtils.nativeClassInit();
    }

    private GLUtils() {
    }

    public static String getEGLErrorString(int n) {
        switch (n) {
            default: {
                return "0x" + Integer.toHexString(n);
            }
            case 12288: {
                return "EGL_SUCCESS";
            }
            case 12289: {
                return "EGL_NOT_INITIALIZED";
            }
            case 12290: {
                return "EGL_BAD_ACCESS";
            }
            case 12291: {
                return "EGL_BAD_ALLOC";
            }
            case 12292: {
                return "EGL_BAD_ATTRIBUTE";
            }
            case 12293: {
                return "EGL_BAD_CONFIG";
            }
            case 12294: {
                return "EGL_BAD_CONTEXT";
            }
            case 12295: {
                return "EGL_BAD_CURRENT_SURFACE";
            }
            case 12296: {
                return "EGL_BAD_DISPLAY";
            }
            case 12297: {
                return "EGL_BAD_MATCH";
            }
            case 12298: {
                return "EGL_BAD_NATIVE_PIXMAP";
            }
            case 12299: {
                return "EGL_BAD_NATIVE_WINDOW";
            }
            case 12300: {
                return "EGL_BAD_PARAMETER";
            }
            case 12301: {
                return "EGL_BAD_SURFACE";
            }
            case 12302: 
        }
        return "EGL_CONTEXT_LOST";
    }

    public static int getInternalFormat(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("getInternalFormat can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        int n = GLUtils.native_getInternalFormat(bitmap);
        if (n < 0) {
            throw new IllegalArgumentException("Unknown internalformat");
        }
        return n;
    }

    public static int getType(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("getType can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        int n = GLUtils.native_getType(bitmap);
        if (n < 0) {
            throw new IllegalArgumentException("Unknown type");
        }
        return n;
    }

    private static native void nativeClassInit();

    private static native int native_getInternalFormat(Bitmap var0);

    private static native int native_getType(Bitmap var0);

    private static native int native_texImage2D(int var0, int var1, int var2, Bitmap var3, int var4, int var5);

    private static native int native_texSubImage2D(int var0, int var1, int var2, int var3, Bitmap var4, int var5, int var6);

    public static native void setTracingLevel(int var0);

    public static void texImage2D(int n, int n2, int n3, Bitmap bitmap, int n4) {
        if (bitmap == null) {
            throw new NullPointerException("texImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        if (GLUtils.native_texImage2D(n, n2, n3, bitmap, -1, n4) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }

    public static void texImage2D(int n, int n2, int n3, Bitmap bitmap, int n4, int n5) {
        if (bitmap == null) {
            throw new NullPointerException("texImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        if (GLUtils.native_texImage2D(n, n2, n3, bitmap, n4, n5) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }

    public static void texImage2D(int n, int n2, Bitmap bitmap, int n3) {
        if (bitmap == null) {
            throw new NullPointerException("texImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        if (GLUtils.native_texImage2D(n, n2, -1, bitmap, -1, n3) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }

    public static void texSubImage2D(int n, int n2, int n3, int n4, Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("texSubImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        if (GLUtils.native_texSubImage2D(n, n2, n3, n4, bitmap, -1, GLUtils.getType(bitmap)) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }

    public static void texSubImage2D(int n, int n2, int n3, int n4, Bitmap bitmap, int n5, int n6) {
        if (bitmap == null) {
            throw new NullPointerException("texSubImage2D can't be used with a null Bitmap");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is recycled");
        }
        if (GLUtils.native_texSubImage2D(n, n2, n3, n4, bitmap, n5, n6) != 0) {
            throw new IllegalArgumentException("invalid Bitmap format");
        }
    }
}

