/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class Binder
implements IBinder {
    private static final boolean CHECK_PARCEL_SIZE = false;
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    static final String TAG = "Binder";
    private static String sDumpDisabled = null;
    private String mDescriptor;
    private long mObject;
    private IInterface mOwner;

    public Binder() {
        this.init();
    }

    static void checkParcel(IBinder iBinder, int n, Parcel parcel, String string2) {
    }

    public static final native long clearCallingIdentity();

    private final native void destroy();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean execTransact(int n, long l, long l2, int n2) {
        boolean bl;
        Parcel parcel = Parcel.obtain(l);
        Parcel parcel2 = Parcel.obtain(l2);
        try {
            boolean bl2;
            bl = bl2 = this.onTransact(n, parcel, parcel2, n2);
        }
        catch (RemoteException remoteException) {
            if ((n2 & 1) != 0) {
                Log.w(TAG, "Binder call failed.", remoteException);
            } else {
                parcel2.setDataPosition(0);
                parcel2.writeException(remoteException);
            }
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            if ((n2 & 1) != 0) {
                Log.w(TAG, "Caught a RuntimeException from the binder stub implementation.", runtimeException);
            } else {
                parcel2.setDataPosition(0);
                parcel2.writeException(runtimeException);
            }
            bl = true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e(TAG, "Caught an OutOfMemoryError from the binder stub implementation.", outOfMemoryError);
            RuntimeException runtimeException = new RuntimeException("Out of memory", outOfMemoryError);
            parcel2.setDataPosition(0);
            parcel2.writeException(runtimeException);
            bl = true;
        }
        Binder.checkParcel(this, n, parcel2, "Unreasonably large binder reply buffer");
        parcel2.recycle();
        parcel.recycle();
        StrictMode.clearGatheredViolations();
        return bl;
    }

    public static final native void flushPendingCommands();

    public static final native int getCallingPid();

    public static final native int getCallingUid();

    public static final UserHandle getCallingUserHandle() {
        return new UserHandle(UserHandle.getUserId(Binder.getCallingUid()));
    }

    public static final native int getThreadStrictModePolicy();

    private final native void init();

    public static final boolean isProxy(IInterface iInterface) {
        return iInterface.asBinder() != iInterface;
    }

    public static final native void joinThreadPool();

    public static final native void restoreCallingIdentity(long var0);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setDumpDisabled(String string2) {
        synchronized (Binder.class) {
            sDumpDisabled = string2;
            return;
        }
    }

    public static final native void setThreadStrictModePolicy(int var0);

    public void attachInterface(IInterface iInterface, String string2) {
        this.mOwner = iInterface;
        this.mDescriptor = string2;
    }

    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void dump(FileDescriptor var1_1, String[] var2_2) {
        var3_3 = new FastPrintWriter(new FileOutputStream(var1_1));
        var6_4 = Binder.sDumpDisabled;
        // MONITOREXIT : android.os.Binder.class
        if (var6_4 != null) ** GOTO lbl-1000
        this.dump(var1_1, var3_3, var2_2);
        ** GOTO lbl9
lbl-1000:
        // 1 sources

        {
            var3_3.println(Binder.sDumpDisabled);
lbl9:
            // 3 sources

            while (true) {
                var3_3.flush();
                return;
            }
            {
                catch (Throwable var4_5) {
                    var3_3.flush();
                    throw var4_5;
                }
                catch (SecurityException var8_6) {}
                var3_3.println("Security exception: " + var8_6.getMessage());
                throw var8_6;
            }
            catch (Throwable var7_7) {
                var3_3.println();
                var3_3.println("Exception occurred while dumping:");
                var7_7.printStackTrace(var3_3);
                ** continue;
            }
        }
    }

    @Override
    public void dumpAsync(final FileDescriptor fileDescriptor, String[] stringArray) {
        new Thread("Binder.dumpAsync", new FastPrintWriter(new FileOutputStream(fileDescriptor)), stringArray){
            final /* synthetic */ String[] val$args;
            final /* synthetic */ PrintWriter val$pw;
            {
                this.val$pw = printWriter;
                this.val$args = stringArray;
                super(string2);
            }

            @Override
            public void run() {
                try {
                    Binder.this.dump(fileDescriptor, this.val$pw, this.val$args);
                    return;
                }
                finally {
                    this.val$pw.flush();
                }
            }
        }.start();
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getInterfaceDescriptor() {
        return this.mDescriptor;
    }

    @Override
    public boolean isBinderAlive() {
        return true;
    }

    @Override
    public void linkToDeath(IBinder.DeathRecipient deathRecipient, int n) {
    }

    protected boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        ParcelFileDescriptor parcelFileDescriptor;
        if (n == 1598968902) {
            parcel2.writeString(this.getInterfaceDescriptor());
            return true;
        }
        if (n == 1598311760) {
            parcelFileDescriptor = parcel.readFileDescriptor();
            String[] stringArray = parcel.readStringArray();
            if (parcelFileDescriptor != null) {
                this.dump(parcelFileDescriptor.getFileDescriptor(), stringArray);
            }
            if (parcel2 != null) {
                parcel2.writeNoException();
                return true;
            }
            StrictMode.clearGatheredViolations();
            return true;
        }
        return false;
        finally {
            parcelFileDescriptor.close();
        }
    }

    @Override
    public boolean pingBinder() {
        return true;
    }

    @Override
    public IInterface queryLocalInterface(String string2) {
        if (this.mDescriptor.equals(string2)) {
            return this.mOwner;
        }
        return null;
    }

    @Override
    public final boolean transact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        if (parcel != null) {
            parcel.setDataPosition(0);
        }
        boolean bl = this.onTransact(n, parcel, parcel2, n2);
        if (parcel2 != null) {
            parcel2.setDataPosition(0);
        }
        return bl;
    }

    @Override
    public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient, int n) {
        return true;
    }
}

