/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Environment;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.TypedProperties;
import dalvik.bytecode.OpcodeInfo;
import dalvik.system.VMDebug;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public final class Debug {
    private static final String DEFAULT_TRACE_BODY = "dmtrace";
    private static final String DEFAULT_TRACE_EXTENSION = ".trace";
    private static final String DEFAULT_TRACE_FILE_PATH;
    private static final String DEFAULT_TRACE_PATH_PREFIX;
    public static final int MEMINFO_BUFFERS = 2;
    public static final int MEMINFO_CACHED = 3;
    public static final int MEMINFO_COUNT = 9;
    public static final int MEMINFO_FREE = 1;
    public static final int MEMINFO_SHMEM = 4;
    public static final int MEMINFO_SLAB = 5;
    public static final int MEMINFO_SWAP_FREE = 7;
    public static final int MEMINFO_SWAP_TOTAL = 6;
    public static final int MEMINFO_TOTAL = 0;
    public static final int MEMINFO_ZRAM_TOTAL = 8;
    private static final int MIN_DEBUGGER_IDLE = 1300;
    public static final int SHOW_CLASSLOADER = 2;
    public static final int SHOW_FULL_DETAIL = 1;
    public static final int SHOW_INITIALIZED = 4;
    private static final int SPIN_DELAY = 200;
    private static final String SYSFS_QEMU_TRACE_STATE = "/sys/qemu_trace/state";
    private static final String TAG = "Debug";
    public static final int TRACE_COUNT_ALLOCS = 1;
    private static final TypedProperties debugProperties;
    private static volatile boolean mWaiting;

    static {
        mWaiting = false;
        DEFAULT_TRACE_PATH_PREFIX = Environment.getLegacyExternalStorageDirectory().getPath() + "/";
        DEFAULT_TRACE_FILE_PATH = DEFAULT_TRACE_PATH_PREFIX + DEFAULT_TRACE_BODY + DEFAULT_TRACE_EXTENSION;
        debugProperties = null;
    }

    private Debug() {
    }

    public static final boolean cacheRegisterMap(String string2) {
        return VMDebug.cacheRegisterMap((String)string2);
    }

    @Deprecated
    public static void changeDebugPort(int n) {
    }

    public static long countInstancesOfClass(Class clazz) {
        return VMDebug.countInstancesOfClass((Class)clazz, (boolean)true);
    }

    public static void dumpHprofData(String string2) throws IOException {
        VMDebug.dumpHprofData((String)string2);
    }

    public static void dumpHprofData(String string2, FileDescriptor fileDescriptor) throws IOException {
        VMDebug.dumpHprofData((String)string2, (FileDescriptor)fileDescriptor);
    }

    public static void dumpHprofDataDdms() {
        VMDebug.dumpHprofDataDdms();
    }

    public static native void dumpNativeBacktraceToFile(int var0, String var1);

    public static native void dumpNativeHeap(FileDescriptor var0);

    public static final void dumpReferenceTables() {
        VMDebug.dumpReferenceTables();
    }

    public static boolean dumpService(String string2, FileDescriptor fileDescriptor, String[] stringArray) {
        IBinder iBinder = ServiceManager.getService(string2);
        if (iBinder == null) {
            Log.e(TAG, "Can't find service to dump: " + string2);
            return false;
        }
        try {
            iBinder.dump(fileDescriptor, stringArray);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Can't dump service: " + string2, remoteException);
            return false;
        }
    }

    public static void enableEmulatorTraceOutput() {
        VMDebug.startEmulatorTracing();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean fieldTypeMatches(Field field, Class<?> clazz) {
        Field field2;
        Class<?> clazz2 = field.getType();
        if (clazz2 == clazz) {
            return true;
        }
        try {
            field2 = clazz.getField("TYPE");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        try {
            Class clazz3 = (Class)field2.get(null);
            if (clazz2 != clazz3) return false;
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    private static String fixTraceName(String string2) {
        if (string2 == null) {
            string2 = DEFAULT_TRACE_FILE_PATH;
        }
        if (string2.charAt(0) != '/') {
            string2 = DEFAULT_TRACE_PATH_PREFIX + string2;
        }
        if (!string2.endsWith(DEFAULT_TRACE_EXTENSION)) {
            string2 = string2 + DEFAULT_TRACE_EXTENSION;
        }
        return string2;
    }

    public static final native int getBinderDeathObjectCount();

    public static final native int getBinderLocalObjectCount();

    public static final native int getBinderProxyObjectCount();

    public static native int getBinderReceivedTransactions();

    public static native int getBinderSentTransactions();

    public static String getCaller() {
        return Debug.getCaller(Thread.currentThread().getStackTrace(), 0);
    }

    private static String getCaller(StackTraceElement[] stackTraceElementArray, int n) {
        if (n + 4 >= stackTraceElementArray.length) {
            return "<bottom of call stack>";
        }
        StackTraceElement stackTraceElement = stackTraceElementArray[n + 4];
        return stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
    }

    public static String getCallers(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Debug.getCaller(stackTraceElementArray, i)).append(" ");
        }
        return stringBuffer.toString();
    }

    public static String getCallers(int n, int n2) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 + n;
        for (int i = n; i < n3; ++i) {
            stringBuffer.append(Debug.getCaller(stackTraceElementArray, i)).append(" ");
        }
        return stringBuffer.toString();
    }

    public static String getCallers(int n, String string2) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string2).append(Debug.getCaller(stackTraceElementArray, i)).append("\n");
        }
        return stringBuffer.toString();
    }

    public static int getGlobalAllocCount() {
        return VMDebug.getAllocCount((int)1);
    }

    public static int getGlobalAllocSize() {
        return VMDebug.getAllocCount((int)2);
    }

    public static int getGlobalClassInitCount() {
        return VMDebug.getAllocCount((int)32);
    }

    public static int getGlobalClassInitTime() {
        return VMDebug.getAllocCount((int)64);
    }

    @Deprecated
    public static int getGlobalExternalAllocCount() {
        return 0;
    }

    @Deprecated
    public static int getGlobalExternalAllocSize() {
        return 0;
    }

    @Deprecated
    public static int getGlobalExternalFreedCount() {
        return 0;
    }

    @Deprecated
    public static int getGlobalExternalFreedSize() {
        return 0;
    }

    public static int getGlobalFreedCount() {
        return VMDebug.getAllocCount((int)4);
    }

    public static int getGlobalFreedSize() {
        return VMDebug.getAllocCount((int)8);
    }

    public static int getGlobalGcInvocationCount() {
        return VMDebug.getAllocCount((int)16);
    }

    public static int getLoadedClassCount() {
        return VMDebug.getLoadedClassCount();
    }

    public static native void getMemInfo(long[] var0);

    public static native void getMemoryInfo(int var0, MemoryInfo var1);

    public static native void getMemoryInfo(MemoryInfo var0);

    public static int getMethodTracingMode() {
        return VMDebug.getMethodTracingMode();
    }

    public static native long getNativeHeapAllocatedSize();

    public static native long getNativeHeapFreeSize();

    public static native long getNativeHeapSize();

    public static native long getPss();

    public static native long getPss(int var0, long[] var1);

    public static int getThreadAllocCount() {
        return VMDebug.getAllocCount((int)65536);
    }

    public static int getThreadAllocSize() {
        return VMDebug.getAllocCount((int)131072);
    }

    @Deprecated
    public static int getThreadExternalAllocCount() {
        return 0;
    }

    @Deprecated
    public static int getThreadExternalAllocSize() {
        return 0;
    }

    public static int getThreadGcInvocationCount() {
        return VMDebug.getAllocCount((int)0x100000);
    }

    public static String[] getVmFeatureList() {
        return VMDebug.getVmFeatureList();
    }

    public static boolean isDebuggerConnected() {
        return VMDebug.isDebuggerConnected();
    }

    /*
     * Exception decompiling
     */
    private static void modifyFieldIfSet(Field var0, TypedProperties var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CASE]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void printLoadedClasses(int n) {
        VMDebug.printLoadedClasses((int)n);
    }

    public static void resetAllCounts() {
        VMDebug.resetAllocCount((int)-1);
    }

    public static void resetGlobalAllocCount() {
        VMDebug.resetAllocCount((int)1);
    }

    public static void resetGlobalAllocSize() {
        VMDebug.resetAllocCount((int)2);
    }

    public static void resetGlobalClassInitCount() {
        VMDebug.resetAllocCount((int)32);
    }

    public static void resetGlobalClassInitTime() {
        VMDebug.resetAllocCount((int)64);
    }

    @Deprecated
    public static void resetGlobalExternalAllocCount() {
    }

    @Deprecated
    public static void resetGlobalExternalAllocSize() {
    }

    @Deprecated
    public static void resetGlobalExternalFreedCount() {
    }

    @Deprecated
    public static void resetGlobalExternalFreedSize() {
    }

    public static void resetGlobalFreedCount() {
        VMDebug.resetAllocCount((int)4);
    }

    public static void resetGlobalFreedSize() {
        VMDebug.resetAllocCount((int)8);
    }

    public static void resetGlobalGcInvocationCount() {
        VMDebug.resetAllocCount((int)16);
    }

    public static void resetThreadAllocCount() {
        VMDebug.resetAllocCount((int)65536);
    }

    public static void resetThreadAllocSize() {
        VMDebug.resetAllocCount((int)131072);
    }

    @Deprecated
    public static void resetThreadExternalAllocCount() {
    }

    @Deprecated
    public static void resetThreadExternalAllocSize() {
    }

    public static void resetThreadGcInvocationCount() {
        VMDebug.resetAllocCount((int)0x100000);
    }

    @Deprecated
    public static int setAllocationLimit(int n) {
        return -1;
    }

    public static void setFieldsOn(Class<?> clazz) {
        Debug.setFieldsOn(clazz, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setFieldsOn(Class<?> clazz, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder().append("setFieldsOn(");
        String string2 = clazz == null ? "null" : clazz.getName();
        Log.wtf(TAG, stringBuilder.append(string2).append(") called in non-DEBUG build").toString());
    }

    @Deprecated
    public static int setGlobalAllocationLimit(int n) {
        return -1;
    }

    @Deprecated
    public static void startAllocCounting() {
        VMDebug.startAllocCounting();
    }

    public static void startMethodTracing() {
        VMDebug.startMethodTracing((String)DEFAULT_TRACE_FILE_PATH, (int)0, (int)0, (boolean)false, (int)0);
    }

    public static void startMethodTracing(String string2) {
        Debug.startMethodTracing(string2, 0, 0);
    }

    public static void startMethodTracing(String string2, int n) {
        Debug.startMethodTracing(string2, n, 0);
    }

    public static void startMethodTracing(String string2, int n, int n2) {
        VMDebug.startMethodTracing((String)Debug.fixTraceName(string2), (int)n, (int)n2, (boolean)false, (int)0);
    }

    public static void startMethodTracing(String string2, FileDescriptor fileDescriptor, int n, int n2) {
        VMDebug.startMethodTracing((String)string2, (FileDescriptor)fileDescriptor, (int)n, (int)n2, (boolean)false, (int)0);
    }

    public static void startMethodTracingDdms(int n, int n2, boolean bl, int n3) {
        VMDebug.startMethodTracingDdms((int)n, (int)n2, (boolean)bl, (int)n3);
    }

    public static void startMethodTracingSampling(String string2, int n, int n2) {
        VMDebug.startMethodTracing((String)Debug.fixTraceName(string2), (int)n, (int)0, (boolean)true, (int)n2);
    }

    /*
     * Unable to fully structure code
     */
    public static void startNativeTracing() {
        block10: {
            var0 = null;
            var1_1 = new FastPrintWriter(new FileOutputStream("/sys/qemu_trace/state"));
            try {
                var1_1.println("1");
                if (var1_1 == null) break block10;
                var1_1.close();
            }
            catch (Throwable var3_5) {
                var0 = var1_1;
                ** continue;
            }
            catch (Exception var2_6) {
                var0 = var1_1;
                ** continue;
            }
        }
lbl9:
        // 3 sources

        while (true) {
            VMDebug.startEmulatorTracing();
            return;
        }
        catch (Exception var4_2) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var0 == null) ** GOTO lbl9
                var0.close();
                ** continue;
                break;
            }
        }
        catch (Throwable var3_3) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var0 != null) {
                    var0.close();
                }
                throw var3_4;
            }
        }
    }

    @Deprecated
    public static void stopAllocCounting() {
        VMDebug.stopAllocCounting();
    }

    public static void stopMethodTracing() {
        VMDebug.stopMethodTracing();
    }

    /*
     * Unable to fully structure code
     */
    public static void stopNativeTracing() {
        block10: {
            VMDebug.stopEmulatorTracing();
            var0 = null;
            var1_1 = new FastPrintWriter(new FileOutputStream("/sys/qemu_trace/state"));
            try {
                var1_1.println("0");
                if (var1_1 == null) break block10;
                var1_1.close();
            }
            catch (Throwable var3_5) {
                var0 = var1_1;
                ** continue;
            }
            catch (Exception var2_6) {
                var0 = var1_1;
                ** continue;
            }
            return;
            catch (Exception var4_2) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var0 == null) ** continue;
                    var0.close();
                    return;
                }
            }
            catch (Throwable var3_3) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var0 != null) {
                        var0.close();
                    }
                    throw var3_4;
                }
            }
        }
    }

    public static long threadCpuTimeNanos() {
        return VMDebug.threadCpuTimeNanos();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitForDebugger() {
        if (!VMDebug.isDebuggingEnabled() || Debug.isDebuggerConnected()) {
            return;
        }
        System.out.println("Sending WAIT chunk");
        byte[] byArray = new byte[]{0};
        DdmServer.sendChunk((Chunk)new Chunk(ChunkHandler.type((String)"WAIT"), byArray, 0, 1));
        mWaiting = true;
        while (!Debug.isDebuggerConnected()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        mWaiting = false;
        System.out.println("Debugger has connected");
        while (true) {
            long l;
            if ((l = VMDebug.lastDebuggerActivity()) < 0L) {
                System.out.println("debugger detached?");
                return;
            }
            if (l >= 1300L) {
                System.out.println("debugger has settled (" + l + ")");
                return;
            }
            System.out.println("waiting for debugger to settle...");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static boolean waitingForDebugger() {
        return mWaiting;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DebugProperty {
    }

    public static class InstructionCount {
        private static final int NUM_INSTR = 1 + OpcodeInfo.MAXIMUM_PACKED_VALUE;
        private int[] mCounts = new int[NUM_INSTR];

        public boolean collect() {
            try {
                VMDebug.stopInstructionCounting();
                VMDebug.getInstructionCount((int[])this.mCounts);
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return false;
            }
        }

        public int globalMethodInvocations() {
            int n = 0;
            for (int i = 0; i < NUM_INSTR; ++i) {
                if (!OpcodeInfo.isInvoke((int)i)) continue;
                n += this.mCounts[i];
            }
            return n;
        }

        public int globalTotal() {
            int n = 0;
            for (int i = 0; i < NUM_INSTR; ++i) {
                n += this.mCounts[i];
            }
            return n;
        }

        public boolean resetAndStart() {
            try {
                VMDebug.startInstructionCounting();
                VMDebug.resetInstructionCount();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return false;
            }
        }
    }

    public static class MemoryInfo
    implements Parcelable {
        public static final Parcelable.Creator<MemoryInfo> CREATOR = new Parcelable.Creator<MemoryInfo>(){

            @Override
            public MemoryInfo createFromParcel(Parcel parcel) {
                return new MemoryInfo(parcel);
            }

            public MemoryInfo[] newArray(int n) {
                return new MemoryInfo[n];
            }
        };
        public static final int NUM_CATEGORIES = 7;
        public static final int NUM_DVK_STATS = 5;
        public static final int NUM_OTHER_STATS = 16;
        public static final int offsetPrivateClean = 4;
        public static final int offsetPrivateDirty = 2;
        public static final int offsetPss = 0;
        public static final int offsetSharedClean = 5;
        public static final int offsetSharedDirty = 3;
        public static final int offsetSwappablePss = 1;
        public static final int offsetSwappedOut = 6;
        public int dalvikPrivateClean;
        public int dalvikPrivateDirty;
        public int dalvikPss;
        public int dalvikSharedClean;
        public int dalvikSharedDirty;
        public int dalvikSwappablePss;
        public int dalvikSwappedOut;
        public int nativePrivateClean;
        public int nativePrivateDirty;
        public int nativePss;
        public int nativeSharedClean;
        public int nativeSharedDirty;
        public int nativeSwappablePss;
        public int nativeSwappedOut;
        public int otherPrivateClean;
        public int otherPrivateDirty;
        public int otherPss;
        public int otherSharedClean;
        public int otherSharedDirty;
        private int[] otherStats = new int[147];
        public int otherSwappablePss;
        public int otherSwappedOut;

        public MemoryInfo() {
        }

        private MemoryInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        public static String getOtherLabel(int n) {
            switch (n) {
                default: {
                    return "????";
                }
                case 0: {
                    return "Dalvik Other";
                }
                case 1: {
                    return "Stack";
                }
                case 2: {
                    return "Cursor";
                }
                case 3: {
                    return "Ashmem";
                }
                case 4: {
                    return "Other dev";
                }
                case 5: {
                    return ".so mmap";
                }
                case 6: {
                    return ".jar mmap";
                }
                case 7: {
                    return ".apk mmap";
                }
                case 8: {
                    return ".ttf mmap";
                }
                case 9: {
                    return ".dex mmap";
                }
                case 10: {
                    return "code mmap";
                }
                case 11: {
                    return "image mmap";
                }
                case 12: {
                    return "Other mmap";
                }
                case 13: {
                    return "Graphics";
                }
                case 14: {
                    return "GL";
                }
                case 15: {
                    return "Memtrack";
                }
                case 16: {
                    return ".Heap";
                }
                case 17: {
                    return ".LOS";
                }
                case 18: {
                    return ".LinearAlloc";
                }
                case 19: {
                    return ".GC";
                }
                case 20: 
            }
            return ".JITCache";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int getOtherPrivateClean(int n) {
            return this.otherStats[4 + n * 7];
        }

        public int getOtherPrivateDirty(int n) {
            return this.otherStats[2 + n * 7];
        }

        public int getOtherPss(int n) {
            return this.otherStats[0 + n * 7];
        }

        public int getOtherSharedClean(int n) {
            return this.otherStats[5 + n * 7];
        }

        public int getOtherSharedDirty(int n) {
            return this.otherStats[3 + n * 7];
        }

        public int getOtherSwappablePss(int n) {
            return this.otherStats[1 + n * 7];
        }

        public int getOtherSwappedOut(int n) {
            return this.otherStats[6 + n * 7];
        }

        public int getTotalPrivateClean() {
            return this.dalvikPrivateClean + this.nativePrivateClean + this.otherPrivateClean;
        }

        public int getTotalPrivateDirty() {
            return this.dalvikPrivateDirty + this.nativePrivateDirty + this.otherPrivateDirty;
        }

        public int getTotalPss() {
            return this.dalvikPss + this.nativePss + this.otherPss;
        }

        public int getTotalSharedClean() {
            return this.dalvikSharedClean + this.nativeSharedClean + this.otherSharedClean;
        }

        public int getTotalSharedDirty() {
            return this.dalvikSharedDirty + this.nativeSharedDirty + this.otherSharedDirty;
        }

        public int getTotalSwappablePss() {
            return this.dalvikSwappablePss + this.nativeSwappablePss + this.otherSwappablePss;
        }

        public int getTotalSwappedOut() {
            return this.dalvikSwappedOut + this.nativeSwappedOut + this.otherSwappedOut;
        }

        public int getTotalUss() {
            return this.dalvikPrivateClean + this.dalvikPrivateDirty + this.nativePrivateClean + this.nativePrivateDirty + this.otherPrivateClean + this.otherPrivateDirty;
        }

        public void readFromParcel(Parcel parcel) {
            this.dalvikPss = parcel.readInt();
            this.dalvikSwappablePss = parcel.readInt();
            this.dalvikPrivateDirty = parcel.readInt();
            this.dalvikSharedDirty = parcel.readInt();
            this.dalvikPrivateClean = parcel.readInt();
            this.dalvikSharedClean = parcel.readInt();
            this.dalvikSwappedOut = parcel.readInt();
            this.nativePss = parcel.readInt();
            this.nativeSwappablePss = parcel.readInt();
            this.nativePrivateDirty = parcel.readInt();
            this.nativeSharedDirty = parcel.readInt();
            this.nativePrivateClean = parcel.readInt();
            this.nativeSharedClean = parcel.readInt();
            this.nativeSwappedOut = parcel.readInt();
            this.otherPss = parcel.readInt();
            this.otherSwappablePss = parcel.readInt();
            this.otherPrivateDirty = parcel.readInt();
            this.otherSharedDirty = parcel.readInt();
            this.otherPrivateClean = parcel.readInt();
            this.otherSharedClean = parcel.readInt();
            this.otherSwappedOut = parcel.readInt();
            this.otherStats = parcel.createIntArray();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.dalvikPss);
            parcel.writeInt(this.dalvikSwappablePss);
            parcel.writeInt(this.dalvikPrivateDirty);
            parcel.writeInt(this.dalvikSharedDirty);
            parcel.writeInt(this.dalvikPrivateClean);
            parcel.writeInt(this.dalvikSharedClean);
            parcel.writeInt(this.dalvikSwappedOut);
            parcel.writeInt(this.nativePss);
            parcel.writeInt(this.nativeSwappablePss);
            parcel.writeInt(this.nativePrivateDirty);
            parcel.writeInt(this.nativeSharedDirty);
            parcel.writeInt(this.nativePrivateClean);
            parcel.writeInt(this.nativeSharedClean);
            parcel.writeInt(this.nativeSwappedOut);
            parcel.writeInt(this.otherPss);
            parcel.writeInt(this.otherSwappablePss);
            parcel.writeInt(this.otherPrivateDirty);
            parcel.writeInt(this.otherSharedDirty);
            parcel.writeInt(this.otherPrivateClean);
            parcel.writeInt(this.otherSharedClean);
            parcel.writeInt(this.otherSwappedOut);
            parcel.writeIntArray(this.otherStats);
        }
    }
}

