/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.TimeUtils;

public final class Message
implements Parcelable {
    public static final Parcelable.Creator<Message> CREATOR;
    static final int FLAGS_TO_CLEAR_ON_COPY_FROM = 1;
    static final int FLAG_ASYNCHRONOUS = 2;
    static final int FLAG_IN_USE = 1;
    private static final int MAX_POOL_SIZE = 50;
    private static boolean gCheckRecycle;
    private static Message sPool;
    private static int sPoolSize;
    private static final Object sPoolSync;
    public int arg1;
    public int arg2;
    Runnable callback;
    Bundle data;
    int flags;
    Message next;
    public Object obj;
    public Messenger replyTo;
    public int sendingUid = -1;
    Handler target;
    public int what;
    long when;

    static {
        sPoolSync = new Object();
        sPoolSize = 0;
        gCheckRecycle = true;
        CREATOR = new Parcelable.Creator<Message>(){

            @Override
            public Message createFromParcel(Parcel parcel) {
                Message message = Message.obtain();
                message.readFromParcel(parcel);
                return message;
            }

            public Message[] newArray(int n) {
                return new Message[n];
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message obtain() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null) {
                Message message = sPool;
                sPool = message.next;
                message.next = null;
                message.flags = 0;
                sPoolSize = -1 + sPoolSize;
                return message;
            }
            return new Message();
        }
    }

    public static Message obtain(Handler handler) {
        Message message = Message.obtain();
        message.target = handler;
        return message;
    }

    public static Message obtain(Handler handler, int n) {
        Message message = Message.obtain();
        message.target = handler;
        message.what = n;
        return message;
    }

    public static Message obtain(Handler handler, int n, int n2, int n3) {
        Message message = Message.obtain();
        message.target = handler;
        message.what = n;
        message.arg1 = n2;
        message.arg2 = n3;
        return message;
    }

    public static Message obtain(Handler handler, int n, int n2, int n3, Object object) {
        Message message = Message.obtain();
        message.target = handler;
        message.what = n;
        message.arg1 = n2;
        message.arg2 = n3;
        message.obj = object;
        return message;
    }

    public static Message obtain(Handler handler, int n, Object object) {
        Message message = Message.obtain();
        message.target = handler;
        message.what = n;
        message.obj = object;
        return message;
    }

    public static Message obtain(Handler handler, Runnable runnable) {
        Message message = Message.obtain();
        message.target = handler;
        message.callback = runnable;
        return message;
    }

    public static Message obtain(Message message) {
        Message message2 = Message.obtain();
        message2.what = message.what;
        message2.arg1 = message.arg1;
        message2.arg2 = message.arg2;
        message2.obj = message.obj;
        message2.replyTo = message.replyTo;
        message2.sendingUid = message.sendingUid;
        if (message.data != null) {
            message2.data = new Bundle(message.data);
        }
        message2.target = message.target;
        message2.callback = message.callback;
        return message2;
    }

    private void readFromParcel(Parcel parcel) {
        this.what = parcel.readInt();
        this.arg1 = parcel.readInt();
        this.arg2 = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.obj = parcel.readParcelable(this.getClass().getClassLoader());
        }
        this.when = parcel.readLong();
        this.data = parcel.readBundle();
        this.replyTo = Messenger.readMessengerOrNullFromParcel(parcel);
        this.sendingUid = parcel.readInt();
    }

    public static void updateCheckRecycle(int n) {
        if (n < 21) {
            gCheckRecycle = false;
        }
    }

    public void copyFrom(Message message) {
        this.flags = 0xFFFFFFFE & message.flags;
        this.what = message.what;
        this.arg1 = message.arg1;
        this.arg2 = message.arg2;
        this.obj = message.obj;
        this.replyTo = message.replyTo;
        this.sendingUid = message.sendingUid;
        if (message.data != null) {
            this.data = (Bundle)message.data.clone();
            return;
        }
        this.data = null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Runnable getCallback() {
        return this.callback;
    }

    public Bundle getData() {
        if (this.data == null) {
            this.data = new Bundle();
        }
        return this.data;
    }

    public Handler getTarget() {
        return this.target;
    }

    public long getWhen() {
        return this.when;
    }

    public boolean isAsynchronous() {
        return (2 & this.flags) != 0;
    }

    boolean isInUse() {
        return (1 & this.flags) == 1;
    }

    void markInUse() {
        this.flags = 1 | this.flags;
    }

    public Bundle peekData() {
        return this.data;
    }

    public void recycle() {
        if (this.isInUse()) {
            if (gCheckRecycle) {
                throw new IllegalStateException("This message cannot be recycled because it is still in use.");
            }
        } else {
            this.recycleUnchecked();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void recycleUnchecked() {
        this.flags = 1;
        this.what = 0;
        this.arg1 = 0;
        this.arg2 = 0;
        this.obj = null;
        this.replyTo = null;
        this.sendingUid = -1;
        this.when = 0L;
        this.target = null;
        this.callback = null;
        this.data = null;
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 50) {
                this.next = sPool;
                sPool = this;
                sPoolSize = 1 + sPoolSize;
            }
            return;
        }
    }

    public void sendToTarget() {
        this.target.sendMessage(this);
    }

    public void setAsynchronous(boolean bl) {
        if (bl) {
            this.flags = 2 | this.flags;
            return;
        }
        this.flags = 0xFFFFFFFD & this.flags;
    }

    public void setData(Bundle bundle) {
        this.data = bundle;
    }

    public void setTarget(Handler handler) {
        this.target = handler;
    }

    public String toString() {
        return this.toString(SystemClock.uptimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    String toString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ when=");
        TimeUtils.formatDuration(this.when - l, stringBuilder);
        if (this.target != null) {
            if (this.callback != null) {
                stringBuilder.append(" callback=");
                stringBuilder.append(this.callback.getClass().getName());
            } else {
                stringBuilder.append(" what=");
                stringBuilder.append(this.what);
            }
            if (this.arg1 != 0) {
                stringBuilder.append(" arg1=");
                stringBuilder.append(this.arg1);
            }
            if (this.arg2 != 0) {
                stringBuilder.append(" arg2=");
                stringBuilder.append(this.arg2);
            }
            if (this.obj != null) {
                stringBuilder.append(" obj=");
                stringBuilder.append(this.obj);
            }
            stringBuilder.append(" target=");
            stringBuilder.append(this.target.getClass().getName());
        } else {
            stringBuilder.append(" barrier=");
            stringBuilder.append(this.arg1);
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (this.callback != null) {
            throw new RuntimeException("Can't marshal callbacks across processes.");
        }
        parcel.writeInt(this.what);
        parcel.writeInt(this.arg1);
        parcel.writeInt(this.arg2);
        if (this.obj != null) {
            try {
                Parcelable parcelable = (Parcelable)this.obj;
                parcel.writeInt(1);
                parcel.writeParcelable(parcelable, n);
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException("Can't marshal non-Parcelable objects across processes.");
            }
        } else {
            parcel.writeInt(0);
        }
        parcel.writeLong(this.when);
        parcel.writeBundle(this.data);
        Messenger.writeMessengerOrNullToParcel(this.replyTo, parcel);
        parcel.writeInt(this.sendingUid);
    }
}

