/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.ConditionVariable;
import android.os.FileUtils;
import android.os.PowerManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecoverySystem {
    private static File COMMAND_FILE;
    private static final File DEFAULT_KEYSTORE;
    private static String FOTA_STATUS_FILENAME;
    private static String LAST_LOG_FILENAME;
    private static String LAST_PREFIX;
    private static File LOG_FILE;
    private static int LOG_FILE_MAX_LENGTH = 0;
    private static final long PUBLISH_PROGRESS_INTERVAL_MS = 500L;
    private static File RECOVERY_DIR;
    private static final String TAG = "RecoverySystem";

    static {
        DEFAULT_KEYSTORE = new File("/system/etc/security/otacerts.zip");
        RECOVERY_DIR = new File("/cache/recovery");
        COMMAND_FILE = new File(RECOVERY_DIR, "command");
        LOG_FILE = new File(RECOVERY_DIR, "log");
        LAST_PREFIX = "last_";
        LAST_LOG_FILENAME = "last_log";
        FOTA_STATUS_FILENAME = "fota_status";
        LOG_FILE_MAX_LENGTH = 65536;
    }

    private void RecoverySystem() {
    }

    private static void bootCommand(Context context, String ... stringArray) throws IOException {
        int n;
        RECOVERY_DIR.mkdirs();
        COMMAND_FILE.delete();
        LOG_FILE.delete();
        FileWriter fileWriter = new FileWriter(COMMAND_FILE);
        try {
            n = stringArray.length;
        }
        catch (Throwable throwable) {
            fileWriter.close();
            throw throwable;
        }
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (TextUtils.isEmpty(string2)) continue;
            fileWriter.write(string2);
            fileWriter.write("\n");
            continue;
        }
        fileWriter.close();
        ((PowerManager)context.getSystemService("power")).reboot("recovery");
        throw new IOException("Reboot failed (no permissions?)");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashSet<X509Certificate> getTrustedCerts(File file) throws IOException, GeneralSecurityException {
        InputStream inputStream;
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        if (file == null) {
            file = DEFAULT_KEYSTORE;
        }
        ZipFile zipFile = new ZipFile(file);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            inputStream = zipFile.getInputStream(enumeration.nextElement());
        }
        {
            try {
                hashSet.add((X509Certificate)certificateFactory.generateCertificate(inputStream));
                continue;
            }
            finally {
                inputStream.close();
                continue;
                break;
            }
        }
        {
            catch (Throwable throwable) {
                zipFile.close();
                throw throwable;
            }
        }
        zipFile.close();
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String handleAftermath() {
        String string2;
        try {
            String string3;
            string2 = string3 = FileUtils.readTextFile(LOG_FILE, -LOG_FILE_MAX_LENGTH, "...\n");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.i(TAG, "No recovery log file");
            string2 = null;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Error reading recovery log", iOException);
            string2 = null;
        }
        String[] stringArray = RECOVERY_DIR.list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (stringArray[i].startsWith(LAST_PREFIX) || stringArray[i].equals(LAST_LOG_FILENAME) || stringArray[i].equals(FOTA_STATUS_FILENAME)) continue;
            File file = new File(RECOVERY_DIR, stringArray[i]);
            if (!file.delete()) {
                Log.e(TAG, "Can't delete: " + file);
                continue;
            }
            Log.i(TAG, "Deleted: " + file);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void installPackage(Context context, File file) throws IOException {
        String string2 = file.getCanonicalPath();
        Log.w(TAG, "!!! REBOOTING TO INSTALL " + string2 + " !!!");
        String string3 = string2.equalsIgnoreCase("/cache/dlpkgfile") ? "--update_package=" + string2 + "\n--locale=" + Locale.getDefault().toString() + "\n--requester=dm_client" : "--update_package=" + string2 + "\n--locale=" + Locale.getDefault().toString();
        RecoverySystem.bootCommand(context, string3);
    }

    public static void rebootWipeCache(Context context) throws IOException {
        RecoverySystem.rebootWipeCache(context, context.getPackageName());
    }

    public static void rebootWipeCache(Context context, String string2) throws IOException {
        boolean bl = TextUtils.isEmpty(string2);
        String string3 = null;
        if (!bl) {
            string3 = "--reason=" + RecoverySystem.sanitizeArg(string2);
        }
        RecoverySystem.bootCommand(context, "--wipe_cache", string3, "--locale=" + Locale.getDefault().toString());
    }

    public static void rebootWipeUserData(Context context) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, context.getPackageName());
    }

    public static void rebootWipeUserData(Context context, String string2) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, string2);
    }

    public static void rebootWipeUserData(Context context, boolean bl) throws IOException {
        RecoverySystem.rebootWipeUserData(context, bl, context.getPackageName());
    }

    public static void rebootWipeUserData(Context context, boolean bl, String string2) throws IOException {
        if (((UserManager)context.getSystemService("user")).hasUserRestriction("no_factory_reset")) {
            throw new SecurityException("Wiping data is not allowed for this user.");
        }
        final ConditionVariable conditionVariable = new ConditionVariable();
        Intent intent = new Intent("android.intent.action.MASTER_CLEAR_NOTIFICATION");
        intent.addFlags(0x10000000);
        context.sendOrderedBroadcastAsUser(intent, UserHandle.OWNER, "android.permission.MASTER_CLEAR", new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                conditionVariable.open();
            }
        }, null, 0, null, null);
        conditionVariable.block();
        String string3 = null;
        if (bl) {
            string3 = "--shutdown_after";
        }
        boolean bl2 = TextUtils.isEmpty(string2);
        String string4 = null;
        if (!bl2) {
            string4 = "--reason=" + RecoverySystem.sanitizeArg(string2);
        }
        RecoverySystem.bootCommand(context, string3, "--wipe_data", string4, "--locale=" + Locale.getDefault().toString());
    }

    private static String sanitizeArg(String string2) {
        return string2.replace('\u0000', '?').replace('\n', '?');
    }

    /*
     * Exception decompiling
     */
    public static void verifyPackage(File var0, ProgressListener var1_1, File var2_2) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 97->224)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface ProgressListener {
        public void onProgress(int var1);
    }
}

