/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.android.internal.R;

public abstract class DialogPreference
extends Preference
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener,
PreferenceManager.OnActivityDestroyListener {
    private AlertDialog.Builder mBuilder;
    private Dialog mDialog;
    private Drawable mDialogIcon;
    private int mDialogLayoutResId;
    private CharSequence mDialogMessage;
    private CharSequence mDialogTitle;
    private CharSequence mNegativeButtonText;
    private CharSequence mPositiveButtonText;
    private int mWhichButtonClicked;

    public DialogPreference(Context context) {
        this(context, null);
    }

    public DialogPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010091);
    }

    public DialogPreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public DialogPreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.DialogPreference, n, n2);
        this.mDialogTitle = typedArray.getString(0);
        if (this.mDialogTitle == null) {
            this.mDialogTitle = this.getTitle();
        }
        this.mDialogMessage = typedArray.getString(1);
        this.mDialogIcon = typedArray.getDrawable(2);
        this.mPositiveButtonText = typedArray.getString(3);
        this.mNegativeButtonText = typedArray.getString(4);
        this.mDialogLayoutResId = typedArray.getResourceId(5, this.mDialogLayoutResId);
        typedArray.recycle();
    }

    private void requestInputMethod(Dialog dialog) {
        dialog.getWindow().setSoftInputMode(5);
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public Drawable getDialogIcon() {
        return this.mDialogIcon;
    }

    public int getDialogLayoutResource() {
        return this.mDialogLayoutResId;
    }

    public CharSequence getDialogMessage() {
        return this.mDialogMessage;
    }

    public CharSequence getDialogTitle() {
        return this.mDialogTitle;
    }

    public CharSequence getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    public CharSequence getPositiveButtonText() {
        return this.mPositiveButtonText;
    }

    protected boolean needInputMethod() {
        return false;
    }

    @Override
    public void onActivityDestroy() {
        if (this.mDialog == null || !this.mDialog.isShowing()) {
            return;
        }
        this.mDialog.dismiss();
    }

    protected void onBindDialogView(View view) {
        View view2 = view.findViewById(16908299);
        if (view2 != null) {
            CharSequence charSequence = this.getDialogMessage();
            int n = 8;
            if (!TextUtils.isEmpty(charSequence)) {
                if (view2 instanceof TextView) {
                    ((TextView)view2).setText(charSequence);
                }
                n = 0;
            }
            if (view2.getVisibility() != n) {
                view2.setVisibility(n);
            }
        }
    }

    @Override
    protected void onClick() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            return;
        }
        this.showDialog(null);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        this.mWhichButtonClicked = n;
    }

    protected View onCreateDialogView() {
        if (this.mDialogLayoutResId == 0) {
            return null;
        }
        return LayoutInflater.from(this.mBuilder.getContext()).inflate(this.mDialogLayoutResId, null);
    }

    protected void onDialogClosed(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        this.getPreferenceManager().unregisterOnActivityDestroyListener(this);
        this.mDialog = null;
        boolean bl = this.mWhichButtonClicked == -1;
        this.onDialogClosed(bl);
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        } else {
            SavedState savedState = (SavedState)parcelable;
            super.onRestoreInstanceState(savedState.getSuperState());
            if (!savedState.isDialogShowing) return;
            this.showDialog(savedState.dialogBundle);
            return;
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.mDialog == null || !this.mDialog.isShowing()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.isDialogShowing = true;
        savedState.dialogBundle = this.mDialog.onSaveInstanceState();
        return savedState;
    }

    public void setDialogIcon(int n) {
        this.mDialogIcon = this.getContext().getDrawable(n);
    }

    public void setDialogIcon(Drawable drawable2) {
        this.mDialogIcon = drawable2;
    }

    public void setDialogLayoutResource(int n) {
        this.mDialogLayoutResId = n;
    }

    public void setDialogMessage(int n) {
        this.setDialogMessage(this.getContext().getString(n));
    }

    public void setDialogMessage(CharSequence charSequence) {
        this.mDialogMessage = charSequence;
    }

    public void setDialogTitle(int n) {
        this.setDialogTitle(this.getContext().getString(n));
    }

    public void setDialogTitle(CharSequence charSequence) {
        this.mDialogTitle = charSequence;
    }

    public void setNegativeButtonText(int n) {
        this.setNegativeButtonText(this.getContext().getString(n));
    }

    public void setNegativeButtonText(CharSequence charSequence) {
        this.mNegativeButtonText = charSequence;
    }

    public void setPositiveButtonText(int n) {
        this.setPositiveButtonText(this.getContext().getString(n));
    }

    public void setPositiveButtonText(CharSequence charSequence) {
        this.mPositiveButtonText = charSequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void showDialog(Bundle bundle) {
        Context context = this.getContext();
        this.mWhichButtonClicked = -2;
        this.mBuilder = new AlertDialog.Builder(context).setTitle(this.mDialogTitle).setIcon(this.mDialogIcon).setPositiveButton(this.mPositiveButtonText, (DialogInterface.OnClickListener)this).setNegativeButton(this.mNegativeButtonText, (DialogInterface.OnClickListener)this);
        View view = this.onCreateDialogView();
        if (view != null) {
            this.onBindDialogView(view);
            this.mBuilder.setView(view);
        } else {
            this.mBuilder.setMessage(this.mDialogMessage);
        }
        this.onPrepareDialogBuilder(this.mBuilder);
        this.getPreferenceManager().registerOnActivityDestroyListener(this);
        AlertDialog alertDialog = this.mBuilder.create();
        this.mDialog = alertDialog;
        if (bundle != null) {
            alertDialog.onRestoreInstanceState(bundle);
        }
        if (this.needInputMethod()) {
            this.requestInputMethod(alertDialog);
        }
        alertDialog.setOnDismissListener(this);
        alertDialog.show();
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        Bundle dialogBundle;
        boolean isDialogShowing;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            int n = 1;
            super(parcel);
            if (parcel.readInt() != n) {
                n = 0;
            }
            this.isDialogShowing = n;
            this.dialogBundle = parcel.readBundle();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.isDialogShowing ? 1 : 0;
            parcel.writeInt(n2);
            parcel.writeBundle(this.dialogBundle);
        }
    }
}

