/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import java.util.Map;

public final class PrintAttributes
implements Parcelable {
    public static final int COLOR_MODE_COLOR = 2;
    public static final int COLOR_MODE_MONOCHROME = 1;
    public static final Parcelable.Creator<PrintAttributes> CREATOR = new Parcelable.Creator<PrintAttributes>(){

        @Override
        public PrintAttributes createFromParcel(Parcel parcel) {
            return new PrintAttributes(parcel);
        }

        public PrintAttributes[] newArray(int n) {
            return new PrintAttributes[n];
        }
    };
    private static final int VALID_COLOR_MODES = 3;
    private int mColorMode;
    private MediaSize mMediaSize;
    private Margins mMinMargins;
    private Resolution mResolution;

    PrintAttributes() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private PrintAttributes(Parcel parcel) {
        MediaSize mediaSize = parcel.readInt() == 1 ? MediaSize.createFromParcel(parcel) : null;
        this.mMediaSize = mediaSize;
        Resolution resolution = parcel.readInt() == 1 ? Resolution.createFromParcel(parcel) : null;
        this.mResolution = resolution;
        int n = parcel.readInt();
        Margins margins = null;
        if (n == 1) {
            margins = Margins.createFromParcel(parcel);
        }
        this.mMinMargins = margins;
        this.mColorMode = parcel.readInt();
    }

    static String colorModeToString(int n) {
        switch (n) {
            default: {
                return "COLOR_MODE_UNKNOWN";
            }
            case 1: {
                return "COLOR_MODE_MONOCHROME";
            }
            case 2: 
        }
        return "COLOR_MODE_COLOR";
    }

    static void enforceValidColorMode(int n) {
        if ((n & 3) == 0 && Integer.bitCount(n) == 1) {
            throw new IllegalArgumentException("invalid color mode: " + n);
        }
    }

    public PrintAttributes asLandscape() {
        if (!this.isPortrait()) {
            return this;
        }
        PrintAttributes printAttributes = new PrintAttributes();
        printAttributes.setMediaSize(this.getMediaSize().asLandscape());
        Resolution resolution = this.getResolution();
        printAttributes.setResolution(new Resolution(resolution.getId(), resolution.getLabel(), resolution.getVerticalDpi(), resolution.getHorizontalDpi()));
        printAttributes.setMinMargins(this.getMinMargins());
        printAttributes.setColorMode(this.getColorMode());
        return printAttributes;
    }

    public PrintAttributes asPortrait() {
        if (this.isPortrait()) {
            return this;
        }
        PrintAttributes printAttributes = new PrintAttributes();
        printAttributes.setMediaSize(this.getMediaSize().asPortrait());
        Resolution resolution = this.getResolution();
        printAttributes.setResolution(new Resolution(resolution.getId(), resolution.getLabel(), resolution.getVerticalDpi(), resolution.getHorizontalDpi()));
        printAttributes.setMinMargins(this.getMinMargins());
        printAttributes.setColorMode(this.getColorMode());
        return printAttributes;
    }

    public void clear() {
        this.mMediaSize = null;
        this.mResolution = null;
        this.mMinMargins = null;
        this.mColorMode = 0;
    }

    public void copyFrom(PrintAttributes printAttributes) {
        this.mMediaSize = printAttributes.mMediaSize;
        this.mResolution = printAttributes.mResolution;
        this.mMinMargins = printAttributes.mMinMargins;
        this.mColorMode = printAttributes.mColorMode;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PrintAttributes printAttributes = (PrintAttributes)object;
        if (this.mColorMode != printAttributes.mColorMode) {
            return false;
        }
        if (this.mMinMargins == null ? printAttributes.mMinMargins != null : !this.mMinMargins.equals(printAttributes.mMinMargins)) {
            return false;
        }
        if (this.mMediaSize == null ? printAttributes.mMediaSize != null : !this.mMediaSize.equals(printAttributes.mMediaSize)) {
            return false;
        }
        if (this.mResolution == null) {
            if (printAttributes.mResolution == null) return true;
            return false;
        }
        if (!this.mResolution.equals(printAttributes.mResolution)) return false;
        return true;
    }

    public int getColorMode() {
        return this.mColorMode;
    }

    public MediaSize getMediaSize() {
        return this.mMediaSize;
    }

    public Margins getMinMargins() {
        return this.mMinMargins;
    }

    public Resolution getResolution() {
        return this.mResolution;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = 31 * (31 + this.mColorMode);
        int n2 = this.mMinMargins == null ? 0 : this.mMinMargins.hashCode();
        int n3 = 31 * (n + n2);
        int n4 = this.mMediaSize == null ? 0 : this.mMediaSize.hashCode();
        int n5 = 31 * (n3 + n4);
        Resolution resolution = this.mResolution;
        int n6 = 0;
        if (resolution == null) {
            return n5 + n6;
        }
        n6 = this.mResolution.hashCode();
        return n5 + n6;
    }

    public boolean isPortrait() {
        return this.mMediaSize.isPortrait();
    }

    public void setColorMode(int n) {
        PrintAttributes.enforceValidColorMode(n);
        this.mColorMode = n;
    }

    public void setMediaSize(MediaSize mediaSize) {
        this.mMediaSize = mediaSize;
    }

    public void setMinMargins(Margins margins) {
        this.mMinMargins = margins;
    }

    public void setResolution(Resolution resolution) {
        this.mResolution = resolution;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PrintAttributes{");
        stringBuilder.append("mediaSize: ").append(this.mMediaSize);
        if (this.mMediaSize != null) {
            StringBuilder stringBuilder2 = stringBuilder.append(", orientation: ");
            String string2 = this.mMediaSize.isPortrait() ? "portrait" : "landscape";
            stringBuilder2.append(string2);
        } else {
            stringBuilder.append(", orientation: ").append("null");
        }
        stringBuilder.append(", resolution: ").append(this.mResolution);
        stringBuilder.append(", minMargins: ").append(this.mMinMargins);
        stringBuilder.append(", colorMode: ").append(PrintAttributes.colorModeToString(this.mColorMode));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (this.mMediaSize != null) {
            parcel.writeInt(1);
            this.mMediaSize.writeToParcel(parcel);
        } else {
            parcel.writeInt(0);
        }
        if (this.mResolution != null) {
            parcel.writeInt(1);
            this.mResolution.writeToParcel(parcel);
        } else {
            parcel.writeInt(0);
        }
        if (this.mMinMargins != null) {
            parcel.writeInt(1);
            this.mMinMargins.writeToParcel(parcel);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mColorMode);
    }

    public static final class Builder {
        private final PrintAttributes mAttributes = new PrintAttributes();

        public PrintAttributes build() {
            return this.mAttributes;
        }

        public Builder setColorMode(int n) {
            if (Integer.bitCount(n) > 1) {
                throw new IllegalArgumentException("can specify at most one colorMode bit.");
            }
            this.mAttributes.setColorMode(n);
            return this;
        }

        public Builder setMediaSize(MediaSize mediaSize) {
            this.mAttributes.setMediaSize(mediaSize);
            return this;
        }

        public Builder setMinMargins(Margins margins) {
            this.mAttributes.setMinMargins(margins);
            return this;
        }

        public Builder setResolution(Resolution resolution) {
            this.mAttributes.setResolution(resolution);
            return this;
        }
    }

    public static final class Margins {
        public static final Margins NO_MARGINS = new Margins(0, 0, 0, 0);
        private final int mBottomMils;
        private final int mLeftMils;
        private final int mRightMils;
        private final int mTopMils;

        public Margins(int n, int n2, int n3, int n4) {
            this.mTopMils = n2;
            this.mLeftMils = n;
            this.mRightMils = n3;
            this.mBottomMils = n4;
        }

        static Margins createFromParcel(Parcel parcel) {
            return new Margins(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block9: {
                block8: {
                    if (this == object) break block8;
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    Margins margins = (Margins)object;
                    if (this.mBottomMils != margins.mBottomMils) {
                        return false;
                    }
                    if (this.mLeftMils != margins.mLeftMils) {
                        return false;
                    }
                    if (this.mRightMils != margins.mRightMils) {
                        return false;
                    }
                    if (this.mTopMils != margins.mTopMils) break block9;
                }
                return true;
            }
            return false;
        }

        public int getBottomMils() {
            return this.mBottomMils;
        }

        public int getLeftMils() {
            return this.mLeftMils;
        }

        public int getRightMils() {
            return this.mRightMils;
        }

        public int getTopMils() {
            return this.mTopMils;
        }

        public int hashCode() {
            return 31 * (31 * (31 * (31 + this.mBottomMils) + this.mLeftMils) + this.mRightMils) + this.mTopMils;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Margins{");
            stringBuilder.append("leftMils: ").append(this.mLeftMils);
            stringBuilder.append(", topMils: ").append(this.mTopMils);
            stringBuilder.append(", rightMils: ").append(this.mRightMils);
            stringBuilder.append(", bottomMils: ").append(this.mBottomMils);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        void writeToParcel(Parcel parcel) {
            parcel.writeInt(this.mLeftMils);
            parcel.writeInt(this.mTopMils);
            parcel.writeInt(this.mRightMils);
            parcel.writeInt(this.mBottomMils);
        }
    }

    public static final class MediaSize {
        public static final MediaSize ISO_A0;
        public static final MediaSize ISO_A1;
        public static final MediaSize ISO_A10;
        public static final MediaSize ISO_A2;
        public static final MediaSize ISO_A3;
        public static final MediaSize ISO_A4;
        public static final MediaSize ISO_A5;
        public static final MediaSize ISO_A6;
        public static final MediaSize ISO_A7;
        public static final MediaSize ISO_A8;
        public static final MediaSize ISO_A9;
        public static final MediaSize ISO_B0;
        public static final MediaSize ISO_B1;
        public static final MediaSize ISO_B10;
        public static final MediaSize ISO_B2;
        public static final MediaSize ISO_B3;
        public static final MediaSize ISO_B4;
        public static final MediaSize ISO_B5;
        public static final MediaSize ISO_B6;
        public static final MediaSize ISO_B7;
        public static final MediaSize ISO_B8;
        public static final MediaSize ISO_B9;
        public static final MediaSize ISO_C0;
        public static final MediaSize ISO_C1;
        public static final MediaSize ISO_C10;
        public static final MediaSize ISO_C2;
        public static final MediaSize ISO_C3;
        public static final MediaSize ISO_C4;
        public static final MediaSize ISO_C5;
        public static final MediaSize ISO_C6;
        public static final MediaSize ISO_C7;
        public static final MediaSize ISO_C8;
        public static final MediaSize ISO_C9;
        public static final MediaSize JIS_B0;
        public static final MediaSize JIS_B1;
        public static final MediaSize JIS_B10;
        public static final MediaSize JIS_B2;
        public static final MediaSize JIS_B3;
        public static final MediaSize JIS_B4;
        public static final MediaSize JIS_B5;
        public static final MediaSize JIS_B6;
        public static final MediaSize JIS_B7;
        public static final MediaSize JIS_B8;
        public static final MediaSize JIS_B9;
        public static final MediaSize JIS_EXEC;
        public static final MediaSize JPN_CHOU2;
        public static final MediaSize JPN_CHOU3;
        public static final MediaSize JPN_CHOU4;
        public static final MediaSize JPN_HAGAKI;
        public static final MediaSize JPN_KAHU;
        public static final MediaSize JPN_KAKU2;
        public static final MediaSize JPN_OUFUKU;
        public static final MediaSize JPN_YOU4;
        private static final String LOG_TAG = "MediaSize";
        public static final MediaSize NA_FOOLSCAP;
        public static final MediaSize NA_GOVT_LETTER;
        public static final MediaSize NA_INDEX_3X5;
        public static final MediaSize NA_INDEX_4X6;
        public static final MediaSize NA_INDEX_5X8;
        public static final MediaSize NA_JUNIOR_LEGAL;
        public static final MediaSize NA_LEDGER;
        public static final MediaSize NA_LEGAL;
        public static final MediaSize NA_LETTER;
        public static final MediaSize NA_MONARCH;
        public static final MediaSize NA_QUARTO;
        public static final MediaSize NA_TABLOID;
        public static final MediaSize OM_DAI_PA_KAI;
        public static final MediaSize OM_JUURO_KU_KAI;
        public static final MediaSize OM_PA_KAI;
        public static final MediaSize PRC_1;
        public static final MediaSize PRC_10;
        public static final MediaSize PRC_16K;
        public static final MediaSize PRC_2;
        public static final MediaSize PRC_3;
        public static final MediaSize PRC_4;
        public static final MediaSize PRC_5;
        public static final MediaSize PRC_6;
        public static final MediaSize PRC_7;
        public static final MediaSize PRC_8;
        public static final MediaSize PRC_9;
        public static final MediaSize ROC_16K;
        public static final MediaSize ROC_8K;
        public static final MediaSize UNKNOWN_LANDSCAPE;
        public static final MediaSize UNKNOWN_PORTRAIT;
        private static final Map<String, MediaSize> sIdToMediaSizeMap;
        private final int mHeightMils;
        private final String mId;
        public final String mLabel;
        public final int mLabelResId;
        public final String mPackageName;
        private final int mWidthMils;

        static {
            sIdToMediaSizeMap = new ArrayMap<String, MediaSize>();
            UNKNOWN_PORTRAIT = new MediaSize("UNKNOWN_PORTRAIT", "android", 17040978, 1, Integer.MAX_VALUE);
            UNKNOWN_LANDSCAPE = new MediaSize("UNKNOWN_LANDSCAPE", "android", 17040979, Integer.MAX_VALUE, 1);
            ISO_A0 = new MediaSize("ISO_A0", "android", 17040897, 33110, 46810);
            ISO_A1 = new MediaSize("ISO_A1", "android", 17040898, 23390, 33110);
            ISO_A2 = new MediaSize("ISO_A2", "android", 17040899, 16540, 23390);
            ISO_A3 = new MediaSize("ISO_A3", "android", 17040900, 11690, 16540);
            ISO_A4 = new MediaSize("ISO_A4", "android", 17040901, 8270, 11690);
            ISO_A5 = new MediaSize("ISO_A5", "android", 17040902, 5830, 8270);
            ISO_A6 = new MediaSize("ISO_A6", "android", 17040903, 4130, 5830);
            ISO_A7 = new MediaSize("ISO_A7", "android", 17040904, 2910, 4130);
            ISO_A8 = new MediaSize("ISO_A8", "android", 17040905, 2050, 2910);
            ISO_A9 = new MediaSize("ISO_A9", "android", 17040906, 1460, 2050);
            ISO_A10 = new MediaSize("ISO_A10", "android", 17040907, 1020, 1460);
            ISO_B0 = new MediaSize("ISO_B0", "android", 17040908, 39370, 55670);
            ISO_B1 = new MediaSize("ISO_B1", "android", 17040909, 27830, 39370);
            ISO_B2 = new MediaSize("ISO_B2", "android", 17040910, 19690, 27830);
            ISO_B3 = new MediaSize("ISO_B3", "android", 17040911, 13900, 19690);
            ISO_B4 = new MediaSize("ISO_B4", "android", 17040912, 9840, 13900);
            ISO_B5 = new MediaSize("ISO_B5", "android", 17040913, 6930, 9840);
            ISO_B6 = new MediaSize("ISO_B6", "android", 17040914, 4920, 6930);
            ISO_B7 = new MediaSize("ISO_B7", "android", 17040915, 3460, 4920);
            ISO_B8 = new MediaSize("ISO_B8", "android", 17040916, 2440, 3460);
            ISO_B9 = new MediaSize("ISO_B9", "android", 17040917, 1730, 2440);
            ISO_B10 = new MediaSize("ISO_B10", "android", 17040918, 1220, 1730);
            ISO_C0 = new MediaSize("ISO_C0", "android", 17040919, 36100, 51060);
            ISO_C1 = new MediaSize("ISO_C1", "android", 17040920, 25510, 36100);
            ISO_C2 = new MediaSize("ISO_C2", "android", 17040921, 18030, 25510);
            ISO_C3 = new MediaSize("ISO_C3", "android", 17040922, 12760, 18030);
            ISO_C4 = new MediaSize("ISO_C4", "android", 17040923, 9020, 12760);
            ISO_C5 = new MediaSize("ISO_C5", "android", 17040924, 6380, 9020);
            ISO_C6 = new MediaSize("ISO_C6", "android", 17040925, 4490, 6380);
            ISO_C7 = new MediaSize("ISO_C7", "android", 17040926, 3190, 4490);
            ISO_C8 = new MediaSize("ISO_C8", "android", 17040927, 2240, 3190);
            ISO_C9 = new MediaSize("ISO_C9", "android", 17040928, 1570, 2240);
            ISO_C10 = new MediaSize("ISO_C10", "android", 17040929, 1100, 1570);
            NA_LETTER = new MediaSize("NA_LETTER", "android", 17040930, 8500, 11000);
            NA_GOVT_LETTER = new MediaSize("NA_GOVT_LETTER", "android", 17040931, 8000, 10500);
            NA_LEGAL = new MediaSize("NA_LEGAL", "android", 17040932, 8500, 14000);
            NA_JUNIOR_LEGAL = new MediaSize("NA_JUNIOR_LEGAL", "android", 17040933, 8000, 5000);
            NA_LEDGER = new MediaSize("NA_LEDGER", "android", 17040934, 17000, 11000);
            NA_TABLOID = new MediaSize("NA_TABLOID", "android", 17040935, 11000, 17000);
            NA_INDEX_3X5 = new MediaSize("NA_INDEX_3X5", "android", 17040936, 3000, 5000);
            NA_INDEX_4X6 = new MediaSize("NA_INDEX_4X6", "android", 17040937, 4000, 6000);
            NA_INDEX_5X8 = new MediaSize("NA_INDEX_5X8", "android", 17040938, 5000, 8000);
            NA_MONARCH = new MediaSize("NA_MONARCH", "android", 17040939, 7250, 10500);
            NA_QUARTO = new MediaSize("NA_QUARTO", "android", 17040940, 8000, 10000);
            NA_FOOLSCAP = new MediaSize("NA_FOOLSCAP", "android", 17040941, 8000, 13000);
            ROC_8K = new MediaSize("ROC_8K", "android", 17040942, 10629, 15354);
            ROC_16K = new MediaSize("ROC_16K", "android", 17040943, 7677, 10629);
            PRC_1 = new MediaSize("PRC_1", "android", 17040944, 4015, 6496);
            PRC_2 = new MediaSize("PRC_2", "android", 17040945, 4015, 6929);
            PRC_3 = new MediaSize("PRC_3", "android", 17040946, 4921, 6929);
            PRC_4 = new MediaSize("PRC_4", "android", 17040947, 4330, 8189);
            PRC_5 = new MediaSize("PRC_5", "android", 17040948, 4330, 8661);
            PRC_6 = new MediaSize("PRC_6", "android", 17040949, 4724, 12599);
            PRC_7 = new MediaSize("PRC_7", "android", 17040950, 6299, 9055);
            PRC_8 = new MediaSize("PRC_8", "android", 17040951, 4724, 12165);
            PRC_9 = new MediaSize("PRC_9", "android", 17040952, 9016, 12756);
            PRC_10 = new MediaSize("PRC_10", "android", 17040953, 12756, 18032);
            PRC_16K = new MediaSize("PRC_16K", "android", 17040954, 5749, 8465);
            OM_PA_KAI = new MediaSize("OM_PA_KAI", "android", 17040955, 10512, 15315);
            OM_DAI_PA_KAI = new MediaSize("OM_DAI_PA_KAI", "android", 17040956, 10827, 15551);
            OM_JUURO_KU_KAI = new MediaSize("OM_JUURO_KU_KAI", "android", 17040957, 7796, 10827);
            JIS_B10 = new MediaSize("JIS_B10", "android", 17040958, 1259, 1772);
            JIS_B9 = new MediaSize("JIS_B9", "android", 17040959, 1772, 2520);
            JIS_B8 = new MediaSize("JIS_B8", "android", 17040960, 2520, 3583);
            JIS_B7 = new MediaSize("JIS_B7", "android", 17040961, 3583, 5049);
            JIS_B6 = new MediaSize("JIS_B6", "android", 17040962, 5049, 7165);
            JIS_B5 = new MediaSize("JIS_B5", "android", 17040963, 7165, 10118);
            JIS_B4 = new MediaSize("JIS_B4", "android", 17040964, 10118, 14331);
            JIS_B3 = new MediaSize("JIS_B3", "android", 17040965, 14331, 20276);
            JIS_B2 = new MediaSize("JIS_B2", "android", 17040966, 20276, 28661);
            JIS_B1 = new MediaSize("JIS_B1", "android", 17040967, 28661, 40551);
            JIS_B0 = new MediaSize("JIS_B0", "android", 17040968, 40551, 57323);
            JIS_EXEC = new MediaSize("JIS_EXEC", "android", 17040969, 8504, 12992);
            JPN_CHOU4 = new MediaSize("JPN_CHOU4", "android", 17040970, 3543, 8071);
            JPN_CHOU3 = new MediaSize("JPN_CHOU3", "android", 17040971, 4724, 9252);
            JPN_CHOU2 = new MediaSize("JPN_CHOU2", "android", 17040972, 4374, 5748);
            JPN_HAGAKI = new MediaSize("JPN_HAGAKI", "android", 17040973, 3937, 5827);
            JPN_OUFUKU = new MediaSize("JPN_OUFUKU", "android", 17040974, 5827, 7874);
            JPN_KAHU = new MediaSize("JPN_KAHU", "android", 17040975, 9449, 12681);
            JPN_KAKU2 = new MediaSize("JPN_KAKU2", "android", 17040976, 9449, 13071);
            JPN_YOU4 = new MediaSize("JPN_YOU4", "android", 17040977, 4134, 9252);
        }

        public MediaSize(String string2, String string3, int n, int n2) {
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalArgumentException("id cannot be empty.");
            }
            if (TextUtils.isEmpty(string3)) {
                throw new IllegalArgumentException("label cannot be empty.");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("widthMils cannot be less than or equal to zero.");
            }
            if (n2 <= 0) {
                throw new IllegalArgumentException("heightMils cannot be less than or euqual to zero.");
            }
            this.mId = string2;
            this.mLabel = string3;
            this.mWidthMils = n;
            this.mHeightMils = n2;
            this.mLabelResId = 0;
            this.mPackageName = null;
        }

        public MediaSize(String string2, String string3, int n, int n2, int n3) {
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalArgumentException("id cannot be empty.");
            }
            if (TextUtils.isEmpty(string3)) {
                throw new IllegalArgumentException("packageName cannot be empty.");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("labelResId must be greater than zero.");
            }
            if (n2 <= 0) {
                throw new IllegalArgumentException("widthMils cannot be less than or equal to zero.");
            }
            if (n3 <= 0) {
                throw new IllegalArgumentException("heightMils cannot be less than or euqual to zero.");
            }
            this.mPackageName = string3;
            this.mId = string2;
            this.mLabelResId = n;
            this.mWidthMils = n2;
            this.mHeightMils = n3;
            this.mLabel = null;
            sIdToMediaSizeMap.put(this.mId, this);
        }

        public MediaSize(String string2, String string3, String string4, int n, int n2, int n3) {
            this.mPackageName = string4;
            this.mId = string2;
            this.mLabelResId = n3;
            this.mWidthMils = n;
            this.mHeightMils = n2;
            this.mLabel = string3;
        }

        static MediaSize createFromParcel(Parcel parcel) {
            return new MediaSize(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt());
        }

        public static MediaSize getStandardMediaSizeById(String string2) {
            return sIdToMediaSizeMap.get(string2);
        }

        public MediaSize asLandscape() {
            if (!this.isPortrait()) {
                return this;
            }
            return new MediaSize(this.mId, this.mLabel, this.mPackageName, Math.max(this.mWidthMils, this.mHeightMils), Math.min(this.mWidthMils, this.mHeightMils), this.mLabelResId);
        }

        public MediaSize asPortrait() {
            if (this.isPortrait()) {
                return this;
            }
            return new MediaSize(this.mId, this.mLabel, this.mPackageName, Math.min(this.mWidthMils, this.mHeightMils), Math.max(this.mWidthMils, this.mHeightMils), this.mLabelResId);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block7: {
                block6: {
                    if (this == object) break block6;
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    MediaSize mediaSize = (MediaSize)object;
                    if (this.mWidthMils != mediaSize.mWidthMils) {
                        return false;
                    }
                    if (this.mHeightMils != mediaSize.mHeightMils) break block7;
                }
                return true;
            }
            return false;
        }

        public int getHeightMils() {
            return this.mHeightMils;
        }

        public String getId() {
            return this.mId;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getLabel(PackageManager packageManager) {
            if (TextUtils.isEmpty(this.mPackageName)) return this.mLabel;
            if (this.mLabelResId <= 0) return this.mLabel;
            try {
                return packageManager.getResourcesForApplication(this.mPackageName).getString(this.mLabelResId);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w(LOG_TAG, "Could not load resouce" + this.mLabelResId + " from package " + this.mPackageName);
                return this.mLabel;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w(LOG_TAG, "Could not load resouce" + this.mLabelResId + " from package " + this.mPackageName);
                return this.mLabel;
            }
        }

        public int getWidthMils() {
            return this.mWidthMils;
        }

        public int hashCode() {
            return 31 * (31 + this.mWidthMils) + this.mHeightMils;
        }

        public boolean isPortrait() {
            return this.mHeightMils >= this.mWidthMils;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("MediaSize{");
            stringBuilder.append("id: ").append(this.mId);
            stringBuilder.append(", label: ").append(this.mLabel);
            stringBuilder.append(", packageName: ").append(this.mPackageName);
            stringBuilder.append(", heightMils: ").append(this.mHeightMils);
            stringBuilder.append(", widthMils: ").append(this.mWidthMils);
            stringBuilder.append(", labelResId: ").append(this.mLabelResId);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        void writeToParcel(Parcel parcel) {
            parcel.writeString(this.mId);
            parcel.writeString(this.mLabel);
            parcel.writeString(this.mPackageName);
            parcel.writeInt(this.mWidthMils);
            parcel.writeInt(this.mHeightMils);
            parcel.writeInt(this.mLabelResId);
        }
    }

    public static final class Resolution {
        private final int mHorizontalDpi;
        private final String mId;
        private final String mLabel;
        private final int mVerticalDpi;

        public Resolution(String string2, String string3, int n, int n2) {
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalArgumentException("id cannot be empty.");
            }
            if (TextUtils.isEmpty(string3)) {
                throw new IllegalArgumentException("label cannot be empty.");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("horizontalDpi cannot be less than or equal to zero.");
            }
            if (n2 <= 0) {
                throw new IllegalArgumentException("verticalDpi cannot be less than or equal to zero.");
            }
            this.mId = string2;
            this.mLabel = string3;
            this.mHorizontalDpi = n;
            this.mVerticalDpi = n2;
        }

        static Resolution createFromParcel(Parcel parcel) {
            return new Resolution(parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt());
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block7: {
                block6: {
                    if (this == object) break block6;
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    Resolution resolution = (Resolution)object;
                    if (this.mHorizontalDpi != resolution.mHorizontalDpi) {
                        return false;
                    }
                    if (this.mVerticalDpi != resolution.mVerticalDpi) break block7;
                }
                return true;
            }
            return false;
        }

        public int getHorizontalDpi() {
            return this.mHorizontalDpi;
        }

        public String getId() {
            return this.mId;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public int getVerticalDpi() {
            return this.mVerticalDpi;
        }

        public int hashCode() {
            return 31 * (31 + this.mHorizontalDpi) + this.mVerticalDpi;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Resolution{");
            stringBuilder.append("id: ").append(this.mId);
            stringBuilder.append(", label: ").append(this.mLabel);
            stringBuilder.append(", horizontalDpi: ").append(this.mHorizontalDpi);
            stringBuilder.append(", verticalDpi: ").append(this.mVerticalDpi);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        void writeToParcel(Parcel parcel) {
            parcel.writeString(this.mId);
            parcel.writeString(this.mLabel);
            parcel.writeInt(this.mHorizontalDpi);
            parcel.writeInt(this.mVerticalDpi);
        }
    }
}

