/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Parcel;
import android.os.Parcelable;
import android.print.PrintAttributes;
import android.print.PrinterId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class PrinterCapabilitiesInfo
implements Parcelable {
    public static final Parcelable.Creator<PrinterCapabilitiesInfo> CREATOR;
    private static final PrintAttributes.Margins DEFAULT_MARGINS;
    public static final int DEFAULT_UNDEFINED = -1;
    private static final int PROPERTY_COLOR_MODE = 2;
    private static final int PROPERTY_COUNT = 3;
    private static final int PROPERTY_MEDIA_SIZE = 0;
    private static final int PROPERTY_RESOLUTION = 1;
    private int mColorModes;
    private final int[] mDefaults;
    private List<PrintAttributes.MediaSize> mMediaSizes;
    private PrintAttributes.Margins mMinMargins = DEFAULT_MARGINS;
    private List<PrintAttributes.Resolution> mResolutions;

    static {
        DEFAULT_MARGINS = new PrintAttributes.Margins(0, 0, 0, 0);
        CREATOR = new Parcelable.Creator<PrinterCapabilitiesInfo>(){

            @Override
            public PrinterCapabilitiesInfo createFromParcel(Parcel parcel) {
                return new PrinterCapabilitiesInfo(parcel);
            }

            public PrinterCapabilitiesInfo[] newArray(int n) {
                return new PrinterCapabilitiesInfo[n];
            }
        };
    }

    public PrinterCapabilitiesInfo() {
        this.mDefaults = new int[3];
        Arrays.fill(this.mDefaults, -1);
    }

    private PrinterCapabilitiesInfo(Parcel parcel) {
        this.mDefaults = new int[3];
        this.mMinMargins = this.readMargins(parcel);
        this.readMediaSizes(parcel);
        this.readResolutions(parcel);
        this.mColorModes = parcel.readInt();
        this.readDefaults(parcel);
    }

    public PrinterCapabilitiesInfo(PrinterCapabilitiesInfo printerCapabilitiesInfo) {
        this.mDefaults = new int[3];
        this.copyFrom(printerCapabilitiesInfo);
    }

    static /* synthetic */ List access$002(PrinterCapabilitiesInfo printerCapabilitiesInfo, List list) {
        printerCapabilitiesInfo.mMediaSizes = list;
        return list;
    }

    static /* synthetic */ List access$202(PrinterCapabilitiesInfo printerCapabilitiesInfo, List list) {
        printerCapabilitiesInfo.mResolutions = list;
        return list;
    }

    static /* synthetic */ PrintAttributes.Margins access$302(PrinterCapabilitiesInfo printerCapabilitiesInfo, PrintAttributes.Margins margins) {
        printerCapabilitiesInfo.mMinMargins = margins;
        return margins;
    }

    static /* synthetic */ int access$402(PrinterCapabilitiesInfo printerCapabilitiesInfo, int n) {
        printerCapabilitiesInfo.mColorModes = n;
        return n;
    }

    private String colorModesToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = this.mColorModes;
        while (n != 0) {
            int n2 = 1 << Integer.numberOfTrailingZeros(n);
            n &= ~n2;
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(PrintAttributes.colorModeToString(n2));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void readDefaults(Parcel parcel) {
        int n = parcel.readInt();
        for (int i = 0; i < n; ++i) {
            this.mDefaults[i] = parcel.readInt();
        }
    }

    private PrintAttributes.Margins readMargins(Parcel parcel) {
        if (parcel.readInt() == 1) {
            return PrintAttributes.Margins.createFromParcel(parcel);
        }
        return null;
    }

    private void readMediaSizes(Parcel parcel) {
        int n = parcel.readInt();
        if (n > 0 && this.mMediaSizes == null) {
            this.mMediaSizes = new ArrayList<PrintAttributes.MediaSize>();
        }
        for (int i = 0; i < n; ++i) {
            this.mMediaSizes.add(PrintAttributes.MediaSize.createFromParcel(parcel));
        }
    }

    private void readResolutions(Parcel parcel) {
        int n = parcel.readInt();
        if (n > 0 && this.mResolutions == null) {
            this.mResolutions = new ArrayList<PrintAttributes.Resolution>();
        }
        for (int i = 0; i < n; ++i) {
            this.mResolutions.add(PrintAttributes.Resolution.createFromParcel(parcel));
        }
    }

    private void writeDefaults(Parcel parcel) {
        int n = this.mDefaults.length;
        parcel.writeInt(n);
        for (int i = 0; i < n; ++i) {
            parcel.writeInt(this.mDefaults[i]);
        }
    }

    private void writeMargins(PrintAttributes.Margins margins, Parcel parcel) {
        if (margins == null) {
            parcel.writeInt(0);
            return;
        }
        parcel.writeInt(1);
        margins.writeToParcel(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeMediaSizes(Parcel parcel) {
        if (this.mMediaSizes == null) {
            parcel.writeInt(0);
            return;
        } else {
            int n = this.mMediaSizes.size();
            parcel.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.mMediaSizes.get(i).writeToParcel(parcel);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeResolutions(Parcel parcel) {
        if (this.mResolutions == null) {
            parcel.writeInt(0);
            return;
        } else {
            int n = this.mResolutions.size();
            parcel.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.mResolutions.get(i).writeToParcel(parcel);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void copyFrom(PrinterCapabilitiesInfo printerCapabilitiesInfo) {
        if (this != printerCapabilitiesInfo) {
            this.mMinMargins = printerCapabilitiesInfo.mMinMargins;
            if (printerCapabilitiesInfo.mMediaSizes != null) {
                if (this.mMediaSizes != null) {
                    this.mMediaSizes.clear();
                    this.mMediaSizes.addAll(printerCapabilitiesInfo.mMediaSizes);
                } else {
                    this.mMediaSizes = new ArrayList<PrintAttributes.MediaSize>(printerCapabilitiesInfo.mMediaSizes);
                }
            } else {
                this.mMediaSizes = null;
            }
            if (printerCapabilitiesInfo.mResolutions != null) {
                if (this.mResolutions != null) {
                    this.mResolutions.clear();
                    this.mResolutions.addAll(printerCapabilitiesInfo.mResolutions);
                } else {
                    this.mResolutions = new ArrayList<PrintAttributes.Resolution>(printerCapabilitiesInfo.mResolutions);
                }
            } else {
                this.mResolutions = null;
            }
            this.mColorModes = printerCapabilitiesInfo.mColorModes;
            for (int this.mDefaults[var3_3] : printerCapabilitiesInfo.mDefaults) {
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block10: {
            block9: {
                if (this == object) break block9;
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                PrinterCapabilitiesInfo printerCapabilitiesInfo = (PrinterCapabilitiesInfo)object;
                if (this.mMinMargins == null ? printerCapabilitiesInfo.mMinMargins != null : !this.mMinMargins.equals(printerCapabilitiesInfo.mMinMargins)) {
                    return false;
                }
                if (this.mMediaSizes == null ? printerCapabilitiesInfo.mMediaSizes != null : !this.mMediaSizes.equals(printerCapabilitiesInfo.mMediaSizes)) {
                    return false;
                }
                if (this.mResolutions == null ? printerCapabilitiesInfo.mResolutions != null : !this.mResolutions.equals(printerCapabilitiesInfo.mResolutions)) {
                    return false;
                }
                if (this.mColorModes != printerCapabilitiesInfo.mColorModes) {
                    return false;
                }
                if (!Arrays.equals(this.mDefaults, printerCapabilitiesInfo.mDefaults)) break block10;
            }
            return true;
        }
        return false;
    }

    public int getColorModes() {
        return this.mColorModes;
    }

    public PrintAttributes getDefaults() {
        int n;
        int n2;
        PrintAttributes.Builder builder = new PrintAttributes.Builder();
        builder.setMinMargins(this.mMinMargins);
        int n3 = this.mDefaults[0];
        if (n3 >= 0) {
            builder.setMediaSize(this.mMediaSizes.get(n3));
        }
        if ((n2 = this.mDefaults[1]) >= 0) {
            builder.setResolution(this.mResolutions.get(n2));
        }
        if ((n = this.mDefaults[2]) > 0) {
            builder.setColorMode(n);
        }
        return builder.build();
    }

    public List<PrintAttributes.MediaSize> getMediaSizes() {
        return Collections.unmodifiableList(this.mMediaSizes);
    }

    public PrintAttributes.Margins getMinMargins() {
        return this.mMinMargins;
    }

    public List<PrintAttributes.Resolution> getResolutions() {
        return Collections.unmodifiableList(this.mResolutions);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = this.mMinMargins == null ? 0 : this.mMinMargins.hashCode();
        int n2 = 31 * (n + 31);
        int n3 = this.mMediaSizes == null ? 0 : this.mMediaSizes.hashCode();
        int n4 = 31 * (n2 + n3);
        List<PrintAttributes.Resolution> list = this.mResolutions;
        int n5 = 0;
        if (list == null) {
            return 31 * (31 * (n4 + n5) + this.mColorModes) + Arrays.hashCode(this.mDefaults);
        }
        n5 = this.mResolutions.hashCode();
        return 31 * (31 * (n4 + n5) + this.mColorModes) + Arrays.hashCode(this.mDefaults);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PrinterInfo{");
        stringBuilder.append("minMargins=").append(this.mMinMargins);
        stringBuilder.append(", mediaSizes=").append(this.mMediaSizes);
        stringBuilder.append(", resolutions=").append(this.mResolutions);
        stringBuilder.append(", colorModes=").append(this.colorModesToString());
        stringBuilder.append("\"}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.writeMargins(this.mMinMargins, parcel);
        this.writeMediaSizes(parcel);
        this.writeResolutions(parcel);
        parcel.writeInt(this.mColorModes);
        this.writeDefaults(parcel);
    }

    public static final class Builder {
        private final PrinterCapabilitiesInfo mPrototype;

        public Builder(PrinterId printerId) {
            if (printerId == null) {
                throw new IllegalArgumentException("printerId cannot be null.");
            }
            this.mPrototype = new PrinterCapabilitiesInfo();
        }

        private void throwIfDefaultAlreadySpecified(int n) {
            if (this.mPrototype.mDefaults[n] != -1) {
                throw new IllegalArgumentException("Default already specified.");
            }
        }

        public Builder addMediaSize(PrintAttributes.MediaSize mediaSize, boolean bl) {
            if (this.mPrototype.mMediaSizes == null) {
                PrinterCapabilitiesInfo.access$002(this.mPrototype, new ArrayList());
            }
            int n = this.mPrototype.mMediaSizes.size();
            this.mPrototype.mMediaSizes.add(mediaSize);
            if (bl) {
                this.throwIfDefaultAlreadySpecified(0);
                ((PrinterCapabilitiesInfo)this.mPrototype).mDefaults[0] = n;
            }
            return this;
        }

        public Builder addResolution(PrintAttributes.Resolution resolution, boolean bl) {
            if (this.mPrototype.mResolutions == null) {
                PrinterCapabilitiesInfo.access$202(this.mPrototype, new ArrayList());
            }
            int n = this.mPrototype.mResolutions.size();
            this.mPrototype.mResolutions.add(resolution);
            if (bl) {
                this.throwIfDefaultAlreadySpecified(1);
                ((PrinterCapabilitiesInfo)this.mPrototype).mDefaults[1] = n;
            }
            return this;
        }

        public PrinterCapabilitiesInfo build() {
            if (this.mPrototype.mMediaSizes == null || this.mPrototype.mMediaSizes.isEmpty()) {
                throw new IllegalStateException("No media size specified.");
            }
            if (this.mPrototype.mDefaults[0] == -1) {
                throw new IllegalStateException("No default media size specified.");
            }
            if (this.mPrototype.mResolutions == null || this.mPrototype.mResolutions.isEmpty()) {
                throw new IllegalStateException("No resolution specified.");
            }
            if (this.mPrototype.mDefaults[1] == -1) {
                throw new IllegalStateException("No default resolution specified.");
            }
            if (this.mPrototype.mColorModes == 0) {
                throw new IllegalStateException("No color mode specified.");
            }
            if (this.mPrototype.mDefaults[2] == -1) {
                throw new IllegalStateException("No default color mode specified.");
            }
            if (this.mPrototype.mMinMargins == null) {
                throw new IllegalArgumentException("margins cannot be null");
            }
            return this.mPrototype;
        }

        public Builder setColorModes(int n, int n2) {
            int n3;
            for (int i = n; i > 0; i &= ~n3) {
                n3 = 1 << Integer.numberOfTrailingZeros(i);
                PrintAttributes.enforceValidColorMode(n3);
            }
            if ((n & n2) == 0) {
                throw new IllegalArgumentException("Default color mode not in color modes.");
            }
            PrintAttributes.enforceValidColorMode(n);
            PrinterCapabilitiesInfo.access$402(this.mPrototype, n);
            ((PrinterCapabilitiesInfo)this.mPrototype).mDefaults[2] = n2;
            return this;
        }

        public Builder setMinMargins(PrintAttributes.Margins margins) {
            if (margins == null) {
                throw new IllegalArgumentException("margins cannot be null");
            }
            PrinterCapabilitiesInfo.access$302(this.mPrototype, margins);
            return this;
        }
    }
}

