/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.print.PrintJobInfo;
import android.print.PrinterId;
import android.printservice.IPrintService;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintJob;
import android.printservice.PrinterDiscoverySession;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PrintService
extends Service {
    private static final boolean DEBUG = false;
    public static final String EXTRA_PRINTER_INFO = "android.intent.extra.print.EXTRA_PRINTER_INFO";
    public static final String EXTRA_PRINT_JOB_INFO = "android.intent.extra.print.PRINT_JOB_INFO";
    private static final String LOG_TAG = "PrintService";
    public static final String SERVICE_INTERFACE = "android.printservice.PrintService";
    public static final String SERVICE_META_DATA = "android.printservice";
    private IPrintServiceClient mClient;
    private PrinterDiscoverySession mDiscoverySession;
    private Handler mHandler;
    private int mLastSessionId = -1;

    static /* synthetic */ int access$102(PrintService printService, int n) {
        printService.mLastSessionId = n;
        return n;
    }

    static /* synthetic */ PrinterDiscoverySession access$202(PrintService printService, PrinterDiscoverySession printerDiscoverySession) {
        printService.mDiscoverySession = printerDiscoverySession;
        return printerDiscoverySession;
    }

    static /* synthetic */ IPrintServiceClient access$302(PrintService printService, IPrintServiceClient iPrintServiceClient) {
        printService.mClient = iPrintServiceClient;
        return iPrintServiceClient;
    }

    static void throwIfNotCalledOnMainThread() {
        if (!Looper.getMainLooper().isCurrentThread()) {
            throw new IllegalAccessError("must be called from the main thread");
        }
    }

    @Override
    protected final void attachBaseContext(Context context) {
        super.attachBaseContext(context);
        this.mHandler = new ServiceHandler(context.getMainLooper());
    }

    public final PrinterId generatePrinterId(String string2) {
        PrintService.throwIfNotCalledOnMainThread();
        return new PrinterId(new ComponentName(this.getPackageName(), this.getClass().getName()), string2);
    }

    /*
     * Unable to fully structure code
     */
    public final List<PrintJob> getActivePrintJobs() {
        block10: {
            PrintService.throwIfNotCalledOnMainThread();
            if (this.mClient == null) {
                var4_1 = Collections.emptyList();
lbl4:
                // 2 sources

                return var4_1;
            }
            var3_2 = this.mClient.getPrintJobInfos();
            var4_1 = null;
            if (var3_2 == null) break block10;
            try {
                var5_3 = var3_2.size();
                var6_4 = new ArrayList<PrintJob>(var5_3);
            }
            catch (RemoteException var1_6) lbl-1000:
            // 2 sources

            {
                while (true) {
                    Log.e("PrintService", "Error calling getPrintJobs()", (Throwable)var1_7);
                    ** continue;
                    break;
                }
            }
            for (var7_5 = 0; var7_5 < var5_3; ++var7_5) {
                var6_4.add(new PrintJob(var3_2.get(var7_5), this.mClient));
                continue;
            }
            var4_1 = var6_4;
        }
        ** while (var4_1 != null)
lbl21:
        // 2 sources

        return Collections.emptyList();
        catch (RemoteException var1_8) {
            ** continue;
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new IPrintService.Stub(){

            @Override
            public void createPrinterDiscoverySession() {
                PrintService.this.mHandler.sendEmptyMessage(1);
            }

            @Override
            public void destroyPrinterDiscoverySession() {
                PrintService.this.mHandler.sendEmptyMessage(2);
            }

            @Override
            public void onPrintJobQueued(PrintJobInfo printJobInfo) {
                PrintService.this.mHandler.obtainMessage(8, printJobInfo).sendToTarget();
            }

            @Override
            public void requestCancelPrintJob(PrintJobInfo printJobInfo) {
                PrintService.this.mHandler.obtainMessage(9, printJobInfo).sendToTarget();
            }

            @Override
            public void setClient(IPrintServiceClient iPrintServiceClient) {
                PrintService.this.mHandler.obtainMessage(10, iPrintServiceClient).sendToTarget();
            }

            @Override
            public void startPrinterDiscovery(List<PrinterId> list) {
                PrintService.this.mHandler.obtainMessage(3, list).sendToTarget();
            }

            @Override
            public void startPrinterStateTracking(PrinterId printerId) {
                PrintService.this.mHandler.obtainMessage(6, printerId).sendToTarget();
            }

            @Override
            public void stopPrinterDiscovery() {
                PrintService.this.mHandler.sendEmptyMessage(4);
            }

            @Override
            public void stopPrinterStateTracking(PrinterId printerId) {
                PrintService.this.mHandler.obtainMessage(7, printerId).sendToTarget();
            }

            @Override
            public void validatePrinters(List<PrinterId> list) {
                PrintService.this.mHandler.obtainMessage(5, list).sendToTarget();
            }
        };
    }

    protected void onConnected() {
    }

    protected abstract PrinterDiscoverySession onCreatePrinterDiscoverySession();

    protected void onDisconnected() {
    }

    protected abstract void onPrintJobQueued(PrintJob var1);

    protected abstract void onRequestCancelPrintJob(PrintJob var1);

    private final class ServiceHandler
    extends Handler {
        public static final int MSG_CREATE_PRINTER_DISCOVERY_SESSION = 1;
        public static final int MSG_DESTROY_PRINTER_DISCOVERY_SESSION = 2;
        public static final int MSG_ON_PRINTJOB_QUEUED = 8;
        public static final int MSG_ON_REQUEST_CANCEL_PRINTJOB = 9;
        public static final int MSG_SET_CLEINT = 10;
        public static final int MSG_START_PRINTER_DISCOVERY = 3;
        public static final int MSG_START_PRINTER_STATE_TRACKING = 6;
        public static final int MSG_STOP_PRINTER_DISCOVERY = 4;
        public static final int MSG_STOP_PRINTER_STATE_TRACKING = 7;
        public static final int MSG_VALIDATE_PRINTERS = 5;

        public ServiceHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            int n = message.what;
            switch (n) {
                default: {
                    throw new IllegalArgumentException("Unknown message: " + n);
                }
                case 1: {
                    PrinterDiscoverySession printerDiscoverySession = PrintService.this.onCreatePrinterDiscoverySession();
                    if (printerDiscoverySession == null) {
                        throw new NullPointerException("session cannot be null");
                    }
                    if (printerDiscoverySession.getId() == PrintService.this.mLastSessionId) {
                        throw new IllegalStateException("cannot reuse session instances");
                    }
                    PrintService.access$202(PrintService.this, printerDiscoverySession);
                    PrintService.access$102(PrintService.this, printerDiscoverySession.getId());
                    printerDiscoverySession.setObserver(PrintService.this.mClient);
                    return;
                }
                case 2: {
                    if (PrintService.this.mDiscoverySession == null) return;
                    PrintService.this.mDiscoverySession.destroy();
                    PrintService.access$202(PrintService.this, null);
                    return;
                }
                case 3: {
                    if (PrintService.this.mDiscoverySession == null) return;
                    ArrayList arrayList = (ArrayList)message.obj;
                    PrintService.this.mDiscoverySession.startPrinterDiscovery(arrayList);
                    return;
                }
                case 4: {
                    if (PrintService.this.mDiscoverySession == null) return;
                    PrintService.this.mDiscoverySession.stopPrinterDiscovery();
                    return;
                }
                case 5: {
                    if (PrintService.this.mDiscoverySession == null) return;
                    List list = (List)message.obj;
                    PrintService.this.mDiscoverySession.validatePrinters(list);
                    return;
                }
                case 6: {
                    if (PrintService.this.mDiscoverySession == null) return;
                    PrinterId printerId = (PrinterId)message.obj;
                    PrintService.this.mDiscoverySession.startPrinterStateTracking(printerId);
                    return;
                }
                case 7: {
                    if (PrintService.this.mDiscoverySession == null) return;
                    PrinterId printerId = (PrinterId)message.obj;
                    PrintService.this.mDiscoverySession.stopPrinterStateTracking(printerId);
                    return;
                }
                case 9: {
                    PrintJobInfo printJobInfo = (PrintJobInfo)message.obj;
                    PrintService.this.onRequestCancelPrintJob(new PrintJob(printJobInfo, PrintService.this.mClient));
                    return;
                }
                case 8: {
                    PrintJobInfo printJobInfo = (PrintJobInfo)message.obj;
                    PrintService.this.onPrintJobQueued(new PrintJob(printJobInfo, PrintService.this.mClient));
                    return;
                }
                case 10: 
            }
            PrintService.access$302(PrintService.this, (IPrintServiceClient)message.obj);
            if (PrintService.this.mClient != null) {
                PrintService.this.onConnected();
                return;
            }
            PrintService.this.onDisconnected();
        }
    }
}

