/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.FieldPacker;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class AllocationAdapter
extends Allocation {
    AllocationAdapter(long l, RenderScript renderScript, Allocation allocation) {
        super(l, renderScript, allocation.mType, allocation.mUsage);
        this.mAdaptedAllocation = allocation;
    }

    public static AllocationAdapter create1D(RenderScript renderScript, Allocation allocation) {
        renderScript.validate();
        AllocationAdapter allocationAdapter = new AllocationAdapter(0L, renderScript, allocation);
        allocationAdapter.mConstrainedLOD = true;
        allocationAdapter.mConstrainedFace = true;
        allocationAdapter.mConstrainedY = true;
        allocationAdapter.mConstrainedZ = true;
        allocationAdapter.initLOD(0);
        return allocationAdapter;
    }

    public static AllocationAdapter create2D(RenderScript renderScript, Allocation allocation) {
        renderScript.validate();
        AllocationAdapter allocationAdapter = new AllocationAdapter(0L, renderScript, allocation);
        allocationAdapter.mConstrainedLOD = true;
        allocationAdapter.mConstrainedFace = true;
        allocationAdapter.mConstrainedY = false;
        allocationAdapter.mConstrainedZ = true;
        allocationAdapter.initLOD(0);
        return allocationAdapter;
    }

    @Override
    long getID(RenderScript renderScript) {
        throw new RSInvalidStateException("This operation is not supported with adapters at this time.");
    }

    void initLOD(int n) {
        if (n < 0) {
            throw new RSIllegalArgumentException("Attempting to set negative lod (" + n + ").");
        }
        int n2 = this.mAdaptedAllocation.mType.getX();
        int n3 = this.mAdaptedAllocation.mType.getY();
        int n4 = this.mAdaptedAllocation.mType.getZ();
        for (int i = 0; i < n; ++i) {
            if (n2 == 1 && n3 == 1 && n4 == 1) {
                throw new RSIllegalArgumentException("Attempting to set lod (" + n + ") out of range.");
            }
            if (n2 > 1) {
                n2 >>= 1;
            }
            if (n3 > 1) {
                n3 >>= 1;
            }
            if (n4 <= 1) continue;
            n4 >>= 1;
        }
        this.mCurrentDimX = n2;
        this.mCurrentDimY = n3;
        this.mCurrentDimZ = n4;
        this.mCurrentCount = this.mCurrentDimX;
        if (this.mCurrentDimY > 1) {
            this.mCurrentCount *= this.mCurrentDimY;
        }
        if (this.mCurrentDimZ > 1) {
            this.mCurrentCount *= this.mCurrentDimZ;
        }
        this.mSelectedY = 0;
        this.mSelectedZ = 0;
    }

    public void readData(float[] fArray) {
        super.copyTo(fArray);
    }

    public void readData(int[] nArray) {
        super.copyTo(nArray);
    }

    @Override
    public void resize(int n) {
        synchronized (this) {
            throw new RSInvalidStateException("Resize not allowed for Adapters.");
        }
    }

    public void setFace(Type.CubemapFace cubemapFace) {
        if (!this.mAdaptedAllocation.getType().hasFaces()) {
            throw new RSInvalidStateException("Cannot set Face when the allocation type does not include faces.");
        }
        if (!this.mConstrainedFace) {
            throw new RSInvalidStateException("Cannot set LOD when the adapter includes mipmaps.");
        }
        if (cubemapFace == null) {
            throw new RSIllegalArgumentException("Cannot set null face.");
        }
        this.mSelectedFace = cubemapFace;
    }

    public void setLOD(int n) {
        if (!this.mAdaptedAllocation.getType().hasMipmaps()) {
            throw new RSInvalidStateException("Cannot set LOD when the allocation type does not include mipmaps.");
        }
        if (!this.mConstrainedLOD) {
            throw new RSInvalidStateException("Cannot set LOD when the adapter includes mipmaps.");
        }
        this.initLOD(n);
    }

    public void setY(int n) {
        if (this.mAdaptedAllocation.getType().getY() == 0) {
            throw new RSInvalidStateException("Cannot set Y when the allocation type does not include Y dim.");
        }
        if (this.mAdaptedAllocation.getType().getY() <= n) {
            throw new RSInvalidStateException("Cannot set Y greater than dimension of allocation.");
        }
        if (!this.mConstrainedY) {
            throw new RSInvalidStateException("Cannot set Y when the adapter includes Y.");
        }
        this.mSelectedY = n;
    }

    public void setZ(int n) {
        if (this.mAdaptedAllocation.getType().getZ() == 0) {
            throw new RSInvalidStateException("Cannot set Z when the allocation type does not include Z dim.");
        }
        if (this.mAdaptedAllocation.getType().getZ() <= n) {
            throw new RSInvalidStateException("Cannot set Z greater than dimension of allocation.");
        }
        if (!this.mConstrainedZ) {
            throw new RSInvalidStateException("Cannot set Z when the adapter includes Z.");
        }
        this.mSelectedZ = n;
    }

    public void subData(int n, FieldPacker fieldPacker) {
        super.setFromFieldPacker(n, fieldPacker);
    }

    public void subData1D(int n, int n2, byte[] byArray) {
        super.copy1DRangeFrom(n, n2, byArray);
    }

    public void subData1D(int n, int n2, float[] fArray) {
        super.copy1DRangeFrom(n, n2, fArray);
    }

    public void subData1D(int n, int n2, int[] nArray) {
        super.copy1DRangeFrom(n, n2, nArray);
    }

    public void subData1D(int n, int n2, short[] sArray) {
        super.copy1DRangeFrom(n, n2, sArray);
    }

    public void subData2D(int n, int n2, int n3, int n4, float[] fArray) {
        super.copy2DRangeFrom(n, n2, n3, n4, fArray);
    }

    public void subData2D(int n, int n2, int n3, int n4, int[] nArray) {
        super.copy2DRangeFrom(n, n2, n3, n4, nArray);
    }

    public void subElementData(int n, int n2, FieldPacker fieldPacker) {
        super.setFromFieldPacker(n, n2, fieldPacker);
    }
}

