/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Byte2;
import android.renderscript.Byte3;
import android.renderscript.Byte4;
import android.renderscript.Double2;
import android.renderscript.Double3;
import android.renderscript.Double4;
import android.renderscript.Float2;
import android.renderscript.Float3;
import android.renderscript.Float4;
import android.renderscript.Int2;
import android.renderscript.Int3;
import android.renderscript.Int4;
import android.renderscript.Long2;
import android.renderscript.Long3;
import android.renderscript.Long4;
import android.renderscript.Matrix2f;
import android.renderscript.Matrix3f;
import android.renderscript.Matrix4f;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Short2;
import android.renderscript.Short3;
import android.renderscript.Short4;
import android.util.Log;
import java.util.BitSet;

public class FieldPacker {
    private BitSet mAlignment;
    private final byte[] mData;
    private int mLen;
    private int mPos;

    public FieldPacker(int n) {
        this.mPos = 0;
        this.mLen = n;
        this.mData = new byte[n];
        this.mAlignment = new BitSet();
    }

    public FieldPacker(byte[] byArray) {
        this.mPos = byArray.length;
        this.mLen = byArray.length;
        this.mData = byArray;
        this.mAlignment = new BitSet();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addBoolean(boolean bl) {
        boolean bl2 = bl;
        this.addI8((byte)(bl2 ? 1 : 0));
    }

    public void addF32(float f) {
        this.addI32(Float.floatToRawIntBits(f));
    }

    public void addF32(Float2 float2) {
        this.addF32(float2.x);
        this.addF32(float2.y);
    }

    public void addF32(Float3 float3) {
        this.addF32(float3.x);
        this.addF32(float3.y);
        this.addF32(float3.z);
    }

    public void addF32(Float4 float4) {
        this.addF32(float4.x);
        this.addF32(float4.y);
        this.addF32(float4.z);
        this.addF32(float4.w);
    }

    public void addF64(double d) {
        this.addI64(Double.doubleToRawLongBits(d));
    }

    public void addF64(Double2 double2) {
        this.addF64(double2.x);
        this.addF64(double2.y);
    }

    public void addF64(Double3 double3) {
        this.addF64(double3.x);
        this.addF64(double3.y);
        this.addF64(double3.z);
    }

    public void addF64(Double4 double4) {
        this.addF64(double4.x);
        this.addF64(double4.y);
        this.addF64(double4.z);
        this.addF64(double4.w);
    }

    public void addI16(Short2 short2) {
        this.addI16(short2.x);
        this.addI16(short2.y);
    }

    public void addI16(Short3 short3) {
        this.addI16(short3.x);
        this.addI16(short3.y);
        this.addI16(short3.z);
    }

    public void addI16(Short4 short4) {
        this.addI16(short4.x);
        this.addI16(short4.y);
        this.addI16(short4.z);
        this.addI16(short4.w);
    }

    public void addI16(short s) {
        this.align(2);
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)(s & 0xFF);
        byte[] byArray2 = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray2[n2] = (byte)(s >> 8);
    }

    public void addI32(int n) {
        this.align(4);
        byte[] byArray = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray[n2] = (byte)(n & 0xFF);
        byte[] byArray2 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray2[n3] = (byte)(0xFF & n >> 8);
        byte[] byArray3 = this.mData;
        int n4 = this.mPos;
        this.mPos = n4 + 1;
        byArray3[n4] = (byte)(0xFF & n >> 16);
        byte[] byArray4 = this.mData;
        int n5 = this.mPos;
        this.mPos = n5 + 1;
        byArray4[n5] = (byte)(0xFF & n >> 24);
    }

    public void addI32(Int2 int2) {
        this.addI32(int2.x);
        this.addI32(int2.y);
    }

    public void addI32(Int3 int3) {
        this.addI32(int3.x);
        this.addI32(int3.y);
        this.addI32(int3.z);
    }

    public void addI32(Int4 int4) {
        this.addI32(int4.x);
        this.addI32(int4.y);
        this.addI32(int4.z);
        this.addI32(int4.w);
    }

    public void addI64(long l) {
        this.align(8);
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)(l & 0xFFL);
        byte[] byArray2 = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray2[n2] = (byte)(0xFFL & l >> 8);
        byte[] byArray3 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray3[n3] = (byte)(0xFFL & l >> 16);
        byte[] byArray4 = this.mData;
        int n4 = this.mPos;
        this.mPos = n4 + 1;
        byArray4[n4] = (byte)(0xFFL & l >> 24);
        byte[] byArray5 = this.mData;
        int n5 = this.mPos;
        this.mPos = n5 + 1;
        byArray5[n5] = (byte)(0xFFL & l >> 32);
        byte[] byArray6 = this.mData;
        int n6 = this.mPos;
        this.mPos = n6 + 1;
        byArray6[n6] = (byte)(0xFFL & l >> 40);
        byte[] byArray7 = this.mData;
        int n7 = this.mPos;
        this.mPos = n7 + 1;
        byArray7[n7] = (byte)(0xFFL & l >> 48);
        byte[] byArray8 = this.mData;
        int n8 = this.mPos;
        this.mPos = n8 + 1;
        byArray8[n8] = (byte)(0xFFL & l >> 56);
    }

    public void addI64(Long2 long2) {
        this.addI64(long2.x);
        this.addI64(long2.y);
    }

    public void addI64(Long3 long3) {
        this.addI64(long3.x);
        this.addI64(long3.y);
        this.addI64(long3.z);
    }

    public void addI64(Long4 long4) {
        this.addI64(long4.x);
        this.addI64(long4.y);
        this.addI64(long4.z);
        this.addI64(long4.w);
    }

    public void addI8(byte by) {
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = by;
    }

    public void addI8(Byte2 byte2) {
        this.addI8(byte2.x);
        this.addI8(byte2.y);
    }

    public void addI8(Byte3 byte3) {
        this.addI8(byte3.x);
        this.addI8(byte3.y);
        this.addI8(byte3.z);
    }

    public void addI8(Byte4 byte4) {
        this.addI8(byte4.x);
        this.addI8(byte4.y);
        this.addI8(byte4.z);
        this.addI8(byte4.w);
    }

    public void addMatrix(Matrix2f matrix2f) {
        for (int i = 0; i < matrix2f.mMat.length; ++i) {
            this.addF32(matrix2f.mMat[i]);
        }
    }

    public void addMatrix(Matrix3f matrix3f) {
        for (int i = 0; i < matrix3f.mMat.length; ++i) {
            this.addF32(matrix3f.mMat[i]);
        }
    }

    public void addMatrix(Matrix4f matrix4f) {
        for (int i = 0; i < matrix4f.mMat.length; ++i) {
            this.addF32(matrix4f.mMat[i]);
        }
    }

    public void addObj(BaseObj baseObj) {
        if (baseObj != null) {
            if (RenderScript.sPointerSize == 8) {
                this.addI64(baseObj.getID(null));
                this.addI64(0L);
                this.addI64(0L);
                this.addI64(0L);
                return;
            }
            this.addI32((int)baseObj.getID(null));
            return;
        }
        if (RenderScript.sPointerSize == 8) {
            this.addI64(0L);
            this.addI64(0L);
            this.addI64(0L);
            this.addI64(0L);
            return;
        }
        this.addI32(0);
    }

    public void addU16(int n) {
        if (n < 0 || n > 65535) {
            Log.e("rs", "FieldPacker.addU16( " + n + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(2);
        byte[] byArray = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray[n2] = (byte)(n & 0xFF);
        byte[] byArray2 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray2[n3] = (byte)(n >> 8);
    }

    public void addU16(Int2 int2) {
        this.addU16(int2.x);
        this.addU16(int2.y);
    }

    public void addU16(Int3 int3) {
        this.addU16(int3.x);
        this.addU16(int3.y);
        this.addU16(int3.z);
    }

    public void addU16(Int4 int4) {
        this.addU16(int4.x);
        this.addU16(int4.y);
        this.addU16(int4.z);
        this.addU16(int4.w);
    }

    public void addU32(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            Log.e("rs", "FieldPacker.addU32( " + l + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(4);
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)(l & 0xFFL);
        byte[] byArray2 = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray2[n2] = (byte)(0xFFL & l >> 8);
        byte[] byArray3 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray3[n3] = (byte)(0xFFL & l >> 16);
        byte[] byArray4 = this.mData;
        int n4 = this.mPos;
        this.mPos = n4 + 1;
        byArray4[n4] = (byte)(0xFFL & l >> 24);
    }

    public void addU32(Long2 long2) {
        this.addU32(long2.x);
        this.addU32(long2.y);
    }

    public void addU32(Long3 long3) {
        this.addU32(long3.x);
        this.addU32(long3.y);
        this.addU32(long3.z);
    }

    public void addU32(Long4 long4) {
        this.addU32(long4.x);
        this.addU32(long4.y);
        this.addU32(long4.z);
        this.addU32(long4.w);
    }

    public void addU64(long l) {
        if (l < 0L) {
            Log.e("rs", "FieldPacker.addU64( " + l + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(8);
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)(l & 0xFFL);
        byte[] byArray2 = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray2[n2] = (byte)(0xFFL & l >> 8);
        byte[] byArray3 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray3[n3] = (byte)(0xFFL & l >> 16);
        byte[] byArray4 = this.mData;
        int n4 = this.mPos;
        this.mPos = n4 + 1;
        byArray4[n4] = (byte)(0xFFL & l >> 24);
        byte[] byArray5 = this.mData;
        int n5 = this.mPos;
        this.mPos = n5 + 1;
        byArray5[n5] = (byte)(0xFFL & l >> 32);
        byte[] byArray6 = this.mData;
        int n6 = this.mPos;
        this.mPos = n6 + 1;
        byArray6[n6] = (byte)(0xFFL & l >> 40);
        byte[] byArray7 = this.mData;
        int n7 = this.mPos;
        this.mPos = n7 + 1;
        byArray7[n7] = (byte)(0xFFL & l >> 48);
        byte[] byArray8 = this.mData;
        int n8 = this.mPos;
        this.mPos = n8 + 1;
        byArray8[n8] = (byte)(0xFFL & l >> 56);
    }

    public void addU64(Long2 long2) {
        this.addU64(long2.x);
        this.addU64(long2.y);
    }

    public void addU64(Long3 long3) {
        this.addU64(long3.x);
        this.addU64(long3.y);
        this.addU64(long3.z);
    }

    public void addU64(Long4 long4) {
        this.addU64(long4.x);
        this.addU64(long4.y);
        this.addU64(long4.z);
        this.addU64(long4.w);
    }

    public void addU8(Short2 short2) {
        this.addU8(short2.x);
        this.addU8(short2.y);
    }

    public void addU8(Short3 short3) {
        this.addU8(short3.x);
        this.addU8(short3.y);
        this.addU8(short3.z);
    }

    public void addU8(Short4 short4) {
        this.addU8(short4.x);
        this.addU8(short4.y);
        this.addU8(short4.z);
        this.addU8(short4.w);
    }

    public void addU8(short s) {
        if (s < 0 || s > 255) {
            Log.e("rs", "FieldPacker.addU8( " + s + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)s;
    }

    public void align(int n) {
        if (n <= 0 || (n & n - 1) != 0) {
            throw new RSIllegalArgumentException("argument must be a non-negative non-zero power of 2: " + n);
        }
        while ((this.mPos & n - 1) != 0) {
            this.mAlignment.flip(this.mPos);
            byte[] byArray = this.mData;
            int n2 = this.mPos;
            this.mPos = n2 + 1;
            byArray[n2] = 0;
        }
    }

    public final byte[] getData() {
        return this.mData;
    }

    public int getPos() {
        return this.mPos;
    }

    public void reset() {
        this.mPos = 0;
    }

    public void reset(int n) {
        if (n < 0 || n > this.mLen) {
            throw new RSIllegalArgumentException("out of range argument: " + n);
        }
        this.mPos = n;
    }

    public void skip(int n) {
        int n2 = n + this.mPos;
        if (n2 < 0 || n2 > this.mLen) {
            throw new RSIllegalArgumentException("out of range argument: " + n);
        }
        this.mPos = n2;
    }

    public boolean subBoolean() {
        return this.subI8() == 1;
    }

    public Byte2 subByte2() {
        Byte2 byte2 = new Byte2();
        byte2.y = this.subI8();
        byte2.x = this.subI8();
        return byte2;
    }

    public Byte3 subByte3() {
        Byte3 byte3 = new Byte3();
        byte3.z = this.subI8();
        byte3.y = this.subI8();
        byte3.x = this.subI8();
        return byte3;
    }

    public Byte4 subByte4() {
        Byte4 byte4 = new Byte4();
        byte4.w = this.subI8();
        byte4.z = this.subI8();
        byte4.y = this.subI8();
        byte4.x = this.subI8();
        return byte4;
    }

    public Double2 subDouble2() {
        Double2 double2 = new Double2();
        double2.y = this.subF64();
        double2.x = this.subF64();
        return double2;
    }

    public Double3 subDouble3() {
        Double3 double3 = new Double3();
        double3.z = this.subF64();
        double3.y = this.subF64();
        double3.x = this.subF64();
        return double3;
    }

    public Double4 subDouble4() {
        Double4 double4 = new Double4();
        double4.w = this.subF64();
        double4.z = this.subF64();
        double4.y = this.subF64();
        double4.x = this.subF64();
        return double4;
    }

    public float subF32() {
        return Float.intBitsToFloat(this.subI32());
    }

    public double subF64() {
        return Double.longBitsToDouble(this.subI64());
    }

    public Float2 subFloat2() {
        Float2 float2 = new Float2();
        float2.y = this.subF32();
        float2.x = this.subF32();
        return float2;
    }

    public Float3 subFloat3() {
        Float3 float3 = new Float3();
        float3.z = this.subF32();
        float3.y = this.subF32();
        float3.x = this.subF32();
        return float3;
    }

    public Float4 subFloat4() {
        Float4 float4 = new Float4();
        float4.w = this.subF32();
        float4.z = this.subF32();
        float4.y = this.subF32();
        float4.x = this.subF32();
        return float4;
    }

    public short subI16() {
        int n;
        int n2;
        this.subalign(2);
        byte[] byArray = this.mData;
        this.mPos = n2 = -1 + this.mPos;
        short s = (short)((0xFF & byArray[n2]) << 8);
        byte[] byArray2 = this.mData;
        this.mPos = n = -1 + this.mPos;
        return (short)(s | (short)(0xFF & byArray2[n]));
    }

    public int subI32() {
        int n;
        int n2;
        int n3;
        int n4;
        this.subalign(4);
        byte[] byArray = this.mData;
        this.mPos = n4 = -1 + this.mPos;
        int n5 = (0xFF & byArray[n4]) << 24;
        byte[] byArray2 = this.mData;
        this.mPos = n3 = -1 + this.mPos;
        int n6 = n5 | (0xFF & byArray2[n3]) << 16;
        byte[] byArray3 = this.mData;
        this.mPos = n2 = -1 + this.mPos;
        int n7 = n6 | (0xFF & byArray3[n2]) << 8;
        byte[] byArray4 = this.mData;
        this.mPos = n = -1 + this.mPos;
        return n7 | 0xFF & byArray4[n];
    }

    public long subI64() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.subalign(8);
        byte[] byArray = this.mData;
        this.mPos = n8 = -1 + this.mPos;
        long l = 0L | (0xFFL & (long)byArray[n8]) << 56;
        byte[] byArray2 = this.mData;
        this.mPos = n7 = -1 + this.mPos;
        long l2 = l | (0xFFL & (long)byArray2[n7]) << 48;
        byte[] byArray3 = this.mData;
        this.mPos = n6 = -1 + this.mPos;
        long l3 = l2 | (0xFFL & (long)byArray3[n6]) << 40;
        byte[] byArray4 = this.mData;
        this.mPos = n5 = -1 + this.mPos;
        long l4 = l3 | (0xFFL & (long)byArray4[n5]) << 32;
        byte[] byArray5 = this.mData;
        this.mPos = n4 = -1 + this.mPos;
        long l5 = l4 | (0xFFL & (long)byArray5[n4]) << 24;
        byte[] byArray6 = this.mData;
        this.mPos = n3 = -1 + this.mPos;
        long l6 = l5 | (0xFFL & (long)byArray6[n3]) << 16;
        byte[] byArray7 = this.mData;
        this.mPos = n2 = -1 + this.mPos;
        long l7 = l6 | (0xFFL & (long)byArray7[n2]) << 8;
        byte[] byArray8 = this.mData;
        this.mPos = n = -1 + this.mPos;
        return l7 | 0xFFL & (long)byArray8[n];
    }

    public byte subI8() {
        int n;
        this.subalign(1);
        byte[] byArray = this.mData;
        this.mPos = n = -1 + this.mPos;
        return byArray[n];
    }

    public Int2 subInt2() {
        Int2 int2 = new Int2();
        int2.y = this.subI32();
        int2.x = this.subI32();
        return int2;
    }

    public Int3 subInt3() {
        Int3 int3 = new Int3();
        int3.z = this.subI32();
        int3.y = this.subI32();
        int3.x = this.subI32();
        return int3;
    }

    public Int4 subInt4() {
        Int4 int4 = new Int4();
        int4.w = this.subI32();
        int4.z = this.subI32();
        int4.y = this.subI32();
        int4.x = this.subI32();
        return int4;
    }

    public Long2 subLong2() {
        Long2 long2 = new Long2();
        long2.y = this.subI64();
        long2.x = this.subI64();
        return long2;
    }

    public Long3 subLong3() {
        Long3 long3 = new Long3();
        long3.z = this.subI64();
        long3.y = this.subI64();
        long3.x = this.subI64();
        return long3;
    }

    public Long4 subLong4() {
        Long4 long4 = new Long4();
        long4.w = this.subI64();
        long4.z = this.subI64();
        long4.y = this.subI64();
        long4.x = this.subI64();
        return long4;
    }

    public Matrix2f subMatrix2f() {
        Matrix2f matrix2f = new Matrix2f();
        for (int i = -1 + matrix2f.mMat.length; i >= 0; --i) {
            matrix2f.mMat[i] = this.subF32();
        }
        return matrix2f;
    }

    public Matrix3f subMatrix3f() {
        Matrix3f matrix3f = new Matrix3f();
        for (int i = -1 + matrix3f.mMat.length; i >= 0; --i) {
            matrix3f.mMat[i] = this.subF32();
        }
        return matrix3f;
    }

    public Matrix4f subMatrix4f() {
        Matrix4f matrix4f = new Matrix4f();
        for (int i = -1 + matrix4f.mMat.length; i >= 0; --i) {
            matrix4f.mMat[i] = this.subF32();
        }
        return matrix4f;
    }

    public Short2 subShort2() {
        Short2 short2 = new Short2();
        short2.y = this.subI16();
        short2.x = this.subI16();
        return short2;
    }

    public Short3 subShort3() {
        Short3 short3 = new Short3();
        short3.z = this.subI16();
        short3.y = this.subI16();
        short3.x = this.subI16();
        return short3;
    }

    public Short4 subShort4() {
        Short4 short4 = new Short4();
        short4.w = this.subI16();
        short4.z = this.subI16();
        short4.y = this.subI16();
        short4.x = this.subI16();
        return short4;
    }

    public void subalign(int n) {
        if ((n & n - 1) != 0) {
            throw new RSIllegalArgumentException("argument must be a non-negative non-zero power of 2: " + n);
        }
        while ((this.mPos & n - 1) != 0) {
            this.mPos = -1 + this.mPos;
        }
        if (this.mPos > 0) {
            while (this.mAlignment.get(-1 + this.mPos)) {
                this.mPos = -1 + this.mPos;
                this.mAlignment.flip(this.mPos);
            }
        }
    }
}

