/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import java.util.Vector;

public class Mesh
extends BaseObj {
    Allocation[] mIndexBuffers;
    Primitive[] mPrimitives;
    Allocation[] mVertexBuffers;

    Mesh(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    public Allocation getIndexSetAllocation(int n) {
        return this.mIndexBuffers[n];
    }

    public Primitive getPrimitive(int n) {
        return this.mPrimitives[n];
    }

    public int getPrimitiveCount() {
        if (this.mIndexBuffers == null) {
            return 0;
        }
        return this.mIndexBuffers.length;
    }

    public Allocation getVertexAllocation(int n) {
        return this.mVertexBuffers[n];
    }

    public int getVertexAllocationCount() {
        if (this.mVertexBuffers == null) {
            return 0;
        }
        return this.mVertexBuffers.length;
    }

    @Override
    void updateFromNative() {
        super.updateFromNative();
        int n = this.mRS.nMeshGetVertexBufferCount(this.getID(this.mRS));
        int n2 = this.mRS.nMeshGetIndexCount(this.getID(this.mRS));
        long[] lArray = new long[n];
        long[] lArray2 = new long[n2];
        int[] nArray = new int[n2];
        this.mRS.nMeshGetVertices(this.getID(this.mRS), lArray, n);
        this.mRS.nMeshGetIndices(this.getID(this.mRS), lArray2, nArray, n2);
        this.mVertexBuffers = new Allocation[n];
        this.mIndexBuffers = new Allocation[n2];
        this.mPrimitives = new Primitive[n2];
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == 0L) continue;
            this.mVertexBuffers[i] = new Allocation(lArray[i], this.mRS, null, 1);
            this.mVertexBuffers[i].updateFromNative();
        }
        for (int i = 0; i < n2; ++i) {
            if (lArray2[i] != 0L) {
                this.mIndexBuffers[i] = new Allocation(lArray2[i], this.mRS, null, 1);
                this.mIndexBuffers[i].updateFromNative();
            }
            this.mPrimitives[i] = Primitive.values()[nArray[i]];
        }
    }

    public static class AllocationBuilder {
        Vector mIndexTypes;
        RenderScript mRS;
        int mVertexTypeCount;
        Entry[] mVertexTypes;

        public AllocationBuilder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mVertexTypeCount = 0;
            this.mVertexTypes = new Entry[16];
            this.mIndexTypes = new Vector();
        }

        public AllocationBuilder addIndexSetAllocation(Allocation allocation, Primitive primitive) {
            Entry entry = new Entry();
            entry.a = allocation;
            entry.prim = primitive;
            this.mIndexTypes.addElement(entry);
            return this;
        }

        public AllocationBuilder addIndexSetType(Primitive primitive) {
            Entry entry = new Entry();
            entry.a = null;
            entry.prim = primitive;
            this.mIndexTypes.addElement(entry);
            return this;
        }

        public AllocationBuilder addVertexAllocation(Allocation allocation) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            this.mVertexTypes[this.mVertexTypeCount] = new Entry();
            this.mVertexTypes[this.mVertexTypeCount].a = allocation;
            this.mVertexTypeCount = 1 + this.mVertexTypeCount;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Mesh create() {
            this.mRS.validate();
            long[] lArray = new long[this.mVertexTypeCount];
            long[] lArray2 = new long[this.mIndexTypes.size()];
            int[] nArray = new int[this.mIndexTypes.size()];
            Allocation[] allocationArray = new Allocation[this.mIndexTypes.size()];
            Primitive[] primitiveArray = new Primitive[this.mIndexTypes.size()];
            Allocation[] allocationArray2 = new Allocation[this.mVertexTypeCount];
            for (int i = 0; i < this.mVertexTypeCount; ++i) {
                Entry entry = this.mVertexTypes[i];
                allocationArray2[i] = entry.a;
                lArray[i] = entry.a.getID(this.mRS);
            }
            int n = 0;
            while (true) {
                if (n >= this.mIndexTypes.size()) {
                    Mesh mesh = new Mesh(this.mRS.nMeshCreate(lArray, lArray2, nArray), this.mRS);
                    mesh.mVertexBuffers = allocationArray2;
                    mesh.mIndexBuffers = allocationArray;
                    mesh.mPrimitives = primitiveArray;
                    return mesh;
                }
                Entry entry = (Entry)this.mIndexTypes.elementAt(n);
                long l = entry.a == null ? 0L : entry.a.getID(this.mRS);
                allocationArray[n] = entry.a;
                primitiveArray[n] = entry.prim;
                lArray2[n] = l;
                nArray[n] = entry.prim.mID;
                ++n;
            }
        }

        public int getCurrentIndexSetIndex() {
            return -1 + this.mIndexTypes.size();
        }

        public int getCurrentVertexTypeIndex() {
            return -1 + this.mVertexTypeCount;
        }

        class Entry {
            Allocation a;
            Primitive prim;

            Entry() {
            }
        }
    }

    public static class Builder {
        Vector mIndexTypes;
        RenderScript mRS;
        int mUsage;
        int mVertexTypeCount;
        Entry[] mVertexTypes;

        public Builder(RenderScript renderScript, int n) {
            this.mRS = renderScript;
            this.mUsage = n;
            this.mVertexTypeCount = 0;
            this.mVertexTypes = new Entry[16];
            this.mIndexTypes = new Vector();
        }

        public Builder addIndexSetType(Element element, int n, Primitive primitive) {
            Entry entry = new Entry();
            entry.t = null;
            entry.e = element;
            entry.size = n;
            entry.prim = primitive;
            this.mIndexTypes.addElement(entry);
            return this;
        }

        public Builder addIndexSetType(Primitive primitive) {
            Entry entry = new Entry();
            entry.t = null;
            entry.e = null;
            entry.size = 0;
            entry.prim = primitive;
            this.mIndexTypes.addElement(entry);
            return this;
        }

        public Builder addIndexSetType(Type type, Primitive primitive) {
            Entry entry = new Entry();
            entry.t = type;
            entry.e = null;
            entry.size = 0;
            entry.prim = primitive;
            this.mIndexTypes.addElement(entry);
            return this;
        }

        public Builder addVertexType(Element element, int n) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            this.mVertexTypes[this.mVertexTypeCount] = new Entry();
            this.mVertexTypes[this.mVertexTypeCount].t = null;
            this.mVertexTypes[this.mVertexTypeCount].e = element;
            this.mVertexTypes[this.mVertexTypeCount].size = n;
            this.mVertexTypeCount = 1 + this.mVertexTypeCount;
            return this;
        }

        public Builder addVertexType(Type type) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            this.mVertexTypes[this.mVertexTypeCount] = new Entry();
            this.mVertexTypes[this.mVertexTypeCount].t = type;
            this.mVertexTypes[this.mVertexTypeCount].e = null;
            this.mVertexTypeCount = 1 + this.mVertexTypeCount;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Mesh create() {
            this.mRS.validate();
            long[] lArray = new long[this.mVertexTypeCount];
            long[] lArray2 = new long[this.mIndexTypes.size()];
            int[] nArray = new int[this.mIndexTypes.size()];
            Allocation[] allocationArray = new Allocation[this.mVertexTypeCount];
            Allocation[] allocationArray2 = new Allocation[this.mIndexTypes.size()];
            Primitive[] primitiveArray = new Primitive[this.mIndexTypes.size()];
            for (int i = 0; i < this.mVertexTypeCount; ++i) {
                Allocation allocation;
                Entry entry = this.mVertexTypes[i];
                if (entry.t != null) {
                    allocation = Allocation.createTyped(this.mRS, entry.t, this.mUsage);
                } else {
                    Element element = entry.e;
                    allocation = null;
                    if (element != null) {
                        allocation = Allocation.createSized(this.mRS, entry.e, entry.size, this.mUsage);
                    }
                }
                allocationArray[i] = allocation;
                lArray[i] = allocation.getID(this.mRS);
            }
            int n = 0;
            while (true) {
                Allocation allocation;
                if (n >= this.mIndexTypes.size()) {
                    Mesh mesh = new Mesh(this.mRS.nMeshCreate(lArray, lArray2, nArray), this.mRS);
                    mesh.mVertexBuffers = allocationArray;
                    mesh.mIndexBuffers = allocationArray2;
                    mesh.mPrimitives = primitiveArray;
                    return mesh;
                }
                Entry entry = (Entry)this.mIndexTypes.elementAt(n);
                if (entry.t != null) {
                    allocation = Allocation.createTyped(this.mRS, entry.t, this.mUsage);
                } else {
                    Element element = entry.e;
                    allocation = null;
                    if (element != null) {
                        allocation = Allocation.createSized(this.mRS, entry.e, entry.size, this.mUsage);
                    }
                }
                long l = allocation == null ? 0L : allocation.getID(this.mRS);
                allocationArray2[n] = allocation;
                primitiveArray[n] = entry.prim;
                lArray2[n] = l;
                nArray[n] = entry.prim.mID;
                ++n;
            }
        }

        public int getCurrentIndexSetIndex() {
            return -1 + this.mIndexTypes.size();
        }

        public int getCurrentVertexTypeIndex() {
            return -1 + this.mVertexTypeCount;
        }

        Type newType(Element element, int n) {
            Type.Builder builder = new Type.Builder(this.mRS, element);
            builder.setX(n);
            return builder.create();
        }

        class Entry {
            Element e;
            Primitive prim;
            int size;
            Type t;
            int usage;

            Entry() {
            }
        }
    }

    public static final class Primitive
    extends Enum<Primitive> {
        private static final /* synthetic */ Primitive[] $VALUES;
        public static final /* enum */ Primitive LINE;
        public static final /* enum */ Primitive LINE_STRIP;
        public static final /* enum */ Primitive POINT;
        public static final /* enum */ Primitive TRIANGLE;
        public static final /* enum */ Primitive TRIANGLE_FAN;
        public static final /* enum */ Primitive TRIANGLE_STRIP;
        int mID;

        static {
            POINT = new Primitive(0);
            LINE = new Primitive(1);
            LINE_STRIP = new Primitive(2);
            TRIANGLE = new Primitive(3);
            TRIANGLE_STRIP = new Primitive(4);
            TRIANGLE_FAN = new Primitive(5);
            Primitive[] primitiveArray = new Primitive[]{POINT, LINE, LINE_STRIP, TRIANGLE, TRIANGLE_STRIP, TRIANGLE_FAN};
            $VALUES = primitiveArray;
        }

        private Primitive(int n2) {
            this.mID = n2;
        }

        public static Primitive valueOf(String string2) {
            return Enum.valueOf(Primitive.class, string2);
        }

        public static Primitive[] values() {
            return (Primitive[])$VALUES.clone();
        }
    }

    public static class TriangleMeshBuilder {
        public static final int COLOR = 1;
        public static final int NORMAL = 2;
        public static final int TEXTURE_0 = 256;
        float mA = 1.0f;
        float mB = 1.0f;
        Element mElement;
        int mFlags;
        float mG = 1.0f;
        int mIndexCount;
        short[] mIndexData;
        int mMaxIndex;
        float mNX = 0.0f;
        float mNY = 0.0f;
        float mNZ = -1.0f;
        float mR = 1.0f;
        RenderScript mRS;
        float mS0 = 0.0f;
        float mT0 = 0.0f;
        int mVtxCount;
        float[] mVtxData;
        int mVtxSize;

        public TriangleMeshBuilder(RenderScript renderScript, int n, int n2) {
            this.mRS = renderScript;
            this.mVtxCount = 0;
            this.mMaxIndex = 0;
            this.mIndexCount = 0;
            this.mVtxData = new float[128];
            this.mIndexData = new short[128];
            this.mVtxSize = n;
            this.mFlags = n2;
            if (n < 2 || n > 3) {
                throw new IllegalArgumentException("Vertex size out of range.");
            }
        }

        private void latch() {
            if ((1 & this.mFlags) != 0) {
                this.makeSpace(4);
                float[] fArray = this.mVtxData;
                int n = this.mVtxCount;
                this.mVtxCount = n + 1;
                fArray[n] = this.mR;
                float[] fArray2 = this.mVtxData;
                int n2 = this.mVtxCount;
                this.mVtxCount = n2 + 1;
                fArray2[n2] = this.mG;
                float[] fArray3 = this.mVtxData;
                int n3 = this.mVtxCount;
                this.mVtxCount = n3 + 1;
                fArray3[n3] = this.mB;
                float[] fArray4 = this.mVtxData;
                int n4 = this.mVtxCount;
                this.mVtxCount = n4 + 1;
                fArray4[n4] = this.mA;
            }
            if ((0x100 & this.mFlags) != 0) {
                this.makeSpace(2);
                float[] fArray = this.mVtxData;
                int n = this.mVtxCount;
                this.mVtxCount = n + 1;
                fArray[n] = this.mS0;
                float[] fArray5 = this.mVtxData;
                int n5 = this.mVtxCount;
                this.mVtxCount = n5 + 1;
                fArray5[n5] = this.mT0;
            }
            if ((2 & this.mFlags) != 0) {
                this.makeSpace(4);
                float[] fArray = this.mVtxData;
                int n = this.mVtxCount;
                this.mVtxCount = n + 1;
                fArray[n] = this.mNX;
                float[] fArray6 = this.mVtxData;
                int n6 = this.mVtxCount;
                this.mVtxCount = n6 + 1;
                fArray6[n6] = this.mNY;
                float[] fArray7 = this.mVtxData;
                int n7 = this.mVtxCount;
                this.mVtxCount = n7 + 1;
                fArray7[n7] = this.mNZ;
                float[] fArray8 = this.mVtxData;
                int n8 = this.mVtxCount;
                this.mVtxCount = n8 + 1;
                fArray8[n8] = 0.0f;
            }
            this.mMaxIndex = 1 + this.mMaxIndex;
        }

        private void makeSpace(int n) {
            if (n + this.mVtxCount >= this.mVtxData.length) {
                float[] fArray = new float[2 * this.mVtxData.length];
                System.arraycopy((float[])this.mVtxData, (int)0, (float[])fArray, (int)0, (int)this.mVtxData.length);
                this.mVtxData = fArray;
            }
        }

        public TriangleMeshBuilder addTriangle(int n, int n2, int n3) {
            if (n >= this.mMaxIndex || n < 0 || n2 >= this.mMaxIndex || n2 < 0 || n3 >= this.mMaxIndex || n3 < 0) {
                throw new IllegalStateException("Index provided greater than vertex count.");
            }
            if (3 + this.mIndexCount >= this.mIndexData.length) {
                short[] sArray = new short[2 * this.mIndexData.length];
                System.arraycopy((short[])this.mIndexData, (int)0, (short[])sArray, (int)0, (int)this.mIndexData.length);
                this.mIndexData = sArray;
            }
            short[] sArray = this.mIndexData;
            int n4 = this.mIndexCount;
            this.mIndexCount = n4 + 1;
            sArray[n4] = (short)n;
            short[] sArray2 = this.mIndexData;
            int n5 = this.mIndexCount;
            this.mIndexCount = n5 + 1;
            sArray2[n5] = (short)n2;
            short[] sArray3 = this.mIndexData;
            int n6 = this.mIndexCount;
            this.mIndexCount = n6 + 1;
            sArray3[n6] = (short)n3;
            return this;
        }

        public TriangleMeshBuilder addVertex(float f, float f2) {
            if (this.mVtxSize != 2) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(2);
            float[] fArray = this.mVtxData;
            int n = this.mVtxCount;
            this.mVtxCount = n + 1;
            fArray[n] = f;
            float[] fArray2 = this.mVtxData;
            int n2 = this.mVtxCount;
            this.mVtxCount = n2 + 1;
            fArray2[n2] = f2;
            this.latch();
            return this;
        }

        public TriangleMeshBuilder addVertex(float f, float f2, float f3) {
            if (this.mVtxSize != 3) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(4);
            float[] fArray = this.mVtxData;
            int n = this.mVtxCount;
            this.mVtxCount = n + 1;
            fArray[n] = f;
            float[] fArray2 = this.mVtxData;
            int n2 = this.mVtxCount;
            this.mVtxCount = n2 + 1;
            fArray2[n2] = f2;
            float[] fArray3 = this.mVtxData;
            int n3 = this.mVtxCount;
            this.mVtxCount = n3 + 1;
            fArray3[n3] = f3;
            float[] fArray4 = this.mVtxData;
            int n4 = this.mVtxCount;
            this.mVtxCount = n4 + 1;
            fArray4[n4] = 1.0f;
            this.latch();
            return this;
        }

        public Mesh create(boolean bl) {
            Element.Builder builder = new Element.Builder(this.mRS);
            builder.add(Element.createVector(this.mRS, Element.DataType.FLOAT_32, this.mVtxSize), "position");
            if ((1 & this.mFlags) != 0) {
                builder.add(Element.F32_4(this.mRS), "color");
            }
            if ((0x100 & this.mFlags) != 0) {
                builder.add(Element.F32_2(this.mRS), "texture0");
            }
            if ((2 & this.mFlags) != 0) {
                builder.add(Element.F32_3(this.mRS), "normal");
            }
            this.mElement = builder.create();
            int n = 1;
            if (bl) {
                n |= 4;
            }
            Builder builder2 = new Builder(this.mRS, n);
            builder2.addVertexType(this.mElement, this.mMaxIndex);
            builder2.addIndexSetType(Element.U16(this.mRS), this.mIndexCount, Primitive.TRIANGLE);
            Mesh mesh = builder2.create();
            mesh.getVertexAllocation(0).copy1DRangeFromUnchecked(0, this.mMaxIndex, this.mVtxData);
            if (bl && bl) {
                mesh.getVertexAllocation(0).syncAll(1);
            }
            mesh.getIndexSetAllocation(0).copy1DRangeFromUnchecked(0, this.mIndexCount, this.mIndexData);
            if (bl) {
                mesh.getIndexSetAllocation(0).syncAll(1);
            }
            return mesh;
        }

        public TriangleMeshBuilder setColor(float f, float f2, float f3, float f4) {
            if ((1 & this.mFlags) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mR = f;
            this.mG = f2;
            this.mB = f3;
            this.mA = f4;
            return this;
        }

        public TriangleMeshBuilder setNormal(float f, float f2, float f3) {
            if ((2 & this.mFlags) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mNX = f;
            this.mNY = f2;
            this.mNZ = f3;
            return this;
        }

        public TriangleMeshBuilder setTexture(float f, float f2) {
            if ((0x100 & this.mFlags) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mS0 = f;
            this.mT0 = f2;
            return this;
        }
    }
}

