/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Type;
import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class Program
extends BaseObj {
    static final int MAX_CONSTANT = 8;
    static final int MAX_INPUT = 8;
    static final int MAX_OUTPUT = 8;
    static final int MAX_TEXTURE = 8;
    Type[] mConstants;
    Element[] mInputs;
    Element[] mOutputs;
    String mShader;
    int mTextureCount;
    String[] mTextureNames;
    TextureType[] mTextures;

    Program(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bindConstants(Allocation allocation, int n) {
        if (n < 0 || n >= this.mConstants.length) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        if (allocation != null && allocation.getType().getID(this.mRS) != this.mConstants[n].getID(this.mRS)) {
            throw new IllegalArgumentException("Allocation type does not match slot type.");
        }
        long l = allocation != null ? allocation.getID(this.mRS) : 0L;
        this.mRS.nProgramBindConstants(this.getID(this.mRS), n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bindSampler(Sampler sampler, int n) throws IllegalArgumentException {
        this.mRS.validate();
        if (n < 0 || n >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        long l = sampler != null ? sampler.getID(this.mRS) : 0L;
        this.mRS.nProgramBindSampler(this.getID(this.mRS), n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bindTexture(Allocation allocation, int n) throws IllegalArgumentException {
        this.mRS.validate();
        if (n < 0 || n >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        if (allocation != null && allocation.getType().hasFaces() && this.mTextures[n] != TextureType.TEXTURE_CUBE) {
            throw new IllegalArgumentException("Cannot bind cubemap to 2d texture slot");
        }
        long l = allocation != null ? allocation.getID(this.mRS) : 0L;
        this.mRS.nProgramBindTexture(this.getID(this.mRS), n, l);
    }

    public Type getConstant(int n) {
        if (n < 0 || n >= this.mConstants.length) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mConstants[n];
    }

    public int getConstantCount() {
        if (this.mConstants != null) {
            return this.mConstants.length;
        }
        return 0;
    }

    public int getTextureCount() {
        return this.mTextureCount;
    }

    public String getTextureName(int n) {
        if (n < 0 || n >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mTextureNames[n];
    }

    public TextureType getTextureType(int n) {
        if (n < 0 || n >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mTextures[n];
    }

    public static class BaseProgramBuilder {
        int mConstantCount;
        Type[] mConstants;
        int mInputCount;
        Element[] mInputs;
        int mOutputCount;
        Element[] mOutputs;
        RenderScript mRS;
        String mShader;
        int mTextureCount;
        String[] mTextureNames;
        TextureType[] mTextureTypes;
        Type[] mTextures;

        protected BaseProgramBuilder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mInputs = new Element[8];
            this.mOutputs = new Element[8];
            this.mConstants = new Type[8];
            this.mInputCount = 0;
            this.mOutputCount = 0;
            this.mConstantCount = 0;
            this.mTextureCount = 0;
            this.mTextureTypes = new TextureType[8];
            this.mTextureNames = new String[8];
        }

        public BaseProgramBuilder addConstant(Type type) throws IllegalStateException {
            if (this.mConstantCount >= 8) {
                throw new RSIllegalArgumentException("Max input count exceeded.");
            }
            if (type.getElement().isComplex()) {
                throw new RSIllegalArgumentException("Complex elements not allowed.");
            }
            this.mConstants[this.mConstantCount] = type;
            this.mConstantCount = 1 + this.mConstantCount;
            return this;
        }

        public BaseProgramBuilder addTexture(TextureType textureType) throws IllegalArgumentException {
            this.addTexture(textureType, "Tex" + this.mTextureCount);
            return this;
        }

        public BaseProgramBuilder addTexture(TextureType textureType, String string2) throws IllegalArgumentException {
            if (this.mTextureCount >= 8) {
                throw new IllegalArgumentException("Max texture count exceeded.");
            }
            this.mTextureTypes[this.mTextureCount] = textureType;
            this.mTextureNames[this.mTextureCount] = string2;
            this.mTextureCount = 1 + this.mTextureCount;
            return this;
        }

        public int getCurrentConstantIndex() {
            return -1 + this.mConstantCount;
        }

        public int getCurrentTextureIndex() {
            return -1 + this.mTextureCount;
        }

        protected void initProgram(Program program) {
            program.mInputs = new Element[this.mInputCount];
            System.arraycopy(this.mInputs, 0, program.mInputs, 0, this.mInputCount);
            program.mOutputs = new Element[this.mOutputCount];
            System.arraycopy(this.mOutputs, 0, program.mOutputs, 0, this.mOutputCount);
            program.mConstants = new Type[this.mConstantCount];
            System.arraycopy(this.mConstants, 0, program.mConstants, 0, this.mConstantCount);
            program.mTextureCount = this.mTextureCount;
            program.mTextures = new TextureType[this.mTextureCount];
            System.arraycopy(this.mTextureTypes, 0, program.mTextures, 0, this.mTextureCount);
            program.mTextureNames = new String[this.mTextureCount];
            System.arraycopy(this.mTextureNames, 0, program.mTextureNames, 0, this.mTextureCount);
        }

        /*
         * Unable to fully structure code
         */
        public BaseProgramBuilder setShader(Resources var1_1, int var2_2) {
            var3_3 = var1_1.openRawResource(var2_2);
            try {
                var6_4 = new byte[1024];
                var7_5 = 0;
            }
            catch (Throwable var4_9) {
                try {
                    var3_3.close();
                    throw var4_9;
                }
                catch (IOException var5_10) {
                    throw new Resources.NotFoundException();
                }
            }
            while (true) lbl-1000:
            // 2 sources

            {
                var8_6 = var6_4.length - var7_5;
                if (var8_6 != 0) ** GOTO lbl21
                break;
            }
            {
                block11: {
                    var9_7 = new byte[2 * var6_4.length];
                    System.arraycopy((byte[])var6_4, (int)0, (byte[])var9_7, (int)0, (int)var6_4.length);
                    var6_4 = var9_7;
                    var8_6 = var6_4.length - var7_5;
lbl21:
                    // 2 sources

                    if ((var10_8 = var3_3.read(var6_4, var7_5, var8_6)) > 0) break block11;
                    var3_3.close();
                    this.mShader = new String(var6_4, 0, var7_5, "UTF-8");
                    return this;
                }
                var7_5 += var10_8;
                ** while (true)
            }
            catch (UnsupportedEncodingException var11_11) {
                Log.e("RenderScript shader creation", "Could not decode shader string");
                return this;
            }
        }

        public BaseProgramBuilder setShader(String string2) {
            this.mShader = string2;
            return this;
        }
    }

    static final class ProgramParam
    extends Enum<ProgramParam> {
        private static final /* synthetic */ ProgramParam[] $VALUES;
        public static final /* enum */ ProgramParam CONSTANT;
        public static final /* enum */ ProgramParam INPUT;
        public static final /* enum */ ProgramParam OUTPUT;
        public static final /* enum */ ProgramParam TEXTURE_TYPE;
        int mID;

        static {
            INPUT = new ProgramParam(0);
            OUTPUT = new ProgramParam(1);
            CONSTANT = new ProgramParam(2);
            TEXTURE_TYPE = new ProgramParam(3);
            ProgramParam[] programParamArray = new ProgramParam[]{INPUT, OUTPUT, CONSTANT, TEXTURE_TYPE};
            $VALUES = programParamArray;
        }

        private ProgramParam(int n2) {
            this.mID = n2;
        }

        public static ProgramParam valueOf(String string2) {
            return Enum.valueOf(ProgramParam.class, string2);
        }

        public static ProgramParam[] values() {
            return (ProgramParam[])$VALUES.clone();
        }
    }

    public static final class TextureType
    extends Enum<TextureType> {
        private static final /* synthetic */ TextureType[] $VALUES;
        public static final /* enum */ TextureType TEXTURE_2D = new TextureType(0);
        public static final /* enum */ TextureType TEXTURE_CUBE = new TextureType(1);
        int mID;

        static {
            TextureType[] textureTypeArray = new TextureType[]{TEXTURE_2D, TEXTURE_CUBE};
            $VALUES = textureTypeArray;
        }

        private TextureType(int n2) {
            this.mID = n2;
        }

        public static TextureType valueOf(String string2) {
            return Enum.valueOf(TextureType.class, string2);
        }

        public static TextureType[] values() {
            return (TextureType[])$VALUES.clone();
        }
    }
}

