/*
 * Decompiled with CFR 0.152.
 */
package android.service.fingerprint;

import android.content.ContentResolver;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;

public class FingerprintUtils {
    private static final boolean DEBUG = true;
    private static final String TAG = "FingerprintUtils";

    /*
     * Enabled aggressive block sorting
     */
    public static void addFingerprintIdForUser(int n, ContentResolver contentResolver, int n2) {
        int[] nArray = FingerprintUtils.getFingerprintIdsForUser(contentResolver, n2);
        if (n != 0) {
            int n3 = 0;
            while (true) {
                if (n3 >= nArray.length) {
                    int[] nArray2 = Arrays.copyOf(nArray, 1 + nArray.length);
                    nArray2[nArray.length] = n;
                    Settings.Secure.putStringForUser(contentResolver, "user_fingerprint_ids", Arrays.toString(nArray2), n2);
                    return;
                }
                if (nArray[n3] == n) break;
                ++n3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getFingerprintIdsForUser(ContentResolver contentResolver, int n) {
        String string2 = Settings.Secure.getStringForUser(contentResolver, "user_fingerprint_ids", n);
        int[] nArray = new int[]{};
        if (!TextUtils.isEmpty(string2)) {
            String[] stringArray = string2.replace("[", "").replace("]", "").split(", ");
            nArray = new int[stringArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    nArray[i] = Integer.decode(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    Log.d(TAG, "Error when parsing finger id " + stringArray[i]);
                }
            }
        }
        return nArray;
    }

    public static boolean removeFingerprintIdForUser(int n, ContentResolver contentResolver, int n2) {
        if (n == 0) {
            throw new IllegalStateException("Bad fingerId");
        }
        int[] nArray = FingerprintUtils.getFingerprintIdsForUser(contentResolver, n2);
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n == nArray[i]) continue;
            int n4 = n3 + 1;
            nArray2[n3] = nArray[i];
            n3 = n4;
        }
        if (n3 > 0) {
            Settings.Secure.putStringForUser(contentResolver, "user_fingerprint_ids", Arrays.toString(Arrays.copyOf(nArray2, n3)), n2);
            return true;
        }
        return false;
    }
}

