/*
 * Decompiled with CFR 0.152.
 */
package android.service.trust;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.service.trust.ITrustAgentService;
import android.service.trust.ITrustAgentServiceCallback;
import android.util.Log;
import android.util.Slog;

public class TrustAgentService
extends Service {
    private static final boolean DEBUG = false;
    public static final String KEY_FEATURES = "trust_agent_features";
    private static final int MSG_SET_TRUST_AGENT_FEATURES_ENABLED = 2;
    private static final int MSG_TRUST_TIMEOUT = 3;
    private static final int MSG_UNLOCK_ATTEMPT = 1;
    public static final String SERVICE_INTERFACE = "android.service.trust.TrustAgentService";
    public static final String TRUST_AGENT_META_DATA = "android.service.trust.trustagent";
    private final String TAG = TrustAgentService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    private ITrustAgentServiceCallback mCallback;
    private Handler mHandler;
    private final Object mLock = new Object();
    private boolean mManagingTrust;
    private Runnable mPendingGrantTrustTask;

    public TrustAgentService() {
        this.mHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        TrustAgentService trustAgentService = TrustAgentService.this;
                        boolean bl = message.arg1 != 0;
                        trustAgentService.onUnlockAttempt(bl);
                        return;
                    }
                    case 2: {
                        Bundle bundle = message.peekData();
                        IBinder iBinder = (IBinder)message.obj;
                        boolean bl = TrustAgentService.this.onSetTrustAgentFeaturesEnabled(bundle);
                        try {
                            Object object = TrustAgentService.this.mLock;
                            synchronized (object) {
                            }
                        }
                        catch (RemoteException remoteException) {
                            TrustAgentService.this.onError("calling onSetTrustAgentFeaturesEnabledCompleted()");
                            return;
                        }
                        {
                            TrustAgentService.this.mCallback.onSetTrustAgentFeaturesEnabledCompleted(bl, iBinder);
                            return;
                        }
                    }
                    case 3: 
                }
                TrustAgentService.this.onTrustTimeout();
            }
        };
    }

    static /* synthetic */ ITrustAgentServiceCallback access$102(TrustAgentService trustAgentService, ITrustAgentServiceCallback iTrustAgentServiceCallback) {
        trustAgentService.mCallback = iTrustAgentServiceCallback;
        return iTrustAgentServiceCallback;
    }

    static /* synthetic */ Runnable access$602(TrustAgentService trustAgentService, Runnable runnable) {
        trustAgentService.mPendingGrantTrustTask = runnable;
        return runnable;
    }

    private void onError(String string2) {
        Slog.v(this.TAG, "Remote exception while " + string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void grantTrust(final CharSequence charSequence, final long l, final boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mManagingTrust) {
                throw new IllegalStateException("Cannot grant trust if agent is not managing trust. Call setManagingTrust(true) first.");
            }
            ITrustAgentServiceCallback iTrustAgentServiceCallback = this.mCallback;
            if (iTrustAgentServiceCallback != null) {
                try {
                    this.mCallback.grantTrust(charSequence.toString(), l, bl);
                }
                catch (RemoteException remoteException) {
                    this.onError("calling enableTrust()");
                }
            } else {
                this.mPendingGrantTrustTask = new Runnable(){

                    @Override
                    public void run() {
                        TrustAgentService.this.grantTrust(charSequence, l, bl);
                    }
                };
            }
            return;
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new TrustAgentServiceWrapper();
    }

    @Override
    public void onCreate() {
        super.onCreate();
        ComponentName componentName = new ComponentName((Context)this, this.getClass());
        try {
            if (!"android.permission.BIND_TRUST_AGENT".equals(this.getPackageManager().getServiceInfo((ComponentName)componentName, (int)0).permission)) {
                throw new IllegalStateException(componentName.flattenToShortString() + " is not declared with the permission " + "\"" + "android.permission.BIND_TRUST_AGENT" + "\"");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e(this.TAG, "Can't get ServiceInfo for " + componentName.toShortString());
        }
    }

    public boolean onSetTrustAgentFeaturesEnabled(Bundle bundle) {
        return false;
    }

    public void onTrustTimeout() {
    }

    public void onUnlockAttempt(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void revokeTrust() {
        Object object = this.mLock;
        synchronized (object) {
            ITrustAgentServiceCallback iTrustAgentServiceCallback;
            if (this.mPendingGrantTrustTask != null) {
                this.mPendingGrantTrustTask = null;
            }
            if ((iTrustAgentServiceCallback = this.mCallback) != null) {
                try {
                    this.mCallback.revokeTrust();
                }
                catch (RemoteException remoteException) {
                    this.onError("calling revokeTrust()");
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setManagingTrust(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mManagingTrust != bl) {
                this.mManagingTrust = bl;
                ITrustAgentServiceCallback iTrustAgentServiceCallback = this.mCallback;
                if (iTrustAgentServiceCallback != null) {
                    try {
                        this.mCallback.setManagingTrust(bl);
                    }
                    catch (RemoteException remoteException) {
                        this.onError("calling setManagingTrust()");
                    }
                }
            }
            return;
        }
    }

    private final class TrustAgentServiceWrapper
    extends ITrustAgentService.Stub {
        private TrustAgentServiceWrapper() {
        }

        @Override
        public void onTrustTimeout() {
            TrustAgentService.this.mHandler.sendEmptyMessage(3);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onUnlockAttempt(boolean bl) {
            Handler handler = TrustAgentService.this.mHandler;
            int n = bl ? 1 : 0;
            handler.obtainMessage(1, n, 0).sendToTarget();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setCallback(ITrustAgentServiceCallback iTrustAgentServiceCallback) {
            Object object = TrustAgentService.this.mLock;
            synchronized (object) {
                TrustAgentService.access$102(TrustAgentService.this, iTrustAgentServiceCallback);
                boolean bl = TrustAgentService.this.mManagingTrust;
                if (bl) {
                    try {
                        TrustAgentService.this.mCallback.setManagingTrust(TrustAgentService.this.mManagingTrust);
                    }
                    catch (RemoteException remoteException) {
                        TrustAgentService.this.onError("calling setManagingTrust()");
                    }
                }
                if (TrustAgentService.this.mPendingGrantTrustTask != null) {
                    TrustAgentService.this.mPendingGrantTrustTask.run();
                    TrustAgentService.access$602(TrustAgentService.this, null);
                }
                return;
            }
        }

        @Override
        public void setTrustAgentFeaturesEnabled(Bundle bundle, IBinder iBinder) {
            Message message = TrustAgentService.this.mHandler.obtainMessage(2, iBinder);
            message.setData(bundle);
            message.sendToTarget();
        }
    }
}

