/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.content.Intent;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.KeyphraseEnrollmentInfo;
import android.hardware.soundtrigger.KeyphraseMetadata;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.AudioFormat;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.service.voice.IVoiceInteractionService;
import android.util.Slog;
import com.android.internal.app.IVoiceInteractionManagerService;
import java.io.PrintWriter;
import java.util.Locale;

public class AlwaysOnHotwordDetector {
    static final boolean DBG = false;
    public static final int MANAGE_ACTION_ENROLL = 0;
    public static final int MANAGE_ACTION_RE_ENROLL = 1;
    public static final int MANAGE_ACTION_UN_ENROLL = 2;
    private static final int MSG_AVAILABILITY_CHANGED = 1;
    private static final int MSG_DETECTION_ERROR = 3;
    private static final int MSG_DETECTION_PAUSE = 4;
    private static final int MSG_DETECTION_RESUME = 5;
    private static final int MSG_HOTWORD_DETECTED = 2;
    public static final int RECOGNITION_FLAG_ALLOW_MULTIPLE_TRIGGERS = 2;
    public static final int RECOGNITION_FLAG_CAPTURE_TRIGGER_AUDIO = 1;
    public static final int RECOGNITION_FLAG_NONE = 0;
    public static final int RECOGNITION_MODE_USER_IDENTIFICATION = 2;
    public static final int RECOGNITION_MODE_VOICE_TRIGGER = 1;
    public static final int STATE_HARDWARE_UNAVAILABLE = -2;
    private static final int STATE_INVALID = -3;
    public static final int STATE_KEYPHRASE_ENROLLED = 2;
    public static final int STATE_KEYPHRASE_UNENROLLED = 1;
    public static final int STATE_KEYPHRASE_UNSUPPORTED = -1;
    private static final int STATE_NOT_READY = 0;
    private static final int STATUS_ERROR = Integer.MIN_VALUE;
    private static final int STATUS_OK = 0;
    static final String TAG = "AlwaysOnHotwordDetector";
    private int mAvailability = 0;
    private final Callback mExternalCallback;
    private final Handler mHandler;
    private final SoundTriggerListener mInternalCallback;
    private final KeyphraseEnrollmentInfo mKeyphraseEnrollmentInfo;
    private final KeyphraseMetadata mKeyphraseMetadata;
    private final Locale mLocale;
    private final Object mLock = new Object();
    private final IVoiceInteractionManagerService mModelManagementService;
    private final String mText;
    private final IVoiceInteractionService mVoiceInteractionService;

    public AlwaysOnHotwordDetector(String string2, Locale locale, Callback callback, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo, IVoiceInteractionService iVoiceInteractionService, IVoiceInteractionManagerService iVoiceInteractionManagerService) {
        this.mText = string2;
        this.mLocale = locale;
        this.mKeyphraseEnrollmentInfo = keyphraseEnrollmentInfo;
        this.mKeyphraseMetadata = this.mKeyphraseEnrollmentInfo.getKeyphraseMetadata(string2, locale);
        this.mExternalCallback = callback;
        this.mHandler = new MyHandler();
        this.mInternalCallback = new SoundTriggerListener(this.mHandler);
        this.mVoiceInteractionService = iVoiceInteractionService;
        this.mModelManagementService = iVoiceInteractionManagerService;
        new RefreshAvailabiltyTask().execute(new Void[0]);
    }

    static /* synthetic */ int access$202(AlwaysOnHotwordDetector alwaysOnHotwordDetector, int n) {
        alwaysOnHotwordDetector.mAvailability = n;
        return n;
    }

    private Intent getManageIntentLocked(int n) {
        if (this.mAvailability == -3) {
            throw new IllegalStateException("getManageIntent called on an invalid detector");
        }
        if (this.mAvailability != 2 && this.mAvailability != 1) {
            throw new UnsupportedOperationException("Managing the given keyphrase is not supported");
        }
        return this.mKeyphraseEnrollmentInfo.getManageKeyphraseIntent(n, this.mText, this.mLocale);
    }

    private int getSupportedRecognitionModesLocked() {
        if (this.mAvailability == -3) {
            throw new IllegalStateException("getSupportedRecognitionModes called on an invalid detector");
        }
        if (this.mAvailability != 2 && this.mAvailability != 1) {
            throw new UnsupportedOperationException("Getting supported recognition modes for the keyphrase is not supported");
        }
        return this.mKeyphraseMetadata.recognitionModeFlags;
    }

    private void notifyStateChangedLocked() {
        Message message = Message.obtain(this.mHandler, 1);
        message.arg1 = this.mAvailability;
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int startRecognitionLocked(int n) {
        boolean bl = true;
        SoundTrigger.KeyphraseRecognitionExtra[] keyphraseRecognitionExtraArray = new SoundTrigger.KeyphraseRecognitionExtra[bl];
        keyphraseRecognitionExtraArray[0] = new SoundTrigger.KeyphraseRecognitionExtra(this.mKeyphraseMetadata.id, this.mKeyphraseMetadata.recognitionModeFlags, 0, new SoundTrigger.ConfidenceLevel[0]);
        boolean bl2 = (n & 1) != 0 ? bl : false;
        if ((n & 2) == 0) {
            bl = false;
        }
        int n2 = Integer.MIN_VALUE;
        try {
            int n3;
            n2 = n3 = this.mModelManagementService.startRecognition(this.mVoiceInteractionService, this.mKeyphraseMetadata.id, this.mLocale.toLanguageTag(), this.mInternalCallback, new SoundTrigger.RecognitionConfig(bl2, bl, keyphraseRecognitionExtraArray, null));
        }
        catch (RemoteException remoteException) {
            Slog.w(TAG, "RemoteException in startRecognition!", remoteException);
        }
        if (n2 != 0) {
            Slog.w(TAG, "startRecognition() failed with error code " + n2);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int stopRecognitionLocked() {
        int n = Integer.MIN_VALUE;
        try {
            int n2;
            n = n2 = this.mModelManagementService.stopRecognition(this.mVoiceInteractionService, this.mKeyphraseMetadata.id, this.mInternalCallback);
        }
        catch (RemoteException remoteException) {
            Slog.w(TAG, "RemoteException in stopRecognition!", remoteException);
        }
        if (n != 0) {
            Slog.w(TAG, "stopRecognition() failed with error code " + n);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Intent createEnrollIntent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getManageIntentLocked(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Intent createReEnrollIntent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getManageIntentLocked(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Intent createUnEnrollIntent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getManageIntentLocked(2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(String string2, PrintWriter printWriter) {
        Object object = this.mLock;
        synchronized (object) {
            printWriter.print(string2);
            printWriter.print("Text=");
            printWriter.println(this.mText);
            printWriter.print(string2);
            printWriter.print("Locale=");
            printWriter.println(this.mLocale);
            printWriter.print(string2);
            printWriter.print("Availability=");
            printWriter.println(this.mAvailability);
            printWriter.print(string2);
            printWriter.print("KeyphraseMetadata=");
            printWriter.println(this.mKeyphraseMetadata);
            printWriter.print(string2);
            printWriter.print("EnrollmentInfo=");
            printWriter.println(this.mKeyphraseEnrollmentInfo);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSupportedRecognitionModes() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getSupportedRecognitionModesLocked();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void invalidate() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAvailability = -3;
            this.notifyStateChangedLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onSoundModelsChanged() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailability != -3 && this.mAvailability != -2 && this.mAvailability != -1) {
                this.stopRecognitionLocked();
                new RefreshAvailabiltyTask().execute(new Void[0]);
                return;
            }
            Slog.w(TAG, "Received onSoundModelsChanged for an unsupported keyphrase/config");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startRecognition(int n) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailability == -3) {
                throw new IllegalStateException("startRecognition called on an invalid detector");
            }
            if (this.mAvailability != 2) {
                throw new UnsupportedOperationException("Recognition for the given keyphrase is not supported");
            }
            if (this.startRecognitionLocked(n) != 0) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean stopRecognition() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailability == -3) {
                throw new IllegalStateException("stopRecognition called on an invalid detector");
            }
            if (this.mAvailability != 2) {
                throw new UnsupportedOperationException("Recognition for the given keyphrase is not supported");
            }
            if (this.stopRecognitionLocked() != 0) return false;
            return true;
        }
    }

    public static abstract class Callback {
        public abstract void onAvailabilityChanged(int var1);

        public abstract void onDetected(EventPayload var1);

        public abstract void onError();

        public abstract void onRecognitionPaused();

        public abstract void onRecognitionResumed();
    }

    public static class EventPayload {
        private final AudioFormat mAudioFormat;
        private final boolean mCaptureAvailable;
        private final int mCaptureSession;
        private final byte[] mData;
        private final boolean mTriggerAvailable;

        private EventPayload(boolean bl, boolean bl2, AudioFormat audioFormat, int n, byte[] byArray) {
            this.mTriggerAvailable = bl;
            this.mCaptureAvailable = bl2;
            this.mCaptureSession = n;
            this.mAudioFormat = audioFormat;
            this.mData = byArray;
        }

        public AudioFormat getCaptureAudioFormat() {
            return this.mAudioFormat;
        }

        public Integer getCaptureSession() {
            if (this.mCaptureAvailable) {
                return this.mCaptureSession;
            }
            return null;
        }

        public byte[] getTriggerAudio() {
            if (this.mTriggerAvailable) {
                return this.mData;
            }
            return null;
        }
    }

    class MyHandler
    extends Handler {
        MyHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            Object object = AlwaysOnHotwordDetector.this.mLock;
            synchronized (object) {
                if (AlwaysOnHotwordDetector.this.mAvailability == -3) {
                    Slog.w(AlwaysOnHotwordDetector.TAG, "Received message: " + message.what + " for an invalid detector");
                    return;
                }
            }
            switch (message.what) {
                default: {
                    super.handleMessage(message);
                    return;
                }
                case 1: {
                    AlwaysOnHotwordDetector.this.mExternalCallback.onAvailabilityChanged(message.arg1);
                    return;
                }
                case 2: {
                    AlwaysOnHotwordDetector.this.mExternalCallback.onDetected((EventPayload)message.obj);
                    return;
                }
                case 3: {
                    AlwaysOnHotwordDetector.this.mExternalCallback.onError();
                    return;
                }
                case 4: {
                    AlwaysOnHotwordDetector.this.mExternalCallback.onRecognitionPaused();
                    return;
                }
                case 5: 
            }
            AlwaysOnHotwordDetector.this.mExternalCallback.onRecognitionResumed();
        }
    }

    class RefreshAvailabiltyTask
    extends AsyncTask<Void, Void, Void> {
        RefreshAvailabiltyTask() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int internalGetInitialAvailability() {
            SoundTrigger.ModuleProperties moduleProperties;
            Object object = AlwaysOnHotwordDetector.this.mLock;
            synchronized (object) {
                if (AlwaysOnHotwordDetector.this.mAvailability == -3) {
                    return -3;
                }
            }
            try {
                SoundTrigger.ModuleProperties moduleProperties2;
                moduleProperties = moduleProperties2 = AlwaysOnHotwordDetector.this.mModelManagementService.getDspModuleProperties(AlwaysOnHotwordDetector.this.mVoiceInteractionService);
            }
            catch (RemoteException remoteException) {
                Slog.w(AlwaysOnHotwordDetector.TAG, "RemoteException in getDspProperties!", remoteException);
                return -2;
            }
            if (moduleProperties == null) {
                return -2;
            }
            if (AlwaysOnHotwordDetector.this.mKeyphraseMetadata != null) return 0;
            return -1;
        }

        private boolean internalGetIsEnrolled(int n, Locale locale) {
            try {
                boolean bl = AlwaysOnHotwordDetector.this.mModelManagementService.isEnrolledForKeyphrase(AlwaysOnHotwordDetector.this.mVoiceInteractionService, n, locale.toLanguageTag());
                return bl;
            }
            catch (RemoteException remoteException) {
                Slog.w(AlwaysOnHotwordDetector.TAG, "RemoteException in listRegisteredKeyphraseSoundModels!", remoteException);
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Void doInBackground(Void ... voidArray) {
            int n = this.internalGetInitialAvailability();
            if (n == 0 || n == 1 || n == 2) {
                n = !this.internalGetIsEnrolled(((AlwaysOnHotwordDetector)AlwaysOnHotwordDetector.this).mKeyphraseMetadata.id, AlwaysOnHotwordDetector.this.mLocale) ? 1 : 2;
            }
            Object object = AlwaysOnHotwordDetector.this.mLock;
            synchronized (object) {
                AlwaysOnHotwordDetector.access$202(AlwaysOnHotwordDetector.this, n);
                AlwaysOnHotwordDetector.this.notifyStateChangedLocked();
                return null;
            }
        }
    }

    static final class SoundTriggerListener
    extends IRecognitionStatusCallback.Stub {
        private final Handler mHandler;

        public SoundTriggerListener(Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void onDetected(SoundTrigger.KeyphraseRecognitionEvent keyphraseRecognitionEvent) {
            Slog.i(AlwaysOnHotwordDetector.TAG, "onDetected");
            Message.obtain(this.mHandler, 2, new EventPayload(keyphraseRecognitionEvent.triggerInData, keyphraseRecognitionEvent.captureAvailable, keyphraseRecognitionEvent.captureFormat, keyphraseRecognitionEvent.captureSession, keyphraseRecognitionEvent.data)).sendToTarget();
        }

        @Override
        public void onError(int n) {
            Slog.i(AlwaysOnHotwordDetector.TAG, "onError: " + n);
            this.mHandler.sendEmptyMessage(3);
        }

        @Override
        public void onRecognitionPaused() {
            Slog.i(AlwaysOnHotwordDetector.TAG, "onRecognitionPaused");
            this.mHandler.sendEmptyMessage(4);
        }

        @Override
        public void onRecognitionResumed() {
            Slog.i(AlwaysOnHotwordDetector.TAG, "onRecognitionResumed");
            this.mHandler.sendEmptyMessage(5);
        }
    }
}

