/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.CameraCapabilities;
import android.telecom.Conference;
import android.telecom.ConnectionService;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Connection {
    public static final int CALL_SUBSTATE_AUDIO_CONNECTED_SUSPENDED = 1;
    public static final int CALL_SUBSTATE_AVP_RETRY = 4;
    public static final int CALL_SUBSTATE_MEDIA_PAUSED = 8;
    public static final int CALL_SUBSTATE_NONE = 0;
    public static final int CALL_SUBSTATE_VIDEO_CONNECTED_SUSPENDED = 2;
    private static final boolean PII_DEBUG = false;
    public static final int STATE_ACTIVE = 4;
    public static final int STATE_DIALING = 3;
    public static final int STATE_DISCONNECTED = 6;
    public static final int STATE_HOLDING = 5;
    public static final int STATE_INITIALIZING = 0;
    public static final int STATE_NEW = 1;
    public static final int STATE_RINGING = 2;
    private Uri mAddress;
    private int mAddressPresentation;
    private boolean mAudioModeIsVoip;
    private AudioState mAudioState;
    private int mCallCapabilities;
    private int mCallSubstate;
    private String mCallerDisplayName;
    private int mCallerDisplayNamePresentation;
    private Conference mConference;
    private final List<Connection> mConferenceableConnections;
    private final Listener mConnectionDeathListener = new Listener(){

        @Override
        public void onDestroyed(Connection connection) {
            if (Connection.this.mConferenceableConnections.remove(connection)) {
                Connection.this.fireOnConferenceableConnectionsChanged();
            }
        }
    };
    private ConnectionService mConnectionService;
    private DisconnectCause mDisconnectCause;
    private final Set<Listener> mListeners = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
    private PhoneAccountHandle mPhoneAccountHandle = null;
    private boolean mRingbackRequested = false;
    private int mState = 1;
    private StatusHints mStatusHints;
    private final List<Connection> mUnmodifiableConferenceableConnections;
    private VideoProvider mVideoProvider;
    private int mVideoState;

    static {
        PII_DEBUG = Log.isLoggable(3);
    }

    public Connection() {
        this.mConferenceableConnections = new ArrayList<Connection>();
        this.mUnmodifiableConferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
    }

    private final void clearConferenceableList() {
        Iterator<Connection> iterator = this.mConferenceableConnections.iterator();
        while (iterator.hasNext()) {
            iterator.next().removeConnectionListener(this.mConnectionDeathListener);
        }
        this.mConferenceableConnections.clear();
    }

    public static Connection createCanceledConnection() {
        return new FailureSignalingConnection(new DisconnectCause(4));
    }

    public static Connection createFailedConnection(DisconnectCause disconnectCause) {
        return new FailureSignalingConnection(disconnectCause);
    }

    private final void fireConferenceChanged() {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConferenceChanged(this, this.mConference);
        }
    }

    private final void fireOnConferenceableConnectionsChanged() {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConferenceableConnectionsChanged(this, this.getConferenceableConnections());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setState(int n) {
        if (this.mState == 6 && this.mState != n) {
            Log.d(this, "Connection already DISCONNECTED; cannot transition out of this state.", new Object[0]);
            return;
        } else {
            if (this.mState == n) return;
            Object[] objectArray = new Object[]{Connection.stateToString(n)};
            Log.d(this, "setState: %s", objectArray);
            this.mState = n;
            this.onStateChanged(n);
            Iterator<Listener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onStateChanged(this, n);
            }
        }
    }

    public static String stateToString(int n) {
        switch (n) {
            default: {
                Object[] objectArray = new Object[]{n};
                Log.wtf(Connection.class, "Unknown state %d", objectArray);
                return "UNKNOWN";
            }
            case 0: {
                return "STATE_INITIALIZING";
            }
            case 1: {
                return "STATE_NEW";
            }
            case 2: {
                return "STATE_RINGING";
            }
            case 3: {
                return "STATE_DIALING";
            }
            case 4: {
                return "STATE_ACTIVE";
            }
            case 5: {
                return "STATE_HOLDING";
            }
            case 6: 
        }
        return "DISCONNECTED";
    }

    /*
     * Enabled aggressive block sorting
     */
    static String toLogSafePhoneNumber(String string2) {
        if (string2 == null) {
            return "";
        }
        if (PII_DEBUG) return string2;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c == '-' || c == '@' || c == '.') {
                stringBuilder.append(c);
            } else {
                stringBuilder.append('x');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public final Connection addConnectionListener(Listener listener) {
        this.mListeners.add(listener);
        return this;
    }

    public final void destroy() {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroyed(this);
        }
    }

    public final Uri getAddress() {
        return this.mAddress;
    }

    public final int getAddressPresentation() {
        return this.mAddressPresentation;
    }

    public final boolean getAudioModeIsVoip() {
        return this.mAudioModeIsVoip;
    }

    public final AudioState getAudioState() {
        return this.mAudioState;
    }

    public final int getCallCapabilities() {
        return this.mCallCapabilities;
    }

    public final int getCallSubstate() {
        return this.mCallSubstate;
    }

    public final String getCallerDisplayName() {
        return this.mCallerDisplayName;
    }

    public final int getCallerDisplayNamePresentation() {
        return this.mCallerDisplayNamePresentation;
    }

    public final Conference getConference() {
        return this.mConference;
    }

    public final List<Connection> getConferenceableConnections() {
        return this.mUnmodifiableConferenceableConnections;
    }

    public final ConnectionService getConnectionService() {
        return this.mConnectionService;
    }

    public final DisconnectCause getDisconnectCause() {
        return this.mDisconnectCause;
    }

    public final PhoneAccountHandle getPhoneAccountHandle() {
        return this.mPhoneAccountHandle;
    }

    public final int getState() {
        return this.mState;
    }

    public final StatusHints getStatusHints() {
        return this.mStatusHints;
    }

    public final VideoProvider getVideoProvider() {
        return this.mVideoProvider;
    }

    public final int getVideoState() {
        return this.mVideoState;
    }

    public final boolean isRingbackRequested() {
        return this.mRingbackRequested;
    }

    public void onAbort() {
    }

    public void onAnswer() {
        this.onAnswer(0);
    }

    public void onAnswer(int n) {
    }

    public void onAudioStateChanged(AudioState audioState) {
    }

    public void onConferenceWith(Connection connection) {
    }

    public void onDeflect(String string2) {
    }

    public void onDisconnect() {
    }

    public void onHold() {
    }

    public void onPlayDtmfTone(char c) {
    }

    public void onPostDialContinue(boolean bl) {
    }

    public void onReject() {
    }

    public void onSeparate() {
    }

    public void onStateChanged(int n) {
    }

    public void onStopDtmfTone() {
    }

    public void onUnhold() {
    }

    public final Connection removeConnectionListener(Listener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
        return this;
    }

    public final void resetConference() {
        if (this.mConference != null) {
            Log.d(this, "Conference reset", new Object[0]);
            this.mConference = null;
            this.fireConferenceChanged();
        }
    }

    public final void setActive() {
        this.setRingbackRequested(false);
        this.setState(4);
    }

    public void setActiveSubscription() {
    }

    public final void setAddress(Uri uri, int n) {
        Log.d(this, "setAddress %s", uri);
        this.mAddress = uri;
        this.mAddressPresentation = n;
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onAddressChanged(this, uri, n);
        }
    }

    public final void setAudioModeIsVoip(boolean bl) {
        this.mAudioModeIsVoip = bl;
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onAudioModeIsVoipChanged(this, bl);
        }
    }

    final void setAudioState(AudioState audioState) {
        Log.d(this, "setAudioState %s", audioState);
        this.mAudioState = audioState;
        this.onAudioStateChanged(audioState);
    }

    public final void setCallCapabilities(int n) {
        if (this.mCallCapabilities != n) {
            this.mCallCapabilities = n;
            Iterator<Listener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onCallCapabilitiesChanged(this, this.mCallCapabilities);
            }
        }
    }

    public final void setCallSubstate(int n) {
        Object[] objectArray = new Object[]{n};
        Log.d(this, "setCallSubstate %d", objectArray);
        this.mCallSubstate = n;
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCallSubstateChanged(this, this.mCallSubstate);
        }
    }

    public final void setCallerDisplayName(String string2, int n) {
        Log.d(this, "setCallerDisplayName %s", string2);
        this.mCallerDisplayName = string2;
        this.mCallerDisplayNamePresentation = n;
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCallerDisplayNameChanged(this, string2, n);
        }
    }

    public final boolean setConference(Conference conference) {
        if (this.mConference == null) {
            this.mConference = conference;
            if (this.mConnectionService != null && this.mConnectionService.containsConference(conference)) {
                this.fireConferenceChanged();
            }
            return true;
        }
        return false;
    }

    public final void setConferenceableConnections(List<Connection> list) {
        this.clearConferenceableList();
        for (Connection connection : list) {
            if (this.mConferenceableConnections.contains(connection)) continue;
            connection.addConnectionListener(this.mConnectionDeathListener);
            this.mConferenceableConnections.add(connection);
        }
        this.fireOnConferenceableConnectionsChanged();
    }

    public final void setConnectionService(ConnectionService connectionService) {
        if (this.mConnectionService != null) {
            Log.e(this, (Throwable)new Exception(), "Trying to set ConnectionService on a connection which is already associated with another ConnectionService.", new Object[0]);
            return;
        }
        this.mConnectionService = connectionService;
    }

    public final void setDialing() {
        this.setState(3);
    }

    public final void setDisconnected(DisconnectCause disconnectCause) {
        this.mDisconnectCause = disconnectCause;
        this.setState(6);
        Log.d(this, "Disconnected with cause %s", disconnectCause);
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDisconnected(this, disconnectCause);
        }
    }

    public final void setInitialized() {
        this.setState(1);
    }

    public final void setInitializing() {
        this.setState(0);
    }

    public void setLocalCallHold(int n) {
    }

    public final void setOnHold() {
        this.setState(5);
    }

    public final void setPhoneAccountHandle(PhoneAccountHandle phoneAccountHandle) {
        this.mPhoneAccountHandle = phoneAccountHandle;
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onPhoneAccountChanged(this, phoneAccountHandle);
        }
    }

    public final void setPostDialWait(String string2) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onPostDialWait(this, string2);
        }
    }

    public final void setRingbackRequested(boolean bl) {
        if (this.mRingbackRequested != bl) {
            this.mRingbackRequested = bl;
            Iterator<Listener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onRingbackRequested(this, bl);
            }
        }
    }

    public final void setRinging() {
        this.setState(2);
    }

    public final void setSsNotificationData(int n, int n2) {
        Log.d(this, "setSsNotificationData = " + n + " " + n2, new Object[0]);
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onSsNotificationData(n, n2);
        }
    }

    public final void setStatusHints(StatusHints statusHints) {
        this.mStatusHints = statusHints;
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onStatusHintsChanged(this, statusHints);
        }
    }

    public final void setVideoProvider(VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onVideoProviderChanged(this, videoProvider);
        }
    }

    public final void setVideoState(int n) {
        Object[] objectArray = new Object[]{n};
        Log.d(this, "setVideoState %d", objectArray);
        this.mVideoState = n;
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onVideoStateChanged(this, this.mVideoState);
        }
    }

    public final void unsetConnectionService(ConnectionService connectionService) {
        if (this.mConnectionService != connectionService) {
            Log.e(this, (Throwable)new Exception(), "Trying to remove ConnectionService from a Connection that does not belong to the ConnectionService.", new Object[0]);
            return;
        }
        this.mConnectionService = null;
    }

    private static class FailureSignalingConnection
    extends Connection {
        public FailureSignalingConnection(DisconnectCause disconnectCause) {
            this.setDisconnected(disconnectCause);
        }
    }

    public static abstract class Listener {
        public void onAddressChanged(Connection connection, Uri uri, int n) {
        }

        public void onAudioModeIsVoipChanged(Connection connection, boolean bl) {
        }

        public void onCallCapabilitiesChanged(Connection connection, int n) {
        }

        public void onCallSubstateChanged(Connection connection, int n) {
        }

        public void onCallerDisplayNameChanged(Connection connection, String string2, int n) {
        }

        public void onConferenceChanged(Connection connection, Conference conference) {
        }

        public void onConferenceableConnectionsChanged(Connection connection, List<Connection> list) {
        }

        public void onDestroyed(Connection connection) {
        }

        public void onDisconnected(Connection connection, DisconnectCause disconnectCause) {
        }

        public void onPhoneAccountChanged(Connection connection, PhoneAccountHandle phoneAccountHandle) {
        }

        public void onPostDialWait(Connection connection, String string2) {
        }

        public void onRingbackRequested(Connection connection, boolean bl) {
        }

        public void onSsNotificationData(int n, int n2) {
        }

        public void onStateChanged(Connection connection, int n) {
        }

        public void onStatusHintsChanged(Connection connection, StatusHints statusHints) {
        }

        public void onVideoProviderChanged(Connection connection, VideoProvider videoProvider) {
        }

        public void onVideoStateChanged(Connection connection, int n) {
        }
    }

    public static abstract class VideoProvider {
        private static final int MSG_REQUEST_CALL_DATA_USAGE = 10;
        private static final int MSG_REQUEST_CAMERA_CAPABILITIES = 9;
        private static final int MSG_SEND_SESSION_MODIFY_REQUEST = 7;
        private static final int MSG_SEND_SESSION_MODIFY_RESPONSE = 8;
        private static final int MSG_SET_CAMERA = 2;
        private static final int MSG_SET_DEVICE_ORIENTATION = 5;
        private static final int MSG_SET_DISPLAY_SURFACE = 4;
        private static final int MSG_SET_PAUSE_IMAGE = 11;
        private static final int MSG_SET_PREVIEW_SURFACE = 3;
        private static final int MSG_SET_VIDEO_CALLBACK = 1;
        private static final int MSG_SET_ZOOM = 6;
        public static final int SESSION_EVENT_CAMERA_FAILURE = 5;
        public static final int SESSION_EVENT_CAMERA_READY = 6;
        public static final int SESSION_EVENT_RX_PAUSE = 1;
        public static final int SESSION_EVENT_RX_RESUME = 2;
        public static final int SESSION_EVENT_TX_START = 3;
        public static final int SESSION_EVENT_TX_STOP = 4;
        public static final int SESSION_MODIFY_REQUEST_FAIL = 2;
        public static final int SESSION_MODIFY_REQUEST_INVALID = 3;
        public static final int SESSION_MODIFY_REQUEST_SUCCESS = 1;
        public static final int SESSION_MODIFY_REQUEST_TIMED_OUT = 4;
        private final VideoProviderBinder mBinder;
        private final VideoProviderHandler mMessageHandler = new VideoProviderHandler();
        private IVideoCallback mVideoCallback;

        public VideoProvider() {
            this.mBinder = new VideoProviderBinder();
        }

        static /* synthetic */ IVideoCallback access$102(VideoProvider videoProvider, IVideoCallback iVideoCallback) {
            videoProvider.mVideoCallback = iVideoCallback;
            return iVideoCallback;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void changeCallDataUsage(long l) {
            if (this.mVideoCallback == null) return;
            try {
                this.mVideoCallback.changeCallDataUsage(l);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void changeCameraCapabilities(CameraCapabilities cameraCapabilities) {
            if (this.mVideoCallback == null) return;
            try {
                this.mVideoCallback.changeCameraCapabilities(cameraCapabilities);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void changePeerDimensions(int n, int n2) {
            if (this.mVideoCallback == null) return;
            try {
                this.mVideoCallback.changePeerDimensions(n, n2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void changeVideoQuality(int n) {
            if (this.mVideoCallback == null) return;
            try {
                this.mVideoCallback.changeVideoQuality(n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public final IVideoProvider getInterface() {
            return this.mBinder;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleCallSessionEvent(int n) {
            if (this.mVideoCallback == null) return;
            try {
                this.mVideoCallback.handleCallSessionEvent(n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public abstract void onRequestCallDataUsage();

        public abstract void onRequestCameraCapabilities();

        public abstract void onSendSessionModifyRequest(VideoProfile var1);

        public abstract void onSendSessionModifyResponse(VideoProfile var1);

        public abstract void onSetCamera(String var1);

        public abstract void onSetDeviceOrientation(int var1);

        public abstract void onSetDisplaySurface(Surface var1);

        public abstract void onSetPauseImage(String var1);

        public abstract void onSetPreviewSurface(Surface var1);

        public abstract void onSetZoom(float var1);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void receiveSessionModifyRequest(VideoProfile videoProfile) {
            if (this.mVideoCallback == null) return;
            try {
                this.mVideoCallback.receiveSessionModifyRequest(videoProfile);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void receiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
            if (this.mVideoCallback == null) return;
            try {
                this.mVideoCallback.receiveSessionModifyResponse(n, videoProfile, videoProfile2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        private final class VideoProviderBinder
        extends IVideoProvider.Stub {
            private VideoProviderBinder() {
            }

            @Override
            public void requestCallDataUsage() {
                VideoProvider.this.mMessageHandler.obtainMessage(10).sendToTarget();
            }

            @Override
            public void requestCameraCapabilities() {
                VideoProvider.this.mMessageHandler.obtainMessage(9).sendToTarget();
            }

            @Override
            public void sendSessionModifyRequest(VideoProfile videoProfile) {
                VideoProvider.this.mMessageHandler.obtainMessage(7, videoProfile).sendToTarget();
            }

            @Override
            public void sendSessionModifyResponse(VideoProfile videoProfile) {
                VideoProvider.this.mMessageHandler.obtainMessage(8, videoProfile).sendToTarget();
            }

            @Override
            public void setCamera(String string2) {
                VideoProvider.this.mMessageHandler.obtainMessage(2, string2).sendToTarget();
            }

            @Override
            public void setDeviceOrientation(int n) {
                VideoProvider.this.mMessageHandler.obtainMessage(5, n, 0).sendToTarget();
            }

            @Override
            public void setDisplaySurface(Surface surface) {
                VideoProvider.this.mMessageHandler.obtainMessage(4, surface).sendToTarget();
            }

            @Override
            public void setPauseImage(String string2) {
                VideoProvider.this.mMessageHandler.obtainMessage(11, string2).sendToTarget();
            }

            @Override
            public void setPreviewSurface(Surface surface) {
                VideoProvider.this.mMessageHandler.obtainMessage(3, surface).sendToTarget();
            }

            @Override
            public void setVideoCallback(IBinder iBinder) {
                VideoProvider.this.mMessageHandler.obtainMessage(1, iBinder).sendToTarget();
            }

            @Override
            public void setZoom(float f) {
                VideoProvider.this.mMessageHandler.obtainMessage(6, Float.valueOf(f)).sendToTarget();
            }
        }

        private final class VideoProviderHandler
        extends Handler {
            private VideoProviderHandler() {
            }

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        VideoProvider.access$102(VideoProvider.this, IVideoCallback.Stub.asInterface((IBinder)message.obj));
                        return;
                    }
                    case 2: {
                        VideoProvider.this.onSetCamera((String)message.obj);
                        return;
                    }
                    case 3: {
                        VideoProvider.this.onSetPreviewSurface((Surface)message.obj);
                        return;
                    }
                    case 4: {
                        VideoProvider.this.onSetDisplaySurface((Surface)message.obj);
                        return;
                    }
                    case 5: {
                        VideoProvider.this.onSetDeviceOrientation(message.arg1);
                        return;
                    }
                    case 6: {
                        VideoProvider.this.onSetZoom(((Float)message.obj).floatValue());
                        return;
                    }
                    case 7: {
                        VideoProvider.this.onSendSessionModifyRequest((VideoProfile)message.obj);
                        return;
                    }
                    case 8: {
                        VideoProvider.this.onSendSessionModifyResponse((VideoProfile)message.obj);
                        return;
                    }
                    case 9: {
                        VideoProvider.this.onRequestCameraCapabilities();
                        return;
                    }
                    case 10: {
                        VideoProvider.this.onRequestCallDataUsage();
                        return;
                    }
                    case 11: 
                }
                VideoProvider.this.onSetPauseImage((String)message.obj);
            }
        }
    }
}

