/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.telecom.AsusTouchPalInfo;
import android.telecom.AudioState;
import android.telecom.CameraCapabilities;
import android.telecom.InCallAdapter;
import android.telecom.ParcelableCall;
import android.telecom.Phone;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IInCallAdapter;
import com.android.internal.telecom.IInCallService;

public abstract class InCallService
extends Service {
    private static final int MSG_ADD_CALL = 2;
    private static final int MSG_BRING_TO_FOREGROUND = 6;
    private static final int MSG_ON_AUDIO_STATE_CHANGED = 5;
    private static final int MSG_SET_IN_CALL_ADAPTER = 1;
    private static final int MSG_SET_POST_DIAL_WAIT = 4;
    private static final int MSG_UPDATE_CALL = 3;
    private static final int MSG_UPDATE_TOUCH_PAL_INFO = 7;
    public static final String SERVICE_INTERFACE = "android.telecom.InCallService";
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            int n = 1;
            if (InCallService.this.mPhone == null && message.what != n) {
                return;
            }
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    InCallService.access$002(InCallService.this, new Phone(new InCallAdapter((IInCallAdapter)message.obj)));
                    InCallService.this.onPhoneCreated(InCallService.this.mPhone);
                    return;
                }
                case 2: {
                    InCallService.this.mPhone.internalAddCall((ParcelableCall)message.obj);
                    return;
                }
                case 3: {
                    InCallService.this.mPhone.internalUpdateCall((ParcelableCall)message.obj);
                    return;
                }
                case 4: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    try {
                        String string2 = (String)someArgs.arg1;
                        String string3 = (String)someArgs.arg2;
                        InCallService.this.mPhone.internalSetPostDialWait(string2, string3);
                        return;
                    }
                    finally {
                        someArgs.recycle();
                    }
                }
                case 5: {
                    InCallService.this.mPhone.internalAudioStateChanged((AudioState)message.obj);
                    return;
                }
                case 6: {
                    Phone phone = InCallService.this.mPhone;
                    if (message.arg1 != n) {
                        n = 0;
                    }
                    phone.internalBringToForeground(n != 0);
                    return;
                }
                case 7: 
            }
            InCallService.this.mPhone.internalTouchPalInfoUpdate((AsusTouchPalInfo)message.obj);
        }
    };
    private Phone mPhone;

    static /* synthetic */ Phone access$002(InCallService inCallService, Phone phone) {
        inCallService.mPhone = phone;
        return phone;
    }

    public Phone getPhone() {
        return this.mPhone;
    }

    @Override
    public IBinder onBind(Intent intent) {
        return new InCallServiceBinder();
    }

    public void onPhoneCreated(Phone phone) {
    }

    public void onPhoneDestroyed(Phone phone) {
    }

    @Override
    public boolean onUnbind(Intent intent) {
        if (this.mPhone != null) {
            Phone phone = this.mPhone;
            this.mPhone = null;
            phone.destroy();
            this.onPhoneDestroyed(phone);
        }
        return false;
    }

    private final class InCallServiceBinder
    extends IInCallService.Stub {
        private InCallServiceBinder() {
        }

        @Override
        public void addCall(ParcelableCall parcelableCall) {
            InCallService.this.mHandler.obtainMessage(2, parcelableCall).sendToTarget();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void bringToForeground(boolean bl) {
            Handler handler = InCallService.this.mHandler;
            int n = bl ? 1 : 0;
            handler.obtainMessage(6, n, 0).sendToTarget();
        }

        @Override
        public void onAudioStateChanged(AudioState audioState) {
            InCallService.this.mHandler.obtainMessage(5, audioState).sendToTarget();
        }

        @Override
        public void onTouchPalInfoUpdate(AsusTouchPalInfo asusTouchPalInfo) {
            InCallService.this.mHandler.obtainMessage(7, asusTouchPalInfo).sendToTarget();
        }

        @Override
        public void setInCallAdapter(IInCallAdapter iInCallAdapter) {
            InCallService.this.mHandler.obtainMessage(1, iInCallAdapter).sendToTarget();
        }

        @Override
        public void setPostDial(String string2, String string3) {
        }

        @Override
        public void setPostDialWait(String string2, String string3) {
            SomeArgs someArgs = SomeArgs.obtain();
            someArgs.arg1 = string2;
            someArgs.arg2 = string3;
            InCallService.this.mHandler.obtainMessage(4, someArgs).sendToTarget();
        }

        @Override
        public void updateCall(ParcelableCall parcelableCall) {
            InCallService.this.mHandler.obtainMessage(3, parcelableCall).sendToTarget();
        }
    }

    public static abstract class VideoCall {
        public abstract void requestCallDataUsage();

        public abstract void requestCameraCapabilities();

        public abstract void sendSessionModifyRequest(VideoProfile var1);

        public abstract void sendSessionModifyResponse(VideoProfile var1);

        public abstract void setCamera(String var1);

        public abstract void setDeviceOrientation(int var1);

        public abstract void setDisplaySurface(Surface var1);

        public abstract void setPauseImage(String var1);

        public abstract void setPreviewSurface(Surface var1);

        public abstract void setVideoCallListener(Listener var1);

        public abstract void setZoom(float var1);

        public static abstract class Listener {
            public abstract void onCallDataUsageChanged(long var1);

            public abstract void onCallSessionEvent(int var1);

            public abstract void onCameraCapabilitiesChanged(CameraCapabilities var1);

            public abstract void onPeerDimensionsChanged(int var1, int var2);

            public abstract void onSessionModifyRequestReceived(VideoProfile var1);

            public abstract void onSessionModifyResponseReceived(int var1, VideoProfile var2, VideoProfile var3);

            public abstract void onVideoQualityChanged(int var1);
        }
    }
}

