/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.telecom.AsusTouchPalInfo;
import android.telecom.AudioState;
import android.telecom.Call;
import android.telecom.InCallAdapter;
import android.telecom.Log;
import android.telecom.ParcelableCall;
import android.util.ArrayMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Phone {
    private AudioState mAudioState;
    private final Map<String, Call> mCallByTelecomCallId = new ArrayMap<String, Call>();
    private final List<Call> mCalls = new CopyOnWriteArrayList<Call>();
    private final InCallAdapter mInCallAdapter;
    private final List<Listener> mListeners;
    private final List<Call> mUnmodifiableCalls = Collections.unmodifiableList(this.mCalls);

    Phone(InCallAdapter inCallAdapter) {
        this.mListeners = new CopyOnWriteArrayList<Listener>();
        this.mInCallAdapter = inCallAdapter;
    }

    private void checkCallTree(ParcelableCall parcelableCall) {
        if (parcelableCall.getParentCallId() != null && !this.mCallByTelecomCallId.containsKey(parcelableCall.getParentCallId())) {
            Object[] objectArray = new Object[]{parcelableCall.getId(), parcelableCall.getParentCallId()};
            Log.wtf((Object)this, "ParcelableCall %s has nonexistent parent %s", objectArray);
        }
        if (parcelableCall.getChildCallIds() != null) {
            for (int i = 0; i < parcelableCall.getChildCallIds().size(); ++i) {
                if (this.mCallByTelecomCallId.containsKey(parcelableCall.getChildCallIds().get(i))) continue;
                Object[] objectArray = new Object[]{parcelableCall.getId(), parcelableCall.getChildCallIds().get(i)};
                Log.wtf((Object)this, "ParcelableCall %s has nonexistent child %s", objectArray);
            }
        }
    }

    private void fireAudioStateChanged(AudioState audioState) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onAudioStateChanged(this, audioState);
        }
    }

    private void fireBringToForeground(boolean bl) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onBringToForeground(this, bl);
        }
    }

    private void fireCallAdded(Call call) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCallAdded(this, call);
        }
    }

    private void fireCallRemoved(Call call) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCallRemoved(this, call);
        }
    }

    private void fireTouchPalInfoUpdate(AsusTouchPalInfo asusTouchPalInfo) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onTouchPalInfoUpdate(this, asusTouchPalInfo);
        }
    }

    public final void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    final void destroy() {
        for (Call call : this.mCalls) {
            if (call.getState() == 7) continue;
            call.internalSetDisconnected();
        }
    }

    public final AudioState getAudioState() {
        return this.mAudioState;
    }

    public final List<Call> getCalls() {
        return this.mUnmodifiableCalls;
    }

    final void internalAddCall(ParcelableCall parcelableCall) {
        Call call = new Call(this, parcelableCall.getId(), this.mInCallAdapter, parcelableCall.mIsActiveSub);
        this.mCallByTelecomCallId.put(parcelableCall.getId(), call);
        this.mCalls.add(call);
        this.checkCallTree(parcelableCall);
        call.internalUpdate(parcelableCall, this.mCallByTelecomCallId);
        this.fireCallAdded(call);
    }

    final void internalAudioStateChanged(AudioState audioState) {
        if (!Objects.equals(this.mAudioState, audioState)) {
            this.mAudioState = audioState;
            this.fireAudioStateChanged(audioState);
        }
    }

    final void internalBringToForeground(boolean bl) {
        this.fireBringToForeground(bl);
    }

    final Call internalGetCallByTelecomId(String string2) {
        return this.mCallByTelecomCallId.get(string2);
    }

    final void internalRemoveCall(Call call) {
        this.mCallByTelecomCallId.remove(call.internalGetCallId());
        this.mCalls.remove(call);
        this.fireCallRemoved(call);
    }

    final void internalSetPostDialWait(String string2, String string3) {
        Call call = this.mCallByTelecomCallId.get(string2);
        if (call != null) {
            call.internalSetPostDialWait(string3);
        }
    }

    final void internalTouchPalInfoUpdate(AsusTouchPalInfo asusTouchPalInfo) {
        this.fireTouchPalInfoUpdate(asusTouchPalInfo);
    }

    final void internalUpdateCall(ParcelableCall parcelableCall) {
        Call call = this.mCallByTelecomCallId.get(parcelableCall.getId());
        if (call != null) {
            this.checkCallTree(parcelableCall);
            call.internalUpdate(parcelableCall, this.mCallByTelecomCallId);
        }
    }

    public final void pokeUserActivity() {
        this.mInCallAdapter.pokeUserActivity();
    }

    public final void removeListener(Listener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public final void restartRing() {
        this.mInCallAdapter.restartRing();
    }

    public final void setAudioRoute(int n) {
        this.mInCallAdapter.setAudioRoute(n);
    }

    public final void setMuted(boolean bl) {
        this.mInCallAdapter.mute(bl);
    }

    public final void setProximitySensorOff(boolean bl) {
        this.mInCallAdapter.turnProximitySensorOff(bl);
    }

    public final void setProximitySensorOn() {
        this.mInCallAdapter.turnProximitySensorOn();
    }

    public final void silenceRing() {
        this.mInCallAdapter.silenceRing();
    }

    public final void startOrUpdateInCallTimeout() {
        this.mInCallAdapter.startOrUpdateInCallTimeout();
    }

    public void switchToOtherActiveSub(String string2, boolean bl) {
        this.mInCallAdapter.switchToOtherActiveSub(string2, bl);
    }

    public static abstract class Listener {
        public void onAudioStateChanged(Phone phone, AudioState audioState) {
        }

        public void onBringToForeground(Phone phone, boolean bl) {
        }

        public void onCallAdded(Phone phone, Call call) {
        }

        public void onCallRemoved(Phone phone, Call call) {
        }

        public void onTouchPalInfoUpdate(Phone phone, AsusTouchPalInfo asusTouchPalInfo) {
        }
    }
}

