/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.Connection;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.RemoteConnection;
import com.android.internal.telecom.IConnectionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public final class RemoteConference {
    private int mCallCapabilities;
    private final Set<Callback> mCallbacks = new CopyOnWriteArraySet<Callback>();
    private final List<RemoteConnection> mChildConnections = new CopyOnWriteArrayList<RemoteConnection>();
    private final List<RemoteConnection> mConferenceableConnections;
    private final IConnectionService mConnectionService;
    private DisconnectCause mDisconnectCause;
    private final String mId;
    private int mState = 1;
    private final List<RemoteConnection> mUnmodifiableChildConnections = Collections.unmodifiableList(this.mChildConnections);
    private final List<RemoteConnection> mUnmodifiableConferenceableConnections;

    RemoteConference(String string2, IConnectionService iConnectionService) {
        this.mConferenceableConnections = new ArrayList<RemoteConnection>();
        this.mUnmodifiableConferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mId = string2;
        this.mConnectionService = iConnectionService;
    }

    void addConnection(RemoteConnection remoteConnection) {
        if (!this.mChildConnections.contains(remoteConnection)) {
            this.mChildConnections.add(remoteConnection);
            remoteConnection.setConference(this);
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onConnectionAdded(this, remoteConnection);
            }
        }
    }

    public void disconnect() {
        try {
            this.mConnectionService.disconnect(this.mId);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final int getCallCapabilities() {
        return this.mCallCapabilities;
    }

    public List<RemoteConnection> getConferenceableConnections() {
        return this.mUnmodifiableConferenceableConnections;
    }

    public final List<RemoteConnection> getConnections() {
        return this.mUnmodifiableChildConnections;
    }

    public DisconnectCause getDisconnectCause() {
        return this.mDisconnectCause;
    }

    String getId() {
        return this.mId;
    }

    public final int getState() {
        return this.mState;
    }

    public void hold() {
        try {
            this.mConnectionService.hold(this.mId);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void merge() {
        try {
            this.mConnectionService.mergeConference(this.mId);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void playDtmfTone(char c) {
        try {
            this.mConnectionService.playDtmfTone(this.mId, c);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final void registerCallback(Callback callback) {
        this.mCallbacks.add(callback);
    }

    void removeConnection(RemoteConnection remoteConnection) {
        if (this.mChildConnections.contains(remoteConnection)) {
            this.mChildConnections.remove(remoteConnection);
            remoteConnection.setConference(null);
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onConnectionRemoved(this, remoteConnection);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void separate(RemoteConnection remoteConnection) {
        if (!this.mChildConnections.contains(remoteConnection)) return;
        try {
            this.mConnectionService.splitFromConference(remoteConnection.getId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setAudioState(AudioState audioState) {
        try {
            this.mConnectionService.onAudioStateChanged(this.mId, audioState);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    void setCallCapabilities(int n) {
        if (this.mCallCapabilities != n) {
            this.mCallCapabilities = n;
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onCapabilitiesChanged(this, this.mCallCapabilities);
            }
        }
    }

    void setConferenceableConnections(List<RemoteConnection> list) {
        this.mConferenceableConnections.clear();
        this.mConferenceableConnections.addAll(list);
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConferenceableConnectionsChanged(this, this.mUnmodifiableConferenceableConnections);
        }
    }

    void setDestroyed() {
        Iterator<RemoteConnection> iterator = this.mChildConnections.iterator();
        while (iterator.hasNext()) {
            iterator.next().setConference(null);
        }
        Iterator<Callback> iterator2 = this.mCallbacks.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onDestroyed(this);
        }
    }

    void setDisconnected(DisconnectCause disconnectCause) {
        if (this.mState != 6) {
            this.mDisconnectCause = disconnectCause;
            this.setState(6);
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDisconnected(this, disconnectCause);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setState(int n) {
        if (n != 4 && n != 5 && n != 6) {
            Object[] objectArray = new Object[]{Connection.stateToString(n)};
            Log.w(this, "Unsupported state transition for Conference call.", objectArray);
            return;
        } else {
            if (this.mState == n) return;
            int n2 = this.mState;
            this.mState = n;
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onStateChanged(this, n2, n);
            }
        }
    }

    public void stopDtmfTone() {
        try {
            this.mConnectionService.stopDtmfTone(this.mId);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void swap() {
        try {
            this.mConnectionService.swapConference(this.mId);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void unhold() {
        try {
            this.mConnectionService.unhold(this.mId);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final void unregisterCallback(Callback callback) {
        this.mCallbacks.remove(callback);
    }

    public static abstract class Callback {
        public void onCapabilitiesChanged(RemoteConference remoteConference, int n) {
        }

        public void onConferenceableConnectionsChanged(RemoteConference remoteConference, List<RemoteConnection> list) {
        }

        public void onConnectionAdded(RemoteConference remoteConference, RemoteConnection remoteConnection) {
        }

        public void onConnectionRemoved(RemoteConference remoteConference, RemoteConnection remoteConnection) {
        }

        public void onDestroyed(RemoteConference remoteConference) {
        }

        public void onDisconnected(RemoteConference remoteConference, DisconnectCause disconnectCause) {
        }

        public void onStateChanged(RemoteConference remoteConference, int n, int n2) {
        }
    }
}

