/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.CameraCapabilities;
import android.telecom.ConnectionRequest;
import android.telecom.DisconnectCause;
import android.telecom.PhoneAccountHandle;
import android.telecom.RemoteConference;
import android.telecom.StatusHints;
import android.telecom.VideoCallbackServant;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.telecom.IConnectionService;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class RemoteConnection {
    private Uri mAddress;
    private int mAddressPresentation;
    private int mCallCapabilities;
    private int mCallSubstate;
    private final Set<Callback> mCallbacks = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
    private String mCallerDisplayName;
    private int mCallerDisplayNamePresentation;
    private RemoteConference mConference;
    private final List<RemoteConnection> mConferenceableConnections = new ArrayList<RemoteConnection>();
    private boolean mConnected;
    private final String mConnectionId;
    private IConnectionService mConnectionService;
    private DisconnectCause mDisconnectCause;
    private boolean mIsVoipAudioMode;
    private boolean mRingbackRequested;
    private int mState = 1;
    private StatusHints mStatusHints;
    private final List<RemoteConnection> mUnmodifiableconferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
    private VideoProvider mVideoProvider;
    private int mVideoState;

    RemoteConnection(DisconnectCause disconnectCause) {
        this("NULL", null, null);
        this.mConnected = false;
        this.mState = 6;
        this.mDisconnectCause = disconnectCause;
    }

    RemoteConnection(String string2, IConnectionService iConnectionService, ConnectionRequest connectionRequest) {
        this.mConnectionId = string2;
        this.mConnectionService = iConnectionService;
        this.mConnected = true;
        this.mState = 0;
    }

    public static RemoteConnection failure(DisconnectCause disconnectCause) {
        return new RemoteConnection(disconnectCause);
    }

    public void abort() {
        try {
            if (this.mConnected) {
                this.mConnectionService.abort(this.mConnectionId);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void answer() {
        try {
            if (this.mConnected) {
                this.mConnectionService.answer(this.mConnectionId);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void answer(int n) {
        try {
            if (this.mConnected) {
                this.mConnectionService.answerVideo(this.mConnectionId, n);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void disconnect() {
        try {
            if (this.mConnected) {
                this.mConnectionService.disconnect(this.mConnectionId);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public Uri getAddress() {
        return this.mAddress;
    }

    public int getAddressPresentation() {
        return this.mAddressPresentation;
    }

    public int getCallCapabilities() {
        return this.mCallCapabilities;
    }

    public int getCallSubstate() {
        return this.mCallSubstate;
    }

    public CharSequence getCallerDisplayName() {
        return this.mCallerDisplayName;
    }

    public int getCallerDisplayNamePresentation() {
        return this.mCallerDisplayNamePresentation;
    }

    public RemoteConference getConference() {
        return this.mConference;
    }

    public List<RemoteConnection> getConferenceableConnections() {
        return this.mUnmodifiableconferenceableConnections;
    }

    IConnectionService getConnectionService() {
        return this.mConnectionService;
    }

    public DisconnectCause getDisconnectCause() {
        return this.mDisconnectCause;
    }

    String getId() {
        return this.mConnectionId;
    }

    public int getState() {
        return this.mState;
    }

    public StatusHints getStatusHints() {
        return this.mStatusHints;
    }

    public final VideoProvider getVideoProvider() {
        return this.mVideoProvider;
    }

    public int getVideoState() {
        return this.mVideoState;
    }

    public void hold() {
        try {
            if (this.mConnected) {
                this.mConnectionService.hold(this.mConnectionId);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean isRingbackRequested() {
        return false;
    }

    public boolean isVoipAudioMode() {
        return this.mIsVoipAudioMode;
    }

    public void playDtmfTone(char c) {
        try {
            if (this.mConnected) {
                this.mConnectionService.playDtmfTone(this.mConnectionId, c);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void postDialContinue(boolean bl) {
        try {
            if (this.mConnected) {
                this.mConnectionService.onPostDialContinue(this.mConnectionId, bl);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void registerCallback(Callback callback) {
        this.mCallbacks.add(callback);
    }

    public void reject() {
        try {
            if (this.mConnected) {
                this.mConnectionService.reject(this.mConnectionId);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    void setAddress(Uri uri, int n) {
        this.mAddress = uri;
        this.mAddressPresentation = n;
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onAddressChanged(this, uri, n);
        }
    }

    public void setAudioState(AudioState audioState) {
        try {
            if (this.mConnected) {
                this.mConnectionService.onAudioStateChanged(this.mConnectionId, audioState);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    void setCallCapabilities(int n) {
        this.mCallCapabilities = n;
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCallCapabilitiesChanged(this, n);
        }
    }

    void setCallSubstate(int n) {
        this.mCallSubstate = n;
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCallSubstateChanged(this, n);
        }
    }

    void setCallerDisplayName(String string2, int n) {
        this.mCallerDisplayName = string2;
        this.mCallerDisplayNamePresentation = n;
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCallerDisplayNameChanged(this, string2, n);
        }
    }

    void setConference(RemoteConference remoteConference) {
        if (this.mConference != remoteConference) {
            this.mConference = remoteConference;
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onConferenceChanged(this, remoteConference);
            }
        }
    }

    void setConferenceableConnections(List<RemoteConnection> list) {
        this.mConferenceableConnections.clear();
        this.mConferenceableConnections.addAll(list);
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConferenceableConnectionsChanged(this, this.mUnmodifiableconferenceableConnections);
        }
    }

    void setDestroyed() {
        if (!this.mCallbacks.isEmpty()) {
            if (this.mState != 6) {
                this.setDisconnected(new DisconnectCause(1, "Connection destroyed."));
            }
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDestroyed(this);
            }
            this.mCallbacks.clear();
            this.mConnected = false;
        }
    }

    void setDisconnected(DisconnectCause disconnectCause) {
        if (this.mState != 6) {
            this.mState = 6;
            this.mDisconnectCause = disconnectCause;
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDisconnected(this, this.mDisconnectCause);
            }
        }
    }

    public void setDisconnectedWithSsNotification(int n, String string2, int n2, int n3) {
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().setDisconnectedWithSsNotification(this, n, string2, n2, n3);
        }
    }

    void setIsVoipAudioMode(boolean bl) {
        this.mIsVoipAudioMode = bl;
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onVoipAudioChanged(this, bl);
        }
    }

    void setPhoneAccountHandle(PhoneAccountHandle phoneAccountHandle) {
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().setPhoneAccountHandle(this, phoneAccountHandle);
        }
    }

    void setPostDialWait(String string2) {
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onPostDialWait(this, string2);
        }
    }

    void setRingbackRequested(boolean bl) {
        if (this.mRingbackRequested != bl) {
            this.mRingbackRequested = bl;
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onRingbackRequested(this, bl);
            }
        }
    }

    void setState(int n) {
        if (this.mState != n) {
            this.mState = n;
            Iterator<Callback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onStateChanged(this, n);
            }
        }
    }

    void setStatusHints(StatusHints statusHints) {
        this.mStatusHints = statusHints;
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onStatusHintsChanged(this, statusHints);
        }
    }

    void setVideoProvider(VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onVideoProviderChanged(this, videoProvider);
        }
    }

    void setVideoState(int n) {
        this.mVideoState = n;
        Iterator<Callback> iterator = this.mCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().onVideoStateChanged(this, n);
        }
    }

    public void stopDtmfTone() {
        try {
            if (this.mConnected) {
                this.mConnectionService.stopDtmfTone(this.mConnectionId);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void unhold() {
        try {
            if (this.mConnected) {
                this.mConnectionService.unhold(this.mConnectionId);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void unregisterCallback(Callback callback) {
        if (callback != null) {
            this.mCallbacks.remove(callback);
        }
    }

    public static abstract class Callback {
        public void onAddressChanged(RemoteConnection remoteConnection, Uri uri, int n) {
        }

        public void onCallCapabilitiesChanged(RemoteConnection remoteConnection, int n) {
        }

        public void onCallSubstateChanged(RemoteConnection remoteConnection, int n) {
        }

        public void onCallerDisplayNameChanged(RemoteConnection remoteConnection, String string2, int n) {
        }

        public void onConferenceChanged(RemoteConnection remoteConnection, RemoteConference remoteConference) {
        }

        public void onConferenceableConnectionsChanged(RemoteConnection remoteConnection, List<RemoteConnection> list) {
        }

        public void onDestroyed(RemoteConnection remoteConnection) {
        }

        public void onDisconnected(RemoteConnection remoteConnection, DisconnectCause disconnectCause) {
        }

        public void onPostDialWait(RemoteConnection remoteConnection, String string2) {
        }

        public void onRingbackRequested(RemoteConnection remoteConnection, boolean bl) {
        }

        public void onStateChanged(RemoteConnection remoteConnection, int n) {
        }

        public void onStatusHintsChanged(RemoteConnection remoteConnection, StatusHints statusHints) {
        }

        public void onVideoProviderChanged(RemoteConnection remoteConnection, VideoProvider videoProvider) {
        }

        public void onVideoStateChanged(RemoteConnection remoteConnection, int n) {
        }

        public void onVoipAudioChanged(RemoteConnection remoteConnection, boolean bl) {
        }

        public void setDisconnectedWithSsNotification(RemoteConnection remoteConnection, int n, String string2, int n2, int n3) {
        }

        public void setPhoneAccountHandle(RemoteConnection remoteConnection, PhoneAccountHandle phoneAccountHandle) {
        }
    }

    public static class VideoProvider {
        private final Set<Listener> mListeners;
        private final IVideoCallback mVideoCallbackDelegate = new IVideoCallback(){

            @Override
            public IBinder asBinder() {
                return null;
            }

            @Override
            public void changeCallDataUsage(long l) {
                Iterator iterator = VideoProvider.this.mListeners.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onCallDataUsageChanged(VideoProvider.this, l);
                }
            }

            @Override
            public void changeCameraCapabilities(CameraCapabilities cameraCapabilities) {
                Iterator iterator = VideoProvider.this.mListeners.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onCameraCapabilitiesChanged(VideoProvider.this, cameraCapabilities);
                }
            }

            @Override
            public void changePeerDimensions(int n, int n2) {
                Iterator iterator = VideoProvider.this.mListeners.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onPeerDimensionsChanged(VideoProvider.this, n, n2);
                }
            }

            @Override
            public void changeVideoQuality(int n) {
                Iterator iterator = VideoProvider.this.mListeners.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onVideoQualityChanged(VideoProvider.this, n);
                }
            }

            @Override
            public void handleCallSessionEvent(int n) {
                Iterator iterator = VideoProvider.this.mListeners.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onHandleCallSessionEvent(VideoProvider.this, n);
                }
            }

            @Override
            public void receiveSessionModifyRequest(VideoProfile videoProfile) {
                Iterator iterator = VideoProvider.this.mListeners.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onReceiveSessionModifyRequest(VideoProvider.this, videoProfile);
                }
            }

            @Override
            public void receiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
                Iterator iterator = VideoProvider.this.mListeners.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onReceiveSessionModifyResponse(VideoProvider.this, n, videoProfile, videoProfile2);
                }
            }
        };
        private final VideoCallbackServant mVideoCallbackServant = new VideoCallbackServant(this.mVideoCallbackDelegate);
        private final IVideoProvider mVideoProviderBinder;

        public VideoProvider(IVideoProvider iVideoProvider) {
            this.mListeners = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
            this.mVideoProviderBinder = iVideoProvider;
            try {
                this.mVideoProviderBinder.setVideoCallback(this.mVideoCallbackServant.getStub().asBinder());
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void addListener(Listener listener) {
            this.mListeners.add(listener);
        }

        public void removeListener(Listener listener) {
            this.mListeners.remove(listener);
        }

        public void requestCallDataUsage() {
            try {
                this.mVideoProviderBinder.requestCallDataUsage();
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void requestCameraCapabilities() {
            try {
                this.mVideoProviderBinder.requestCameraCapabilities();
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void sendSessionModifyRequest(VideoProfile videoProfile) {
            try {
                this.mVideoProviderBinder.sendSessionModifyRequest(videoProfile);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void sendSessionModifyResponse(VideoProfile videoProfile) {
            try {
                this.mVideoProviderBinder.sendSessionModifyResponse(videoProfile);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void setCamera(String string2) {
            try {
                this.mVideoProviderBinder.setCamera(string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void setDeviceOrientation(int n) {
            try {
                this.mVideoProviderBinder.setDeviceOrientation(n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void setDisplaySurface(Surface surface) {
            try {
                this.mVideoProviderBinder.setDisplaySurface(surface);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void setPauseImage(String string2) {
            try {
                this.mVideoProviderBinder.setPauseImage(string2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void setPreviewSurface(Surface surface) {
            try {
                this.mVideoProviderBinder.setPreviewSurface(surface);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public void setZoom(float f) {
            try {
                this.mVideoProviderBinder.setZoom(f);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public static abstract class Listener {
            public void onCallDataUsageChanged(VideoProvider videoProvider, long l) {
            }

            public void onCameraCapabilitiesChanged(VideoProvider videoProvider, CameraCapabilities cameraCapabilities) {
            }

            public void onHandleCallSessionEvent(VideoProvider videoProvider, int n) {
            }

            public void onPeerDimensionsChanged(VideoProvider videoProvider, int n, int n2) {
            }

            public void onReceiveSessionModifyRequest(VideoProvider videoProvider, VideoProfile videoProfile) {
            }

            public void onReceiveSessionModifyResponse(VideoProvider videoProvider, int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
            }

            public void onVideoQualityChanged(VideoProvider videoProvider, int n) {
            }
        }
    }
}

