/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionService;
import android.telecom.ConnectionServiceAdapterServant;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.RemoteConference;
import android.telecom.RemoteConnection;
import android.telecom.StatusHints;
import com.android.internal.telecom.IConnectionService;
import com.android.internal.telecom.IConnectionServiceAdapter;
import com.android.internal.telecom.IVideoProvider;
import com.android.internal.telecom.RemoteServiceCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

final class RemoteConnectionService {
    private static final RemoteConference NULL_CONFERENCE;
    private static final RemoteConnection NULL_CONNECTION;
    private final Map<String, RemoteConference> mConferenceById;
    private final Map<String, RemoteConnection> mConnectionById;
    private final IBinder.DeathRecipient mDeathRecipient;
    private final ConnectionService mOurConnectionServiceImpl;
    private final IConnectionService mOutgoingConnectionServiceRpc;
    private final Set<RemoteConnection> mPendingConnections;
    private final ConnectionServiceAdapterServant mServant;
    private final IConnectionServiceAdapter mServantDelegate = new IConnectionServiceAdapter(){

        @Override
        public void addConferenceCall(final String string2, ParcelableConference parcelableConference) {
            RemoteConference remoteConference = new RemoteConference(string2, RemoteConnectionService.this.mOutgoingConnectionServiceRpc);
            for (String string3 : parcelableConference.getConnectionIds()) {
                RemoteConnection remoteConnection = (RemoteConnection)RemoteConnectionService.this.mConnectionById.get(string3);
                if (remoteConnection == null) continue;
                remoteConference.addConnection(remoteConnection);
            }
            if (remoteConference.getConnections().size() == 0) {
                return;
            }
            remoteConference.setState(parcelableConference.getState());
            remoteConference.setCallCapabilities(parcelableConference.getCapabilities());
            RemoteConnectionService.this.mConferenceById.put(string2, remoteConference);
            remoteConference.registerCallback(new RemoteConference.Callback(){

                @Override
                public void onDestroyed(RemoteConference remoteConference) {
                    RemoteConnectionService.this.mConferenceById.remove(string2);
                    RemoteConnectionService.this.maybeDisconnectAdapter();
                }
            });
            RemoteConnectionService.this.mOurConnectionServiceImpl.addRemoteConference(remoteConference);
        }

        @Override
        public IBinder asBinder() {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleCreateConnectionComplete(String string2, ConnectionRequest connectionRequest, ParcelableConnection parcelableConnection) {
            RemoteConnection remoteConnection = RemoteConnectionService.this.findConnectionForAction(string2, "handleCreateConnectionSuccessful");
            if (remoteConnection != NULL_CONNECTION && RemoteConnectionService.this.mPendingConnections.contains(remoteConnection)) {
                RemoteConnectionService.this.mPendingConnections.remove(remoteConnection);
                remoteConnection.setCallCapabilities(parcelableConnection.getCapabilities());
                remoteConnection.setAddress(parcelableConnection.getHandle(), parcelableConnection.getHandlePresentation());
                remoteConnection.setCallerDisplayName(parcelableConnection.getCallerDisplayName(), parcelableConnection.getCallerDisplayNamePresentation());
                if (parcelableConnection.getState() == 6) {
                    remoteConnection.setDisconnected(parcelableConnection.getDisconnectCause());
                } else {
                    remoteConnection.setState(parcelableConnection.getState());
                }
                ArrayList<RemoteConnection> arrayList = new ArrayList<RemoteConnection>();
                for (String string3 : parcelableConnection.getConferenceableConnectionIds()) {
                    if (!RemoteConnectionService.this.mConnectionById.containsKey(string3)) continue;
                    arrayList.add((RemoteConnection)RemoteConnectionService.this.mConnectionById.get(string3));
                }
                remoteConnection.setConferenceableConnections(arrayList);
                remoteConnection.setVideoState(parcelableConnection.getVideoState());
                remoteConnection.setCallSubstate(parcelableConnection.getCallSubstate());
                if (remoteConnection.getState() == 6) {
                    remoteConnection.setDestroyed();
                }
            }
        }

        @Override
        public void onPostDialWait(String string2, String string3) {
            RemoteConnectionService.this.findConnectionForAction(string2, "onPostDialWait").setPostDialWait(string3);
        }

        @Override
        public void queryRemoteConnectionServices(RemoteServiceCallback remoteServiceCallback) {
        }

        @Override
        public void removeCall(String string2) {
            if (RemoteConnectionService.this.mConnectionById.containsKey(string2)) {
                RemoteConnectionService.this.findConnectionForAction(string2, "removeCall").setDestroyed();
                return;
            }
            RemoteConnectionService.this.findConferenceForAction(string2, "removeCall").setDestroyed();
        }

        @Override
        public void setActive(String string2) {
            if (RemoteConnectionService.this.mConnectionById.containsKey(string2)) {
                RemoteConnectionService.this.findConnectionForAction(string2, "setActive").setState(4);
                return;
            }
            RemoteConnectionService.this.findConferenceForAction(string2, "setActive").setState(4);
        }

        @Override
        public void setAddress(String string2, Uri uri, int n) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setAddress").setAddress(uri, n);
        }

        @Override
        public void setCallCapabilities(String string2, int n) {
            if (RemoteConnectionService.this.mConnectionById.containsKey(string2)) {
                RemoteConnectionService.this.findConnectionForAction(string2, "setCallCapabilities").setCallCapabilities(n);
                return;
            }
            RemoteConnectionService.this.findConferenceForAction(string2, "setCallCapabilities").setCallCapabilities(n);
        }

        @Override
        public void setCallSubstate(String string2, int n) {
            RemoteConnectionService.this.findConnectionForAction(string2, "callSubstate").setCallSubstate(n);
        }

        @Override
        public void setCallerDisplayName(String string2, String string3, int n) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setCallerDisplayName").setCallerDisplayName(string3, n);
        }

        @Override
        public final void setConferenceableConnections(String string2, List<String> list) {
            ArrayList<RemoteConnection> arrayList = new ArrayList<RemoteConnection>();
            for (String string3 : list) {
                if (!RemoteConnectionService.this.mConnectionById.containsKey(string3)) continue;
                arrayList.add((RemoteConnection)RemoteConnectionService.this.mConnectionById.get(string3));
            }
            if (RemoteConnectionService.this.hasConnection(string2)) {
                RemoteConnectionService.this.findConnectionForAction(string2, "setConferenceableConnections").setConferenceableConnections(arrayList);
                return;
            }
            RemoteConnectionService.this.findConferenceForAction(string2, "setConferenceableConnections").setConferenceableConnections(arrayList);
        }

        @Override
        public void setDialing(String string2) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setDialing").setState(3);
        }

        @Override
        public void setDisconnected(String string2, DisconnectCause disconnectCause) {
            if (RemoteConnectionService.this.mConnectionById.containsKey(string2)) {
                RemoteConnectionService.this.findConnectionForAction(string2, "setDisconnected").setDisconnected(disconnectCause);
                return;
            }
            RemoteConnectionService.this.findConferenceForAction(string2, "setDisconnected").setDisconnected(disconnectCause);
        }

        @Override
        public void setDisconnectedWithSsNotification(String string2, int n, String string3, int n2, int n3) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setDisconnectedWithSsNotification").setDisconnectedWithSsNotification(n, string3, n2, n3);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setIsConferenced(String string2, String string3) {
            RemoteConnection remoteConnection = RemoteConnectionService.this.findConnectionForAction(string2, "setIsConferenced");
            if (remoteConnection == NULL_CONNECTION) return;
            if (string3 == null) {
                if (remoteConnection.getConference() == null) return;
                remoteConnection.getConference().removeConnection(remoteConnection);
                return;
            }
            RemoteConference remoteConference = RemoteConnectionService.this.findConferenceForAction(string3, "setIsConferenced");
            if (remoteConference == NULL_CONFERENCE) return;
            remoteConference.addConnection(remoteConnection);
        }

        @Override
        public void setIsVoipAudioMode(String string2, boolean bl) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setIsVoipAudioMode").setIsVoipAudioMode(bl);
        }

        @Override
        public void setOnHold(String string2) {
            if (RemoteConnectionService.this.mConnectionById.containsKey(string2)) {
                RemoteConnectionService.this.findConnectionForAction(string2, "setOnHold").setState(5);
                return;
            }
            RemoteConnectionService.this.findConferenceForAction(string2, "setOnHold").setState(5);
        }

        @Override
        public void setPhoneAccountHandle(String string2, PhoneAccountHandle phoneAccountHandle) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setPhoneAccountHandle").setPhoneAccountHandle(phoneAccountHandle);
        }

        @Override
        public void setRingbackRequested(String string2, boolean bl) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setRingbackRequested").setRingbackRequested(bl);
        }

        @Override
        public void setRinging(String string2) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setRinging").setState(2);
        }

        @Override
        public void setStatusHints(String string2, StatusHints statusHints) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setStatusHints").setStatusHints(statusHints);
        }

        @Override
        public void setVideoProvider(String string2, IVideoProvider iVideoProvider) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setVideoProvider").setVideoProvider(new RemoteConnection.VideoProvider(iVideoProvider));
        }

        @Override
        public void setVideoState(String string2, int n) {
            RemoteConnectionService.this.findConnectionForAction(string2, "setVideoState").setVideoState(n);
        }
    };

    static {
        NULL_CONNECTION = new RemoteConnection("NULL", null, null);
        NULL_CONFERENCE = new RemoteConference("NULL", null);
    }

    RemoteConnectionService(IConnectionService iConnectionService, ConnectionService connectionService) throws RemoteException {
        this.mServant = new ConnectionServiceAdapterServant(this.mServantDelegate);
        this.mDeathRecipient = new IBinder.DeathRecipient(){

            @Override
            public void binderDied() {
                Iterator iterator = RemoteConnectionService.this.mConnectionById.values().iterator();
                while (iterator.hasNext()) {
                    ((RemoteConnection)iterator.next()).setDestroyed();
                }
                Iterator iterator2 = RemoteConnectionService.this.mConferenceById.values().iterator();
                while (iterator2.hasNext()) {
                    ((RemoteConference)iterator2.next()).setDestroyed();
                }
                RemoteConnectionService.this.mConnectionById.clear();
                RemoteConnectionService.this.mConferenceById.clear();
                RemoteConnectionService.this.mPendingConnections.clear();
                RemoteConnectionService.this.mOutgoingConnectionServiceRpc.asBinder().unlinkToDeath(RemoteConnectionService.this.mDeathRecipient, 0);
            }
        };
        this.mConnectionById = new HashMap<String, RemoteConnection>();
        this.mConferenceById = new HashMap<String, RemoteConference>();
        this.mPendingConnections = new HashSet<RemoteConnection>();
        this.mOutgoingConnectionServiceRpc = iConnectionService;
        this.mOutgoingConnectionServiceRpc.asBinder().linkToDeath(this.mDeathRecipient, 0);
        this.mOurConnectionServiceImpl = connectionService;
    }

    private RemoteConference findConferenceForAction(String string2, String string3) {
        if (this.mConferenceById.containsKey(string2)) {
            return this.mConferenceById.get(string2);
        }
        Log.w(this, "%s - Cannot find Conference %s", string3, string2);
        return NULL_CONFERENCE;
    }

    private RemoteConnection findConnectionForAction(String string2, String string3) {
        if (this.mConnectionById.containsKey(string2)) {
            return this.mConnectionById.get(string2);
        }
        Log.w(this, "%s - Cannot find Connection %s", string3, string2);
        return NULL_CONNECTION;
    }

    private boolean hasConnection(String string2) {
        return this.mConnectionById.containsKey(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void maybeDisconnectAdapter() {
        if (!this.mConnectionById.isEmpty() || !this.mConferenceById.isEmpty()) return;
        try {
            this.mOutgoingConnectionServiceRpc.removeConnectionServiceAdapter(this.mServant.getStub());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    final RemoteConnection createRemoteConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest, boolean bl) {
        final String string2 = UUID.randomUUID().toString();
        ConnectionRequest connectionRequest2 = new ConnectionRequest(connectionRequest.getAccountHandle(), connectionRequest.getAddress(), connectionRequest.getExtras(), connectionRequest.getVideoState());
        try {
            if (this.mConnectionById.isEmpty()) {
                this.mOutgoingConnectionServiceRpc.addConnectionServiceAdapter(this.mServant.getStub());
            }
            RemoteConnection remoteConnection = new RemoteConnection(string2, this.mOutgoingConnectionServiceRpc, connectionRequest2);
            this.mPendingConnections.add(remoteConnection);
            this.mConnectionById.put(string2, remoteConnection);
            this.mOutgoingConnectionServiceRpc.createConnection(phoneAccountHandle, string2, connectionRequest2, bl, false);
            remoteConnection.registerCallback(new RemoteConnection.Callback(){

                @Override
                public void onDestroyed(RemoteConnection remoteConnection) {
                    RemoteConnectionService.this.mConnectionById.remove(string2);
                    RemoteConnectionService.this.maybeDisconnectAdapter();
                }
            });
            return remoteConnection;
        }
        catch (RemoteException remoteException) {
            return RemoteConnection.failure(new DisconnectCause(1, remoteException.toString()));
        }
    }

    public String toString() {
        return "[RemoteCS - " + this.mOutgoingConnectionServiceRpc.asBinder().toString() + "]";
    }
}

