/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;
import android.telephony.SignalStrength;

public final class CellSignalStrengthLte
extends CellSignalStrength
implements Parcelable {
    public static final Parcelable.Creator<CellSignalStrengthLte> CREATOR = new Parcelable.Creator<CellSignalStrengthLte>(){

        @Override
        public CellSignalStrengthLte createFromParcel(Parcel parcel) {
            return new CellSignalStrengthLte(parcel);
        }

        public CellSignalStrengthLte[] newArray(int n) {
            return new CellSignalStrengthLte[n];
        }
    };
    private static final boolean DBG = false;
    private static final String LOG_TAG = "CellSignalStrengthLte";
    private int mCqi;
    private int mRsrp;
    private int mRsrq;
    private int mRssnr;
    private int mSignalStrength;
    private int mTimingAdvance;

    public CellSignalStrengthLte() {
        this.setDefaultValues();
    }

    public CellSignalStrengthLte(int n, int n2, int n3, int n4, int n5, int n6) {
        this.initialize(n, n2, n3, n4, n5, n6);
    }

    private CellSignalStrengthLte(Parcel parcel) {
        this.mSignalStrength = parcel.readInt();
        this.mRsrp = -1 * parcel.readInt();
        this.mRsrq = -1 * parcel.readInt();
        this.mRssnr = parcel.readInt();
        this.mCqi = parcel.readInt();
        this.mTimingAdvance = parcel.readInt();
    }

    public CellSignalStrengthLte(CellSignalStrengthLte cellSignalStrengthLte) {
        this.copyFrom(cellSignalStrengthLte);
    }

    private static void log(String string2) {
        Rlog.w(LOG_TAG, string2);
    }

    @Override
    public CellSignalStrengthLte copy() {
        return new CellSignalStrengthLte(this);
    }

    protected void copyFrom(CellSignalStrengthLte cellSignalStrengthLte) {
        this.mSignalStrength = cellSignalStrengthLte.mSignalStrength;
        this.mRsrp = cellSignalStrengthLte.mRsrp;
        this.mRsrq = cellSignalStrengthLte.mRsrq;
        this.mRssnr = cellSignalStrengthLte.mRssnr;
        this.mCqi = cellSignalStrengthLte.mCqi;
        this.mTimingAdvance = cellSignalStrengthLte.mTimingAdvance;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        CellSignalStrengthLte cellSignalStrengthLte;
        block3: {
            try {
                cellSignalStrengthLte = (CellSignalStrengthLte)object;
                if (object != null) break block3;
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        if (this.mSignalStrength == cellSignalStrengthLte.mSignalStrength && this.mRsrp == cellSignalStrengthLte.mRsrp && this.mRsrq == cellSignalStrengthLte.mRsrq && this.mRssnr == cellSignalStrengthLte.mRssnr && this.mCqi == cellSignalStrengthLte.mCqi && this.mTimingAdvance == cellSignalStrengthLte.mTimingAdvance) return true;
        return false;
    }

    @Override
    public int getAsuLevel() {
        int n = this.getDbm();
        if (n <= -140) {
            return 0;
        }
        if (n >= -43) {
            return 97;
        }
        return n + 140;
    }

    @Override
    public int getDbm() {
        return this.mRsrp;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getLevel() {
        int n = this.mRsrp == Integer.MAX_VALUE ? 0 : (this.mRsrp >= -95 ? 4 : (this.mRsrp >= -105 ? 3 : (this.mRsrp >= -115 ? 2 : 1)));
        int n2 = this.mRssnr == Integer.MAX_VALUE ? 0 : (this.mRssnr >= 45 ? 4 : (this.mRssnr >= 10 ? 3 : (this.mRssnr >= -30 ? 2 : 1)));
        if (this.mRsrp == Integer.MAX_VALUE) {
            return n2;
        }
        if (this.mRssnr == Integer.MAX_VALUE) {
            return n;
        }
        if (n2 < n) {
            return n2;
        }
        return n;
    }

    public int getTimingAdvance() {
        return this.mTimingAdvance;
    }

    @Override
    public int hashCode() {
        return 31 * this.mSignalStrength + 31 * this.mRsrp + 31 * this.mRsrq + 31 * this.mRssnr + 31 * this.mCqi + 31 * this.mTimingAdvance;
    }

    public void initialize(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mSignalStrength = n;
        this.mRsrp = n2;
        this.mRsrq = n3;
        this.mRssnr = n4;
        this.mCqi = n5;
        this.mTimingAdvance = n6;
    }

    public void initialize(SignalStrength signalStrength, int n) {
        this.mSignalStrength = signalStrength.getLteSignalStrength();
        this.mRsrp = signalStrength.getLteRsrp();
        this.mRsrq = signalStrength.getLteRsrq();
        this.mRssnr = signalStrength.getLteRssnr();
        this.mCqi = signalStrength.getLteCqi();
        this.mTimingAdvance = n;
    }

    @Override
    public void setDefaultValues() {
        this.mSignalStrength = Integer.MAX_VALUE;
        this.mRsrp = Integer.MAX_VALUE;
        this.mRsrq = Integer.MAX_VALUE;
        this.mRssnr = Integer.MAX_VALUE;
        this.mCqi = Integer.MAX_VALUE;
        this.mTimingAdvance = Integer.MAX_VALUE;
    }

    public String toString() {
        return "CellSignalStrengthLte: ss=" + this.mSignalStrength + " rsrp=" + this.mRsrp + " rsrq=" + this.mRsrq + " rssnr=" + this.mRssnr + " cqi=" + this.mCqi + " ta=" + this.mTimingAdvance;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mSignalStrength);
        parcel.writeInt(-1 * this.mRsrp);
        parcel.writeInt(-1 * this.mRsrq);
        parcel.writeInt(this.mRssnr);
        parcel.writeInt(this.mCqi);
        parcel.writeInt(this.mTimingAdvance);
    }
}

