/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;

public final class CellSignalStrengthWcdma
extends CellSignalStrength
implements Parcelable {
    public static final Parcelable.Creator<CellSignalStrengthWcdma> CREATOR = new Parcelable.Creator<CellSignalStrengthWcdma>(){

        @Override
        public CellSignalStrengthWcdma createFromParcel(Parcel parcel) {
            return new CellSignalStrengthWcdma(parcel);
        }

        public CellSignalStrengthWcdma[] newArray(int n) {
            return new CellSignalStrengthWcdma[n];
        }
    };
    private static final boolean DBG = false;
    private static final String LOG_TAG = "CellSignalStrengthWcdma";
    private static final int WCDMA_SIGNAL_STRENGTH_GOOD = 8;
    private static final int WCDMA_SIGNAL_STRENGTH_GREAT = 12;
    private static final int WCDMA_SIGNAL_STRENGTH_MODERATE = 5;
    private int mBitErrorRate;
    private int mSignalStrength;

    public CellSignalStrengthWcdma() {
        this.setDefaultValues();
    }

    public CellSignalStrengthWcdma(int n, int n2) {
        this.initialize(n, n2);
    }

    private CellSignalStrengthWcdma(Parcel parcel) {
        this.mSignalStrength = parcel.readInt();
        this.mBitErrorRate = parcel.readInt();
    }

    public CellSignalStrengthWcdma(CellSignalStrengthWcdma cellSignalStrengthWcdma) {
        this.copyFrom(cellSignalStrengthWcdma);
    }

    private static void log(String string2) {
        Rlog.w(LOG_TAG, string2);
    }

    @Override
    public CellSignalStrengthWcdma copy() {
        return new CellSignalStrengthWcdma(this);
    }

    protected void copyFrom(CellSignalStrengthWcdma cellSignalStrengthWcdma) {
        this.mSignalStrength = cellSignalStrengthWcdma.mSignalStrength;
        this.mBitErrorRate = cellSignalStrengthWcdma.mBitErrorRate;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        CellSignalStrengthWcdma cellSignalStrengthWcdma;
        block3: {
            try {
                cellSignalStrengthWcdma = (CellSignalStrengthWcdma)object;
                if (object != null) break block3;
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        if (this.mSignalStrength == cellSignalStrengthWcdma.mSignalStrength && this.mBitErrorRate == cellSignalStrengthWcdma.mBitErrorRate) return true;
        return false;
    }

    @Override
    public int getAsuLevel() {
        return this.mSignalStrength;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getDbm() {
        int n = this.mSignalStrength;
        if (n == 99) {
            return Integer.MAX_VALUE;
        }
        int n2 = n;
        if (n2 == Integer.MAX_VALUE) return Integer.MAX_VALUE;
        return -113 + n2 * 2;
    }

    @Override
    public int getLevel() {
        int n = this.mSignalStrength;
        if (n <= 2 || n == 99) {
            return 0;
        }
        if (n >= 12) {
            return 4;
        }
        if (n >= 8) {
            return 3;
        }
        if (n >= 5) {
            return 2;
        }
        return 1;
    }

    @Override
    public int hashCode() {
        return 31 * this.mSignalStrength + 31 * this.mBitErrorRate;
    }

    public void initialize(int n, int n2) {
        this.mSignalStrength = n;
        this.mBitErrorRate = n2;
    }

    @Override
    public void setDefaultValues() {
        this.mSignalStrength = Integer.MAX_VALUE;
        this.mBitErrorRate = Integer.MAX_VALUE;
    }

    public String toString() {
        return "CellSignalStrengthWcdma: ss=" + this.mSignalStrength + " ber=" + this.mBitErrorRate;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mSignalStrength);
        parcel.writeInt(this.mBitErrorRate);
    }
}

