/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.GetChars;
import android.text.Spanned;
import android.text.TextUtils;

public class AlteredCharSequence
implements CharSequence,
GetChars {
    private char[] mChars;
    private int mEnd;
    private CharSequence mSource;
    private int mStart;

    private AlteredCharSequence(CharSequence charSequence, char[] cArray, int n, int n2) {
        this.mSource = charSequence;
        this.mChars = cArray;
        this.mStart = n;
        this.mEnd = n2;
    }

    public static AlteredCharSequence make(CharSequence charSequence, char[] cArray, int n, int n2) {
        if (charSequence instanceof Spanned) {
            return new AlteredSpanned(charSequence, cArray, n, n2);
        }
        return new AlteredCharSequence(charSequence, cArray, n, n2);
    }

    @Override
    public char charAt(int n) {
        if (n >= this.mStart && n < this.mEnd) {
            return this.mChars[n - this.mStart];
        }
        return this.mSource.charAt(n);
    }

    @Override
    public void getChars(int n, int n2, char[] cArray, int n3) {
        TextUtils.getChars(this.mSource, n, n2, cArray, n3);
        int n4 = Math.max(this.mStart, n);
        int n5 = Math.min(this.mEnd, n2);
        if (n4 > n5) {
            System.arraycopy((char[])this.mChars, (int)(n4 - this.mStart), (char[])cArray, (int)n3, (int)(n5 - n4));
        }
    }

    @Override
    public int length() {
        return this.mSource.length();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return AlteredCharSequence.make(this.mSource.subSequence(n, n2), this.mChars, this.mStart - n, this.mEnd - n);
    }

    @Override
    public String toString() {
        int n = this.length();
        char[] cArray = new char[n];
        this.getChars(0, n, cArray, 0);
        return String.valueOf(cArray);
    }

    void update(char[] cArray, int n, int n2) {
        this.mChars = cArray;
        this.mStart = n;
        this.mEnd = n2;
    }

    private static class AlteredSpanned
    extends AlteredCharSequence
    implements Spanned {
        private Spanned mSpanned;

        private AlteredSpanned(CharSequence charSequence, char[] cArray, int n, int n2) {
            super(charSequence, cArray, n, n2);
            this.mSpanned = (Spanned)charSequence;
        }

        @Override
        public int getSpanEnd(Object object) {
            return this.mSpanned.getSpanEnd(object);
        }

        @Override
        public int getSpanFlags(Object object) {
            return this.mSpanned.getSpanFlags(object);
        }

        @Override
        public int getSpanStart(Object object) {
            return this.mSpanned.getSpanStart(object);
        }

        @Override
        public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
            return this.mSpanned.getSpans(n, n2, clazz);
        }

        @Override
        public int nextSpanTransition(int n, int n2, Class clazz) {
            return this.mSpanned.nextSpanTransition(n, n2, clazz);
        }
    }
}

