/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import libcore.util.EmptyArray;

class PackedObjectVector<E> {
    private int mColumns;
    private int mRowGapLength;
    private int mRowGapStart;
    private int mRows;
    private Object[] mValues;

    public PackedObjectVector(int n) {
        this.mColumns = n;
        this.mValues = EmptyArray.OBJECT;
        this.mRows = 0;
        this.mRowGapStart = 0;
        this.mRowGapLength = this.mRows;
    }

    private void growBuffer() {
        Object[] objectArray = ArrayUtils.newUnpaddedObjectArray(GrowingArrayUtils.growSize(this.size()) * this.mColumns);
        int n = objectArray.length / this.mColumns;
        int n2 = this.mRows - (this.mRowGapStart + this.mRowGapLength);
        System.arraycopy(this.mValues, 0, objectArray, 0, this.mColumns * this.mRowGapStart);
        System.arraycopy(this.mValues, (this.mRows - n2) * this.mColumns, objectArray, (n - n2) * this.mColumns, n2 * this.mColumns);
        this.mRowGapLength += n - this.mRows;
        this.mRows = n;
        this.mValues = objectArray;
    }

    private void moveRowGapTo(int n) {
        if (n == this.mRowGapStart) {
            return;
        }
        if (n > this.mRowGapStart) {
            int n2 = n + this.mRowGapLength - (this.mRowGapStart + this.mRowGapLength);
            for (int i = this.mRowGapStart + this.mRowGapLength; i < n2 + (this.mRowGapStart + this.mRowGapLength); ++i) {
                int n3 = i - (this.mRowGapStart + this.mRowGapLength) + this.mRowGapStart;
                for (int j = 0; j < this.mColumns; ++j) {
                    Object object;
                    this.mValues[j + n3 * this.mColumns] = object = this.mValues[j + i * this.mColumns];
                }
            }
        } else {
            int n4 = this.mRowGapStart - n;
            for (int i = -1 + (n + n4); i >= n; --i) {
                int n5 = i - n + this.mRowGapStart + this.mRowGapLength - n4;
                for (int j = 0; j < this.mColumns; ++j) {
                    Object object;
                    this.mValues[j + n5 * this.mColumns] = object = this.mValues[j + i * this.mColumns];
                }
            }
        }
        this.mRowGapStart = n;
    }

    public void deleteAt(int n, int n2) {
        this.moveRowGapTo(n + n2);
        this.mRowGapStart -= n2;
        this.mRowGapLength = n2 + this.mRowGapLength;
        if (this.mRowGapLength > 2 * this.size()) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dump() {
        int n = 0;
        while (true) {
            if (n >= this.mRows) {
                System.out.print("-----\n\n");
                return;
            }
            for (int i = 0; i < this.mColumns; ++i) {
                Object object = this.mValues[i + n * this.mColumns];
                if (n < this.mRowGapStart || n >= this.mRowGapStart + this.mRowGapLength) {
                    System.out.print(object + " ");
                    continue;
                }
                System.out.print("(" + object + ") ");
            }
            System.out.print(" << \n");
            ++n;
        }
    }

    public E getValue(int n, int n2) {
        if (n >= this.mRowGapStart) {
            n += this.mRowGapLength;
        }
        return (E)this.mValues[n2 + n * this.mColumns];
    }

    public void insertAt(int n, E[] EArray) {
        this.moveRowGapTo(n);
        if (this.mRowGapLength == 0) {
            this.growBuffer();
        }
        this.mRowGapStart = 1 + this.mRowGapStart;
        this.mRowGapLength = -1 + this.mRowGapLength;
        if (EArray == null) {
            for (int i = 0; i < this.mColumns; ++i) {
                this.setValue(n, i, null);
            }
        } else {
            for (int i = 0; i < this.mColumns; ++i) {
                this.setValue(n, i, EArray[i]);
            }
        }
    }

    public void setValue(int n, int n2, E e) {
        if (n >= this.mRowGapStart) {
            n += this.mRowGapLength;
        }
        this.mValues[n2 + n * this.mColumns] = e;
    }

    public int size() {
        return this.mRows - this.mRowGapLength;
    }

    public int width() {
        return this.mColumns;
    }
}

