/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.graphics.Rect;
import android.text.Editable;
import android.text.GetChars;
import android.text.Spannable;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.view.View;

public abstract class ReplacementTransformationMethod
implements TransformationMethod {
    protected abstract char[] getOriginal();

    protected abstract char[] getReplacement();

    @Override
    public CharSequence getTransformation(CharSequence charSequence, View view) {
        char[] cArray;
        char[] cArray2;
        block7: {
            cArray2 = this.getOriginal();
            cArray = this.getReplacement();
            if (charSequence instanceof Editable) break block7;
            boolean bl = true;
            int n = cArray2.length;
            int n2 = 0;
            while (true) {
                block9: {
                    block8: {
                        if (n2 >= n) break block8;
                        if (TextUtils.indexOf(charSequence, cArray2[n2]) < 0) break block9;
                        bl = false;
                    }
                    if (!bl) break;
                    return charSequence;
                }
                ++n2;
            }
            if (!(charSequence instanceof Spannable)) {
                if (charSequence instanceof Spanned) {
                    return new SpannedString(new SpannedReplacementCharSequence((Spanned)charSequence, cArray2, cArray));
                }
                return new ReplacementCharSequence(charSequence, cArray2, cArray).toString();
            }
        }
        if (charSequence instanceof Spanned) {
            return new SpannedReplacementCharSequence((Spanned)charSequence, cArray2, cArray);
        }
        return new ReplacementCharSequence(charSequence, cArray2, cArray);
    }

    @Override
    public void onFocusChanged(View view, CharSequence charSequence, boolean bl, int n, Rect rect) {
    }

    private static class ReplacementCharSequence
    implements CharSequence,
    GetChars {
        private char[] mOriginal;
        private char[] mReplacement;
        private CharSequence mSource;

        public ReplacementCharSequence(CharSequence charSequence, char[] cArray, char[] cArray2) {
            this.mSource = charSequence;
            this.mOriginal = cArray;
            this.mReplacement = cArray2;
        }

        @Override
        public char charAt(int n) {
            char c = this.mSource.charAt(n);
            int n2 = this.mOriginal.length;
            for (int i = 0; i < n2; ++i) {
                if (c != this.mOriginal[i]) continue;
                c = this.mReplacement[i];
            }
            return c;
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            TextUtils.getChars(this.mSource, n, n2, cArray, n3);
            int n4 = n3 + (n2 - n);
            int n5 = this.mOriginal.length;
            for (int i = n3; i < n4; ++i) {
                char c = cArray[i];
                for (int j = 0; j < n5; ++j) {
                    if (c != this.mOriginal[j]) continue;
                    cArray[i] = this.mReplacement[j];
                }
            }
        }

        @Override
        public int length() {
            return this.mSource.length();
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            return new String(cArray);
        }

        @Override
        public String toString() {
            char[] cArray = new char[this.length()];
            this.getChars(0, this.length(), cArray, 0);
            return new String(cArray);
        }
    }

    private static class SpannedReplacementCharSequence
    extends ReplacementCharSequence
    implements Spanned {
        private Spanned mSpanned;

        public SpannedReplacementCharSequence(Spanned spanned, char[] cArray, char[] cArray2) {
            super(spanned, cArray, cArray2);
            this.mSpanned = spanned;
        }

        @Override
        public int getSpanEnd(Object object) {
            return this.mSpanned.getSpanEnd(object);
        }

        @Override
        public int getSpanFlags(Object object) {
            return this.mSpanned.getSpanFlags(object);
        }

        @Override
        public int getSpanStart(Object object) {
            return this.mSpanned.getSpanStart(object);
        }

        @Override
        public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
            return this.mSpanned.getSpans(n, n2, clazz);
        }

        @Override
        public int nextSpanTransition(int n, int n2, Class clazz) {
            return this.mSpanned.nextSpanTransition(n, n2, clazz);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new SpannedString(this).subSequence(n, n2);
        }
    }
}

