/*
 * Decompiled with CFR 0.152.
 */
package android.text.util;

public class Rfc822Token {
    private String mAddress;
    private String mComment;
    private String mName;

    public Rfc822Token(String string2, String string3, String string4) {
        this.mName = string2;
        this.mAddress = string3;
        this.mComment = string4;
    }

    public static String quoteComment(String string2) {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '(' || c == ')' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String quoteName(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '\\' || c == '\"') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String quoteNameIfNecessary(String string2) {
        int n = string2.length();
        int n2 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= n) break block3;
                    char c = string2.charAt(n2);
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == ' ' || c >= '0' && c <= '9') break block4;
                    string2 = '\"' + Rfc822Token.quoteName(string2) + '\"';
                }
                return string2;
            }
            ++n2;
        }
    }

    private static boolean stringEquals(String string2, String string3) {
        if (string2 == null) {
            return string3 == null;
        }
        return string2.equals(string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof Rfc822Token)) break block2;
                Rfc822Token rfc822Token = (Rfc822Token)object;
                if (Rfc822Token.stringEquals(this.mName, rfc822Token.mName) && Rfc822Token.stringEquals(this.mAddress, rfc822Token.mAddress) && Rfc822Token.stringEquals(this.mComment, rfc822Token.mComment)) break block3;
            }
            return false;
        }
        return true;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getComment() {
        return this.mComment;
    }

    public String getName() {
        return this.mName;
    }

    public int hashCode() {
        int n = 17;
        if (this.mName != null) {
            n = 527 + this.mName.hashCode();
        }
        if (this.mAddress != null) {
            n = n * 31 + this.mAddress.hashCode();
        }
        if (this.mComment != null) {
            n = n * 31 + this.mComment.hashCode();
        }
        return n;
    }

    public void setAddress(String string2) {
        this.mAddress = string2;
    }

    public void setComment(String string2) {
        this.mComment = string2;
    }

    public void setName(String string2) {
        this.mName = string2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mName != null && this.mName.length() != 0) {
            stringBuilder.append(Rfc822Token.quoteNameIfNecessary(this.mName));
            stringBuilder.append(' ');
        }
        if (this.mComment != null && this.mComment.length() != 0) {
            stringBuilder.append('(');
            stringBuilder.append(Rfc822Token.quoteComment(this.mComment));
            stringBuilder.append(") ");
        }
        if (this.mAddress != null && this.mAddress.length() != 0) {
            stringBuilder.append('<');
            stringBuilder.append(this.mAddress);
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }
}

