/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public final class Scene {
    private Context mContext;
    Runnable mEnterAction;
    Runnable mExitAction;
    private View mLayout;
    private int mLayoutId = -1;
    private ViewGroup mSceneRoot;

    public Scene(ViewGroup viewGroup) {
        this.mSceneRoot = viewGroup;
    }

    private Scene(ViewGroup viewGroup, int n, Context context) {
        this.mContext = context;
        this.mSceneRoot = viewGroup;
        this.mLayoutId = n;
    }

    public Scene(ViewGroup viewGroup, View view) {
        this.mSceneRoot = viewGroup;
        this.mLayout = view;
    }

    @Deprecated
    public Scene(ViewGroup viewGroup, ViewGroup viewGroup2) {
        this.mSceneRoot = viewGroup;
        this.mLayout = viewGroup2;
    }

    static Scene getCurrentScene(View view) {
        return (Scene)view.getTag(16908355);
    }

    public static Scene getSceneForLayout(ViewGroup viewGroup, int n, Context context) {
        Scene scene;
        SparseArray<Scene> sparseArray = (SparseArray<Scene>)viewGroup.getTag(16908356);
        if (sparseArray == null) {
            sparseArray = new SparseArray<Scene>();
            viewGroup.setTagInternal(16908356, sparseArray);
        }
        if ((scene = (Scene)sparseArray.get(n)) != null) {
            return scene;
        }
        Scene scene2 = new Scene(viewGroup, n, context);
        sparseArray.put(n, scene2);
        return scene2;
    }

    static void setCurrentScene(View view, Scene scene) {
        view.setTagInternal(16908355, scene);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void enter() {
        if (this.mLayoutId > 0 || this.mLayout != null) {
            this.getSceneRoot().removeAllViews();
            if (this.mLayoutId > 0) {
                LayoutInflater.from(this.mContext).inflate(this.mLayoutId, this.mSceneRoot);
            } else {
                this.mSceneRoot.addView(this.mLayout);
            }
        }
        if (this.mEnterAction != null) {
            this.mEnterAction.run();
        }
        Scene.setCurrentScene(this.mSceneRoot, this);
    }

    public void exit() {
        if (Scene.getCurrentScene(this.mSceneRoot) == this && this.mExitAction != null) {
            this.mExitAction.run();
        }
    }

    public ViewGroup getSceneRoot() {
        return this.mSceneRoot;
    }

    boolean isCreatedFromLayoutResource() {
        return this.mLayoutId > 0;
    }

    public void setEnterAction(Runnable runnable) {
        this.mEnterAction = runnable;
    }

    public void setExitAction(Runnable runnable) {
        this.mExitAction = runnable;
    }
}

