/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.transition.VisibilityPropagation;
import android.view.ViewGroup;

public class SidePropagation
extends VisibilityPropagation {
    private static final String TAG = "SlidePropagation";
    private float mPropagationSpeed = 3.0f;
    private int mSide = 80;

    private int distance(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        switch (this.mSide) {
            default: {
                return 0;
            }
            case 3: {
                return n7 - n + Math.abs(n4 - n2);
            }
            case 48: {
                return n8 - n2 + Math.abs(n3 - n);
            }
            case 5: {
                return n - n5 + Math.abs(n4 - n2);
            }
            case 80: 
        }
        return n2 - n6 + Math.abs(n3 - n);
    }

    private int getMaxDistance(ViewGroup viewGroup) {
        switch (this.mSide) {
            default: {
                return viewGroup.getHeight();
            }
            case 3: 
            case 5: 
        }
        return viewGroup.getWidth();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getStartDelay(ViewGroup viewGroup, Transition transition2, TransitionValues transitionValues, TransitionValues transitionValues2) {
        int n;
        int n2;
        TransitionValues transitionValues3;
        if (transitionValues == null && transitionValues2 == null) {
            return 0L;
        }
        int n3 = 1;
        Rect rect = transition2.getEpicenter();
        if (transitionValues2 == null || this.getViewVisibility(transitionValues) == 0) {
            transitionValues3 = transitionValues;
            n3 = -1;
        } else {
            transitionValues3 = transitionValues2;
        }
        int n4 = this.getViewX(transitionValues3);
        int n5 = this.getViewY(transitionValues3);
        int[] nArray = new int[2];
        viewGroup.getLocationOnScreen(nArray);
        int n6 = nArray[0] + Math.round(viewGroup.getTranslationX());
        int n7 = nArray[1] + Math.round(viewGroup.getTranslationY());
        int n8 = n6 + viewGroup.getWidth();
        int n9 = n7 + viewGroup.getHeight();
        if (rect != null) {
            n2 = rect.centerX();
            n = rect.centerY();
        } else {
            n2 = (n6 + n8) / 2;
            n = (n7 + n9) / 2;
        }
        float f = (float)this.distance(n4, n5, n2, n, n6, n7, n8, n9) / (float)this.getMaxDistance(viewGroup);
        long l = transition2.getDuration();
        if (l < 0L) {
            l = 300L;
        }
        return Math.round(f * ((float)(l * (long)n3) / this.mPropagationSpeed));
    }

    public void setPropagationSpeed(float f) {
        if (f == 0.0f) {
            throw new IllegalArgumentException("propagationSpeed may not be 0");
        }
        this.mPropagationSpeed = f;
    }

    public void setSide(int n) {
        this.mSide = n;
    }
}

