/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import libcore.util.EmptyArray;

public class SparseLongArray
implements Cloneable {
    private int[] mKeys;
    private int mSize;
    private long[] mValues;

    public SparseLongArray() {
        this(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SparseLongArray(int n) {
        if (n == 0) {
            this.mKeys = EmptyArray.INT;
            this.mValues = EmptyArray.LONG;
        } else {
            this.mValues = ArrayUtils.newUnpaddedLongArray(n);
            this.mKeys = new int[this.mValues.length];
        }
        this.mSize = 0;
    }

    public void append(int n, long l) {
        if (this.mSize != 0 && n <= this.mKeys[-1 + this.mSize]) {
            this.put(n, l);
            return;
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, n);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, l);
        this.mSize = 1 + this.mSize;
    }

    public void clear() {
        this.mSize = 0;
    }

    public SparseLongArray clone() {
        SparseLongArray sparseLongArray = null;
        try {
            sparseLongArray = (SparseLongArray)super.clone();
            sparseLongArray.mKeys = (int[])this.mKeys.clone();
            sparseLongArray.mValues = (long[])this.mValues.clone();
            return sparseLongArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return sparseLongArray;
        }
    }

    public void delete(int n) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 >= 0) {
            this.removeAt(n2);
        }
    }

    public long get(int n) {
        return this.get(n, 0L);
    }

    public long get(int n, long l) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 < 0) {
            return l;
        }
        return this.mValues[n2];
    }

    public int indexOfKey(int n) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
    }

    public int indexOfValue(long l) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != l) continue;
            return i;
        }
        return -1;
    }

    public int keyAt(int n) {
        return this.mKeys[n];
    }

    public void put(int n, long l) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 >= 0) {
            this.mValues[n2] = l;
            return;
        }
        int n3 = ~n2;
        this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, n3, n);
        this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, n3, l);
        this.mSize = 1 + this.mSize;
    }

    public void removeAt(int n) {
        System.arraycopy((int[])this.mKeys, (int)(n + 1), (int[])this.mKeys, (int)n, (int)(this.mSize - (n + 1)));
        System.arraycopy((long[])this.mValues, (int)(n + 1), (long[])this.mValues, (int)n, (int)(this.mSize - (n + 1)));
        this.mSize = -1 + this.mSize;
    }

    public int size() {
        return this.mSize;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(28 * this.mSize);
        stringBuilder.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyAt(i));
            stringBuilder.append('=');
            stringBuilder.append(this.valueAt(i));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public long valueAt(int n) {
        return this.mValues[n];
    }
}

