/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;

public class Gravity {
    public static final int AXIS_CLIP = 8;
    public static final int AXIS_PULL_AFTER = 4;
    public static final int AXIS_PULL_BEFORE = 2;
    public static final int AXIS_SPECIFIED = 1;
    public static final int AXIS_X_SHIFT = 0;
    public static final int AXIS_Y_SHIFT = 4;
    public static final int BOTTOM = 80;
    public static final int CENTER = 17;
    public static final int CENTER_HORIZONTAL = 1;
    public static final int CENTER_VERTICAL = 16;
    public static final int CLIP_HORIZONTAL = 8;
    public static final int CLIP_VERTICAL = 128;
    public static final int DISPLAY_CLIP_HORIZONTAL = 0x1000000;
    public static final int DISPLAY_CLIP_VERTICAL = 0x10000000;
    public static final int END = 0x800005;
    public static final int FILL = 119;
    public static final int FILL_HORIZONTAL = 7;
    public static final int FILL_VERTICAL = 112;
    public static final int HORIZONTAL_GRAVITY_MASK = 7;
    public static final int LEFT = 3;
    public static final int NO_GRAVITY = 0;
    public static final int RELATIVE_HORIZONTAL_GRAVITY_MASK = 0x800007;
    public static final int RELATIVE_LAYOUT_DIRECTION = 0x800000;
    public static final int RIGHT = 5;
    public static final int START = 0x800003;
    public static final int TOP = 48;
    public static final int VERTICAL_GRAVITY_MASK = 112;

    /*
     * Enabled aggressive block sorting
     */
    public static void apply(int n, int n2, int n3, Rect rect, int n4, int n5, Rect rect2) {
        switch (n & 6) {
            default: {
                rect2.left = n4 + rect.left;
                rect2.right = n4 + rect.right;
                break;
            }
            case 0: {
                rect2.left = n4 + (rect.left + (rect.right - rect.left - n2) / 2);
                rect2.right = n2 + rect2.left;
                if ((n & 8) != 8) break;
                if (rect2.left < rect.left) {
                    rect2.left = rect.left;
                }
                if (rect2.right <= rect.right) break;
                rect2.right = rect.right;
                break;
            }
            case 2: {
                rect2.left = n4 + rect.left;
                rect2.right = n2 + rect2.left;
                if ((n & 8) != 8 || rect2.right <= rect.right) break;
                rect2.right = rect.right;
                break;
            }
            case 4: {
                rect2.right = rect.right - n4;
                rect2.left = rect2.right - n2;
                if ((n & 8) != 8 || rect2.left >= rect.left) break;
                rect2.left = rect.left;
            }
        }
        switch (n & 0x60) {
            default: {
                rect2.top = n5 + rect.top;
                rect2.bottom = n5 + rect.bottom;
                return;
            }
            case 0: {
                rect2.top = n5 + (rect.top + (rect.bottom - rect.top - n3) / 2);
                rect2.bottom = n3 + rect2.top;
                if ((n & 0x80) != 128) return;
                if (rect2.top < rect.top) {
                    rect2.top = rect.top;
                }
                if (rect2.bottom <= rect.bottom) return;
                rect2.bottom = rect.bottom;
                return;
            }
            case 32: {
                rect2.top = n5 + rect.top;
                rect2.bottom = n3 + rect2.top;
                if ((n & 0x80) != 128 || rect2.bottom <= rect.bottom) return;
                rect2.bottom = rect.bottom;
                return;
            }
            case 64: {
                rect2.bottom = rect.bottom - n5;
                rect2.top = rect2.bottom - n3;
                if ((n & 0x80) != 128 || rect2.top >= rect.top) return;
                rect2.top = rect.top;
                return;
            }
        }
    }

    public static void apply(int n, int n2, int n3, Rect rect, int n4, int n5, Rect rect2, int n6) {
        Gravity.apply(Gravity.getAbsoluteGravity(n, n6), n2, n3, rect, n4, n5, rect2);
    }

    public static void apply(int n, int n2, int n3, Rect rect, Rect rect2) {
        Gravity.apply(n, n2, n3, rect, 0, 0, rect2);
    }

    public static void apply(int n, int n2, int n3, Rect rect, Rect rect2, int n4) {
        Gravity.apply(Gravity.getAbsoluteGravity(n, n4), n2, n3, rect, 0, 0, rect2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void applyDisplay(int n, Rect rect, Rect rect2) {
        int n2;
        if ((0x10000000 & n) != 0) {
            if (rect2.top < rect.top) {
                rect2.top = rect.top;
            }
            if (rect2.bottom > rect.bottom) {
                rect2.bottom = rect.bottom;
            }
        } else {
            int n3;
            if (rect2.top < rect.top) {
                n3 = rect.top - rect2.top;
            } else {
                int n4 = rect2.bottom;
                int n5 = rect.bottom;
                n3 = 0;
                if (n4 > n5) {
                    n3 = rect.bottom - rect2.bottom;
                }
            }
            if (n3 != 0) {
                if (rect2.height() > rect.bottom - rect.top) {
                    rect2.top = rect.top;
                    rect2.bottom = rect.bottom;
                } else {
                    rect2.top = n3 + rect2.top;
                    rect2.bottom = n3 + rect2.bottom;
                }
            }
        }
        if ((0x1000000 & n) != 0) {
            if (rect2.left < rect.left) {
                rect2.left = rect.left;
            }
            if (rect2.right <= rect.right) return;
            rect2.right = rect.right;
            return;
        }
        if (rect2.left < rect.left) {
            n2 = rect.left - rect2.left;
        } else {
            int n6 = rect2.right;
            int n7 = rect.right;
            n2 = 0;
            if (n6 > n7) {
                n2 = rect.right - rect2.right;
            }
        }
        if (n2 == 0) return;
        if (rect2.width() > rect.right - rect.left) {
            rect2.left = rect.left;
            rect2.right = rect.right;
            return;
        }
        rect2.left = n2 + rect2.left;
        rect2.right = n2 + rect2.right;
    }

    public static void applyDisplay(int n, Rect rect, Rect rect2, int n2) {
        Gravity.applyDisplay(Gravity.getAbsoluteGravity(n, n2), rect, rect2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getAbsoluteGravity(int n, int n2) {
        int n3 = n;
        if ((0x800000 & n3) > 0) {
            if ((n3 & 0x800003) == 0x800003) {
                int n4 = n3 & 0xFF7FFFFC;
                n3 = n2 == 1 ? n4 | 5 : n4 | 3;
            } else if ((n3 & 0x800005) == 0x800005) {
                int n5 = n3 & 0xFF7FFFFA;
                n3 = n2 == 1 ? n5 | 3 : n5 | 5;
            }
            n3 &= 0xFF7FFFFF;
        }
        return n3;
    }

    public static boolean isHorizontal(int n) {
        return n > 0 && (0x800007 & n) != 0;
    }

    public static boolean isVertical(int n) {
        return n > 0 && (n & 0x70) != 0;
    }
}

