/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.SurfaceTexture;
import android.view.HardwareRenderer;
import com.android.internal.util.VirtualRefBasePtr;

final class HardwareLayer {
    private VirtualRefBasePtr mFinalizer;
    private HardwareRenderer mRenderer;

    private HardwareLayer(HardwareRenderer hardwareRenderer, long l) {
        if (hardwareRenderer == null || l == 0L) {
            throw new IllegalArgumentException("Either hardware renderer: " + hardwareRenderer + " or deferredUpdater: " + l + " is invalid");
        }
        this.mRenderer = hardwareRenderer;
        this.mFinalizer = new VirtualRefBasePtr(l);
    }

    static HardwareLayer adoptTextureLayer(HardwareRenderer hardwareRenderer, long l) {
        return new HardwareLayer(hardwareRenderer, l);
    }

    private static native long nGetLayer(long var0);

    private static native int nGetTexName(long var0);

    private static native boolean nPrepare(long var0, int var2, int var3, boolean var4);

    private static native void nSetLayerPaint(long var0, long var2);

    private static native void nSetSurfaceTexture(long var0, SurfaceTexture var2, boolean var3);

    private static native void nSetTransform(long var0, long var2);

    private static native void nUpdateRenderLayer(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native void nUpdateSurfaceTexture(long var0);

    public boolean copyInto(Bitmap bitmap) {
        return this.mRenderer.copyLayerInto(this, bitmap);
    }

    public void destroy() {
        if (!this.isValid()) {
            return;
        }
        this.mRenderer.onLayerDestroyed(this);
        this.mRenderer = null;
        this.mFinalizer.release();
        this.mFinalizer = null;
    }

    public void detachSurfaceTexture() {
        this.mRenderer.detachSurfaceTexture(this.mFinalizer.get());
    }

    public long getDeferredLayerUpdater() {
        return this.mFinalizer.get();
    }

    public long getLayer() {
        return HardwareLayer.nGetLayer(this.mFinalizer.get());
    }

    public boolean isValid() {
        return this.mFinalizer != null && this.mFinalizer.get() != 0L;
    }

    public boolean prepare(int n, int n2, boolean bl) {
        return HardwareLayer.nPrepare(this.mFinalizer.get(), n, n2, bl);
    }

    public void setLayerPaint(Paint paint) {
        HardwareLayer.nSetLayerPaint(this.mFinalizer.get(), paint.mNativePaint);
        this.mRenderer.pushLayerUpdate(this);
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        HardwareLayer.nSetSurfaceTexture(this.mFinalizer.get(), surfaceTexture, false);
        this.mRenderer.pushLayerUpdate(this);
    }

    public void setTransform(Matrix matrix) {
        HardwareLayer.nSetTransform(this.mFinalizer.get(), matrix.native_instance);
        this.mRenderer.pushLayerUpdate(this);
    }

    public void updateSurfaceTexture() {
        HardwareLayer.nUpdateSurfaceTexture(this.mFinalizer.get());
        this.mRenderer.pushLayerUpdate(this);
    }
}

