/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;

public final class PointerIcon
implements Parcelable {
    public static final Parcelable.Creator<PointerIcon> CREATOR;
    public static final int STYLE_ARROW = 1000;
    public static final int STYLE_CUSTOM = -1;
    private static final int STYLE_DEFAULT = 1000;
    public static final int STYLE_NULL = 0;
    private static final int STYLE_OEM_FIRST = 10000;
    public static final int STYLE_SPOT_ANCHOR = 2002;
    public static final int STYLE_SPOT_HOVER = 2000;
    public static final int STYLE_SPOT_TOUCH = 2001;
    private static final String TAG = "PointerIcon";
    private static final PointerIcon gNullIcon;
    private Bitmap mBitmap;
    private float mHotSpotX;
    private float mHotSpotY;
    private final int mStyle;
    private int mSystemIconResourceId;

    static {
        gNullIcon = new PointerIcon(0);
        CREATOR = new Parcelable.Creator<PointerIcon>(){

            @Override
            public PointerIcon createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                if (n == 0) {
                    return PointerIcon.getNullIcon();
                }
                int n2 = parcel.readInt();
                if (n2 != 0) {
                    PointerIcon pointerIcon = new PointerIcon(n);
                    PointerIcon.access$102(pointerIcon, n2);
                    return pointerIcon;
                }
                return PointerIcon.createCustomIcon(Bitmap.CREATOR.createFromParcel(parcel), parcel.readFloat(), parcel.readFloat());
            }

            public PointerIcon[] newArray(int n) {
                return new PointerIcon[n];
            }
        };
    }

    private PointerIcon(int n) {
        this.mStyle = n;
    }

    static /* synthetic */ int access$102(PointerIcon pointerIcon, int n) {
        pointerIcon.mSystemIconResourceId = n;
        return n;
    }

    public static PointerIcon createCustomIcon(Bitmap bitmap, float f, float f2) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        PointerIcon.validateHotSpot(bitmap, f, f2);
        PointerIcon pointerIcon = new PointerIcon(-1);
        pointerIcon.mBitmap = bitmap;
        pointerIcon.mHotSpotX = f;
        pointerIcon.mHotSpotY = f2;
        return pointerIcon;
    }

    public static PointerIcon getDefaultIcon(Context context) {
        return PointerIcon.getSystemIcon(context, 1000);
    }

    public static PointerIcon getNullIcon() {
        return gNullIcon;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PointerIcon getSystemIcon(Context context, int n) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (n == 0) {
            return gNullIcon;
        }
        int n2 = PointerIcon.getSystemIconStyleIndex(n);
        if (n2 == 0) {
            n2 = PointerIcon.getSystemIconStyleIndex(1000);
        }
        TypedArray typedArray = context.obtainStyledAttributes(null, R.styleable.Pointer, 16844043, 0);
        int n3 = typedArray.getResourceId(n2, -1);
        typedArray.recycle();
        if (n3 == -1) {
            Log.w(TAG, "Missing theme resources for pointer icon style " + n);
            if (n != 1000) return PointerIcon.getSystemIcon(context, 1000);
            return gNullIcon;
        }
        PointerIcon pointerIcon = new PointerIcon(n);
        if ((0xFF000000 & n3) == 0x1000000) {
            pointerIcon.mSystemIconResourceId = n3;
            return pointerIcon;
        }
        pointerIcon.loadResource(context, context.getResources(), n3);
        return pointerIcon;
    }

    private static int getSystemIconStyleIndex(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 2000: {
                return 1;
            }
            case 2001: {
                return 2;
            }
            case 2002: 
        }
        return 3;
    }

    public static PointerIcon loadCustomIcon(Resources resources, int n) {
        if (resources == null) {
            throw new IllegalArgumentException("resources must not be null");
        }
        PointerIcon pointerIcon = new PointerIcon(-1);
        pointerIcon.loadResource(null, resources, n);
        return pointerIcon;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadResource(Context context, Resources resources, int n) {
        float f;
        float f2;
        int n2;
        block6: {
            XmlResourceParser xmlResourceParser = resources.getXml(n);
            try {
                XmlUtils.beginDocument(xmlResourceParser, "pointer-icon");
                TypedArray typedArray = resources.obtainAttributes(xmlResourceParser, R.styleable.PointerIcon);
                n2 = typedArray.getResourceId(0, 0);
                f2 = typedArray.getDimension(1, 0.0f);
                f = typedArray.getDimension(2, 0.0f);
                typedArray.recycle();
                if (n2 != 0) break block6;
                throw new IllegalArgumentException("<pointer-icon> is missing bitmap attribute.");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Exception parsing pointer icon resource.", exception);
            }
            finally {
                xmlResourceParser.close();
            }
        }
        Drawable drawable2 = context == null ? resources.getDrawable(n2) : context.getDrawable(n2);
        if (!(drawable2 instanceof BitmapDrawable)) {
            throw new IllegalArgumentException("<pointer-icon> bitmap attribute must refer to a bitmap drawable.");
        }
        this.mBitmap = ((BitmapDrawable)drawable2).getBitmap();
        this.mHotSpotX = f2;
        this.mHotSpotY = f;
    }

    private void throwIfIconIsNotLoaded() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("The icon is not loaded.");
        }
    }

    private static void validateHotSpot(Bitmap bitmap, float f, float f2) {
        if (f < 0.0f || f >= (float)bitmap.getWidth()) {
            throw new IllegalArgumentException("x hotspot lies outside of the bitmap area");
        }
        if (f2 < 0.0f || f2 >= (float)bitmap.getHeight()) {
            throw new IllegalArgumentException("y hotspot lies outside of the bitmap area");
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block6: {
            block5: {
                if (this == object) break block5;
                if (object == null || !(object instanceof PointerIcon)) {
                    return false;
                }
                PointerIcon pointerIcon = (PointerIcon)object;
                if (this.mStyle != pointerIcon.mStyle || this.mSystemIconResourceId != pointerIcon.mSystemIconResourceId) {
                    return false;
                }
                if (this.mSystemIconResourceId == 0 && (this.mBitmap != pointerIcon.mBitmap || this.mHotSpotX != pointerIcon.mHotSpotX || this.mHotSpotY != pointerIcon.mHotSpotY)) break block6;
            }
            return true;
        }
        return false;
    }

    public Bitmap getBitmap() {
        this.throwIfIconIsNotLoaded();
        return this.mBitmap;
    }

    public float getHotSpotX() {
        this.throwIfIconIsNotLoaded();
        return this.mHotSpotX;
    }

    public float getHotSpotY() {
        this.throwIfIconIsNotLoaded();
        return this.mHotSpotY;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public boolean isLoaded() {
        return this.mBitmap != null || this.mStyle == 0;
    }

    public boolean isNullIcon() {
        return this.mStyle == 0;
    }

    public PointerIcon load(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (this.mSystemIconResourceId == 0 || this.mBitmap != null) {
            return this;
        }
        PointerIcon pointerIcon = new PointerIcon(this.mStyle);
        pointerIcon.mSystemIconResourceId = this.mSystemIconResourceId;
        pointerIcon.loadResource(context, context.getResources(), this.mSystemIconResourceId);
        return pointerIcon;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mStyle);
        if (this.mStyle != 0) {
            parcel.writeInt(this.mSystemIconResourceId);
            if (this.mSystemIconResourceId == 0) {
                this.mBitmap.writeToParcel(parcel, n);
                parcel.writeFloat(this.mHotSpotX);
                parcel.writeFloat(this.mHotSpotY);
            }
        }
    }
}

