/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.graphics.Region;
import android.view.View;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ViewTreeObserver {
    private boolean mAlive = true;
    private CopyOnWriteArray<OnComputeInternalInsetsListener> mOnComputeInternalInsetsListeners;
    private ArrayList<OnDrawListener> mOnDrawListeners;
    private CopyOnWriteArrayList<OnGlobalFocusChangeListener> mOnGlobalFocusListeners;
    private CopyOnWriteArray<OnGlobalLayoutListener> mOnGlobalLayoutListeners;
    private CopyOnWriteArray<OnPreDrawListener> mOnPreDrawListeners;
    private CopyOnWriteArray<OnScrollChangedListener> mOnScrollChangedListeners;
    private CopyOnWriteArrayList<OnTouchModeChangeListener> mOnTouchModeChangeListeners;
    private CopyOnWriteArrayList<OnWindowAttachListener> mOnWindowAttachListeners;
    private CopyOnWriteArrayList<OnWindowFocusChangeListener> mOnWindowFocusListeners;

    ViewTreeObserver() {
    }

    private void checkIsAlive() {
        if (!this.mAlive) {
            throw new IllegalStateException("This ViewTreeObserver is not alive, call getViewTreeObserver() again");
        }
    }

    private void kill() {
        this.mAlive = false;
    }

    public void addOnComputeInternalInsetsListener(OnComputeInternalInsetsListener onComputeInternalInsetsListener) {
        this.checkIsAlive();
        if (this.mOnComputeInternalInsetsListeners == null) {
            this.mOnComputeInternalInsetsListeners = new CopyOnWriteArray();
        }
        this.mOnComputeInternalInsetsListeners.add(onComputeInternalInsetsListener);
    }

    public void addOnDrawListener(OnDrawListener onDrawListener) {
        this.checkIsAlive();
        if (this.mOnDrawListeners == null) {
            this.mOnDrawListeners = new ArrayList();
        }
        this.mOnDrawListeners.add(onDrawListener);
    }

    public void addOnGlobalFocusChangeListener(OnGlobalFocusChangeListener onGlobalFocusChangeListener) {
        this.checkIsAlive();
        if (this.mOnGlobalFocusListeners == null) {
            this.mOnGlobalFocusListeners = new CopyOnWriteArrayList();
        }
        this.mOnGlobalFocusListeners.add(onGlobalFocusChangeListener);
    }

    public void addOnGlobalLayoutListener(OnGlobalLayoutListener onGlobalLayoutListener) {
        this.checkIsAlive();
        if (this.mOnGlobalLayoutListeners == null) {
            this.mOnGlobalLayoutListeners = new CopyOnWriteArray();
        }
        this.mOnGlobalLayoutListeners.add(onGlobalLayoutListener);
    }

    public void addOnPreDrawListener(OnPreDrawListener onPreDrawListener) {
        this.checkIsAlive();
        if (this.mOnPreDrawListeners == null) {
            this.mOnPreDrawListeners = new CopyOnWriteArray();
        }
        this.mOnPreDrawListeners.add(onPreDrawListener);
    }

    public void addOnScrollChangedListener(OnScrollChangedListener onScrollChangedListener) {
        this.checkIsAlive();
        if (this.mOnScrollChangedListeners == null) {
            this.mOnScrollChangedListeners = new CopyOnWriteArray();
        }
        this.mOnScrollChangedListeners.add(onScrollChangedListener);
    }

    public void addOnTouchModeChangeListener(OnTouchModeChangeListener onTouchModeChangeListener) {
        this.checkIsAlive();
        if (this.mOnTouchModeChangeListeners == null) {
            this.mOnTouchModeChangeListeners = new CopyOnWriteArrayList();
        }
        this.mOnTouchModeChangeListeners.add(onTouchModeChangeListener);
    }

    public void addOnWindowAttachListener(OnWindowAttachListener onWindowAttachListener) {
        this.checkIsAlive();
        if (this.mOnWindowAttachListeners == null) {
            this.mOnWindowAttachListeners = new CopyOnWriteArrayList();
        }
        this.mOnWindowAttachListeners.add(onWindowAttachListener);
    }

    public void addOnWindowFocusChangeListener(OnWindowFocusChangeListener onWindowFocusChangeListener) {
        this.checkIsAlive();
        if (this.mOnWindowFocusListeners == null) {
            this.mOnWindowFocusListeners = new CopyOnWriteArrayList();
        }
        this.mOnWindowFocusListeners.add(onWindowFocusChangeListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void dispatchOnComputeInternalInsets(InternalInsetsInfo internalInsetsInfo) {
        int n;
        CopyOnWriteArray<OnComputeInternalInsetsListener> copyOnWriteArray = this.mOnComputeInternalInsetsListeners;
        if (copyOnWriteArray == null || copyOnWriteArray.size() <= 0) return;
        CopyOnWriteArray.Access<OnComputeInternalInsetsListener> access = copyOnWriteArray.start();
        try {
            n = access.size();
        }
        catch (Throwable throwable) {
            copyOnWriteArray.end();
            throw throwable;
        }
        for (int i = 0; i < n; ++i) {
            access.get(i).onComputeInternalInsets(internalInsetsInfo);
            continue;
        }
        copyOnWriteArray.end();
        return;
    }

    public final void dispatchOnDraw() {
        if (this.mOnDrawListeners != null) {
            ArrayList<OnDrawListener> arrayList = this.mOnDrawListeners;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                arrayList.get(i).onDraw();
            }
        }
    }

    final void dispatchOnGlobalFocusChange(View view, View view2) {
        CopyOnWriteArrayList<OnGlobalFocusChangeListener> copyOnWriteArrayList = this.mOnGlobalFocusListeners;
        if (copyOnWriteArrayList != null && copyOnWriteArrayList.size() > 0) {
            Iterator<OnGlobalFocusChangeListener> iterator = copyOnWriteArrayList.iterator();
            while (iterator.hasNext()) {
                iterator.next().onGlobalFocusChanged(view, view2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void dispatchOnGlobalLayout() {
        int n;
        CopyOnWriteArray<OnGlobalLayoutListener> copyOnWriteArray = this.mOnGlobalLayoutListeners;
        if (copyOnWriteArray == null || copyOnWriteArray.size() <= 0) return;
        CopyOnWriteArray.Access<OnGlobalLayoutListener> access = copyOnWriteArray.start();
        try {
            n = access.size();
        }
        catch (Throwable throwable) {
            copyOnWriteArray.end();
            throw throwable;
        }
        for (int i = 0; i < n; ++i) {
            access.get(i).onGlobalLayout();
            continue;
        }
        copyOnWriteArray.end();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean dispatchOnPreDraw() {
        CopyOnWriteArray<OnPreDrawListener> copyOnWriteArray = this.mOnPreDrawListeners;
        boolean bl = false;
        if (copyOnWriteArray != null) {
            int n = copyOnWriteArray.size();
            bl = false;
            if (n > 0) {
                boolean bl2;
                int n2;
                CopyOnWriteArray.Access<OnPreDrawListener> access = copyOnWriteArray.start();
                try {
                    n2 = access.size();
                }
                catch (Throwable throwable) {
                    copyOnWriteArray.end();
                    throw throwable;
                }
                for (int i = 0; i < n2; bl |= bl2, ++i) {
                    boolean bl3 = access.get(i).onPreDraw();
                    bl2 = !bl3;
                }
                copyOnWriteArray.end();
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void dispatchOnScrollChanged() {
        int n;
        CopyOnWriteArray<OnScrollChangedListener> copyOnWriteArray = this.mOnScrollChangedListeners;
        if (copyOnWriteArray == null || copyOnWriteArray.size() <= 0) return;
        CopyOnWriteArray.Access<OnScrollChangedListener> access = copyOnWriteArray.start();
        try {
            n = access.size();
        }
        catch (Throwable throwable) {
            copyOnWriteArray.end();
            throw throwable;
        }
        for (int i = 0; i < n; ++i) {
            access.get(i).onScrollChanged();
            continue;
        }
        copyOnWriteArray.end();
        return;
    }

    final void dispatchOnTouchModeChanged(boolean bl) {
        CopyOnWriteArrayList<OnTouchModeChangeListener> copyOnWriteArrayList = this.mOnTouchModeChangeListeners;
        if (copyOnWriteArrayList != null && copyOnWriteArrayList.size() > 0) {
            Iterator<OnTouchModeChangeListener> iterator = copyOnWriteArrayList.iterator();
            while (iterator.hasNext()) {
                iterator.next().onTouchModeChanged(bl);
            }
        }
    }

    final void dispatchOnWindowAttachedChange(boolean bl) {
        CopyOnWriteArrayList<OnWindowAttachListener> copyOnWriteArrayList = this.mOnWindowAttachListeners;
        if (copyOnWriteArrayList != null && copyOnWriteArrayList.size() > 0) {
            for (OnWindowAttachListener onWindowAttachListener : copyOnWriteArrayList) {
                if (bl) {
                    onWindowAttachListener.onWindowAttached();
                    continue;
                }
                onWindowAttachListener.onWindowDetached();
            }
        }
    }

    final void dispatchOnWindowFocusChange(boolean bl) {
        CopyOnWriteArrayList<OnWindowFocusChangeListener> copyOnWriteArrayList = this.mOnWindowFocusListeners;
        if (copyOnWriteArrayList != null && copyOnWriteArrayList.size() > 0) {
            Iterator<OnWindowFocusChangeListener> iterator = copyOnWriteArrayList.iterator();
            while (iterator.hasNext()) {
                iterator.next().onWindowFocusChanged(bl);
            }
        }
    }

    final boolean hasComputeInternalInsetsListeners() {
        CopyOnWriteArray<OnComputeInternalInsetsListener> copyOnWriteArray = this.mOnComputeInternalInsetsListeners;
        return copyOnWriteArray != null && copyOnWriteArray.size() > 0;
    }

    final boolean hasOnPreDrawListeners() {
        return this.mOnPreDrawListeners != null && this.mOnPreDrawListeners.size() > 0;
    }

    public boolean isAlive() {
        return this.mAlive;
    }

    /*
     * Enabled aggressive block sorting
     */
    void merge(ViewTreeObserver viewTreeObserver) {
        if (viewTreeObserver.mOnWindowAttachListeners != null) {
            if (this.mOnWindowAttachListeners != null) {
                this.mOnWindowAttachListeners.addAll(viewTreeObserver.mOnWindowAttachListeners);
            } else {
                this.mOnWindowAttachListeners = viewTreeObserver.mOnWindowAttachListeners;
            }
        }
        if (viewTreeObserver.mOnWindowFocusListeners != null) {
            if (this.mOnWindowFocusListeners != null) {
                this.mOnWindowFocusListeners.addAll(viewTreeObserver.mOnWindowFocusListeners);
            } else {
                this.mOnWindowFocusListeners = viewTreeObserver.mOnWindowFocusListeners;
            }
        }
        if (viewTreeObserver.mOnGlobalFocusListeners != null) {
            if (this.mOnGlobalFocusListeners != null) {
                this.mOnGlobalFocusListeners.addAll(viewTreeObserver.mOnGlobalFocusListeners);
            } else {
                this.mOnGlobalFocusListeners = viewTreeObserver.mOnGlobalFocusListeners;
            }
        }
        if (viewTreeObserver.mOnGlobalLayoutListeners != null) {
            if (this.mOnGlobalLayoutListeners != null) {
                this.mOnGlobalLayoutListeners.addAll(viewTreeObserver.mOnGlobalLayoutListeners);
            } else {
                this.mOnGlobalLayoutListeners = viewTreeObserver.mOnGlobalLayoutListeners;
            }
        }
        if (viewTreeObserver.mOnPreDrawListeners != null) {
            if (this.mOnPreDrawListeners != null) {
                this.mOnPreDrawListeners.addAll(viewTreeObserver.mOnPreDrawListeners);
            } else {
                this.mOnPreDrawListeners = viewTreeObserver.mOnPreDrawListeners;
            }
        }
        if (viewTreeObserver.mOnTouchModeChangeListeners != null) {
            if (this.mOnTouchModeChangeListeners != null) {
                this.mOnTouchModeChangeListeners.addAll(viewTreeObserver.mOnTouchModeChangeListeners);
            } else {
                this.mOnTouchModeChangeListeners = viewTreeObserver.mOnTouchModeChangeListeners;
            }
        }
        if (viewTreeObserver.mOnComputeInternalInsetsListeners != null) {
            if (this.mOnComputeInternalInsetsListeners != null) {
                this.mOnComputeInternalInsetsListeners.addAll(viewTreeObserver.mOnComputeInternalInsetsListeners);
            } else {
                this.mOnComputeInternalInsetsListeners = viewTreeObserver.mOnComputeInternalInsetsListeners;
            }
        }
        if (viewTreeObserver.mOnScrollChangedListeners != null) {
            if (this.mOnScrollChangedListeners != null) {
                this.mOnScrollChangedListeners.addAll(viewTreeObserver.mOnScrollChangedListeners);
            } else {
                this.mOnScrollChangedListeners = viewTreeObserver.mOnScrollChangedListeners;
            }
        }
        viewTreeObserver.kill();
    }

    @Deprecated
    public void removeGlobalOnLayoutListener(OnGlobalLayoutListener onGlobalLayoutListener) {
        this.removeOnGlobalLayoutListener(onGlobalLayoutListener);
    }

    public void removeOnComputeInternalInsetsListener(OnComputeInternalInsetsListener onComputeInternalInsetsListener) {
        this.checkIsAlive();
        if (this.mOnComputeInternalInsetsListeners == null) {
            return;
        }
        this.mOnComputeInternalInsetsListeners.remove(onComputeInternalInsetsListener);
    }

    public void removeOnDrawListener(OnDrawListener onDrawListener) {
        this.checkIsAlive();
        if (this.mOnDrawListeners == null) {
            return;
        }
        this.mOnDrawListeners.remove(onDrawListener);
    }

    public void removeOnGlobalFocusChangeListener(OnGlobalFocusChangeListener onGlobalFocusChangeListener) {
        this.checkIsAlive();
        if (this.mOnGlobalFocusListeners == null) {
            return;
        }
        this.mOnGlobalFocusListeners.remove(onGlobalFocusChangeListener);
    }

    public void removeOnGlobalLayoutListener(OnGlobalLayoutListener onGlobalLayoutListener) {
        this.checkIsAlive();
        if (this.mOnGlobalLayoutListeners == null) {
            return;
        }
        this.mOnGlobalLayoutListeners.remove(onGlobalLayoutListener);
    }

    public void removeOnPreDrawListener(OnPreDrawListener onPreDrawListener) {
        this.checkIsAlive();
        if (this.mOnPreDrawListeners == null) {
            return;
        }
        this.mOnPreDrawListeners.remove(onPreDrawListener);
    }

    public void removeOnScrollChangedListener(OnScrollChangedListener onScrollChangedListener) {
        this.checkIsAlive();
        if (this.mOnScrollChangedListeners == null) {
            return;
        }
        this.mOnScrollChangedListeners.remove(onScrollChangedListener);
    }

    public void removeOnTouchModeChangeListener(OnTouchModeChangeListener onTouchModeChangeListener) {
        this.checkIsAlive();
        if (this.mOnTouchModeChangeListeners == null) {
            return;
        }
        this.mOnTouchModeChangeListeners.remove(onTouchModeChangeListener);
    }

    public void removeOnWindowAttachListener(OnWindowAttachListener onWindowAttachListener) {
        this.checkIsAlive();
        if (this.mOnWindowAttachListeners == null) {
            return;
        }
        this.mOnWindowAttachListeners.remove(onWindowAttachListener);
    }

    public void removeOnWindowFocusChangeListener(OnWindowFocusChangeListener onWindowFocusChangeListener) {
        this.checkIsAlive();
        if (this.mOnWindowFocusListeners == null) {
            return;
        }
        this.mOnWindowFocusListeners.remove(onWindowFocusChangeListener);
    }

    static class CopyOnWriteArray<T> {
        private final Access<T> mAccess;
        private ArrayList<T> mData = new ArrayList();
        private ArrayList<T> mDataCopy;
        private boolean mStart;

        CopyOnWriteArray() {
            this.mAccess = new Access();
        }

        private ArrayList<T> getArray() {
            if (this.mStart) {
                if (this.mDataCopy == null) {
                    this.mDataCopy = new ArrayList<T>(this.mData);
                }
                return this.mDataCopy;
            }
            return this.mData;
        }

        void add(T t) {
            this.getArray().add(t);
        }

        void addAll(CopyOnWriteArray<T> copyOnWriteArray) {
            this.getArray().addAll(copyOnWriteArray.mData);
        }

        void clear() {
            this.getArray().clear();
        }

        void end() {
            if (!this.mStart) {
                throw new IllegalStateException("Iteration not started");
            }
            this.mStart = false;
            if (this.mDataCopy != null) {
                this.mData = this.mDataCopy;
                ((Access)this.mAccess).mData.clear();
                Access.access$102(this.mAccess, 0);
            }
            this.mDataCopy = null;
        }

        void remove(T t) {
            this.getArray().remove(t);
        }

        int size() {
            return this.getArray().size();
        }

        Access<T> start() {
            if (this.mStart) {
                throw new IllegalStateException("Iteration already started");
            }
            this.mStart = true;
            this.mDataCopy = null;
            Access.access$002(this.mAccess, this.mData);
            Access.access$102(this.mAccess, this.mData.size());
            return this.mAccess;
        }

        static class Access<T> {
            private ArrayList<T> mData;
            private int mSize;

            Access() {
            }

            static /* synthetic */ ArrayList access$002(Access access, ArrayList arrayList) {
                access.mData = arrayList;
                return arrayList;
            }

            static /* synthetic */ int access$102(Access access, int n) {
                access.mSize = n;
                return n;
            }

            T get(int n) {
                return this.mData.get(n);
            }

            int size() {
                return this.mSize;
            }
        }
    }

    public static final class InternalInsetsInfo {
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_REGION = 3;
        public static final int TOUCHABLE_INSETS_VISIBLE = 2;
        public final Rect contentInsets = new Rect();
        int mTouchableInsets;
        public final Region touchableRegion;
        public final Rect visibleInsets = new Rect();

        public InternalInsetsInfo() {
            this.touchableRegion = new Region();
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (this == object) break block4;
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    InternalInsetsInfo internalInsetsInfo = (InternalInsetsInfo)object;
                    if (this.mTouchableInsets != internalInsetsInfo.mTouchableInsets || !this.contentInsets.equals(internalInsetsInfo.contentInsets) || !this.visibleInsets.equals(internalInsetsInfo.visibleInsets) || !this.touchableRegion.equals(internalInsetsInfo.touchableRegion)) break block5;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * (31 * (31 * this.contentInsets.hashCode() + this.visibleInsets.hashCode()) + this.touchableRegion.hashCode()) + this.mTouchableInsets;
        }

        boolean isEmpty() {
            return this.contentInsets.isEmpty() && this.visibleInsets.isEmpty() && this.touchableRegion.isEmpty() && this.mTouchableInsets == 0;
        }

        void reset() {
            this.contentInsets.setEmpty();
            this.visibleInsets.setEmpty();
            this.touchableRegion.setEmpty();
            this.mTouchableInsets = 0;
        }

        void set(InternalInsetsInfo internalInsetsInfo) {
            this.contentInsets.set(internalInsetsInfo.contentInsets);
            this.visibleInsets.set(internalInsetsInfo.visibleInsets);
            this.touchableRegion.set(internalInsetsInfo.touchableRegion);
            this.mTouchableInsets = internalInsetsInfo.mTouchableInsets;
        }

        public void setTouchableInsets(int n) {
            this.mTouchableInsets = n;
        }
    }

    public static interface OnComputeInternalInsetsListener {
        public void onComputeInternalInsets(InternalInsetsInfo var1);
    }

    public static interface OnDrawListener {
        public void onDraw();
    }

    public static interface OnGlobalFocusChangeListener {
        public void onGlobalFocusChanged(View var1, View var2);
    }

    public static interface OnGlobalLayoutListener {
        public void onGlobalLayout();
    }

    public static interface OnPreDrawListener {
        public boolean onPreDraw();
    }

    public static interface OnScrollChangedListener {
        public void onScrollChanged();
    }

    public static interface OnTouchModeChangeListener {
        public void onTouchModeChanged(boolean var1);
    }

    public static interface OnWindowAttachListener {
        public void onWindowAttached();

        public void onWindowDetached();
    }

    public static interface OnWindowFocusChangeListener {
        public void onWindowFocusChanged(boolean var1);
    }
}

