/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;

public final class WindowManagerImpl
implements WindowManager {
    private final Display mDisplay;
    private final WindowManagerGlobal mGlobal = WindowManagerGlobal.getInstance();
    private final Window mParentWindow;

    public WindowManagerImpl(Display display) {
        this(display, null);
    }

    private WindowManagerImpl(Display display, Window window) {
        this.mDisplay = display;
        this.mParentWindow = window;
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        this.mGlobal.addView(view, layoutParams, this.mDisplay, this.mParentWindow);
    }

    public WindowManagerImpl createLocalWindowManager(Window window) {
        return new WindowManagerImpl(this.mDisplay, window);
    }

    public WindowManagerImpl createPresentationWindowManager(Display display) {
        return new WindowManagerImpl(display, this.mParentWindow);
    }

    @Override
    public Display getDefaultDisplay() {
        return this.mDisplay;
    }

    @Override
    public void removeView(View view) {
        this.mGlobal.removeView(view, false);
    }

    @Override
    public void removeViewImmediate(View view) {
        this.mGlobal.removeView(view, true);
    }

    @Override
    public void updateViewLayout(View view, ViewGroup.LayoutParams layoutParams) {
        this.mGlobal.updateViewLayout(view, layoutParams);
    }
}

