/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pools;
import android.view.accessibility.AccessibilityRecord;
import java.util.ArrayList;

public final class AccessibilityEvent
extends AccessibilityRecord
implements Parcelable {
    public static final int CONTENT_CHANGE_TYPE_CONTENT_DESCRIPTION = 4;
    public static final int CONTENT_CHANGE_TYPE_SUBTREE = 1;
    public static final int CONTENT_CHANGE_TYPE_TEXT = 2;
    public static final int CONTENT_CHANGE_TYPE_UNDEFINED = 0;
    public static final Parcelable.Creator<AccessibilityEvent> CREATOR;
    private static final boolean DEBUG = false;
    public static final int INVALID_POSITION = -1;
    private static final int MAX_POOL_SIZE = 10;
    @Deprecated
    public static final int MAX_TEXT_LENGTH = 500;
    public static final int TYPES_ALL_MASK = -1;
    public static final int TYPE_ANNOUNCEMENT = 16384;
    public static final int TYPE_GESTURE_DETECTION_END = 524288;
    public static final int TYPE_GESTURE_DETECTION_START = 262144;
    public static final int TYPE_NOTIFICATION_STATE_CHANGED = 64;
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_END = 1024;
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_START = 512;
    public static final int TYPE_TOUCH_INTERACTION_END = 0x200000;
    public static final int TYPE_TOUCH_INTERACTION_START = 0x100000;
    public static final int TYPE_VIEW_ACCESSIBILITY_FOCUSED = 32768;
    public static final int TYPE_VIEW_ACCESSIBILITY_FOCUS_CLEARED = 65536;
    public static final int TYPE_VIEW_CLICKED = 1;
    public static final int TYPE_VIEW_FOCUSED = 8;
    public static final int TYPE_VIEW_HOVER_ENTER = 128;
    public static final int TYPE_VIEW_HOVER_EXIT = 256;
    public static final int TYPE_VIEW_LONG_CLICKED = 2;
    public static final int TYPE_VIEW_SCROLLED = 4096;
    public static final int TYPE_VIEW_SELECTED = 4;
    public static final int TYPE_VIEW_TEXT_CHANGED = 16;
    public static final int TYPE_VIEW_TEXT_SELECTION_CHANGED = 8192;
    public static final int TYPE_VIEW_TEXT_TRAVERSED_AT_MOVEMENT_GRANULARITY = 131072;
    public static final int TYPE_WINDOWS_CHANGED = 0x400000;
    public static final int TYPE_WINDOW_CONTENT_CHANGED = 2048;
    public static final int TYPE_WINDOW_STATE_CHANGED = 32;
    private static final Pools.SynchronizedPool<AccessibilityEvent> sPool;
    int mAction;
    int mContentChangeTypes;
    private long mEventTime;
    private int mEventType;
    int mMovementGranularity;
    private CharSequence mPackageName;
    private ArrayList<AccessibilityRecord> mRecords;

    static {
        sPool = new Pools.SynchronizedPool(10);
        CREATOR = new Parcelable.Creator<AccessibilityEvent>(){

            @Override
            public AccessibilityEvent createFromParcel(Parcel parcel) {
                AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain();
                accessibilityEvent.initFromParcel(parcel);
                return accessibilityEvent;
            }

            public AccessibilityEvent[] newArray(int n) {
                return new AccessibilityEvent[n];
            }
        };
    }

    private AccessibilityEvent() {
    }

    public static String eventTypeToString(int n) {
        if (n == -1) {
            return "TYPES_ALL_MASK";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        block25: while (n != 0) {
            int n3 = 1 << Integer.numberOfTrailingZeros(n);
            n &= ~n3;
            switch (n3) {
                default: {
                    continue block25;
                }
                case 1: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_CLICKED");
                    ++n2;
                    continue block25;
                }
                case 2: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_LONG_CLICKED");
                    ++n2;
                    continue block25;
                }
                case 4: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_SELECTED");
                    ++n2;
                    continue block25;
                }
                case 8: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_FOCUSED");
                    ++n2;
                    continue block25;
                }
                case 16: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_TEXT_CHANGED");
                    ++n2;
                    continue block25;
                }
                case 32: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_WINDOW_STATE_CHANGED");
                    ++n2;
                    continue block25;
                }
                case 128: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_HOVER_ENTER");
                    ++n2;
                    continue block25;
                }
                case 256: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_HOVER_EXIT");
                    ++n2;
                    continue block25;
                }
                case 64: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_NOTIFICATION_STATE_CHANGED");
                    ++n2;
                    continue block25;
                }
                case 512: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_TOUCH_EXPLORATION_GESTURE_START");
                    ++n2;
                    continue block25;
                }
                case 1024: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_TOUCH_EXPLORATION_GESTURE_END");
                    ++n2;
                    continue block25;
                }
                case 2048: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_WINDOW_CONTENT_CHANGED");
                    ++n2;
                    continue block25;
                }
                case 8192: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_TEXT_SELECTION_CHANGED");
                    ++n2;
                    continue block25;
                }
                case 4096: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_SCROLLED");
                    ++n2;
                    continue block25;
                }
                case 16384: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_ANNOUNCEMENT");
                    ++n2;
                    continue block25;
                }
                case 32768: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_ACCESSIBILITY_FOCUSED");
                    ++n2;
                    continue block25;
                }
                case 65536: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_ACCESSIBILITY_FOCUS_CLEARED");
                    ++n2;
                    continue block25;
                }
                case 131072: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_VIEW_TEXT_TRAVERSED_AT_MOVEMENT_GRANULARITY");
                    ++n2;
                    continue block25;
                }
                case 262144: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_GESTURE_DETECTION_START");
                    ++n2;
                    continue block25;
                }
                case 524288: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_GESTURE_DETECTION_END");
                    ++n2;
                    continue block25;
                }
                case 0x100000: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_TOUCH_INTERACTION_START");
                    ++n2;
                    continue block25;
                }
                case 0x200000: {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("TYPE_TOUCH_INTERACTION_END");
                    ++n2;
                    continue block25;
                }
                case 0x400000: 
            }
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("TYPE_WINDOWS_CHANGED");
            ++n2;
        }
        if (n2 > 1) {
            stringBuilder.insert(0, '[');
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public static AccessibilityEvent obtain() {
        AccessibilityEvent accessibilityEvent = sPool.acquire();
        if (accessibilityEvent != null) {
            return accessibilityEvent;
        }
        return new AccessibilityEvent();
    }

    public static AccessibilityEvent obtain(int n) {
        AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain();
        accessibilityEvent.setEventType(n);
        return accessibilityEvent;
    }

    public static AccessibilityEvent obtain(AccessibilityEvent accessibilityEvent) {
        AccessibilityEvent accessibilityEvent2 = AccessibilityEvent.obtain();
        accessibilityEvent2.init(accessibilityEvent);
        if (accessibilityEvent.mRecords != null) {
            int n = accessibilityEvent.mRecords.size();
            accessibilityEvent2.mRecords = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                AccessibilityRecord accessibilityRecord = AccessibilityRecord.obtain(accessibilityEvent.mRecords.get(i));
                accessibilityEvent2.mRecords.add(accessibilityRecord);
            }
        }
        return accessibilityEvent2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readAccessibilityRecordFromParcel(AccessibilityRecord accessibilityRecord, Parcel parcel) {
        accessibilityRecord.mBooleanProperties = parcel.readInt();
        accessibilityRecord.mCurrentItemIndex = parcel.readInt();
        accessibilityRecord.mItemCount = parcel.readInt();
        accessibilityRecord.mFromIndex = parcel.readInt();
        accessibilityRecord.mToIndex = parcel.readInt();
        accessibilityRecord.mScrollX = parcel.readInt();
        accessibilityRecord.mScrollY = parcel.readInt();
        accessibilityRecord.mMaxScrollX = parcel.readInt();
        accessibilityRecord.mMaxScrollY = parcel.readInt();
        accessibilityRecord.mAddedCount = parcel.readInt();
        accessibilityRecord.mRemovedCount = parcel.readInt();
        accessibilityRecord.mClassName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        accessibilityRecord.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        accessibilityRecord.mBeforeText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        accessibilityRecord.mParcelableData = parcel.readParcelable(null);
        parcel.readList(accessibilityRecord.mText, null);
        accessibilityRecord.mSourceWindowId = parcel.readInt();
        accessibilityRecord.mSourceNodeId = parcel.readLong();
        boolean bl = parcel.readInt() == 1;
        accessibilityRecord.mSealed = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeAccessibilityRecordToParcel(AccessibilityRecord accessibilityRecord, Parcel parcel, int n) {
        parcel.writeInt(accessibilityRecord.mBooleanProperties);
        parcel.writeInt(accessibilityRecord.mCurrentItemIndex);
        parcel.writeInt(accessibilityRecord.mItemCount);
        parcel.writeInt(accessibilityRecord.mFromIndex);
        parcel.writeInt(accessibilityRecord.mToIndex);
        parcel.writeInt(accessibilityRecord.mScrollX);
        parcel.writeInt(accessibilityRecord.mScrollY);
        parcel.writeInt(accessibilityRecord.mMaxScrollX);
        parcel.writeInt(accessibilityRecord.mMaxScrollY);
        parcel.writeInt(accessibilityRecord.mAddedCount);
        parcel.writeInt(accessibilityRecord.mRemovedCount);
        TextUtils.writeToParcel(accessibilityRecord.mClassName, parcel, n);
        TextUtils.writeToParcel(accessibilityRecord.mContentDescription, parcel, n);
        TextUtils.writeToParcel(accessibilityRecord.mBeforeText, parcel, n);
        parcel.writeParcelable(accessibilityRecord.mParcelableData, n);
        parcel.writeList(accessibilityRecord.mText);
        parcel.writeInt(accessibilityRecord.mSourceWindowId);
        parcel.writeLong(accessibilityRecord.mSourceNodeId);
        int n2 = accessibilityRecord.mSealed ? 1 : 0;
        parcel.writeInt(n2);
    }

    public void appendRecord(AccessibilityRecord accessibilityRecord) {
        this.enforceNotSealed();
        if (this.mRecords == null) {
            this.mRecords = new ArrayList();
        }
        this.mRecords.add(accessibilityRecord);
    }

    @Override
    protected void clear() {
        super.clear();
        this.mEventType = 0;
        this.mMovementGranularity = 0;
        this.mAction = 0;
        this.mContentChangeTypes = 0;
        this.mPackageName = null;
        this.mEventTime = 0L;
        if (this.mRecords != null) {
            while (!this.mRecords.isEmpty()) {
                this.mRecords.remove(0).recycle();
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getAction() {
        return this.mAction;
    }

    public int getContentChangeTypes() {
        return this.mContentChangeTypes;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    public int getEventType() {
        return this.mEventType;
    }

    public int getMovementGranularity() {
        return this.mMovementGranularity;
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public AccessibilityRecord getRecord(int n) {
        if (this.mRecords == null) {
            throw new IndexOutOfBoundsException("Invalid index " + n + ", size is 0");
        }
        return this.mRecords.get(n);
    }

    public int getRecordCount() {
        if (this.mRecords == null) {
            return 0;
        }
        return this.mRecords.size();
    }

    void init(AccessibilityEvent accessibilityEvent) {
        super.init(accessibilityEvent);
        this.mEventType = accessibilityEvent.mEventType;
        this.mMovementGranularity = accessibilityEvent.mMovementGranularity;
        this.mAction = accessibilityEvent.mAction;
        this.mContentChangeTypes = accessibilityEvent.mContentChangeTypes;
        this.mEventTime = accessibilityEvent.mEventTime;
        this.mPackageName = accessibilityEvent.mPackageName;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initFromParcel(Parcel parcel) {
        int n = 1;
        if (parcel.readInt() != n) {
            n = 0;
        }
        this.mSealed = n;
        this.mEventType = parcel.readInt();
        this.mMovementGranularity = parcel.readInt();
        this.mAction = parcel.readInt();
        this.mContentChangeTypes = parcel.readInt();
        this.mPackageName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mEventTime = parcel.readLong();
        this.mConnectionId = parcel.readInt();
        this.readAccessibilityRecordFromParcel(this, parcel);
        int n2 = parcel.readInt();
        if (n2 > 0) {
            this.mRecords = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                AccessibilityRecord accessibilityRecord = AccessibilityRecord.obtain();
                this.readAccessibilityRecordFromParcel(accessibilityRecord, parcel);
                accessibilityRecord.mConnectionId = this.mConnectionId;
                this.mRecords.add(accessibilityRecord);
            }
        }
    }

    @Override
    public void recycle() {
        this.clear();
        sPool.release(this);
    }

    public void setAction(int n) {
        this.enforceNotSealed();
        this.mAction = n;
    }

    public void setContentChangeTypes(int n) {
        this.enforceNotSealed();
        this.mContentChangeTypes = n;
    }

    public void setEventTime(long l) {
        this.enforceNotSealed();
        this.mEventTime = l;
    }

    public void setEventType(int n) {
        this.enforceNotSealed();
        this.mEventType = n;
    }

    public void setMovementGranularity(int n) {
        this.enforceNotSealed();
        this.mMovementGranularity = n;
    }

    public void setPackageName(CharSequence charSequence) {
        this.enforceNotSealed();
        this.mPackageName = charSequence;
    }

    @Override
    public void setSealed(boolean bl) {
        super.setSealed(bl);
        ArrayList<AccessibilityRecord> arrayList = this.mRecords;
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((AccessibilityRecord)arrayList.get(i)).setSealed(bl);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EventType: ").append(AccessibilityEvent.eventTypeToString(this.mEventType));
        stringBuilder.append("; EventTime: ").append(this.mEventTime);
        stringBuilder.append("; PackageName: ").append(this.mPackageName);
        stringBuilder.append("; MovementGranularity: ").append(this.mMovementGranularity);
        stringBuilder.append("; Action: ").append(this.mAction);
        stringBuilder.append(super.toString());
        stringBuilder.append("; recordCount: ").append(this.getRecordCount());
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.isSealed() ? 1 : 0;
        parcel.writeInt(n2);
        parcel.writeInt(this.mEventType);
        parcel.writeInt(this.mMovementGranularity);
        parcel.writeInt(this.mAction);
        parcel.writeInt(this.mContentChangeTypes);
        TextUtils.writeToParcel(this.mPackageName, parcel, 0);
        parcel.writeLong(this.mEventTime);
        parcel.writeInt(this.mConnectionId);
        this.writeAccessibilityRecordToParcel(this, parcel, n);
        int n3 = this.getRecordCount();
        parcel.writeInt(n3);
        int n4 = 0;
        while (n4 < n3) {
            this.writeAccessibilityRecordToParcel(this.mRecords.get(n4), parcel, n);
            ++n4;
        }
        return;
    }
}

