/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.text.Editable;
import android.text.Selection;
import android.text.TextWatcher;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;

public class FindActionModeCallback
implements ActionMode.Callback,
TextWatcher,
View.OnClickListener,
WebView.FindListener {
    private ActionMode mActionMode;
    private int mActiveMatchIndex;
    private View mCustomView;
    private EditText mEditText;
    private Point mGlobalVisibleOffset;
    private Rect mGlobalVisibleRect = new Rect();
    private InputMethodManager mInput;
    private TextView mMatches;
    private boolean mMatchesFound;
    private int mNumberOfMatches;
    private Resources mResources;
    private WebView mWebView;

    public FindActionModeCallback(Context context) {
        this.mGlobalVisibleOffset = new Point();
        this.mCustomView = LayoutInflater.from(context).inflate(17367302, null);
        this.mEditText = (EditText)this.mCustomView.findViewById(16908291);
        this.mEditText.setCustomSelectionActionModeCallback(new NoAction());
        this.mEditText.setOnClickListener(this);
        this.setText("");
        this.mMatches = (TextView)this.mCustomView.findViewById(16909307);
        this.mInput = (InputMethodManager)context.getSystemService("input_method");
        this.mResources = context.getResources();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void findNext(boolean bl) {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindActionModeCallback::findNext");
        }
        if (!this.mMatchesFound) {
            this.findAll();
            return;
        } else {
            if (this.mNumberOfMatches == 0) return;
            this.mWebView.findNext(bl);
            this.updateMatchesString();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateMatchesString() {
        if (this.mNumberOfMatches == 0) {
            this.mMatches.setText(17040721);
        } else {
            TextView textView = this.mMatches;
            Resources resources = this.mResources;
            int n = this.mNumberOfMatches;
            Object[] objectArray = new Object[]{1 + this.mActiveMatchIndex, this.mNumberOfMatches};
            textView.setText(resources.getQuantityString(18087959, n, objectArray));
        }
        this.mMatches.setVisibility(0);
    }

    @Override
    public void afterTextChanged(Editable editable) {
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public void findAll() {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindActionModeCallback::findAll");
        }
        Editable editable = this.mEditText.getText();
        if (editable.length() == 0) {
            this.mWebView.clearMatches();
            this.mMatches.setVisibility(8);
            this.mMatchesFound = false;
            return;
        }
        this.mMatchesFound = true;
        this.mMatches.setVisibility(4);
        this.mNumberOfMatches = 0;
        this.mWebView.findAllAsync(editable.toString());
    }

    public void finish() {
        this.mActionMode.finish();
    }

    public int getActionModeGlobalBottom() {
        if (this.mActionMode == null) {
            return 0;
        }
        View view = (View)((Object)this.mCustomView.getParent());
        if (view == null) {
            view = this.mCustomView;
        }
        view.getGlobalVisibleRect(this.mGlobalVisibleRect, this.mGlobalVisibleOffset);
        return this.mGlobalVisibleRect.bottom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindActionModeCallback::onActionItemClicked");
        }
        this.mInput.hideSoftInputFromWindow(this.mWebView.getWindowToken(), 0);
        switch (menuItem.getItemId()) {
            default: {
                return false;
            }
            case 16909328: {
                this.findNext(false);
                return true;
            }
            case 16909329: 
        }
        this.findNext(true);
        return true;
    }

    @Override
    public void onClick(View view) {
        this.findNext(true);
    }

    @Override
    public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
        if (!actionMode.isUiFocusable()) {
            return false;
        }
        actionMode.setCustomView(this.mCustomView);
        actionMode.getMenuInflater().inflate(0x1150001, menu2);
        this.mActionMode = actionMode;
        Editable editable = this.mEditText.getText();
        Selection.setSelection(editable, editable.length());
        this.mMatches.setVisibility(8);
        this.mMatchesFound = false;
        this.mMatches.setText("0");
        this.mEditText.requestFocus();
        return true;
    }

    @Override
    public void onDestroyActionMode(ActionMode actionMode) {
        this.mActionMode = null;
        this.mWebView.notifyFindDialogDismissed();
        this.mWebView.setFindDialogFindListener(null);
        this.mInput.hideSoftInputFromWindow(this.mWebView.getWindowToken(), 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onFindResultReceived(int n, int n2, boolean bl) {
        if (bl) {
            boolean bl2 = n2 == 0;
            this.updateMatchCount(n, n2, bl2);
        }
    }

    @Override
    public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
        return false;
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        this.findAll();
    }

    public void setText(String string2) {
        this.mEditText.setText(string2);
        Editable editable = this.mEditText.getText();
        int n = editable.length();
        Selection.setSelection(editable, n, n);
        editable.setSpan(this, 0, n, 18);
        this.mMatchesFound = false;
    }

    public void setWebView(WebView webView) {
        if (webView == null) {
            throw new AssertionError((Object)"WebView supplied to FindActionModeCallback cannot be null");
        }
        this.mWebView = webView;
        this.mWebView.setFindDialogFindListener(this);
    }

    public void showSoftInput() {
        this.mInput.startGettingWindowFocus(this.mEditText.getRootView());
        this.mInput.focusIn(this.mEditText);
        this.mInput.showSoftInput(this.mEditText, 0);
    }

    public void updateMatchCount(int n, int n2, boolean bl) {
        if (!bl) {
            this.mNumberOfMatches = n2;
            this.mActiveMatchIndex = n;
            this.updateMatchesString();
            return;
        }
        this.mMatches.setVisibility(8);
        this.mNumberOfMatches = 0;
        this.updateMatchesString();
    }

    public static class NoAction
    implements ActionMode.Callback {
        @Override
        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            return false;
        }

        @Override
        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            return false;
        }

        @Override
        public void onDestroyActionMode(ActionMode actionMode) {
        }

        @Override
        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            return false;
        }
    }
}

