/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.ParseException;
import android.net.Uri;
import android.net.WebAddress;
import android.webkit.MimeTypeMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class URLUtil {
    static final String ASSET_BASE = "file:///android_asset/";
    static final String CONTENT_BASE = "content:";
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*(\"?)([^\"]*)\\1\\s*$", 2);
    static final String FILE_BASE = "file://";
    private static final String LOGTAG = "webkit";
    static final String PROXY_BASE = "file:///cookieless_proxy/";
    static final String RESOURCE_BASE = "file:///android_res/";

    public static String composeSearchUrl(String string2, String string3, String string4) {
        int n = string3.indexOf(string4);
        if (n < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3.substring(0, n));
        try {
            stringBuilder.append(URLEncoder.encode(string2, "utf-8"));
            stringBuilder.append(string3.substring(n + string4.length()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static byte[] decode(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length == 0) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            block6: {
                byte by;
                block5: {
                    by = byArray[i];
                    if (by != 37) break block5;
                    if (byArray.length - i <= 2) break block6;
                    by = (byte)(16 * URLUtil.parseHex(byArray[i + 1]) + URLUtil.parseHex(byArray[i + 2]));
                    i += 2;
                }
                int n2 = n + 1;
                byArray2[n] = by;
                n = n2;
                continue;
            }
            throw new IllegalArgumentException("Invalid format");
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy((byte[])byArray2, (int)0, (byte[])byArray3, (int)0, (int)n);
        return byArray3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String guessFileName(String string2, String string3, String string4) {
        String string5;
        int n;
        String string6;
        String string7 = null;
        if (!false) {
            int n2;
            string7 = null;
            if (string3 != null && (string7 = URLUtil.parseContentDisposition(string3)) != null && (n2 = 1 + string7.lastIndexOf(47)) > 0) {
                string7 = string7.substring(n2);
            }
        }
        if (string7 == null && (string6 = Uri.decode(string2)) != null) {
            int n3;
            int n4 = string6.indexOf(63);
            if (n4 > 0) {
                string6 = string6.substring(0, n4);
            }
            if (!string6.endsWith("/") && (n3 = 1 + string6.lastIndexOf(47)) > 0) {
                string7 = string6.substring(n3);
            }
        }
        if (string7 == null) {
            string7 = "downloadfile";
        }
        if ((n = string7.indexOf(46)) < 0) {
            string5 = null;
            if (string4 != null && (string5 = MimeTypeMap.getSingleton().getExtensionFromMimeType(string4)) != null) {
                string5 = "." + string5;
            }
            if (string5 != null) return string7 + string5;
            if (string4 != null && string4.toLowerCase(Locale.ROOT).startsWith("text/")) {
                if (string4.equalsIgnoreCase("text/html")) {
                    string5 = ".html";
                    return string7 + string5;
                }
                string5 = ".txt";
                return string7 + string5;
            }
            string5 = ".bin";
            return string7 + string5;
        }
        string5 = null;
        if (string4 != null) {
            int n5 = string7.lastIndexOf(46);
            String string8 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string7.substring(n5 + 1));
            string5 = null;
            if (string8 != null) {
                boolean bl = string8.equalsIgnoreCase(string4);
                string5 = null;
                if (!bl && (string5 = MimeTypeMap.getSingleton().getExtensionFromMimeType(string4)) != null) {
                    string5 = "." + string5;
                }
            }
        }
        if (string5 == null) {
            string5 = string7.substring(n);
        }
        string7 = string7.substring(0, n);
        return string7 + string5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String guessUrl(String string2) {
        WebAddress webAddress;
        String string3 = string2;
        if (string2.length() == 0 || string2.startsWith("about:") || string2.startsWith("data:") || string2.startsWith("file:") || string2.startsWith("javascript:")) {
            return string2;
        }
        if (string2.endsWith(".")) {
            string2 = string2.substring(0, -1 + string2.length());
        }
        try {
            webAddress = new WebAddress(string2);
        }
        catch (ParseException parseException) {
            return string3;
        }
        if (webAddress.getHost().indexOf(46) == -1) {
            webAddress.setHost("www." + webAddress.getHost() + ".com");
        }
        return webAddress.toString();
    }

    public static boolean isAboutUrl(String string2) {
        return string2 != null && string2.startsWith("about:");
    }

    public static boolean isAssetUrl(String string2) {
        return string2 != null && string2.startsWith(ASSET_BASE);
    }

    public static boolean isContentUrl(String string2) {
        return string2 != null && string2.startsWith(CONTENT_BASE);
    }

    @Deprecated
    public static boolean isCookielessProxyUrl(String string2) {
        return string2 != null && string2.startsWith(PROXY_BASE);
    }

    public static boolean isDataUrl(String string2) {
        return string2 != null && string2.startsWith("data:");
    }

    public static boolean isFileUrl(String string2) {
        return string2 != null && string2.startsWith(FILE_BASE) && !string2.startsWith(ASSET_BASE) && !string2.startsWith(PROXY_BASE);
    }

    public static boolean isHttpUrl(String string2) {
        boolean bl = false;
        if (string2 != null) {
            int n = string2.length();
            bl = false;
            if (n > 6) {
                boolean bl2 = string2.substring(0, 7).equalsIgnoreCase("http://");
                bl = false;
                if (bl2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean isHttpsUrl(String string2) {
        boolean bl = false;
        if (string2 != null) {
            int n = string2.length();
            bl = false;
            if (n > 7) {
                boolean bl2 = string2.substring(0, 8).equalsIgnoreCase("https://");
                bl = false;
                if (bl2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean isJavaScriptUrl(String string2) {
        return string2 != null && string2.startsWith("javascript:");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isNetworkUrl(String string2) {
        return string2 != null && string2.length() != 0 && (URLUtil.isHttpUrl(string2) || URLUtil.isHttpsUrl(string2));
    }

    public static boolean isResourceUrl(String string2) {
        return string2 != null && string2.startsWith(RESOURCE_BASE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isValidUrl(String string2) {
        return string2 != null && string2.length() != 0 && (URLUtil.isAssetUrl(string2) || URLUtil.isResourceUrl(string2) || URLUtil.isFileUrl(string2) || URLUtil.isAboutUrl(string2) || URLUtil.isHttpUrl(string2) || URLUtil.isHttpsUrl(string2) || URLUtil.isJavaScriptUrl(string2) || URLUtil.isContentUrl(string2));
    }

    static String parseContentDisposition(String string2) {
        try {
            Matcher matcher = CONTENT_DISPOSITION_PATTERN.matcher(string2);
            if (matcher.find()) {
                String string3 = matcher.group(2);
                return string3;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private static int parseHex(byte by) {
        if (by >= 48 && by <= 57) {
            return by - 48;
        }
        if (by >= 65 && by <= 70) {
            return 10 + (by - 65);
        }
        if (by >= 97 && by <= 102) {
            return 10 + (by - 97);
        }
        throw new IllegalArgumentException("Invalid hex char '" + by + "'");
    }

    public static String stripAnchor(String string2) {
        int n = string2.indexOf(35);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean verifyURLEncoding(String string2) {
        int n = string2.length();
        if (n == 0) return false;
        int n2 = string2.indexOf(37);
        while (n2 >= 0 && n2 < n) {
            int n3;
            if (n2 >= n - 2) return false;
            int n4 = n2 + 1;
            try {
                URLUtil.parseHex((byte)string2.charAt(n4));
                n3 = n4 + 1;
                URLUtil.parseHex((byte)string2.charAt(n3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            n2 = string2.indexOf(37, n3 + 1);
        }
        return true;
    }
}

