/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.R;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import libcore.icu.LocaleData;

public class CalendarView
extends FrameLayout {
    private static final String LOG_TAG = CalendarView.class.getSimpleName();
    private CalendarViewDelegate mDelegate;

    public CalendarView(Context context) {
        this(context, null);
    }

    public CalendarView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843613);
    }

    public CalendarView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public CalendarView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mDelegate = new LegacyCalendarViewDelegate(this, context, attributeSet, n, n2);
    }

    public long getDate() {
        return this.mDelegate.getDate();
    }

    public int getDateTextAppearance() {
        return this.mDelegate.getDateTextAppearance();
    }

    public int getFirstDayOfWeek() {
        return this.mDelegate.getFirstDayOfWeek();
    }

    public int getFocusedMonthDateColor() {
        return this.mDelegate.getFocusedMonthDateColor();
    }

    public long getMaxDate() {
        return this.mDelegate.getMaxDate();
    }

    public long getMinDate() {
        return this.mDelegate.getMinDate();
    }

    public Drawable getSelectedDateVerticalBar() {
        return this.mDelegate.getSelectedDateVerticalBar();
    }

    public int getSelectedWeekBackgroundColor() {
        return this.mDelegate.getSelectedWeekBackgroundColor();
    }

    public boolean getShowWeekNumber() {
        return this.mDelegate.getShowWeekNumber();
    }

    public int getShownWeekCount() {
        return this.mDelegate.getShownWeekCount();
    }

    public int getUnfocusedMonthDateColor() {
        return this.mDelegate.getUnfocusedMonthDateColor();
    }

    public int getWeekDayTextAppearance() {
        return this.mDelegate.getWeekDayTextAppearance();
    }

    public int getWeekNumberColor() {
        return this.mDelegate.getWeekNumberColor();
    }

    public int getWeekSeparatorLineColor() {
        return this.mDelegate.getWeekSeparatorLineColor();
    }

    @Override
    public boolean isEnabled() {
        return this.mDelegate.isEnabled();
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mDelegate.onConfigurationChanged(configuration);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        this.mDelegate.onInitializeAccessibilityEvent(accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        this.mDelegate.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
    }

    public void setDate(long l) {
        this.mDelegate.setDate(l);
    }

    public void setDate(long l, boolean bl, boolean bl2) {
        this.mDelegate.setDate(l, bl, bl2);
    }

    public void setDateTextAppearance(int n) {
        this.mDelegate.setDateTextAppearance(n);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.mDelegate.setEnabled(bl);
    }

    public void setFirstDayOfWeek(int n) {
        this.mDelegate.setFirstDayOfWeek(n);
    }

    public void setFocusedMonthDateColor(int n) {
        this.mDelegate.setFocusedMonthDateColor(n);
    }

    public void setMaxDate(long l) {
        this.mDelegate.setMaxDate(l);
    }

    public void setMinDate(long l) {
        this.mDelegate.setMinDate(l);
    }

    public void setOnDateChangeListener(OnDateChangeListener onDateChangeListener) {
        this.mDelegate.setOnDateChangeListener(onDateChangeListener);
    }

    public void setSelectedDateVerticalBar(int n) {
        this.mDelegate.setSelectedDateVerticalBar(n);
    }

    public void setSelectedDateVerticalBar(Drawable drawable2) {
        this.mDelegate.setSelectedDateVerticalBar(drawable2);
    }

    public void setSelectedWeekBackgroundColor(int n) {
        this.mDelegate.setSelectedWeekBackgroundColor(n);
    }

    public void setShowWeekNumber(boolean bl) {
        this.mDelegate.setShowWeekNumber(bl);
    }

    public void setShownWeekCount(int n) {
        this.mDelegate.setShownWeekCount(n);
    }

    public void setUnfocusedMonthDateColor(int n) {
        this.mDelegate.setUnfocusedMonthDateColor(n);
    }

    public void setWeekDayTextAppearance(int n) {
        this.mDelegate.setWeekDayTextAppearance(n);
    }

    public void setWeekNumberColor(int n) {
        this.mDelegate.setWeekNumberColor(n);
    }

    public void setWeekSeparatorLineColor(int n) {
        this.mDelegate.setWeekSeparatorLineColor(n);
    }

    static abstract class AbstractCalendarViewDelegate
    implements CalendarViewDelegate {
        protected Context mContext;
        protected Locale mCurrentLocale;
        protected CalendarView mDelegator;

        AbstractCalendarViewDelegate(CalendarView calendarView, Context context) {
            this.mDelegator = calendarView;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
        }

        protected void setCurrentLocale(Locale locale) {
            if (locale.equals(this.mCurrentLocale)) {
                return;
            }
            this.mCurrentLocale = locale;
        }
    }

    private static interface CalendarViewDelegate {
        public long getDate();

        public int getDateTextAppearance();

        public int getFirstDayOfWeek();

        public int getFocusedMonthDateColor();

        public long getMaxDate();

        public long getMinDate();

        public Drawable getSelectedDateVerticalBar();

        public int getSelectedWeekBackgroundColor();

        public boolean getShowWeekNumber();

        public int getShownWeekCount();

        public int getUnfocusedMonthDateColor();

        public int getWeekDayTextAppearance();

        public int getWeekNumberColor();

        public int getWeekSeparatorLineColor();

        public boolean isEnabled();

        public void onConfigurationChanged(Configuration var1);

        public void onInitializeAccessibilityEvent(AccessibilityEvent var1);

        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo var1);

        public void setDate(long var1);

        public void setDate(long var1, boolean var3, boolean var4);

        public void setDateTextAppearance(int var1);

        public void setEnabled(boolean var1);

        public void setFirstDayOfWeek(int var1);

        public void setFocusedMonthDateColor(int var1);

        public void setMaxDate(long var1);

        public void setMinDate(long var1);

        public void setOnDateChangeListener(OnDateChangeListener var1);

        public void setSelectedDateVerticalBar(int var1);

        public void setSelectedDateVerticalBar(Drawable var1);

        public void setSelectedWeekBackgroundColor(int var1);

        public void setShowWeekNumber(boolean var1);

        public void setShownWeekCount(int var1);

        public void setUnfocusedMonthDateColor(int var1);

        public void setWeekDayTextAppearance(int var1);

        public void setWeekNumberColor(int var1);

        public void setWeekSeparatorLineColor(int var1);
    }

    private static class LegacyCalendarViewDelegate
    extends AbstractCalendarViewDelegate {
        private static final int ADJUSTMENT_SCROLL_DURATION = 500;
        private static final String DATE_FORMAT = "MM/dd/yyyy";
        private static final int DAYS_PER_WEEK = 7;
        private static final int DEFAULT_DATE_TEXT_SIZE = 14;
        private static final String DEFAULT_MAX_DATE = "01/01/2100";
        private static final String DEFAULT_MIN_DATE = "01/01/1900";
        private static final int DEFAULT_SHOWN_WEEK_COUNT = 6;
        private static final boolean DEFAULT_SHOW_WEEK_NUMBER = true;
        private static final int DEFAULT_WEEK_DAY_TEXT_APPEARANCE_RES_ID = -1;
        private static final int GOTO_SCROLL_DURATION = 1000;
        private static final long MILLIS_IN_DAY = 86400000L;
        private static final long MILLIS_IN_WEEK = 604800000L;
        private static final int SCROLL_CHANGE_DELAY = 40;
        private static final int SCROLL_HYST_WEEKS = 2;
        private static final int UNSCALED_BOTTOM_BUFFER = 20;
        private static final int UNSCALED_LIST_SCROLL_TOP_OFFSET = 2;
        private static final int UNSCALED_SELECTED_DATE_VERTICAL_BAR_WIDTH = 6;
        private static final int UNSCALED_WEEK_MIN_VISIBLE_HEIGHT = 12;
        private static final int UNSCALED_WEEK_SEPARATOR_LINE_WIDTH = 1;
        private WeeksAdapter mAdapter;
        private int mBottomBuffer = 20;
        private int mCurrentMonthDisplayed = -1;
        private int mCurrentScrollState = 0;
        private final DateFormat mDateFormat;
        private int mDateTextAppearanceResId;
        private int mDateTextSize;
        private String[] mDayLabels;
        private ViewGroup mDayNamesHeader;
        private int mDaysPerWeek = 7;
        private Calendar mFirstDayOfMonth;
        private int mFirstDayOfWeek;
        private int mFocusedMonthDateColor;
        private float mFriction = 0.05f;
        private boolean mIsScrollingUp = false;
        private int mListScrollTopOffset = 2;
        private ListView mListView;
        private Calendar mMaxDate;
        private Calendar mMinDate;
        private TextView mMonthName;
        private OnDateChangeListener mOnDateChangeListener;
        private long mPreviousScrollPosition;
        private int mPreviousScrollState = 0;
        private ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();
        private Drawable mSelectedDateVerticalBar;
        private final int mSelectedDateVerticalBarWidth;
        private int mSelectedWeekBackgroundColor;
        private boolean mShowWeekNumber;
        private int mShownWeekCount;
        private Calendar mTempDate;
        private int mUnfocusedMonthDateColor;
        private float mVelocityScale = 0.333f;
        private int mWeekDayTextAppearanceResId;
        private int mWeekMinVisibleHeight = 12;
        private int mWeekNumberColor;
        private int mWeekSeparatorLineColor;
        private final int mWeekSeperatorLineWidth;

        /*
         * Enabled aggressive block sorting
         */
        LegacyCalendarViewDelegate(CalendarView calendarView, Context context, AttributeSet attributeSet, int n, int n2) {
            super(calendarView, context);
            String string2;
            this.mDateFormat = new SimpleDateFormat(DATE_FORMAT);
            this.setCurrentLocale(Locale.getDefault());
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CalendarView, n, n2);
            this.mShowWeekNumber = typedArray.getBoolean(1, true);
            this.mFirstDayOfWeek = typedArray.getInt(0, LocaleData.get((Locale)Locale.getDefault()).firstDayOfWeek);
            String string3 = typedArray.getString(2);
            if (TextUtils.isEmpty(string3) || !this.parseDate(string3, this.mMinDate)) {
                this.parseDate(DEFAULT_MIN_DATE, this.mMinDate);
            }
            if (TextUtils.isEmpty(string2 = typedArray.getString(3)) || !this.parseDate(string2, this.mMaxDate)) {
                this.parseDate(DEFAULT_MAX_DATE, this.mMaxDate);
            }
            if (this.mMaxDate.before(this.mMinDate)) {
                throw new IllegalArgumentException("Max date cannot be before min date.");
            }
            this.mShownWeekCount = typedArray.getInt(4, 6);
            this.mSelectedWeekBackgroundColor = typedArray.getColor(5, 0);
            this.mFocusedMonthDateColor = typedArray.getColor(6, 0);
            this.mUnfocusedMonthDateColor = typedArray.getColor(7, 0);
            this.mWeekSeparatorLineColor = typedArray.getColor(9, 0);
            this.mWeekNumberColor = typedArray.getColor(8, 0);
            this.mSelectedDateVerticalBar = typedArray.getDrawable(10);
            this.mDateTextAppearanceResId = typedArray.getResourceId(12, 16973894);
            this.updateDateTextSize();
            this.mWeekDayTextAppearanceResId = typedArray.getResourceId(11, -1);
            typedArray.recycle();
            DisplayMetrics displayMetrics = this.mDelegator.getResources().getDisplayMetrics();
            this.mWeekMinVisibleHeight = (int)TypedValue.applyDimension(1, 12.0f, displayMetrics);
            this.mListScrollTopOffset = (int)TypedValue.applyDimension(1, 2.0f, displayMetrics);
            this.mBottomBuffer = (int)TypedValue.applyDimension(1, 20.0f, displayMetrics);
            this.mSelectedDateVerticalBarWidth = (int)TypedValue.applyDimension(1, 6.0f, displayMetrics);
            this.mWeekSeperatorLineWidth = (int)TypedValue.applyDimension(1, 1.0f, displayMetrics);
            View view = ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(17367124, null, false);
            this.mDelegator.addView(view);
            this.mListView = (ListView)this.mDelegator.findViewById(16908298);
            this.mDayNamesHeader = (ViewGroup)view.findViewById(16909091);
            this.mMonthName = (TextView)view.findViewById(16909090);
            this.setUpHeader();
            this.setUpListView();
            this.setUpAdapter();
            this.mTempDate.setTimeInMillis(System.currentTimeMillis());
            if (this.mTempDate.before(this.mMinDate)) {
                this.goTo(this.mMinDate, false, true, true);
            } else if (this.mMaxDate.before(this.mTempDate)) {
                this.goTo(this.mMaxDate, false, true, true);
            } else {
                this.goTo(this.mTempDate, false, true, true);
            }
            this.mDelegator.invalidate();
        }

        static /* synthetic */ int access$1102(LegacyCalendarViewDelegate legacyCalendarViewDelegate, int n) {
            legacyCalendarViewDelegate.mCurrentScrollState = n;
            return n;
        }

        static /* synthetic */ int access$1202(LegacyCalendarViewDelegate legacyCalendarViewDelegate, int n) {
            legacyCalendarViewDelegate.mPreviousScrollState = n;
            return n;
        }

        private static Calendar getCalendarForLocale(Calendar calendar, Locale locale) {
            if (calendar == null) {
                return Calendar.getInstance(locale);
            }
            long l = calendar.getTimeInMillis();
            Calendar calendar2 = Calendar.getInstance(locale);
            calendar2.setTimeInMillis(l);
            return calendar2;
        }

        private int getWeeksSinceMinDate(Calendar calendar) {
            if (calendar.before(this.mMinDate)) {
                throw new IllegalArgumentException("fromDate: " + this.mMinDate.getTime() + " does not precede toDate: " + calendar.getTime());
            }
            long l = calendar.getTimeInMillis() + (long)calendar.getTimeZone().getOffset(calendar.getTimeInMillis());
            long l2 = this.mMinDate.getTimeInMillis() + (long)this.mMinDate.getTimeZone().getOffset(this.mMinDate.getTimeInMillis());
            return (int)((86400000L * (long)(this.mMinDate.get(7) - this.mFirstDayOfWeek) + (l - l2)) / 604800000L);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void goTo(Calendar calendar, boolean bl, boolean bl2, boolean bl3) {
            int n;
            if (calendar.before(this.mMinDate) || calendar.after(this.mMaxDate)) {
                throw new IllegalArgumentException("Time not between " + this.mMinDate.getTime() + " and " + this.mMaxDate.getTime());
            }
            int n2 = this.mListView.getFirstVisiblePosition();
            View view = this.mListView.getChildAt(0);
            if (view != null && view.getTop() < 0) {
                ++n2;
            }
            int n3 = -1 + (n2 + this.mShownWeekCount);
            if (view != null && view.getTop() > this.mBottomBuffer) {
                --n3;
            }
            if (bl2) {
                this.mAdapter.setSelectedDay(calendar);
            }
            if ((n = this.getWeeksSinceMinDate(calendar)) < n2 || n > n3 || bl3) {
                this.mFirstDayOfMonth.setTimeInMillis(calendar.getTimeInMillis());
                this.mFirstDayOfMonth.set(5, 1);
                this.setMonthDisplayed(this.mFirstDayOfMonth);
                int n4 = this.mFirstDayOfMonth.before(this.mMinDate) ? 0 : this.getWeeksSinceMinDate(this.mFirstDayOfMonth);
                this.mPreviousScrollState = 2;
                if (!bl) {
                    this.mListView.setSelectionFromTop(n4, this.mListScrollTopOffset);
                    this.onScrollStateChanged(this.mListView, 0);
                    return;
                }
                this.mListView.smoothScrollToPositionFromTop(n4, this.mListScrollTopOffset, 1000);
                return;
            } else {
                if (!bl2) return;
                this.setMonthDisplayed(calendar);
                return;
            }
        }

        private void invalidateAllWeekViews() {
            int n = this.mListView.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.mListView.getChildAt(i).invalidate();
            }
        }

        private static boolean isSameDate(Calendar calendar, Calendar calendar2) {
            return calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void onScroll(AbsListView absListView, int n, int n2, int n3) {
            long l;
            WeekView weekView;
            block12: {
                block13: {
                    block10: {
                        block11: {
                            weekView = (WeekView)absListView.getChildAt(0);
                            if (weekView == null) break block10;
                            l = absListView.getFirstVisiblePosition() * weekView.getHeight() - weekView.getBottom();
                            if (l >= this.mPreviousScrollPosition) break block11;
                            this.mIsScrollingUp = true;
                            break block12;
                        }
                        if (l > this.mPreviousScrollPosition) break block13;
                    }
                    return;
                }
                this.mIsScrollingUp = false;
            }
            int n4 = weekView.getBottom() < this.mWeekMinVisibleHeight ? 1 : 0;
            if (this.mIsScrollingUp) {
                weekView = (WeekView)absListView.getChildAt(n4 + 2);
            } else if (n4 != 0) {
                weekView = (WeekView)absListView.getChildAt(n4);
            }
            if (weekView != null) {
                int n5 = this.mIsScrollingUp ? weekView.getMonthOfFirstWeekDay() : weekView.getMonthOfLastWeekDay();
                int n6 = this.mCurrentMonthDisplayed == 11 && n5 == 0 ? 1 : (this.mCurrentMonthDisplayed == 0 && n5 == 11 ? -1 : n5 - this.mCurrentMonthDisplayed);
                if (!this.mIsScrollingUp && n6 > 0 || this.mIsScrollingUp && n6 < 0) {
                    Calendar calendar = weekView.getFirstDay();
                    if (this.mIsScrollingUp) {
                        calendar.add(5, -7);
                    } else {
                        calendar.add(5, 7);
                    }
                    this.setMonthDisplayed(calendar);
                }
            }
            this.mPreviousScrollPosition = l;
            this.mPreviousScrollState = this.mCurrentScrollState;
        }

        private void onScrollStateChanged(AbsListView absListView, int n) {
            this.mScrollStateChangedRunnable.doScrollStateChange(absListView, n);
        }

        private boolean parseDate(String string2, Calendar calendar) {
            try {
                calendar.setTime(this.mDateFormat.parse(string2));
                return true;
            }
            catch (ParseException parseException) {
                Log.w(LOG_TAG, "Date: " + string2 + " not in format: " + DATE_FORMAT);
                return false;
            }
        }

        private void setMonthDisplayed(Calendar calendar) {
            this.mCurrentMonthDisplayed = calendar.get(2);
            this.mAdapter.setFocusMonth(this.mCurrentMonthDisplayed);
            long l = calendar.getTimeInMillis();
            String string2 = DateUtils.formatDateRange(this.mContext, l, l, 52);
            this.mMonthName.setText(string2);
            this.mMonthName.invalidate();
        }

        private void setUpAdapter() {
            if (this.mAdapter == null) {
                this.mAdapter = new WeeksAdapter(this.mContext);
                this.mAdapter.registerDataSetObserver(new DataSetObserver(){

                    @Override
                    public void onChanged() {
                        if (LegacyCalendarViewDelegate.this.mOnDateChangeListener != null) {
                            Calendar calendar = LegacyCalendarViewDelegate.this.mAdapter.getSelectedDay();
                            LegacyCalendarViewDelegate.this.mOnDateChangeListener.onSelectedDayChange(LegacyCalendarViewDelegate.this.mDelegator, calendar.get(1), calendar.get(2), calendar.get(5));
                        }
                    }
                });
                this.mListView.setAdapter(this.mAdapter);
            }
            this.mAdapter.notifyDataSetChanged();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setUpHeader() {
            this.mDayLabels = new String[this.mDaysPerWeek];
            int n = this.mFirstDayOfWeek + this.mDaysPerWeek;
            for (int i = this.mFirstDayOfWeek; i < n; ++i) {
                int n2 = i > 7 ? i - 7 : i;
                this.mDayLabels[i - this.mFirstDayOfWeek] = DateUtils.getDayOfWeekString(n2, 50);
            }
            TextView textView = (TextView)this.mDayNamesHeader.getChildAt(0);
            if (this.mShowWeekNumber) {
                textView.setVisibility(0);
            } else {
                textView.setVisibility(8);
            }
            int n3 = 1;
            int n4 = this.mDayNamesHeader.getChildCount();
            while (true) {
                if (n3 >= n4) {
                    this.mDayNamesHeader.invalidate();
                    return;
                }
                TextView textView2 = (TextView)this.mDayNamesHeader.getChildAt(n3);
                if (this.mWeekDayTextAppearanceResId > -1) {
                    textView2.setTextAppearance(this.mContext, this.mWeekDayTextAppearanceResId);
                }
                if (n3 < 1 + this.mDaysPerWeek) {
                    textView2.setText(this.mDayLabels[n3 - 1]);
                    textView2.setVisibility(0);
                } else {
                    textView2.setVisibility(8);
                }
                ++n3;
            }
        }

        private void setUpListView() {
            this.mListView.setDivider(null);
            this.mListView.setItemsCanFocus(true);
            this.mListView.setVerticalScrollBarEnabled(false);
            this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(){

                @Override
                public void onScroll(AbsListView absListView, int n, int n2, int n3) {
                    LegacyCalendarViewDelegate.this.onScroll(absListView, n, n2, n3);
                }

                @Override
                public void onScrollStateChanged(AbsListView absListView, int n) {
                    LegacyCalendarViewDelegate.this.onScrollStateChanged(absListView, n);
                }
            });
            this.mListView.setFriction(this.mFriction);
            this.mListView.setVelocityScale(this.mVelocityScale);
        }

        private void updateDateTextSize() {
            TypedArray typedArray = this.mDelegator.getContext().obtainStyledAttributes(this.mDateTextAppearanceResId, R.styleable.TextAppearance);
            this.mDateTextSize = typedArray.getDimensionPixelSize(0, 14);
            typedArray.recycle();
        }

        @Override
        public long getDate() {
            return this.mAdapter.mSelectedDate.getTimeInMillis();
        }

        @Override
        public int getDateTextAppearance() {
            return this.mDateTextAppearanceResId;
        }

        @Override
        public int getFirstDayOfWeek() {
            return this.mFirstDayOfWeek;
        }

        @Override
        public int getFocusedMonthDateColor() {
            return this.mFocusedMonthDateColor;
        }

        @Override
        public long getMaxDate() {
            return this.mMaxDate.getTimeInMillis();
        }

        @Override
        public long getMinDate() {
            return this.mMinDate.getTimeInMillis();
        }

        @Override
        public Drawable getSelectedDateVerticalBar() {
            return this.mSelectedDateVerticalBar;
        }

        @Override
        public int getSelectedWeekBackgroundColor() {
            return this.mSelectedWeekBackgroundColor;
        }

        @Override
        public boolean getShowWeekNumber() {
            return this.mShowWeekNumber;
        }

        @Override
        public int getShownWeekCount() {
            return this.mShownWeekCount;
        }

        @Override
        public int getUnfocusedMonthDateColor() {
            return this.mFocusedMonthDateColor;
        }

        @Override
        public int getWeekDayTextAppearance() {
            return this.mWeekDayTextAppearanceResId;
        }

        @Override
        public int getWeekNumberColor() {
            return this.mWeekNumberColor;
        }

        @Override
        public int getWeekSeparatorLineColor() {
            return this.mWeekSeparatorLineColor;
        }

        @Override
        public boolean isEnabled() {
            return this.mListView.isEnabled();
        }

        @Override
        public void onConfigurationChanged(Configuration configuration) {
            this.setCurrentLocale(configuration.locale);
        }

        @Override
        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            accessibilityEvent.setClassName(CalendarView.class.getName());
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
            accessibilityNodeInfo.setClassName(CalendarView.class.getName());
        }

        @Override
        protected void setCurrentLocale(Locale locale) {
            super.setCurrentLocale(locale);
            this.mTempDate = LegacyCalendarViewDelegate.getCalendarForLocale(this.mTempDate, locale);
            this.mFirstDayOfMonth = LegacyCalendarViewDelegate.getCalendarForLocale(this.mFirstDayOfMonth, locale);
            this.mMinDate = LegacyCalendarViewDelegate.getCalendarForLocale(this.mMinDate, locale);
            this.mMaxDate = LegacyCalendarViewDelegate.getCalendarForLocale(this.mMaxDate, locale);
        }

        @Override
        public void setDate(long l) {
            this.setDate(l, false, false);
        }

        @Override
        public void setDate(long l, boolean bl, boolean bl2) {
            this.mTempDate.setTimeInMillis(l);
            if (LegacyCalendarViewDelegate.isSameDate(this.mTempDate, this.mAdapter.mSelectedDate)) {
                return;
            }
            this.goTo(this.mTempDate, bl, true, bl2);
        }

        @Override
        public void setDateTextAppearance(int n) {
            if (this.mDateTextAppearanceResId != n) {
                this.mDateTextAppearanceResId = n;
                this.updateDateTextSize();
                this.invalidateAllWeekViews();
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            this.mListView.setEnabled(bl);
        }

        @Override
        public void setFirstDayOfWeek(int n) {
            if (this.mFirstDayOfWeek == n) {
                return;
            }
            this.mFirstDayOfWeek = n;
            this.mAdapter.init();
            this.mAdapter.notifyDataSetChanged();
            this.setUpHeader();
        }

        @Override
        public void setFocusedMonthDateColor(int n) {
            if (this.mFocusedMonthDateColor != n) {
                this.mFocusedMonthDateColor = n;
                int n2 = this.mListView.getChildCount();
                for (int i = 0; i < n2; ++i) {
                    WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                    if (!weekView.mHasFocusedDay) continue;
                    weekView.invalidate();
                }
            }
        }

        @Override
        public void setMaxDate(long l) {
            this.mTempDate.setTimeInMillis(l);
            if (LegacyCalendarViewDelegate.isSameDate(this.mTempDate, this.mMaxDate)) {
                return;
            }
            this.mMaxDate.setTimeInMillis(l);
            this.mAdapter.init();
            Calendar calendar = this.mAdapter.mSelectedDate;
            if (calendar.after(this.mMaxDate)) {
                this.setDate(this.mMaxDate.getTimeInMillis());
                return;
            }
            this.goTo(calendar, false, true, false);
        }

        @Override
        public void setMinDate(long l) {
            this.mTempDate.setTimeInMillis(l);
            if (LegacyCalendarViewDelegate.isSameDate(this.mTempDate, this.mMinDate)) {
                return;
            }
            this.mMinDate.setTimeInMillis(l);
            Calendar calendar = this.mAdapter.mSelectedDate;
            if (calendar.before(this.mMinDate)) {
                this.mAdapter.setSelectedDay(this.mMinDate);
            }
            this.mAdapter.init();
            if (calendar.before(this.mMinDate)) {
                this.setDate(this.mTempDate.getTimeInMillis());
                return;
            }
            this.goTo(calendar, false, true, false);
        }

        @Override
        public void setOnDateChangeListener(OnDateChangeListener onDateChangeListener) {
            this.mOnDateChangeListener = onDateChangeListener;
        }

        @Override
        public void setSelectedDateVerticalBar(int n) {
            this.setSelectedDateVerticalBar(this.mDelegator.getContext().getDrawable(n));
        }

        @Override
        public void setSelectedDateVerticalBar(Drawable drawable2) {
            if (this.mSelectedDateVerticalBar != drawable2) {
                this.mSelectedDateVerticalBar = drawable2;
                int n = this.mListView.getChildCount();
                for (int i = 0; i < n; ++i) {
                    WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                    if (!weekView.mHasSelectedDay) continue;
                    weekView.invalidate();
                }
            }
        }

        @Override
        public void setSelectedWeekBackgroundColor(int n) {
            if (this.mSelectedWeekBackgroundColor != n) {
                this.mSelectedWeekBackgroundColor = n;
                int n2 = this.mListView.getChildCount();
                for (int i = 0; i < n2; ++i) {
                    WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                    if (!weekView.mHasSelectedDay) continue;
                    weekView.invalidate();
                }
            }
        }

        @Override
        public void setShowWeekNumber(boolean bl) {
            if (this.mShowWeekNumber == bl) {
                return;
            }
            this.mShowWeekNumber = bl;
            this.mAdapter.notifyDataSetChanged();
            this.setUpHeader();
        }

        @Override
        public void setShownWeekCount(int n) {
            if (this.mShownWeekCount != n) {
                this.mShownWeekCount = n;
                this.mDelegator.invalidate();
            }
        }

        @Override
        public void setUnfocusedMonthDateColor(int n) {
            if (this.mUnfocusedMonthDateColor != n) {
                this.mUnfocusedMonthDateColor = n;
                int n2 = this.mListView.getChildCount();
                for (int i = 0; i < n2; ++i) {
                    WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                    if (!weekView.mHasUnfocusedDay) continue;
                    weekView.invalidate();
                }
            }
        }

        @Override
        public void setWeekDayTextAppearance(int n) {
            if (this.mWeekDayTextAppearanceResId != n) {
                this.mWeekDayTextAppearanceResId = n;
                this.setUpHeader();
            }
        }

        @Override
        public void setWeekNumberColor(int n) {
            if (this.mWeekNumberColor != n) {
                this.mWeekNumberColor = n;
                if (this.mShowWeekNumber) {
                    this.invalidateAllWeekViews();
                }
            }
        }

        @Override
        public void setWeekSeparatorLineColor(int n) {
            if (this.mWeekSeparatorLineColor != n) {
                this.mWeekSeparatorLineColor = n;
                this.invalidateAllWeekViews();
            }
        }

        private class ScrollStateRunnable
        implements Runnable {
            private int mNewState;
            private AbsListView mView;

            private ScrollStateRunnable() {
            }

            public void doScrollStateChange(AbsListView absListView, int n) {
                this.mView = absListView;
                this.mNewState = n;
                LegacyCalendarViewDelegate.this.mDelegator.removeCallbacks(this);
                LegacyCalendarViewDelegate.this.mDelegator.postDelayed(this, 40L);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                LegacyCalendarViewDelegate.access$1102(LegacyCalendarViewDelegate.this, this.mNewState);
                if (this.mNewState == 0 && LegacyCalendarViewDelegate.this.mPreviousScrollState != 0) {
                    View view = this.mView.getChildAt(0);
                    if (view == null) {
                        return;
                    }
                    int n = view.getBottom() - LegacyCalendarViewDelegate.this.mListScrollTopOffset;
                    if (n > LegacyCalendarViewDelegate.this.mListScrollTopOffset) {
                        if (LegacyCalendarViewDelegate.this.mIsScrollingUp) {
                            this.mView.smoothScrollBy(n - view.getHeight(), 500);
                        } else {
                            this.mView.smoothScrollBy(n, 500);
                        }
                    }
                }
                LegacyCalendarViewDelegate.access$1202(LegacyCalendarViewDelegate.this, this.mNewState);
            }
        }

        private class WeekView
        extends View {
            private String[] mDayNumbers;
            private final Paint mDrawPaint;
            private Calendar mFirstDay;
            private boolean[] mFocusDay;
            private boolean mHasFocusedDay;
            private boolean mHasSelectedDay;
            private boolean mHasUnfocusedDay;
            private int mHeight;
            private int mLastWeekDayMonth;
            private final Paint mMonthNumDrawPaint;
            private int mMonthOfFirstWeekDay;
            private int mNumCells;
            private int mSelectedDay;
            private int mSelectedLeft;
            private int mSelectedRight;
            private final Rect mTempRect;
            private int mWeek;
            private int mWidth;

            public WeekView(Context context) {
                super(context);
                this.mTempRect = new Rect();
                this.mDrawPaint = new Paint();
                this.mMonthNumDrawPaint = new Paint();
                this.mMonthOfFirstWeekDay = -1;
                this.mLastWeekDayMonth = -1;
                this.mWeek = -1;
                this.mHasSelectedDay = false;
                this.mSelectedDay = -1;
                this.mSelectedLeft = -1;
                this.mSelectedRight = -1;
                this.initilaizePaints();
            }

            /*
             * Enabled aggressive block sorting
             */
            private void drawBackground(Canvas canvas) {
                if (!this.mHasSelectedDay) {
                    return;
                }
                this.mDrawPaint.setColor(LegacyCalendarViewDelegate.this.mSelectedWeekBackgroundColor);
                this.mTempRect.top = LegacyCalendarViewDelegate.this.mWeekSeperatorLineWidth;
                this.mTempRect.bottom = this.mHeight;
                boolean bl = this.isLayoutRtl();
                if (bl) {
                    this.mTempRect.left = 0;
                    this.mTempRect.right = -2 + this.mSelectedLeft;
                } else {
                    Rect rect = this.mTempRect;
                    boolean bl2 = LegacyCalendarViewDelegate.this.mShowWeekNumber;
                    int n = 0;
                    if (bl2) {
                        n = this.mWidth / this.mNumCells;
                    }
                    rect.left = n;
                    this.mTempRect.right = -2 + this.mSelectedLeft;
                }
                canvas.drawRect(this.mTempRect, this.mDrawPaint);
                if (bl) {
                    this.mTempRect.left = 3 + this.mSelectedRight;
                    Rect rect = this.mTempRect;
                    int n = LegacyCalendarViewDelegate.this.mShowWeekNumber ? this.mWidth - this.mWidth / this.mNumCells : this.mWidth;
                    rect.right = n;
                } else {
                    this.mTempRect.left = 3 + this.mSelectedRight;
                    this.mTempRect.right = this.mWidth;
                }
                canvas.drawRect(this.mTempRect, this.mDrawPaint);
            }

            private void drawSelectedDateVerticalBars(Canvas canvas) {
                if (!this.mHasSelectedDay) {
                    return;
                }
                LegacyCalendarViewDelegate.this.mSelectedDateVerticalBar.setBounds(this.mSelectedLeft - LegacyCalendarViewDelegate.this.mSelectedDateVerticalBarWidth / 2, LegacyCalendarViewDelegate.this.mWeekSeperatorLineWidth, this.mSelectedLeft + LegacyCalendarViewDelegate.this.mSelectedDateVerticalBarWidth / 2, this.mHeight);
                LegacyCalendarViewDelegate.this.mSelectedDateVerticalBar.draw(canvas);
                LegacyCalendarViewDelegate.this.mSelectedDateVerticalBar.setBounds(this.mSelectedRight - LegacyCalendarViewDelegate.this.mSelectedDateVerticalBarWidth / 2, LegacyCalendarViewDelegate.this.mWeekSeperatorLineWidth, this.mSelectedRight + LegacyCalendarViewDelegate.this.mSelectedDateVerticalBarWidth / 2, this.mHeight);
                LegacyCalendarViewDelegate.this.mSelectedDateVerticalBar.draw(canvas);
            }

            /*
             * Enabled aggressive block sorting
             * Lifted jumps to return sites
             */
            private void drawWeekNumbersAndDates(Canvas canvas) {
                int n;
                int n2 = (int)((this.mDrawPaint.getTextSize() + (float)this.mHeight) / 2.0f) - LegacyCalendarViewDelegate.this.mWeekSeperatorLineWidth;
                int n3 = this.mNumCells;
                int n4 = n3 * 2;
                this.mDrawPaint.setTextAlign(Paint.Align.CENTER);
                this.mDrawPaint.setTextSize(LegacyCalendarViewDelegate.this.mDateTextSize);
                boolean bl = this.isLayoutRtl();
                int n5 = 0;
                if (!bl) {
                    boolean bl2 = LegacyCalendarViewDelegate.this.mShowWeekNumber;
                    n = 0;
                    if (bl2) {
                        this.mDrawPaint.setColor(LegacyCalendarViewDelegate.this.mWeekNumberColor);
                        int n6 = this.mWidth / n4;
                        canvas.drawText(this.mDayNumbers[0], n6, n2, this.mDrawPaint);
                        n = 0 + 1;
                    }
                } else {
                    while (true) {
                        if (n5 >= n3 - 1) {
                            if (!LegacyCalendarViewDelegate.this.mShowWeekNumber) return;
                            this.mDrawPaint.setColor(LegacyCalendarViewDelegate.this.mWeekNumberColor);
                            int n7 = this.mWidth - this.mWidth / n4;
                            canvas.drawText(this.mDayNumbers[0], n7, n2, this.mDrawPaint);
                            return;
                        }
                        Paint paint = this.mMonthNumDrawPaint;
                        int n8 = this.mFocusDay[n5] ? LegacyCalendarViewDelegate.this.mFocusedMonthDateColor : LegacyCalendarViewDelegate.this.mUnfocusedMonthDateColor;
                        paint.setColor(n8);
                        int n9 = (1 + n5 * 2) * this.mWidth / n4;
                        canvas.drawText(this.mDayNumbers[n3 - 1 - n5], n9, n2, this.mMonthNumDrawPaint);
                        ++n5;
                    }
                }
                while (n < n3) {
                    Paint paint = this.mMonthNumDrawPaint;
                    int n10 = this.mFocusDay[n] ? LegacyCalendarViewDelegate.this.mFocusedMonthDateColor : LegacyCalendarViewDelegate.this.mUnfocusedMonthDateColor;
                    paint.setColor(n10);
                    int n11 = (1 + n * 2) * this.mWidth / n4;
                    canvas.drawText(this.mDayNumbers[n], n11, n2, this.mMonthNumDrawPaint);
                    ++n;
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            private void drawWeekSeparators(Canvas canvas) {
                float f;
                float f2;
                int n = LegacyCalendarViewDelegate.this.mListView.getFirstVisiblePosition();
                if (LegacyCalendarViewDelegate.this.mListView.getChildAt(0).getTop() < 0) {
                    ++n;
                }
                if (n == this.mWeek) {
                    return;
                }
                this.mDrawPaint.setColor(LegacyCalendarViewDelegate.this.mWeekSeparatorLineColor);
                this.mDrawPaint.setStrokeWidth(LegacyCalendarViewDelegate.this.mWeekSeperatorLineWidth);
                if (this.isLayoutRtl()) {
                    f2 = 0.0f;
                    if (LegacyCalendarViewDelegate.this.mShowWeekNumber) {
                        f = this.mWidth - this.mWidth / this.mNumCells;
                    } else {
                        f = this.mWidth;
                        f2 = 0.0f;
                    }
                } else {
                    f2 = LegacyCalendarViewDelegate.this.mShowWeekNumber ? (float)(this.mWidth / this.mNumCells) : 0.0f;
                    f = this.mWidth;
                }
                canvas.drawLine(f2, 0.0f, f, 0.0f, this.mDrawPaint);
            }

            private void initilaizePaints() {
                this.mDrawPaint.setFakeBoldText(false);
                this.mDrawPaint.setAntiAlias(true);
                this.mDrawPaint.setStyle(Paint.Style.FILL);
                this.mMonthNumDrawPaint.setFakeBoldText(true);
                this.mMonthNumDrawPaint.setAntiAlias(true);
                this.mMonthNumDrawPaint.setStyle(Paint.Style.FILL);
                this.mMonthNumDrawPaint.setTextAlign(Paint.Align.CENTER);
                this.mMonthNumDrawPaint.setTextSize(LegacyCalendarViewDelegate.this.mDateTextSize);
            }

            /*
             * Enabled aggressive block sorting
             */
            private void updateSelectionPositions() {
                if (this.mHasSelectedDay) {
                    boolean bl = this.isLayoutRtl();
                    int n = this.mSelectedDay - LegacyCalendarViewDelegate.this.mFirstDayOfWeek;
                    if (n < 0) {
                        n += 7;
                    }
                    if (LegacyCalendarViewDelegate.this.mShowWeekNumber && !bl) {
                        ++n;
                    }
                    this.mSelectedLeft = bl ? (-1 + LegacyCalendarViewDelegate.this.mDaysPerWeek - n) * this.mWidth / this.mNumCells : n * this.mWidth / this.mNumCells;
                    this.mSelectedRight = this.mSelectedLeft + this.mWidth / this.mNumCells;
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            public boolean getDayFromLocation(float f, Calendar calendar) {
                int n;
                int n2;
                boolean bl = this.isLayoutRtl();
                if (bl) {
                    n2 = 0;
                    if (LegacyCalendarViewDelegate.this.mShowWeekNumber) {
                        n = this.mWidth - this.mWidth / this.mNumCells;
                    } else {
                        n = this.mWidth;
                        n2 = 0;
                    }
                } else {
                    n2 = LegacyCalendarViewDelegate.this.mShowWeekNumber ? this.mWidth / this.mNumCells : 0;
                    n = this.mWidth;
                }
                if (f < (float)n2 || f > (float)n) {
                    calendar.clear();
                    return false;
                }
                int n3 = (int)((f - (float)n2) * (float)LegacyCalendarViewDelegate.this.mDaysPerWeek / (float)(n - n2));
                if (bl) {
                    n3 = -1 + LegacyCalendarViewDelegate.this.mDaysPerWeek - n3;
                }
                calendar.setTimeInMillis(this.mFirstDay.getTimeInMillis());
                calendar.add(5, n3);
                return true;
            }

            public Calendar getFirstDay() {
                return this.mFirstDay;
            }

            public int getMonthOfFirstWeekDay() {
                return this.mMonthOfFirstWeekDay;
            }

            public int getMonthOfLastWeekDay() {
                return this.mLastWeekDayMonth;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void init(int n, int n2, int n3) {
                this.mSelectedDay = n2;
                boolean bl = this.mSelectedDay != -1;
                this.mHasSelectedDay = bl;
                int n4 = LegacyCalendarViewDelegate.this.mShowWeekNumber ? 1 + LegacyCalendarViewDelegate.this.mDaysPerWeek : LegacyCalendarViewDelegate.this.mDaysPerWeek;
                this.mNumCells = n4;
                this.mWeek = n;
                LegacyCalendarViewDelegate.this.mTempDate.setTimeInMillis(LegacyCalendarViewDelegate.this.mMinDate.getTimeInMillis());
                LegacyCalendarViewDelegate.this.mTempDate.add(3, this.mWeek);
                LegacyCalendarViewDelegate.this.mTempDate.setFirstDayOfWeek(LegacyCalendarViewDelegate.this.mFirstDayOfWeek);
                this.mDayNumbers = new String[this.mNumCells];
                this.mFocusDay = new boolean[this.mNumCells];
                boolean bl2 = LegacyCalendarViewDelegate.this.mShowWeekNumber;
                int n5 = 0;
                if (bl2) {
                    String[] stringArray = this.mDayNumbers;
                    Locale locale = Locale.getDefault();
                    Object[] objectArray = new Object[]{LegacyCalendarViewDelegate.this.mTempDate.get(3)};
                    stringArray[0] = String.format(locale, "%d", objectArray);
                    n5 = 0 + 1;
                }
                int n6 = LegacyCalendarViewDelegate.this.mFirstDayOfWeek - LegacyCalendarViewDelegate.this.mTempDate.get(7);
                LegacyCalendarViewDelegate.this.mTempDate.add(5, n6);
                this.mFirstDay = (Calendar)LegacyCalendarViewDelegate.this.mTempDate.clone();
                this.mMonthOfFirstWeekDay = LegacyCalendarViewDelegate.this.mTempDate.get(2);
                this.mHasUnfocusedDay = true;
                while (n5 < this.mNumCells) {
                    boolean bl3 = LegacyCalendarViewDelegate.this.mTempDate.get(2) == n3;
                    this.mFocusDay[n5] = bl3;
                    this.mHasFocusedDay = bl3 | this.mHasFocusedDay;
                    boolean bl4 = this.mHasUnfocusedDay;
                    boolean bl5 = !bl3;
                    this.mHasUnfocusedDay = bl5 & bl4;
                    if (LegacyCalendarViewDelegate.this.mTempDate.before(LegacyCalendarViewDelegate.this.mMinDate) || LegacyCalendarViewDelegate.this.mTempDate.after(LegacyCalendarViewDelegate.this.mMaxDate)) {
                        this.mDayNumbers[n5] = "";
                    } else {
                        String[] stringArray = this.mDayNumbers;
                        Locale locale = Locale.getDefault();
                        Object[] objectArray = new Object[]{LegacyCalendarViewDelegate.this.mTempDate.get(5)};
                        stringArray[n5] = String.format(locale, "%d", objectArray);
                    }
                    LegacyCalendarViewDelegate.this.mTempDate.add(5, 1);
                    ++n5;
                }
                if (LegacyCalendarViewDelegate.this.mTempDate.get(5) == 1) {
                    LegacyCalendarViewDelegate.this.mTempDate.add(5, -1);
                }
                this.mLastWeekDayMonth = LegacyCalendarViewDelegate.this.mTempDate.get(2);
                this.updateSelectionPositions();
            }

            @Override
            protected void onDraw(Canvas canvas) {
                this.drawBackground(canvas);
                this.drawWeekNumbersAndDates(canvas);
                this.drawWeekSeparators(canvas);
                this.drawSelectedDateVerticalBars(canvas);
            }

            @Override
            protected void onMeasure(int n, int n2) {
                this.mHeight = (LegacyCalendarViewDelegate.this.mListView.getHeight() - LegacyCalendarViewDelegate.this.mListView.getPaddingTop() - LegacyCalendarViewDelegate.this.mListView.getPaddingBottom()) / LegacyCalendarViewDelegate.this.mShownWeekCount;
                this.setMeasuredDimension(View.MeasureSpec.getSize(n), this.mHeight);
            }

            @Override
            protected void onSizeChanged(int n, int n2, int n3, int n4) {
                this.mWidth = n;
                this.updateSelectionPositions();
            }
        }

        private class WeeksAdapter
        extends BaseAdapter
        implements View.OnTouchListener {
            private int mFocusedMonth;
            private GestureDetector mGestureDetector;
            private final Calendar mSelectedDate = Calendar.getInstance();
            private int mSelectedWeek;
            private int mTotalWeekCount;

            public WeeksAdapter(Context context) {
                LegacyCalendarViewDelegate.this.mContext = context;
                this.mGestureDetector = new GestureDetector(LegacyCalendarViewDelegate.this.mContext, new CalendarGestureListener());
                this.init();
            }

            private void init() {
                this.mSelectedWeek = LegacyCalendarViewDelegate.this.getWeeksSinceMinDate(this.mSelectedDate);
                this.mTotalWeekCount = LegacyCalendarViewDelegate.this.getWeeksSinceMinDate(LegacyCalendarViewDelegate.this.mMaxDate);
                if (LegacyCalendarViewDelegate.this.mMinDate.get(7) != LegacyCalendarViewDelegate.this.mFirstDayOfWeek || LegacyCalendarViewDelegate.this.mMaxDate.get(7) != LegacyCalendarViewDelegate.this.mFirstDayOfWeek) {
                    this.mTotalWeekCount = 1 + this.mTotalWeekCount;
                }
                this.notifyDataSetChanged();
            }

            private void onDateTapped(Calendar calendar) {
                this.setSelectedDay(calendar);
                LegacyCalendarViewDelegate.this.setMonthDisplayed(calendar);
            }

            @Override
            public int getCount() {
                return this.mTotalWeekCount;
            }

            @Override
            public Object getItem(int n) {
                return null;
            }

            @Override
            public long getItemId(int n) {
                return n;
            }

            public Calendar getSelectedDay() {
                return this.mSelectedDate;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public View getView(int n, View view, ViewGroup viewGroup) {
                WeekView weekView;
                if (view != null) {
                    weekView = (WeekView)view;
                } else {
                    weekView = new WeekView(LegacyCalendarViewDelegate.this.mContext);
                    weekView.setLayoutParams(new AbsListView.LayoutParams(-2, -2));
                    weekView.setClickable(true);
                    weekView.setOnTouchListener(this);
                }
                int n2 = this.mSelectedWeek == n ? this.mSelectedDate.get(7) : -1;
                weekView.init(n, n2, this.mFocusedMonth);
                return weekView;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (LegacyCalendarViewDelegate.this.mListView.isEnabled() && this.mGestureDetector.onTouchEvent(motionEvent)) {
                    if (!((WeekView)view).getDayFromLocation(motionEvent.getX(), LegacyCalendarViewDelegate.this.mTempDate) || LegacyCalendarViewDelegate.this.mTempDate.before(LegacyCalendarViewDelegate.this.mMinDate) || LegacyCalendarViewDelegate.this.mTempDate.after(LegacyCalendarViewDelegate.this.mMaxDate)) {
                        return true;
                    }
                    this.onDateTapped(LegacyCalendarViewDelegate.this.mTempDate);
                    return true;
                }
                return false;
            }

            public void setFocusMonth(int n) {
                if (this.mFocusedMonth == n) {
                    return;
                }
                this.mFocusedMonth = n;
                this.notifyDataSetChanged();
            }

            public void setSelectedDay(Calendar calendar) {
                if (calendar.get(6) == this.mSelectedDate.get(6) && calendar.get(1) == this.mSelectedDate.get(1)) {
                    return;
                }
                this.mSelectedDate.setTimeInMillis(calendar.getTimeInMillis());
                this.mSelectedWeek = LegacyCalendarViewDelegate.this.getWeeksSinceMinDate(this.mSelectedDate);
                this.mFocusedMonth = this.mSelectedDate.get(2);
                this.notifyDataSetChanged();
            }

            class CalendarGestureListener
            extends GestureDetector.SimpleOnGestureListener {
                CalendarGestureListener() {
                }

                @Override
                public boolean onSingleTapUp(MotionEvent motionEvent) {
                    return true;
                }
            }
        }
    }

    public static interface OnDateChangeListener {
        public void onSelectedDayChange(CalendarView var1, int var2, int var3, int var4);
    }
}

