/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.IntProperty;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.widget.AutoScrollHelper;

public class ListPopupWindow {
    private static final boolean DEBUG = false;
    private static final int EXPAND_LIST_TIMEOUT = 250;
    public static final int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static final int INPUT_METHOD_NEEDED = 1;
    public static final int INPUT_METHOD_NOT_NEEDED = 2;
    public static final int MATCH_PARENT = -1;
    public static final int POSITION_PROMPT_ABOVE = 0;
    public static final int POSITION_PROMPT_BELOW = 1;
    private static final String TAG = "ListPopupWindow";
    public static final int WRAP_CONTENT = -2;
    private ListAdapter mAdapter;
    private Context mContext;
    private boolean mDropDownAlwaysVisible = false;
    private View mDropDownAnchorView;
    private int mDropDownGravity = 0;
    private int mDropDownHeight = -2;
    private int mDropDownHorizontalOffset;
    private DropDownListView mDropDownList;
    private Drawable mDropDownListHighlight;
    private int mDropDownVerticalOffset;
    private boolean mDropDownVerticalOffsetSet;
    private int mDropDownWidth = -2;
    private boolean mForceIgnoreOutsideTouch = false;
    private Handler mHandler;
    private final ListSelectorHider mHideSelector;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private int mLayoutDirection;
    int mListItemExpandMaximum = Integer.MAX_VALUE;
    private boolean mModal;
    private DataSetObserver mObserver;
    private PopupWindow mPopup;
    private int mPromptPosition = 0;
    private View mPromptView;
    private final ResizePopupRunnable mResizePopupRunnable = new ResizePopupRunnable();
    private final PopupScrollListener mScrollListener;
    private Runnable mShowDropDownRunnable;
    private Rect mTempRect;
    private final PopupTouchInterceptor mTouchInterceptor = new PopupTouchInterceptor();

    public ListPopupWindow(Context context) {
        this(context, null, 16843519, 0);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843519, 0);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int n, int n2) {
        this.mScrollListener = new PopupScrollListener();
        this.mHideSelector = new ListSelectorHider();
        this.mHandler = new Handler();
        this.mTempRect = new Rect();
        this.mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ListPopupWindow, n, n2);
        this.mDropDownHorizontalOffset = typedArray.getDimensionPixelOffset(0, 0);
        this.mDropDownVerticalOffset = typedArray.getDimensionPixelOffset(1, 0);
        if (this.mDropDownVerticalOffset != 0) {
            this.mDropDownVerticalOffsetSet = true;
        }
        typedArray.recycle();
        this.mPopup = new PopupWindow(context, attributeSet, n, n2);
        this.mPopup.setInputMethodMode(1);
        this.mLayoutDirection = TextUtils.getLayoutDirectionFromLocale(this.mContext.getResources().getConfiguration().locale);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private int buildDropDown() {
        int n;
        int n2;
        int n3;
        Drawable drawable2;
        int n4;
        if (this.mDropDownList == null) {
            void var14_5;
            Context context = this.mContext;
            this.mShowDropDownRunnable = new Runnable(){

                @Override
                public void run() {
                    View view = ListPopupWindow.this.getAnchorView();
                    if (view != null && view.getWindowToken() != null) {
                        ListPopupWindow.this.show();
                    }
                }
            };
            boolean bl = !this.mModal;
            this.mDropDownList = new DropDownListView(context, bl);
            if (this.mDropDownListHighlight != null) {
                this.mDropDownList.setSelector(this.mDropDownListHighlight);
            }
            this.mDropDownList.setAdapter(this.mAdapter);
            this.mDropDownList.setOnItemClickListener(this.mItemClickListener);
            this.mDropDownList.setFocusable(true);
            this.mDropDownList.setFocusableInTouchMode(true);
            this.mDropDownList.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                @Override
                public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
                    DropDownListView dropDownListView;
                    if (n != -1 && (dropDownListView = ListPopupWindow.this.mDropDownList) != null) {
                        DropDownListView.access$502(dropDownListView, false);
                    }
                }

                @Override
                public void onNothingSelected(AdapterView<?> adapterView) {
                }
            });
            this.mDropDownList.setOnScrollListener(this.mScrollListener);
            if (this.mItemSelectedListener != null) {
                this.mDropDownList.setOnItemSelectedListener(this.mItemSelectedListener);
            }
            DropDownListView dropDownListView = this.mDropDownList;
            View view = this.mPromptView;
            n4 = 0;
            if (view != null) {
                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(1);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                switch (this.mPromptPosition) {
                    default: {
                        Log.e(TAG, "Invalid hint position " + this.mPromptPosition);
                        break;
                    }
                    case 1: {
                        linearLayout.addView((View)dropDownListView, layoutParams);
                        linearLayout.addView(view);
                        break;
                    }
                    case 0: {
                        linearLayout.addView(view);
                        linearLayout.addView((View)dropDownListView, layoutParams);
                        break;
                    }
                }
                view.measure(View.MeasureSpec.makeMeasureSpec(this.mDropDownWidth, Integer.MIN_VALUE), 0);
                LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams)view.getLayoutParams();
                n4 = view.getMeasuredHeight() + layoutParams2.topMargin + layoutParams2.bottomMargin;
                LinearLayout linearLayout2 = linearLayout;
            }
            this.mPopup.setContentView((View)var14_5);
        } else {
            ViewGroup cfr_ignored_0 = (ViewGroup)this.mPopup.getContentView();
            View view = this.mPromptView;
            n4 = 0;
            if (view != null) {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                n4 = view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            }
        }
        if ((drawable2 = this.mPopup.getBackground()) != null) {
            drawable2.getPadding(this.mTempRect);
            n3 = this.mTempRect.top + this.mTempRect.bottom;
            if (!this.mDropDownVerticalOffsetSet) {
                this.mDropDownVerticalOffset = -this.mTempRect.top;
            }
        } else {
            this.mTempRect.setEmpty();
            n3 = 0;
        }
        boolean bl = this.mPopup.getInputMethodMode() == 2;
        int n5 = this.mPopup.getMaxAvailableHeight(this.getAnchorView(), this.mDropDownVerticalOffset, bl);
        if (this.mDropDownAlwaysVisible || this.mDropDownHeight == -1) {
            return n5 + n3;
        }
        switch (this.mDropDownWidth) {
            default: {
                n2 = View.MeasureSpec.makeMeasureSpec(this.mDropDownWidth, 0x40000000);
                break;
            }
            case -2: {
                n2 = View.MeasureSpec.makeMeasureSpec(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right), Integer.MIN_VALUE);
                break;
            }
            case -1: {
                n2 = View.MeasureSpec.makeMeasureSpec(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right), 0x40000000);
            }
        }
        if ((n = this.mDropDownList.measureHeightOfChildren(n2, 0, -1, n5 - n4, -1)) > 0) {
            n4 += n3;
        }
        return n + n4;
    }

    private void removePromptView() {
        ViewParent viewParent;
        if (this.mPromptView != null && (viewParent = this.mPromptView.getParent()) instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.mPromptView);
        }
    }

    public void clearListSelection() {
        DropDownListView dropDownListView = this.mDropDownList;
        if (dropDownListView != null) {
            DropDownListView.access$502(dropDownListView, true);
            dropDownListView.hideSelector();
            dropDownListView.requestLayout();
        }
    }

    public View.OnTouchListener createDragToOpenListener(View view) {
        return new ForwardingListener(view){

            @Override
            public ListPopupWindow getPopup() {
                return ListPopupWindow.this;
            }
        };
    }

    public void dismiss() {
        this.mPopup.dismiss();
        this.removePromptView();
        this.mPopup.setContentView(null);
        this.mDropDownList = null;
        this.mHandler.removeCallbacks(this.mResizePopupRunnable);
    }

    public View getAnchorView() {
        return this.mDropDownAnchorView;
    }

    public int getAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    public Drawable getBackground() {
        return this.mPopup.getBackground();
    }

    public int getHeight() {
        return this.mDropDownHeight;
    }

    public int getHorizontalOffset() {
        return this.mDropDownHorizontalOffset;
    }

    public int getInputMethodMode() {
        return this.mPopup.getInputMethodMode();
    }

    public ListView getListView() {
        return this.mDropDownList;
    }

    public int getPromptPosition() {
        return this.mPromptPosition;
    }

    public Object getSelectedItem() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedItem();
    }

    public long getSelectedItemId() {
        if (!this.isShowing()) {
            return Long.MIN_VALUE;
        }
        return this.mDropDownList.getSelectedItemId();
    }

    public int getSelectedItemPosition() {
        if (!this.isShowing()) {
            return -1;
        }
        return this.mDropDownList.getSelectedItemPosition();
    }

    public View getSelectedView() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedView();
    }

    public int getSoftInputMode() {
        return this.mPopup.getSoftInputMode();
    }

    public int getVerticalOffset() {
        if (!this.mDropDownVerticalOffsetSet) {
            return 0;
        }
        return this.mDropDownVerticalOffset;
    }

    public int getWidth() {
        return this.mDropDownWidth;
    }

    public boolean isDropDownAlwaysVisible() {
        return this.mDropDownAlwaysVisible;
    }

    public boolean isInputMethodNotNeeded() {
        return this.mPopup.getInputMethodMode() == 2;
    }

    public boolean isModal() {
        return this.mModal;
    }

    public boolean isShowing() {
        return this.mPopup.isShowing();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.isShowing()) return false;
        if (n == 62) return false;
        if (this.mDropDownList.getSelectedItemPosition() < 0) {
            if (KeyEvent.isConfirmKey(n)) return false;
        }
        int n2 = this.mDropDownList.getSelectedItemPosition();
        boolean bl = !this.mPopup.isAboveAnchor();
        ListAdapter listAdapter = this.mAdapter;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        if (listAdapter != null) {
            boolean bl2 = listAdapter.areAllItemsEnabled();
            n3 = bl2 ? 0 : this.mDropDownList.lookForSelectablePosition(0, true);
            n4 = bl2 ? -1 + listAdapter.getCount() : this.mDropDownList.lookForSelectablePosition(-1 + listAdapter.getCount(), false);
        }
        if (bl && n == 19 && n2 <= n3 || !bl && n == 20 && n2 >= n4) {
            this.clearListSelection();
            this.mPopup.setInputMethodMode(1);
            this.show();
            return true;
        }
        DropDownListView.access$502(this.mDropDownList, false);
        if (this.mDropDownList.onKeyDown(n, keyEvent)) {
            this.mPopup.setInputMethodMode(2);
            this.mDropDownList.requestFocusFromTouch();
            this.show();
            switch (n) {
                case 19: 
                case 20: 
                case 23: 
                case 66: {
                    return true;
                }
            }
            return false;
        }
        if (bl && n == 20) {
            if (n2 != n4) return false;
            return true;
        }
        if (bl) return false;
        if (n != 19) return false;
        if (n2 != n3) return false;
        return true;
    }

    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        if (n == 4 && this.isShowing()) {
            View view = this.mDropDownAnchorView;
            if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                KeyEvent.DispatcherState dispatcherState = view.getKeyDispatcherState();
                if (dispatcherState != null) {
                    dispatcherState.startTracking(keyEvent, this);
                }
                return true;
            }
            if (keyEvent.getAction() == 1) {
                KeyEvent.DispatcherState dispatcherState = view.getKeyDispatcherState();
                if (dispatcherState != null) {
                    dispatcherState.handleUpEvent(keyEvent);
                }
                if (keyEvent.isTracking() && !keyEvent.isCanceled()) {
                    this.dismiss();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (this.isShowing() && this.mDropDownList.getSelectedItemPosition() >= 0) {
            boolean bl = this.mDropDownList.onKeyUp(n, keyEvent);
            if (bl && KeyEvent.isConfirmKey(n)) {
                this.dismiss();
            }
            return bl;
        }
        return false;
    }

    public boolean performItemClick(int n) {
        if (this.isShowing()) {
            if (this.mItemClickListener != null) {
                DropDownListView dropDownListView = this.mDropDownList;
                View view = dropDownListView.getChildAt(n - dropDownListView.getFirstVisiblePosition());
                Adapter adapter = dropDownListView.getAdapter();
                this.mItemClickListener.onItemClick(dropDownListView, view, n, adapter.getItemId(n));
            }
            return true;
        }
        return false;
    }

    public void postShow() {
        this.mHandler.post(this.mShowDropDownRunnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAdapter(ListAdapter listAdapter) {
        if (this.mObserver == null) {
            this.mObserver = new PopupDataSetObserver();
        } else if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
        }
        this.mAdapter = listAdapter;
        if (this.mAdapter != null) {
            listAdapter.registerDataSetObserver(this.mObserver);
        }
        if (this.mDropDownList != null) {
            this.mDropDownList.setAdapter(this.mAdapter);
        }
    }

    public void setAnchorView(View view) {
        this.mDropDownAnchorView = view;
    }

    public void setAnimationStyle(int n) {
        this.mPopup.setAnimationStyle(n);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.mPopup.setBackgroundDrawable(drawable2);
    }

    public void setContentWidth(int n) {
        Drawable drawable2 = this.mPopup.getBackground();
        if (drawable2 != null) {
            drawable2.getPadding(this.mTempRect);
            this.mDropDownWidth = n + (this.mTempRect.left + this.mTempRect.right);
            return;
        }
        this.setWidth(n);
    }

    public void setDropDownAlwaysVisible(boolean bl) {
        this.mDropDownAlwaysVisible = bl;
    }

    public void setDropDownGravity(int n) {
        this.mDropDownGravity = n;
    }

    public void setForceIgnoreOutsideTouch(boolean bl) {
        this.mForceIgnoreOutsideTouch = bl;
    }

    public void setHeight(int n) {
        this.mDropDownHeight = n;
    }

    public void setHorizontalOffset(int n) {
        this.mDropDownHorizontalOffset = n;
    }

    public void setInputMethodMode(int n) {
        this.mPopup.setInputMethodMode(n);
    }

    void setListItemExpandMax(int n) {
        this.mListItemExpandMaximum = n;
    }

    public void setListSelector(Drawable drawable2) {
        this.mDropDownListHighlight = drawable2;
    }

    public void setModal(boolean bl) {
        this.mModal = bl;
        this.mPopup.setFocusable(bl);
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.mPopup.setOnDismissListener(onDismissListener);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.mItemClickListener = onItemClickListener;
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        this.mItemSelectedListener = onItemSelectedListener;
    }

    public void setPromptPosition(int n) {
        this.mPromptPosition = n;
    }

    public void setPromptView(View view) {
        boolean bl = this.isShowing();
        if (bl) {
            this.removePromptView();
        }
        this.mPromptView = view;
        if (bl) {
            this.show();
        }
    }

    public void setSelection(int n) {
        DropDownListView dropDownListView = this.mDropDownList;
        if (this.isShowing() && dropDownListView != null) {
            DropDownListView.access$502(dropDownListView, false);
            dropDownListView.setSelection(n);
            if (dropDownListView.getChoiceMode() != 0) {
                dropDownListView.setItemChecked(n, true);
            }
        }
    }

    public void setSoftInputMode(int n) {
        this.mPopup.setSoftInputMode(n);
    }

    public void setVerticalOffset(int n) {
        this.mDropDownVerticalOffset = n;
        this.mDropDownVerticalOffsetSet = true;
    }

    public void setWidth(int n) {
        this.mDropDownWidth = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void show() {
        int n;
        int n2;
        boolean bl = true;
        int n3 = this.buildDropDown();
        boolean bl2 = this.isInputMethodNotNeeded();
        PopupWindow popupWindow = this.mPopup;
        boolean bl3 = !bl2 ? bl : false;
        popupWindow.setAllowScrollingAnchorParent(bl3);
        if (this.mPopup.isShowing()) {
            int n4;
            int n5 = this.mDropDownWidth == -1 ? -1 : (this.mDropDownWidth == -2 ? this.getAnchorView().getWidth() : this.mDropDownWidth);
            if (this.mDropDownHeight == -1) {
                n4 = bl2 ? n3 : -1;
                if (bl2) {
                    PopupWindow popupWindow2 = this.mPopup;
                    int n6 = this.mDropDownWidth == -1 ? -1 : 0;
                    popupWindow2.setWindowLayoutMode(n6, 0);
                } else {
                    PopupWindow popupWindow3 = this.mPopup;
                    int n7 = this.mDropDownWidth == -1 ? -1 : 0;
                    popupWindow3.setWindowLayoutMode(n7, -1);
                }
            } else {
                n4 = this.mDropDownHeight == -2 ? n3 : this.mDropDownHeight;
            }
            PopupWindow popupWindow4 = this.mPopup;
            if (this.mForceIgnoreOutsideTouch || this.mDropDownAlwaysVisible) {
                bl = false;
            }
            popupWindow4.setOutsideTouchable(bl);
            this.mPopup.update(this.getAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset, n5, n4);
            return;
        }
        if (this.mDropDownWidth == -1) {
            n2 = -1;
        } else if (this.mDropDownWidth == -2) {
            this.mPopup.setWidth(this.getAnchorView().getWidth());
            n2 = 0;
        } else {
            this.mPopup.setWidth(this.mDropDownWidth);
            n2 = 0;
        }
        if (this.mDropDownHeight == -1) {
            n = -1;
        } else if (this.mDropDownHeight == -2) {
            this.mPopup.setHeight(n3);
            n = 0;
        } else {
            this.mPopup.setHeight(this.mDropDownHeight);
            n = 0;
        }
        this.mPopup.setWindowLayoutMode(n2, n);
        this.mPopup.setClipToScreenEnabled(bl);
        PopupWindow popupWindow5 = this.mPopup;
        if (this.mForceIgnoreOutsideTouch || this.mDropDownAlwaysVisible) {
            bl = false;
        }
        popupWindow5.setOutsideTouchable(bl);
        this.mPopup.setTouchInterceptor(this.mTouchInterceptor);
        this.mPopup.showAsDropDown(this.getAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset, this.mDropDownGravity);
        this.mDropDownList.setSelection(-1);
        if (!this.mModal || this.mDropDownList.isInTouchMode()) {
            this.clearListSelection();
        }
        if (this.mModal) return;
        this.mHandler.post(this.mHideSelector);
    }

    private static class DropDownListView
    extends ListView {
        private static final int CLICK_ANIM_ALPHA = 128;
        private static final long CLICK_ANIM_DURATION = 150L;
        private static final IntProperty<Drawable> DRAWABLE_ALPHA = new IntProperty<Drawable>("alpha"){

            @Override
            public Integer get(Drawable drawable2) {
                return drawable2.getAlpha();
            }

            @Override
            public void setValue(Drawable drawable2, int n) {
                drawable2.setAlpha(n);
            }
        };
        private Animator mClickAnimation;
        private boolean mDrawsInPressedState;
        private boolean mHijackFocus;
        private boolean mListSelectionHidden;
        private AutoScrollHelper.AbsListViewAutoScroller mScrollHelper;

        public DropDownListView(Context context, boolean bl) {
            super(context, null, 16842861);
            this.mHijackFocus = bl;
            this.setCacheColorHint(0);
        }

        static /* synthetic */ boolean access$502(DropDownListView dropDownListView, boolean bl) {
            dropDownListView.mListSelectionHidden = bl;
            return bl;
        }

        private void clearPressedItem() {
            this.mDrawsInPressedState = false;
            this.setPressed(false);
            this.updateSelectorState();
            if (this.mClickAnimation != null) {
                this.mClickAnimation.cancel();
                this.mClickAnimation = null;
            }
        }

        private void clickPressedItem(final View view, final int n) {
            final long l = this.getItemIdAtPosition(n);
            ObjectAnimator objectAnimator = ObjectAnimator.ofInt(this.mSelector, DRAWABLE_ALPHA, 255, 128, 255);
            ((Animator)objectAnimator).setDuration(150L);
            ((Animator)objectAnimator).setInterpolator(new AccelerateDecelerateInterpolator());
            objectAnimator.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animator2) {
                    DropDownListView.this.performItemClick(view, n, l);
                }
            });
            ((Animator)objectAnimator).start();
            if (this.mClickAnimation != null) {
                this.mClickAnimation.cancel();
            }
            this.mClickAnimation = objectAnimator;
        }

        private void setPressedItem(View view, int n, float f, float f2) {
            this.mDrawsInPressedState = true;
            this.setPressed(true);
            this.layoutChildren();
            this.setSelectedPositionInt(n);
            this.positionSelectorLikeTouch(n, view, f, f2);
            this.refreshDrawableState();
            if (this.mClickAnimation != null) {
                this.mClickAnimation.cancel();
                this.mClickAnimation = null;
            }
        }

        @Override
        public boolean hasFocus() {
            return this.mHijackFocus || super.hasFocus();
        }

        @Override
        public boolean hasWindowFocus() {
            return this.mHijackFocus || super.hasWindowFocus();
        }

        @Override
        public boolean isFocused() {
            return this.mHijackFocus || super.isFocused();
        }

        @Override
        public boolean isInTouchMode() {
            return this.mHijackFocus && this.mListSelectionHidden || super.isInTouchMode();
        }

        @Override
        View obtainView(int n, boolean[] blArray) {
            View view = super.obtainView(n, blArray);
            if (view instanceof TextView) {
                ((TextView)view).setHorizontallyScrolling(true);
            }
            return view;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean onForwardedEvent(MotionEvent motionEvent, int n) {
            boolean bl = true;
            int n2 = motionEvent.getActionMasked();
            boolean bl2 = false;
            switch (n2) {
                case 3: {
                    bl2 = false;
                    bl = false;
                    break;
                }
                case 1: {
                    bl = false;
                }
                case 2: {
                    int n3;
                    int n4 = motionEvent.findPointerIndex(n);
                    if (n4 < 0) {
                        bl2 = false;
                        bl = false;
                        break;
                    }
                    int n5 = (int)motionEvent.getX(n4);
                    int n6 = this.pointToPosition(n5, n3 = (int)motionEvent.getY(n4));
                    if (n6 == -1) {
                        bl2 = true;
                        break;
                    }
                    View view = this.getChildAt(n6 - this.getFirstVisiblePosition());
                    this.setPressedItem(view, n6, n5, n3);
                    bl = true;
                    bl2 = false;
                    if (n2 != 1) break;
                    this.clickPressedItem(view, n6);
                    bl2 = false;
                }
            }
            if (!bl || bl2) {
                this.clearPressedItem();
            }
            if (bl) {
                if (this.mScrollHelper == null) {
                    this.mScrollHelper = new AutoScrollHelper.AbsListViewAutoScroller(this);
                }
                this.mScrollHelper.setEnabled(true);
                this.mScrollHelper.onTouch(this, motionEvent);
                return bl;
            } else {
                if (this.mScrollHelper == null) return bl;
                this.mScrollHelper.setEnabled(false);
                return bl;
            }
        }

        @Override
        boolean touchModeDrawsInPressedState() {
            return this.mDrawsInPressedState || super.touchModeDrawsInPressedState();
        }
    }

    public static abstract class ForwardingListener
    implements View.OnTouchListener,
    View.OnAttachStateChangeListener {
        private int mActivePointerId;
        private Runnable mDisallowIntercept;
        private boolean mForwarding;
        private final int mLongPressTimeout;
        private final float mScaledTouchSlop;
        private final View mSrc;
        private final int mTapTimeout;
        private Runnable mTriggerLongPress;
        private boolean mWasLongPress;

        public ForwardingListener(View view) {
            this.mSrc = view;
            this.mScaledTouchSlop = ViewConfiguration.get(view.getContext()).getScaledTouchSlop();
            this.mTapTimeout = ViewConfiguration.getTapTimeout();
            this.mLongPressTimeout = (this.mTapTimeout + ViewConfiguration.getLongPressTimeout()) / 2;
            view.addOnAttachStateChangeListener(this);
        }

        private void clearCallbacks() {
            if (this.mTriggerLongPress != null) {
                this.mSrc.removeCallbacks(this.mTriggerLongPress);
            }
            if (this.mDisallowIntercept != null) {
                this.mSrc.removeCallbacks(this.mDisallowIntercept);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void onLongPress() {
            this.clearCallbacks();
            if (!this.mSrc.isEnabled() || !this.onForwardingStarted()) {
                return;
            }
            this.mSrc.getParent().requestDisallowInterceptTouchEvent(true);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain(l, l, 3, 0.0f, 0.0f, 0);
            this.mSrc.onTouchEvent(motionEvent);
            motionEvent.recycle();
            this.mForwarding = true;
            this.mWasLongPress = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean onTouchForwarded(MotionEvent motionEvent) {
            boolean bl = true;
            View view = this.mSrc;
            ListPopupWindow listPopupWindow = this.getPopup();
            if (listPopupWindow == null) return false;
            if (!listPopupWindow.isShowing()) {
                return false;
            }
            DropDownListView dropDownListView = listPopupWindow.mDropDownList;
            if (dropDownListView == null) return false;
            if (!dropDownListView.isShown()) return false;
            MotionEvent motionEvent2 = MotionEvent.obtainNoHistory(motionEvent);
            view.toGlobalMotionEvent(motionEvent2);
            dropDownListView.toLocalMotionEvent(motionEvent2);
            boolean bl2 = dropDownListView.onForwardedEvent(motionEvent2, this.mActivePointerId);
            motionEvent2.recycle();
            boolean bl3 = motionEvent.getActionMasked();
            boolean bl4 = bl3 != bl && !bl3 ? bl : false;
            if (!bl2) return false;
            if (!bl4) return false;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        private boolean onTouchObserved(MotionEvent motionEvent) {
            View view = this.mSrc;
            if (!view.isEnabled()) {
                return false;
            }
            switch (motionEvent.getActionMasked()) {
                default: {
                    return false;
                }
                case 0: {
                    this.mActivePointerId = motionEvent.getPointerId(0);
                    this.mWasLongPress = false;
                    if (this.mDisallowIntercept == null) {
                        this.mDisallowIntercept = new DisallowIntercept();
                    }
                    view.postDelayed(this.mDisallowIntercept, this.mTapTimeout);
                    if (this.mTriggerLongPress == null) {
                        this.mTriggerLongPress = new TriggerLongPress();
                    }
                    view.postDelayed(this.mTriggerLongPress, this.mLongPressTimeout);
                    return false;
                }
                case 2: {
                    int n = motionEvent.findPointerIndex(this.mActivePointerId);
                    if (n < 0) return false;
                    if (view.pointInView(motionEvent.getX(n), motionEvent.getY(n), this.mScaledTouchSlop)) return false;
                    this.clearCallbacks();
                    view.getParent().requestDisallowInterceptTouchEvent(true);
                    return true;
                }
                case 1: 
                case 3: 
            }
            this.clearCallbacks();
            return false;
        }

        public abstract ListPopupWindow getPopup();

        protected boolean onForwardingStarted() {
            ListPopupWindow listPopupWindow = this.getPopup();
            if (listPopupWindow != null && !listPopupWindow.isShowing()) {
                listPopupWindow.show();
            }
            return true;
        }

        protected boolean onForwardingStopped() {
            ListPopupWindow listPopupWindow = this.getPopup();
            if (listPopupWindow != null && listPopupWindow.isShowing()) {
                listPopupWindow.dismiss();
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            boolean bl;
            boolean bl2 = this.mForwarding;
            if (bl2) {
                bl = this.mWasLongPress ? this.onTouchForwarded(motionEvent) : this.onTouchForwarded(motionEvent) || !this.onForwardingStopped();
            } else {
                bl = this.onTouchObserved(motionEvent) && this.onForwardingStarted();
                if (bl) {
                    long l = SystemClock.uptimeMillis();
                    MotionEvent motionEvent2 = MotionEvent.obtain(l, l, 3, 0.0f, 0.0f, 0);
                    this.mSrc.onTouchEvent(motionEvent2);
                    motionEvent2.recycle();
                }
            }
            this.mForwarding = bl;
            if (bl) return true;
            boolean bl3 = false;
            if (!bl2) return bl3;
            return true;
        }

        @Override
        public void onViewAttachedToWindow(View view) {
        }

        @Override
        public void onViewDetachedFromWindow(View view) {
            this.mForwarding = false;
            this.mActivePointerId = -1;
            if (this.mDisallowIntercept != null) {
                this.mSrc.removeCallbacks(this.mDisallowIntercept);
            }
        }

        private class DisallowIntercept
        implements Runnable {
            private DisallowIntercept() {
            }

            @Override
            public void run() {
                ForwardingListener.this.mSrc.getParent().requestDisallowInterceptTouchEvent(true);
            }
        }

        private class TriggerLongPress
        implements Runnable {
            private TriggerLongPress() {
            }

            @Override
            public void run() {
                ForwardingListener.this.onLongPress();
            }
        }
    }

    private class ListSelectorHider
    implements Runnable {
        private ListSelectorHider() {
        }

        @Override
        public void run() {
            ListPopupWindow.this.clearListSelection();
        }
    }

    private class PopupDataSetObserver
    extends DataSetObserver {
        private PopupDataSetObserver() {
        }

        @Override
        public void onChanged() {
            if (ListPopupWindow.this.isShowing()) {
                ListPopupWindow.this.show();
            }
        }

        @Override
        public void onInvalidated() {
            ListPopupWindow.this.dismiss();
        }
    }

    private class PopupScrollListener
    implements AbsListView.OnScrollListener {
        private PopupScrollListener() {
        }

        @Override
        public void onScroll(AbsListView absListView, int n, int n2, int n3) {
        }

        @Override
        public void onScrollStateChanged(AbsListView absListView, int n) {
            if (n == 1 && !ListPopupWindow.this.isInputMethodNotNeeded() && ListPopupWindow.this.mPopup.getContentView() != null) {
                ListPopupWindow.this.mHandler.removeCallbacks(ListPopupWindow.this.mResizePopupRunnable);
                ListPopupWindow.this.mResizePopupRunnable.run();
            }
        }
    }

    private class PopupTouchInterceptor
    implements View.OnTouchListener {
        private PopupTouchInterceptor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            int n = motionEvent.getAction();
            int n2 = (int)motionEvent.getX();
            int n3 = (int)motionEvent.getY();
            if (n == 0 && ListPopupWindow.this.mPopup != null && ListPopupWindow.this.mPopup.isShowing() && n2 >= 0 && n2 < ListPopupWindow.this.mPopup.getWidth() && n3 >= 0 && n3 < ListPopupWindow.this.mPopup.getHeight()) {
                ListPopupWindow.this.mHandler.postDelayed(ListPopupWindow.this.mResizePopupRunnable, 250L);
                return false;
            }
            if (n != 1) return false;
            ListPopupWindow.this.mHandler.removeCallbacks(ListPopupWindow.this.mResizePopupRunnable);
            return false;
        }
    }

    private class ResizePopupRunnable
    implements Runnable {
        private ResizePopupRunnable() {
        }

        @Override
        public void run() {
            if (ListPopupWindow.this.mDropDownList != null && ListPopupWindow.this.mDropDownList.getCount() > ListPopupWindow.this.mDropDownList.getChildCount() && ListPopupWindow.this.mDropDownList.getChildCount() <= ListPopupWindow.this.mListItemExpandMaximum) {
                ListPopupWindow.this.mPopup.setInputMethodMode(2);
                ListPopupWindow.this.show();
            }
        }
    }
}

