/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import com.android.internal.R;

public class RadioGroup
extends LinearLayout {
    private int mCheckedId = -1;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;
    private boolean mProtectFromCheckedChange = false;

    public RadioGroup(Context context) {
        super(context);
        this.setOrientation(1);
        this.init();
    }

    public RadioGroup(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.RadioGroup, 16842878, 0);
        int n = typedArray.getResourceId(1, -1);
        if (n != -1) {
            this.mCheckedId = n;
        }
        this.setOrientation(typedArray.getInt(0, 1));
        typedArray.recycle();
        this.init();
    }

    static /* synthetic */ boolean access$302(RadioGroup radioGroup, boolean bl) {
        radioGroup.mProtectFromCheckedChange = bl;
        return bl;
    }

    private void init() {
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener(this.mPassThroughListener);
    }

    private void setCheckedId(int n) {
        this.mCheckedId = n;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    private void setCheckedStateForView(int n, boolean bl) {
        View view = this.findViewById(n);
        if (view != null && view instanceof RadioButton) {
            ((RadioButton)view).setChecked(bl);
        }
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        RadioButton radioButton;
        if (view instanceof RadioButton && (radioButton = (RadioButton)view).isChecked()) {
            this.mProtectFromCheckedChange = true;
            if (this.mCheckedId != -1) {
                this.setCheckedStateForView(this.mCheckedId, false);
            }
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(radioButton.getId());
        }
        super.addView(view, n, layoutParams);
    }

    public void check(int n) {
        if (n != -1 && n == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (n != -1) {
            this.setCheckedStateForView(n, true);
        }
        this.setCheckedId(n);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public void clearCheck() {
        this.check(-1);
    }

    @Override
    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    public int getCheckedRadioButtonId() {
        return this.mCheckedId;
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(RadioGroup.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(RadioGroup.class.getName());
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeListener = onCheckedChangeListener;
    }

    @Override
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        PassThroughHierarchyChangeListener.access$202(this.mPassThroughListener, onHierarchyChangeListener);
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
            if (RadioGroup.this.mProtectFromCheckedChange) {
                return;
            }
            RadioGroup.access$302(RadioGroup.this, true);
            if (RadioGroup.this.mCheckedId != -1) {
                RadioGroup.this.setCheckedStateForView(RadioGroup.this.mCheckedId, false);
            }
            RadioGroup.access$302(RadioGroup.this, false);
            int n = compoundButton.getId();
            RadioGroup.this.setCheckedId(n);
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2, f);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            this.width = typedArray.hasValue(n) ? typedArray.getLayoutDimension(n, "layout_width") : -2;
            if (typedArray.hasValue(n2)) {
                this.height = typedArray.getLayoutDimension(n2, "layout_height");
                return;
            }
            this.height = -2;
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RadioGroup var1, int var2);
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        static /* synthetic */ ViewGroup.OnHierarchyChangeListener access$202(PassThroughHierarchyChangeListener passThroughHierarchyChangeListener, ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
            passThroughHierarchyChangeListener.mOnHierarchyChangeListener = onHierarchyChangeListener;
            return onHierarchyChangeListener;
        }

        @Override
        public void onChildViewAdded(View view, View view2) {
            if (view == RadioGroup.this && view2 instanceof RadioButton) {
                if (view2.getId() == -1) {
                    view2.setId(View.generateViewId());
                }
                ((RadioButton)view2).setOnCheckedChangeWidgetListener(RadioGroup.this.mChildOnCheckedChangeListener);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(view, view2);
            }
        }

        @Override
        public void onChildViewRemoved(View view, View view2) {
            if (view == RadioGroup.this && view2 instanceof RadioButton) {
                ((RadioButton)view2).setOnCheckedChangeWidgetListener(null);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(view, view2);
            }
        }
    }
}

