/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.appwidget.AppWidgetManager;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.IRemoteViewsAdapterConnection;
import com.android.internal.widget.IRemoteViewsFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class RemoteViewsAdapter
extends BaseAdapter
implements Handler.Callback {
    private static final String MULTI_USER_PERM = "android.permission.INTERACT_ACROSS_USERS_FULL";
    private static final int REMOTE_VIEWS_CACHE_DURATION = 5000;
    private static final String TAG = "RemoteViewsAdapter";
    private static Handler sCacheRemovalQueue;
    private static HandlerThread sCacheRemovalThread;
    private static final HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> sCachedRemoteViewsCaches;
    private static final int sDefaultCacheSize = 40;
    private static final int sDefaultLoadingViewHeight = 50;
    private static final int sDefaultMessageType = 0;
    private static final HashMap<RemoteViewsCacheKey, Runnable> sRemoteViewsCacheRemoveRunnables;
    private static final int sUnbindServiceDelay = 5000;
    private static final int sUnbindServiceMessageType = 1;
    private final int mAppWidgetId;
    private FixedSizeRemoteViewsCache mCache;
    private WeakReference<RemoteAdapterConnectionCallback> mCallback;
    private final Context mContext;
    private boolean mDataReady = false;
    private final Intent mIntent;
    private LayoutInflater mLayoutInflater;
    private Handler mMainQueue;
    private boolean mNotifyDataSetChangedAfterOnServiceConnected = false;
    private RemoteViews.OnClickHandler mRemoteViewsOnClickHandler;
    private RemoteViewsFrameLayoutRefSet mRequestedViews;
    private RemoteViewsAdapterServiceConnection mServiceConnection;
    private int mVisibleWindowLowerBound;
    private int mVisibleWindowUpperBound;
    private Handler mWorkerQueue;
    private HandlerThread mWorkerThread;

    static {
        sCachedRemoteViewsCaches = new HashMap();
        sRemoteViewsCacheRemoveRunnables = new HashMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemoteViewsAdapter(Context context, Intent intent, RemoteAdapterConnectionCallback remoteAdapterConnectionCallback) {
        this.mContext = context;
        this.mIntent = intent;
        this.mAppWidgetId = intent.getIntExtra("remoteAdapterAppWidgetId", -1);
        this.mLayoutInflater = LayoutInflater.from(context);
        if (this.mIntent == null) {
            throw new IllegalArgumentException("Non-null Intent must be specified.");
        }
        this.mRequestedViews = new RemoteViewsFrameLayoutRefSet();
        if (intent.hasExtra("remoteAdapterAppWidgetId")) {
            intent.removeExtra("remoteAdapterAppWidgetId");
        }
        this.mWorkerThread = new HandlerThread("RemoteViewsCache-loader");
        this.mWorkerThread.start();
        this.mWorkerQueue = new Handler(this.mWorkerThread.getLooper());
        this.mMainQueue = new Handler(Looper.myLooper(), this);
        if (sCacheRemovalThread == null) {
            sCacheRemovalThread = new HandlerThread("RemoteViewsAdapter-cachePruner");
            sCacheRemovalThread.start();
            sCacheRemovalQueue = new Handler(sCacheRemovalThread.getLooper());
        }
        this.mCallback = new WeakReference<RemoteAdapterConnectionCallback>(remoteAdapterConnectionCallback);
        this.mServiceConnection = new RemoteViewsAdapterServiceConnection(this);
        RemoteViewsCacheKey remoteViewsCacheKey = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        synchronized (hashMap) {
            if (sCachedRemoteViewsCaches.containsKey(remoteViewsCacheKey)) {
                this.mCache = sCachedRemoteViewsCaches.get(remoteViewsCacheKey);
                RemoteViewsMetaData remoteViewsMetaData = this.mCache.mMetaData;
                synchronized (remoteViewsMetaData) {
                    if (((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count > 0) {
                        this.mDataReady = true;
                    }
                }
            } else {
                this.mCache = new FixedSizeRemoteViewsCache(40);
            }
            if (!this.mDataReady) {
                this.requestBindService();
            }
            return;
        }
    }

    private void enqueueDeferredUnbindServiceMessage() {
        this.mMainQueue.removeMessages(1);
        this.mMainQueue.sendEmptyMessageDelayed(1, 5000L);
    }

    private int getConvertViewTypeId(View view) {
        Object object;
        int n = -1;
        if (view != null && (object = view.getTag(16908346)) != null) {
            n = (Integer)object;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrayList<Integer> getVisibleWindow(int n, int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n == 0 && n2 == 0 || n < 0 || n2 < 0) return arrayList;
        if (n <= n2) {
            for (int i = n; i <= n2; ++i) {
                arrayList.add(i);
            }
            return arrayList;
        } else {
            for (int i = n; i < n3; ++i) {
                arrayList.add(i);
            }
            for (int i = 0; i <= n2; ++i) {
                arrayList.add(i);
            }
        }
        return arrayList;
    }

    private void loadNextIndexInBackground() {
        this.mWorkerQueue.post(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (!RemoteViewsAdapter.this.mServiceConnection.isConnected()) return;
                FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = RemoteViewsAdapter.this.mCache;
                // MONITORENTER : fixedSizeRemoteViewsCache
                int n = RemoteViewsAdapter.this.mCache.getNextIndexToLoad()[0];
                // MONITOREXIT : fixedSizeRemoteViewsCache
                if (n > -1) {
                    RemoteViewsAdapter.this.updateRemoteViews(n, true);
                    RemoteViewsAdapter.this.loadNextIndexInBackground();
                    return;
                }
                RemoteViewsAdapter.this.enqueueDeferredUnbindServiceMessage();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onNotifyDataSetChanged() {
        ArrayList<Integer> arrayList;
        int n;
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache;
        IRemoteViewsFactory iRemoteViewsFactory = this.mServiceConnection.getRemoteViewsFactory();
        try {
            iRemoteViewsFactory.onDataSetChanged();
            fixedSizeRemoteViewsCache = this.mCache;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error in updateNotifyDataSetChanged(): " + remoteException.getMessage());
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.e(TAG, "Error in updateNotifyDataSetChanged(): " + runtimeException.getMessage());
            return;
        }
        synchronized (fixedSizeRemoteViewsCache) {
            this.mCache.reset();
        }
        this.updateTemporaryMetaData();
        RemoteViewsMetaData remoteViewsMetaData = this.mCache.getTemporaryMetaData();
        synchronized (remoteViewsMetaData) {
            n = this.mCache.getTemporaryMetaData().count;
            arrayList = this.getVisibleWindow(this.mVisibleWindowLowerBound, this.mVisibleWindowUpperBound, n);
        }
        Iterator<Integer> iterator = arrayList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.mMainQueue.post(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = RemoteViewsAdapter.this.mCache;
                        synchronized (fixedSizeRemoteViewsCache) {
                            RemoteViewsAdapter.this.mCache.commitTemporaryMetaData();
                        }
                        RemoteViewsAdapter.this.superNotifyDataSetChanged();
                        RemoteViewsAdapter.this.enqueueDeferredUnbindServiceMessage();
                    }
                });
                this.mNotifyDataSetChangedAfterOnServiceConnected = false;
                return;
            }
            int n2 = iterator.next();
            if (n2 >= n) continue;
            this.updateRemoteViews(n2, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processException(String string2, Exception exception) {
        Log.e(TAG, "Error in " + string2 + ": " + exception.getMessage());
        RemoteViewsMetaData remoteViewsMetaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            remoteViewsMetaData.reset();
        }
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            this.mCache.reset();
        }
        this.mMainQueue.post(new Runnable(){

            @Override
            public void run() {
                RemoteViewsAdapter.this.superNotifyDataSetChanged();
            }
        });
    }

    private boolean requestBindService() {
        if (!this.mServiceConnection.isConnected()) {
            this.mServiceConnection.bind(this.mContext, this.mAppWidgetId, this.mIntent);
        }
        this.mMainQueue.removeMessages(1);
        return this.mServiceConnection.isConnected();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateRemoteViews(final int var1_1, boolean var2_2) {
        block12: {
            var3_3 = this.mServiceConnection.getRemoteViewsFactory();
            try {
                var8_4 = var3_3.getViewAt(var1_1);
                var9_5 = var3_3.getItemId(var1_1);
                if (var8_4 != null) break block12;
            }
            catch (RemoteException var6_6) {
                Log.e("RemoteViewsAdapter", "Error in updateRemoteViews(" + var1_1 + "): " + var6_6.getMessage());
                return;
            }
            catch (RuntimeException var4_7) {
                Log.e("RemoteViewsAdapter", "Error in updateRemoteViews(" + var1_1 + "): " + var4_7.getMessage());
                return;
            }
            Log.e("RemoteViewsAdapter", "Error in updateRemoteViews(" + var1_1 + "): " + " null RemoteViews " + "returned from RemoteViewsFactory.");
            return;
        }
        var11_8 = var8_4.getLayoutId();
        var12_9 = this.mCache.getMetaData();
        synchronized (var12_9) {
            var14_10 = var12_9.isViewTypeInRange(var11_8);
            var15_11 = FixedSizeRemoteViewsCache.access$1200((FixedSizeRemoteViewsCache)this.mCache).count;
        }
        var16_12 = this.mCache;
        synchronized (var16_12) {
            if (var14_10) {
                var19_13 = this.getVisibleWindow(this.mVisibleWindowLowerBound, this.mVisibleWindowUpperBound, var15_11);
                this.mCache.insert(var1_1, var8_4, var9_5, var19_13);
                if (var2_2) {
                    this.mMainQueue.post(new Runnable(){

                        @Override
                        public void run() {
                            RemoteViewsAdapter.this.mRequestedViews.notifyOnRemoteViewsLoaded(var1_1, var8_4);
                        }
                    });
                }
lbl32:
                // 4 sources

                return;
            }
            Log.e("RemoteViewsAdapter", "Error: widget's RemoteViewsFactory returns more view types than  indicated by getViewTypeCount() ");
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTemporaryMetaData() {
        RemoteViewsMetaData remoteViewsMetaData;
        RemoteViews remoteViews;
        RemoteViews remoteViews2;
        int n;
        int n2;
        boolean bl;
        IRemoteViewsFactory iRemoteViewsFactory = this.mServiceConnection.getRemoteViewsFactory();
        try {
            bl = iRemoteViewsFactory.hasStableIds();
            n2 = iRemoteViewsFactory.getViewTypeCount();
            n = iRemoteViewsFactory.getCount();
            remoteViews2 = iRemoteViewsFactory.getLoadingView();
            remoteViews = null;
            if (n > 0) {
                remoteViews = null;
                if (remoteViews2 == null) {
                    remoteViews = iRemoteViewsFactory.getViewAt(0);
                }
            }
            remoteViewsMetaData = this.mCache.getTemporaryMetaData();
            synchronized (remoteViewsMetaData) {
            }
        }
        catch (RemoteException remoteException) {
            this.processException("updateMetaData", remoteException);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.processException("updateMetaData", runtimeException);
            return;
        }
        {
            remoteViewsMetaData.hasStableIds = bl;
            remoteViewsMetaData.viewTypeCount = n2 + 1;
            remoteViewsMetaData.count = n;
            remoteViewsMetaData.setLoadingViewTemplates(remoteViews2, remoteViews);
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mWorkerThread != null) {
                this.mWorkerThread.quit();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getCount() {
        RemoteViewsMetaData remoteViewsMetaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return remoteViewsMetaData.count;
        }
    }

    @Override
    public Object getItem(int n) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getItemId(int n) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (!this.mCache.containsMetaDataAt(n)) return 0L;
            return this.mCache.getMetaDataAt((int)n).itemId;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getItemViewType(int n) {
        int n2;
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (!this.mCache.containsMetaDataAt(n)) return 0;
            n2 = this.mCache.getMetaDataAt((int)n).typeId;
        }
        RemoteViewsMetaData remoteViewsMetaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return remoteViewsMetaData.getMappedViewType(n2);
        }
    }

    public Intent getRemoteViewsServiceIntent() {
        return this.mIntent;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public View getView(int var1_1, View var2_2, ViewGroup var3_3) {
        var4_4 = this.mCache;
        synchronized (var4_4) {
            var6_5 = this.mCache.containsRemoteViewAt(var1_1);
            var7_6 = this.mServiceConnection.isConnected();
            var8_7 = false;
            if (var2_2 != null && var2_2 instanceof RemoteViewsFrameLayout) {
                this.mRequestedViews.removeView((RemoteViewsFrameLayout)var2_2);
            }
            if (!var6_5 && !var7_6) {
                this.requestBindService();
            } else {
                var8_7 = var9_15 = this.mCache.queuePositionsToBePreloadedFromRequestedPosition(var1_1);
            }
            if (!var6_5) {
                var27_26 = this.mCache.getMetaData();
                synchronized (var27_26) {
                    var29_27 = RemoteViewsMetaData.access$1900(var27_26, var1_1, var2_2, var3_3, this.mCache, this.mLayoutInflater, this.mRemoteViewsOnClickHandler);
                }
                this.mRequestedViews.add(var1_1, var29_27);
                this.mCache.queueRequestedPositionToLoad(var1_1);
                this.loadNextIndexInBackground();
                return var29_27;
            }
            if (var2_2 instanceof RemoteViewsFrameLayout) {
                var26_8 = (RemoteViewsFrameLayout)var2_2;
                var10_9 = var26_8.getChildAt(0);
                var11_10 = this.getConvertViewTypeId(var10_9);
                var12_11 = var26_8;
            } else {
                var10_9 = null;
                var11_10 = 0;
                var12_11 = null;
            }
            var13_12 = var3_3.getContext();
            var14_13 = this.mCache.getRemoteViewsAt(var1_1);
            var15_14 = this.mCache.getMetaDataAt((int)var1_1).typeId;
            if (var12_11 == null) ** GOTO lbl59
            if (var11_10 == var15_14) {
                block35: {
                    var14_13.reapply(var13_12, var10_9, this.mRemoteViewsOnClickHandler);
                    if (!var8_7) break block35;
                    this.loadNextIndexInBackground();
                }
                return var12_11;
            }
            try {
                var12_11.removeAllViews();
                var16_16 = var12_11;
            }
            catch (Throwable var18_25) {
                ** continue;
            }
            while (true) {
                ** try [egrp 4[TRYBLOCK] [13, 12 : 201->239)] { 
lbl46:
                // 1 sources

                ** GOTO lbl52
lbl-1000:
                // 1 sources

                {
                    block36: {
                        catch (Throwable var18_23) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                if (var8_7) {
                                    this.loadNextIndexInBackground();
                                }
                                throw var18_24;
                            }
                        }
lbl52:
                        // 1 sources

                        var23_17 = var14_13.apply(var13_12, var3_3, this.mRemoteViewsOnClickHandler);
                        var23_17.setTagInternal(16908346, new Integer(var15_14));
                        var16_16.addView(var23_17);
                        if (!var8_7) break block36;
                        this.loadNextIndexInBackground();
                        break block36;
lbl59:
                        // 2 sources

                        var16_16 = new RemoteViewsFrameLayout(var13_12);
                        continue;
lbl61:
                        // 1 sources

                        catch (Exception var17_20) {
                            ** GOTO lbl-1000
                        }
                    }
                    return var16_16;
                    catch (Exception var17_18) {}
lbl-1000:
                    // 2 sources

                    {
                        Log.w("RemoteViewsAdapter", "Error inflating RemoteViews at position: " + var1_1 + ", using" + "loading view instead" + var17_19);
                        var20_21 = this.mCache.getMetaData();
                        ** synchronized (var20_21)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var22_22 = RemoteViewsMetaData.access$1900(var20_21, var1_1, var2_2, var3_3, this.mCache, this.mLayoutInflater, this.mRemoteViewsOnClickHandler);
                        ** if (!var8_7) goto lbl74
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.loadNextIndexInBackground();
                    }
lbl74:
                    // 2 sources

                    return var22_22;
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getViewTypeCount() {
        RemoteViewsMetaData remoteViewsMetaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return remoteViewsMetaData.viewTypeCount;
        }
    }

    @Override
    public boolean handleMessage(Message message) {
        switch (message.what) {
            default: {
                return false;
            }
            case 1: 
        }
        if (this.mServiceConnection.isConnected()) {
            this.mServiceConnection.unbind(this.mContext, this.mAppWidgetId, this.mIntent);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasStableIds() {
        RemoteViewsMetaData remoteViewsMetaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return remoteViewsMetaData.hasStableIds;
        }
    }

    public boolean isDataReady() {
        return this.mDataReady;
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() <= 0;
    }

    @Override
    public void notifyDataSetChanged() {
        this.mMainQueue.removeMessages(1);
        if (!this.mServiceConnection.isConnected()) {
            if (this.mNotifyDataSetChangedAfterOnServiceConnected) {
                return;
            }
            this.mNotifyDataSetChangedAfterOnServiceConnected = true;
            this.requestBindService();
            return;
        }
        this.mWorkerQueue.post(new Runnable(){

            @Override
            public void run() {
                RemoteViewsAdapter.this.onNotifyDataSetChanged();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void saveRemoteViewsCache() {
        final RemoteViewsCacheKey remoteViewsCacheKey = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        // MONITORENTER : hashMap
        if (sRemoteViewsCacheRemoveRunnables.containsKey(remoteViewsCacheKey)) {
            sCacheRemovalQueue.removeCallbacks(sRemoteViewsCacheRemoveRunnables.get(remoteViewsCacheKey));
            sRemoteViewsCacheRemoveRunnables.remove(remoteViewsCacheKey);
        }
        RemoteViewsMetaData remoteViewsMetaData = this.mCache.mMetaData;
        // MONITORENTER : remoteViewsMetaData
        int n = ((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count;
        // MONITOREXIT : remoteViewsMetaData
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        // MONITORENTER : fixedSizeRemoteViewsCache
        int n2 = this.mCache.mIndexRemoteViews.size();
        // MONITOREXIT : fixedSizeRemoteViewsCache
        if (n > 0 && n2 > 0) {
            sCachedRemoteViewsCaches.put(remoteViewsCacheKey, this.mCache);
        }
        Runnable runnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                HashMap hashMap = sCachedRemoteViewsCaches;
                synchronized (hashMap) {
                    if (sCachedRemoteViewsCaches.containsKey(remoteViewsCacheKey)) {
                        sCachedRemoteViewsCaches.remove(remoteViewsCacheKey);
                    }
                    if (sRemoteViewsCacheRemoveRunnables.containsKey(remoteViewsCacheKey)) {
                        sRemoteViewsCacheRemoveRunnables.remove(remoteViewsCacheKey);
                    }
                    return;
                }
            }
        };
        sRemoteViewsCacheRemoveRunnables.put(remoteViewsCacheKey, runnable);
        sCacheRemovalQueue.postDelayed(runnable, 5000L);
        // MONITOREXIT : hashMap
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler onClickHandler) {
        this.mRemoteViewsOnClickHandler = onClickHandler;
    }

    public void setVisibleRangeHint(int n, int n2) {
        this.mVisibleWindowLowerBound = n;
        this.mVisibleWindowUpperBound = n2;
    }

    void superNotifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    private static class FixedSizeRemoteViewsCache {
        private static final String TAG = "FixedSizeRemoteViewsCache";
        private static final float sMaxCountSlackPercent = 0.75f;
        private static final int sMaxMemoryLimitInBytes = 0x200000;
        private HashMap<Integer, RemoteViewsIndexMetaData> mIndexMetaData;
        private HashMap<Integer, RemoteViews> mIndexRemoteViews;
        private int mLastRequestedIndex;
        private HashSet<Integer> mLoadIndices;
        private int mMaxCount;
        private int mMaxCountSlack;
        private final RemoteViewsMetaData mMetaData;
        private int mPreloadLowerBound;
        private int mPreloadUpperBound;
        private HashSet<Integer> mRequestedIndices;
        private final RemoteViewsMetaData mTemporaryMetaData;

        public FixedSizeRemoteViewsCache(int n) {
            this.mMaxCount = n;
            this.mMaxCountSlack = Math.round(0.75f * (float)(this.mMaxCount / 2));
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mMetaData = new RemoteViewsMetaData();
            this.mTemporaryMetaData = new RemoteViewsMetaData();
            this.mIndexMetaData = new HashMap();
            this.mIndexRemoteViews = new HashMap();
            this.mRequestedIndices = new HashSet();
            this.mLastRequestedIndex = -1;
            this.mLoadIndices = new HashSet();
        }

        private int getFarthestPositionFrom(int n, ArrayList<Integer> arrayList) {
            int n2 = 0;
            int n3 = -1;
            int n4 = 0;
            int n5 = -1;
            for (int n6 : this.mIndexRemoteViews.keySet()) {
                int n7 = Math.abs(n6 - n);
                if (n7 > n4 && !arrayList.contains(n6)) {
                    n5 = n6;
                    n4 = n7;
                }
                if (n7 < n2) continue;
                n3 = n6;
                n2 = n7;
            }
            if (n5 > -1) {
                return n5;
            }
            return n3;
        }

        private int getRemoteViewsBitmapMemoryUsage() {
            int n = 0;
            for (Integer n2 : this.mIndexRemoteViews.keySet()) {
                RemoteViews remoteViews = this.mIndexRemoteViews.get(n2);
                if (remoteViews == null) continue;
                n += remoteViews.estimateMemoryUsage();
            }
            return n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void commitTemporaryMetaData() {
            RemoteViewsMetaData remoteViewsMetaData = this.mTemporaryMetaData;
            synchronized (remoteViewsMetaData) {
                RemoteViewsMetaData remoteViewsMetaData2 = this.mMetaData;
                synchronized (remoteViewsMetaData2) {
                    this.mMetaData.set(this.mTemporaryMetaData);
                    return;
                }
            }
        }

        public boolean containsMetaDataAt(int n) {
            return this.mIndexMetaData.containsKey(n);
        }

        public boolean containsRemoteViewAt(int n) {
            return this.mIndexRemoteViews.containsKey(n);
        }

        public RemoteViewsMetaData getMetaData() {
            return this.mMetaData;
        }

        public RemoteViewsIndexMetaData getMetaDataAt(int n) {
            if (this.mIndexMetaData.containsKey(n)) {
                return this.mIndexMetaData.get(n);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int[] getNextIndexToLoad() {
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                if (!this.mRequestedIndices.isEmpty()) {
                    Integer n = this.mRequestedIndices.iterator().next();
                    this.mRequestedIndices.remove(n);
                    this.mLoadIndices.remove(n);
                    int[] nArray = new int[]{n, 1};
                    return nArray;
                }
                if (!this.mLoadIndices.isEmpty()) {
                    Integer n = this.mLoadIndices.iterator().next();
                    this.mLoadIndices.remove(n);
                    int[] nArray = new int[]{n, 0};
                    return nArray;
                }
                return new int[]{-1, 0};
            }
        }

        public RemoteViews getRemoteViewsAt(int n) {
            if (this.mIndexRemoteViews.containsKey(n)) {
                return this.mIndexRemoteViews.get(n);
            }
            return null;
        }

        public RemoteViewsMetaData getTemporaryMetaData() {
            return this.mTemporaryMetaData;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void insert(int n, RemoteViews remoteViews, long l, ArrayList<Integer> arrayList) {
            if (this.mIndexRemoteViews.size() >= this.mMaxCount) {
                this.mIndexRemoteViews.remove(this.getFarthestPositionFrom(n, arrayList));
            }
            int n2 = this.mLastRequestedIndex > -1 ? this.mLastRequestedIndex : n;
            while (this.getRemoteViewsBitmapMemoryUsage() >= 0x200000) {
                this.mIndexRemoteViews.remove(this.getFarthestPositionFrom(n2, arrayList));
            }
            if (this.mIndexMetaData.containsKey(n)) {
                this.mIndexMetaData.get(n).set(remoteViews, l);
            } else {
                this.mIndexMetaData.put(n, new RemoteViewsIndexMetaData(remoteViews, l));
            }
            this.mIndexRemoteViews.put(n, remoteViews);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean queuePositionsToBePreloadedFromRequestedPosition(int n) {
            int n2;
            if (this.mPreloadLowerBound <= n && n <= this.mPreloadUpperBound && Math.abs(n - (this.mPreloadUpperBound + this.mPreloadLowerBound) / 2) < this.mMaxCountSlack) {
                return false;
            }
            RemoteViewsMetaData remoteViewsMetaData = this.mMetaData;
            synchronized (remoteViewsMetaData) {
                n2 = this.mMetaData.count;
            }
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                this.mLoadIndices.clear();
                this.mLoadIndices.addAll(this.mRequestedIndices);
                int n3 = this.mMaxCount / 2;
                this.mPreloadLowerBound = n - n3;
                this.mPreloadUpperBound = n + n3;
                int n4 = Math.max(0, this.mPreloadLowerBound);
                int n5 = Math.min(this.mPreloadUpperBound, n2 - 1);
                int n6 = n4;
                while (true) {
                    if (n6 > n5) {
                        this.mLoadIndices.removeAll(this.mIndexRemoteViews.keySet());
                        return true;
                    }
                    this.mLoadIndices.add(n6);
                    ++n6;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void queueRequestedPositionToLoad(int n) {
            this.mLastRequestedIndex = n;
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                this.mRequestedIndices.add(n);
                this.mLoadIndices.add(n);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void reset() {
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mLastRequestedIndex = -1;
            this.mIndexRemoteViews.clear();
            this.mIndexMetaData.clear();
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                this.mRequestedIndices.clear();
                this.mLoadIndices.clear();
                return;
            }
        }
    }

    public static interface RemoteAdapterConnectionCallback {
        public void deferNotifyDataSetChanged();

        public boolean onRemoteAdapterConnected();

        public void onRemoteAdapterDisconnected();
    }

    private static class RemoteViewsAdapterServiceConnection
    extends IRemoteViewsAdapterConnection.Stub {
        private WeakReference<RemoteViewsAdapter> mAdapter;
        private boolean mIsConnected;
        private boolean mIsConnecting;
        private IRemoteViewsFactory mRemoteViewsFactory;

        public RemoteViewsAdapterServiceConnection(RemoteViewsAdapter remoteViewsAdapter) {
            this.mAdapter = new WeakReference<RemoteViewsAdapter>(remoteViewsAdapter);
        }

        static /* synthetic */ boolean access$802(RemoteViewsAdapterServiceConnection remoteViewsAdapterServiceConnection, boolean bl) {
            remoteViewsAdapterServiceConnection.mIsConnected = bl;
            return bl;
        }

        static /* synthetic */ boolean access$902(RemoteViewsAdapterServiceConnection remoteViewsAdapterServiceConnection, boolean bl) {
            remoteViewsAdapterServiceConnection.mIsConnecting = bl;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void bind(Context context, int n, Intent intent) {
            synchronized (this) {
                boolean bl = this.mIsConnecting;
                if (!bl) {
                    try {
                        AppWidgetManager appWidgetManager = AppWidgetManager.getInstance(context);
                        if ((RemoteViewsAdapter)this.mAdapter.get() != null) {
                            appWidgetManager.bindRemoteViewsService(context.getOpPackageName(), n, intent, this.asBinder());
                        } else {
                            Slog.w(RemoteViewsAdapter.TAG, "bind: adapter was null");
                        }
                        this.mIsConnecting = true;
                    }
                    catch (Exception exception) {
                        Log.e("RemoteViewsAdapterServiceConnection", "bind(): " + exception.getMessage());
                        this.mIsConnecting = false;
                        this.mIsConnected = false;
                    }
                }
                return;
            }
        }

        public IRemoteViewsFactory getRemoteViewsFactory() {
            synchronized (this) {
                IRemoteViewsFactory iRemoteViewsFactory = this.mRemoteViewsFactory;
                return iRemoteViewsFactory;
            }
        }

        public boolean isConnected() {
            synchronized (this) {
                boolean bl = this.mIsConnected;
                return bl;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onServiceConnected(IBinder iBinder) {
            synchronized (this) {
                RemoteViewsAdapter remoteViewsAdapter;
                block6: {
                    this.mRemoteViewsFactory = IRemoteViewsFactory.Stub.asInterface(iBinder);
                    remoteViewsAdapter = (RemoteViewsAdapter)this.mAdapter.get();
                    if (remoteViewsAdapter != null) break block6;
                    return;
                }
                remoteViewsAdapter.mWorkerQueue.post(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        if (remoteViewsAdapter.mNotifyDataSetChangedAfterOnServiceConnected) {
                            remoteViewsAdapter.onNotifyDataSetChanged();
                        } else {
                            IRemoteViewsFactory iRemoteViewsFactory = remoteViewsAdapter.mServiceConnection.getRemoteViewsFactory();
                            try {
                                if (!iRemoteViewsFactory.isCreated()) {
                                    iRemoteViewsFactory.onDataSetChanged();
                                }
                            }
                            catch (RemoteException remoteException) {
                                Log.e(RemoteViewsAdapter.TAG, "Error notifying factory of data set changed in onServiceConnected(): " + remoteException.getMessage());
                                return;
                            }
                            catch (RuntimeException runtimeException) {
                                Log.e(RemoteViewsAdapter.TAG, "Error notifying factory of data set changed in onServiceConnected(): " + runtimeException.getMessage());
                            }
                            remoteViewsAdapter.updateTemporaryMetaData();
                            remoteViewsAdapter.mMainQueue.post(new Runnable(){

                                /*
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                @Override
                                public void run() {
                                    FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = remoteViewsAdapter.mCache;
                                    synchronized (fixedSizeRemoteViewsCache) {
                                        remoteViewsAdapter.mCache.commitTemporaryMetaData();
                                    }
                                    RemoteAdapterConnectionCallback remoteAdapterConnectionCallback = (RemoteAdapterConnectionCallback)remoteViewsAdapter.mCallback.get();
                                    if (remoteAdapterConnectionCallback != null) {
                                        remoteAdapterConnectionCallback.onRemoteAdapterConnected();
                                    }
                                }
                            });
                        }
                        remoteViewsAdapter.enqueueDeferredUnbindServiceMessage();
                        RemoteViewsAdapterServiceConnection.access$802(RemoteViewsAdapterServiceConnection.this, true);
                        RemoteViewsAdapterServiceConnection.access$902(RemoteViewsAdapterServiceConnection.this, false);
                    }
                });
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onServiceDisconnected() {
            synchronized (this) {
                RemoteViewsAdapter remoteViewsAdapter;
                block6: {
                    this.mIsConnected = false;
                    this.mIsConnecting = false;
                    this.mRemoteViewsFactory = null;
                    remoteViewsAdapter = (RemoteViewsAdapter)this.mAdapter.get();
                    if (remoteViewsAdapter != null) break block6;
                    return;
                }
                remoteViewsAdapter.mMainQueue.post(new Runnable(){

                    @Override
                    public void run() {
                        remoteViewsAdapter.mMainQueue.removeMessages(1);
                        RemoteAdapterConnectionCallback remoteAdapterConnectionCallback = (RemoteAdapterConnectionCallback)remoteViewsAdapter.mCallback.get();
                        if (remoteAdapterConnectionCallback != null) {
                            remoteAdapterConnectionCallback.onRemoteAdapterDisconnected();
                        }
                    }
                });
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void unbind(Context context, int n, Intent intent) {
            synchronized (this) {
                try {
                    AppWidgetManager appWidgetManager = AppWidgetManager.getInstance(context);
                    if ((RemoteViewsAdapter)this.mAdapter.get() != null) {
                        appWidgetManager.unbindRemoteViewsService(context.getOpPackageName(), n, intent);
                    } else {
                        Slog.w(RemoteViewsAdapter.TAG, "unbind: adapter was null");
                    }
                    this.mIsConnecting = false;
                }
                catch (Exception exception) {
                    Log.e("RemoteViewsAdapterServiceConnection", "unbind(): " + exception.getMessage());
                    this.mIsConnecting = false;
                    this.mIsConnected = false;
                }
                return;
            }
        }
    }

    static class RemoteViewsCacheKey {
        final Intent.FilterComparison filter;
        final int widgetId;

        RemoteViewsCacheKey(Intent.FilterComparison filterComparison, int n) {
            this.filter = filterComparison;
            this.widgetId = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (!(object instanceof RemoteViewsCacheKey)) break block2;
                    RemoteViewsCacheKey remoteViewsCacheKey = (RemoteViewsCacheKey)object;
                    if (remoteViewsCacheKey.filter.equals(this.filter) && remoteViewsCacheKey.widgetId == this.widgetId) break block3;
                }
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            int n;
            if (this.filter == null) {
                n = 0;
                return n ^ this.widgetId << 2;
            }
            n = this.filter.hashCode();
            return n ^ this.widgetId << 2;
        }
    }

    private static class RemoteViewsFrameLayout
    extends FrameLayout {
        public RemoteViewsFrameLayout(Context context) {
            super(context);
        }

        public void onRemoteViewsLoaded(RemoteViews remoteViews, RemoteViews.OnClickHandler onClickHandler) {
            try {
                this.removeAllViews();
                this.addView(remoteViews.apply(this.getContext(), this, onClickHandler));
                return;
            }
            catch (Exception exception) {
                Log.e(RemoteViewsAdapter.TAG, "Failed to apply RemoteViews.");
                return;
            }
        }
    }

    private class RemoteViewsFrameLayoutRefSet {
        private HashMap<Integer, LinkedList<RemoteViewsFrameLayout>> mReferences = new HashMap();
        private HashMap<RemoteViewsFrameLayout, LinkedList<RemoteViewsFrameLayout>> mViewToLinkedList = new HashMap();

        /*
         * Enabled aggressive block sorting
         */
        public void add(int n, RemoteViewsFrameLayout remoteViewsFrameLayout) {
            LinkedList<Object> linkedList;
            Integer n2 = n;
            if (this.mReferences.containsKey(n2)) {
                linkedList = this.mReferences.get(n2);
            } else {
                linkedList = new LinkedList();
                this.mReferences.put(n2, linkedList);
            }
            this.mViewToLinkedList.put(remoteViewsFrameLayout, linkedList);
            linkedList.add(remoteViewsFrameLayout);
        }

        public void clear() {
            this.mReferences.clear();
            this.mViewToLinkedList.clear();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void notifyOnRemoteViewsLoaded(int n, RemoteViews remoteViews) {
            Integer n2;
            if (remoteViews == null || !this.mReferences.containsKey(n2 = Integer.valueOf(n))) {
                return;
            }
            LinkedList<RemoteViewsFrameLayout> linkedList = this.mReferences.get(n2);
            Iterator iterator = linkedList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    linkedList.clear();
                    this.mReferences.remove(n2);
                    return;
                }
                RemoteViewsFrameLayout remoteViewsFrameLayout = (RemoteViewsFrameLayout)iterator.next();
                remoteViewsFrameLayout.onRemoteViewsLoaded(remoteViews, RemoteViewsAdapter.this.mRemoteViewsOnClickHandler);
                if (!this.mViewToLinkedList.containsKey(remoteViewsFrameLayout)) continue;
                this.mViewToLinkedList.remove(remoteViewsFrameLayout);
            }
        }

        public void removeView(RemoteViewsFrameLayout remoteViewsFrameLayout) {
            if (this.mViewToLinkedList.containsKey(remoteViewsFrameLayout)) {
                this.mViewToLinkedList.get(remoteViewsFrameLayout).remove(remoteViewsFrameLayout);
                this.mViewToLinkedList.remove(remoteViewsFrameLayout);
            }
        }
    }

    private static class RemoteViewsIndexMetaData {
        long itemId;
        int typeId;

        public RemoteViewsIndexMetaData(RemoteViews remoteViews, long l) {
            this.set(remoteViews, l);
        }

        public void set(RemoteViews remoteViews, long l) {
            this.itemId = l;
            if (remoteViews != null) {
                this.typeId = remoteViews.getLayoutId();
                return;
            }
            this.typeId = 0;
        }
    }

    private static class RemoteViewsMetaData {
        int count;
        boolean hasStableIds;
        RemoteViews mFirstView;
        int mFirstViewHeight;
        private final HashMap<Integer, Integer> mTypeIdIndexMap = new HashMap();
        RemoteViews mUserLoadingView;
        int viewTypeCount;

        public RemoteViewsMetaData() {
            this.reset();
        }

        static /* synthetic */ RemoteViewsFrameLayout access$1900(RemoteViewsMetaData remoteViewsMetaData, int n, View view, ViewGroup viewGroup, Object object, LayoutInflater layoutInflater, RemoteViews.OnClickHandler onClickHandler) {
            return remoteViewsMetaData.createLoadingView(n, view, viewGroup, object, layoutInflater, onClickHandler);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private RemoteViewsFrameLayout createLoadingView(int n, View view, ViewGroup viewGroup, Object object, LayoutInflater layoutInflater, RemoteViews.OnClickHandler onClickHandler) {
            Context context = viewGroup.getContext();
            RemoteViewsFrameLayout remoteViewsFrameLayout = new RemoteViewsFrameLayout(context);
            synchronized (object) {
                RemoteViews remoteViews = this.mUserLoadingView;
                boolean bl = false;
                if (remoteViews != null) {
                    try {
                        View view2 = this.mUserLoadingView.apply(viewGroup.getContext(), viewGroup, onClickHandler);
                        view2.setTagInternal(16908346, new Integer(0));
                        remoteViewsFrameLayout.addView(view2);
                        bl = true;
                    }
                    catch (Exception exception) {
                        Log.w(RemoteViewsAdapter.TAG, "Error inflating custom loading view, using default loadingview instead", exception);
                        bl = false;
                    }
                }
                if (!bl) {
                    int n2 = this.mFirstViewHeight;
                    if (n2 < 0) {
                        try {
                            View view3 = this.mFirstView.apply(viewGroup.getContext(), viewGroup, onClickHandler);
                            view3.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
                            this.mFirstViewHeight = view3.getMeasuredHeight();
                            this.mFirstView = null;
                        }
                        catch (Exception exception) {
                            this.mFirstViewHeight = Math.round(50.0f * context.getResources().getDisplayMetrics().density);
                            this.mFirstView = null;
                            Log.w(RemoteViewsAdapter.TAG, "Error inflating first RemoteViews" + exception);
                        }
                    }
                    TextView textView = (TextView)layoutInflater.inflate(17367238, (ViewGroup)remoteViewsFrameLayout, false);
                    textView.setHeight(this.mFirstViewHeight);
                    textView.setTag(new Integer(0));
                    remoteViewsFrameLayout.addView(textView);
                }
                return remoteViewsFrameLayout;
            }
        }

        public int getMappedViewType(int n) {
            if (this.mTypeIdIndexMap.containsKey(n)) {
                return this.mTypeIdIndexMap.get(n);
            }
            int n2 = 1 + this.mTypeIdIndexMap.size();
            this.mTypeIdIndexMap.put(n, n2);
            return n2;
        }

        public boolean isViewTypeInRange(int n) {
            return this.getMappedViewType(n) < this.viewTypeCount;
        }

        public void reset() {
            this.count = 0;
            this.viewTypeCount = 1;
            this.hasStableIds = true;
            this.mUserLoadingView = null;
            this.mFirstView = null;
            this.mFirstViewHeight = 0;
            this.mTypeIdIndexMap.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void set(RemoteViewsMetaData remoteViewsMetaData) {
            synchronized (remoteViewsMetaData) {
                this.count = remoteViewsMetaData.count;
                this.viewTypeCount = remoteViewsMetaData.viewTypeCount;
                this.hasStableIds = remoteViewsMetaData.hasStableIds;
                this.setLoadingViewTemplates(remoteViewsMetaData.mUserLoadingView, remoteViewsMetaData.mFirstView);
                return;
            }
        }

        public void setLoadingViewTemplates(RemoteViews remoteViews, RemoteViews remoteViews2) {
            this.mUserLoadingView = remoteViews;
            if (remoteViews2 != null) {
                this.mFirstView = remoteViews2;
                this.mFirstViewHeight = -1;
            }
        }
    }
}

