/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.Cursor;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorTreeAdapter;

public abstract class ResourceCursorTreeAdapter
extends CursorTreeAdapter {
    private int mChildLayout;
    private int mCollapsedGroupLayout;
    private int mExpandedGroupLayout;
    private LayoutInflater mInflater;
    private int mLastChildLayout;

    public ResourceCursorTreeAdapter(Context context, Cursor cursor, int n, int n2) {
        this(context, cursor, n, n, n2, n2);
    }

    public ResourceCursorTreeAdapter(Context context, Cursor cursor, int n, int n2, int n3) {
        this(context, cursor, n, n2, n3, n3);
    }

    public ResourceCursorTreeAdapter(Context context, Cursor cursor, int n, int n2, int n3, int n4) {
        super(cursor, context);
        this.mCollapsedGroupLayout = n;
        this.mExpandedGroupLayout = n2;
        this.mChildLayout = n3;
        this.mLastChildLayout = n4;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View newChildView(Context context, Cursor cursor, boolean bl, ViewGroup viewGroup) {
        int n;
        LayoutInflater layoutInflater = this.mInflater;
        if (bl) {
            n = this.mLastChildLayout;
            return layoutInflater.inflate(n, viewGroup, false);
        }
        n = this.mChildLayout;
        return layoutInflater.inflate(n, viewGroup, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View newGroupView(Context context, Cursor cursor, boolean bl, ViewGroup viewGroup) {
        int n;
        LayoutInflater layoutInflater = this.mInflater;
        if (bl) {
            n = this.mExpandedGroupLayout;
            return layoutInflater.inflate(n, viewGroup, false);
        }
        n = this.mCollapsedGroupLayout;
        return layoutInflater.inflate(n, viewGroup, false);
    }
}

